/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.redis.internal.executor.string;

import java.util.List;
import org.apache.geode.redis.internal.data.ByteArrayWrapper;
import org.apache.geode.redis.internal.data.RedisKey;
import org.apache.geode.redis.internal.executor.RedisResponse;
import org.apache.geode.redis.internal.executor.string.RedisStringCommands;
import org.apache.geode.redis.internal.executor.string.StringExecutor;
import org.apache.geode.redis.internal.netty.Coder;
import org.apache.geode.redis.internal.netty.Command;
import org.apache.geode.redis.internal.netty.ExecutionHandlerContext;

public class GetRangeExecutor
extends StringExecutor {
    private static final int startIndex = 2;
    private static final int stopIndex = 3;

    @Override
    public RedisResponse executeCommand(Command command, ExecutionHandlerContext context) {
        long end;
        long start;
        List<byte[]> commandElems = command.getProcessedCommand();
        try {
            byte[] startI = commandElems.get(2);
            byte[] stopI = commandElems.get(3);
            start = Coder.bytesToLong(startI);
            end = Coder.bytesToLong(stopI);
        }
        catch (NumberFormatException e) {
            return RedisResponse.error("value is not an integer or out of range");
        }
        RedisStringCommands stringCommands = this.getRedisStringCommands(context);
        RedisKey key = command.getKey();
        ByteArrayWrapper returnRange = stringCommands.getrange(key, start, end);
        if (returnRange == null) {
            return RedisResponse.nil();
        }
        if (returnRange.length() == 0) {
            return RedisResponse.emptyString();
        }
        return this.respondBulkStrings(returnRange);
    }
}

