/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.redis.internal.executor.string;

import java.util.List;
import org.apache.geode.redis.internal.data.ByteArrayWrapper;
import org.apache.geode.redis.internal.data.RedisKey;
import org.apache.geode.redis.internal.executor.RedisResponse;
import org.apache.geode.redis.internal.executor.key.RedisKeyCommands;
import org.apache.geode.redis.internal.executor.string.RedisStringCommands;
import org.apache.geode.redis.internal.executor.string.StringExecutor;
import org.apache.geode.redis.internal.netty.Command;
import org.apache.geode.redis.internal.netty.ExecutionHandlerContext;

public class MSetNXExecutor
extends StringExecutor {
    private static final int SET = 1;
    private static final int NOT_SET = 0;

    @Override
    public RedisResponse executeCommand(Command command, ExecutionHandlerContext context) {
        RedisKey key;
        byte[] keyArray;
        int i;
        List<byte[]> commandElems = command.getProcessedCommand();
        RedisStringCommands stringCommands = this.getRedisStringCommands(context);
        RedisKeyCommands keyCommands = this.getRedisKeyCommands(context);
        for (i = 1; i < commandElems.size(); i += 2) {
            keyArray = commandElems.get(i);
            key = new RedisKey(keyArray);
            if (!keyCommands.exists(key)) continue;
            return RedisResponse.integer(0L);
        }
        for (i = 1; i < commandElems.size(); i += 2) {
            keyArray = commandElems.get(i);
            key = new RedisKey(keyArray);
            byte[] valueArray = commandElems.get(i + 1);
            ByteArrayWrapper value = new ByteArrayWrapper(valueArray);
            stringCommands.set(key, value, null);
        }
        return RedisResponse.integer(1L);
    }
}

