/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.redis.internal.netty;

import io.netty.channel.ChannelHandlerContext;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.geode.redis.internal.RedisCommandType;
import org.apache.geode.redis.internal.data.ByteArrayWrapper;
import org.apache.geode.redis.internal.data.RedisKey;
import org.apache.geode.redis.internal.executor.RedisResponse;
import org.apache.geode.redis.internal.netty.Coder;
import org.apache.geode.redis.internal.netty.ExecutionHandlerContext;

public class Command {
    private final List<byte[]> commandElems;
    private final RedisCommandType commandType;
    private String key;
    private ByteArrayWrapper bytes;
    private long asyncStartTime;
    private ChannelHandlerContext channelHandlerContext;

    Command() {
        this.commandElems = null;
        this.commandType = null;
    }

    public Command(List<byte[]> commandElems) {
        RedisCommandType type;
        if (commandElems == null || commandElems.isEmpty()) {
            throw new IllegalArgumentException("List of command elements cannot be empty -> List:" + commandElems);
        }
        this.commandElems = commandElems;
        try {
            byte[] charCommand = commandElems.get(0);
            String commandName = Coder.bytesToString(charCommand).toUpperCase();
            type = RedisCommandType.valueOf(commandName);
        }
        catch (Exception e) {
            type = RedisCommandType.UNKNOWN;
        }
        this.commandType = type;
    }

    public boolean isSupported() {
        return this.commandType.isSupported();
    }

    public boolean isUnsupported() {
        return this.commandType.isUnsupported();
    }

    public boolean isUnknown() {
        return this.commandType.isUnknown();
    }

    public List<byte[]> getProcessedCommand() {
        return this.commandElems;
    }

    public List<ByteArrayWrapper> getProcessedCommandWrappers() {
        return this.commandElems.stream().map(ByteArrayWrapper::new).collect(Collectors.toList());
    }

    public List<RedisKey> getProcessedCommandWrapperKeys() {
        return this.commandElems.stream().map(RedisKey::new).collect(Collectors.toList());
    }

    public RedisCommandType getCommandType() {
        return this.commandType;
    }

    public String getStringKey() {
        if (this.commandElems.size() > 1) {
            if (this.bytes == null) {
                this.bytes = new ByteArrayWrapper(this.commandElems.get(1));
                this.key = this.bytes.toString();
            } else if (this.key == null) {
                this.key = this.bytes.toString();
            }
            return this.key;
        }
        return null;
    }

    public RedisKey getKey() {
        if (this.commandElems.size() > 1) {
            if (this.bytes == null) {
                this.bytes = new RedisKey(this.commandElems.get(1));
            }
            return (RedisKey)this.bytes;
        }
        return null;
    }

    public String toString() {
        StringBuilder b = new StringBuilder();
        for (byte[] rawCommand : this.commandElems) {
            b.append(Command.getHexEncodedString(rawCommand));
            b.append(' ');
        }
        return b.toString();
    }

    public static String getHexEncodedString(byte[] data) {
        return Command.getHexEncodedString(data, data.length);
    }

    public static String getHexEncodedString(byte[] data, int size) {
        StringBuilder builder = new StringBuilder();
        for (int i = 0; i < size; ++i) {
            byte aByte = data[i];
            if (aByte > 31 && aByte < 127) {
                builder.append((char)aByte);
                continue;
            }
            if (aByte == 10) {
                builder.append("\\n");
                continue;
            }
            if (aByte == 13) {
                builder.append("\\r");
                continue;
            }
            builder.append(String.format("\\x%02x", aByte));
        }
        return builder.toString();
    }

    public RedisResponse execute(ExecutionHandlerContext executionHandlerContext) {
        RedisCommandType type = this.getCommandType();
        return type.executeCommand(this, executionHandlerContext);
    }

    public boolean isOfType(RedisCommandType type) {
        return type == this.getCommandType();
    }

    public String wrongNumberOfArgumentsErrorMessage() {
        String result = String.format("wrong number of arguments for '%s' command", this.getCommandType().toString().toLowerCase());
        return result;
    }

    public void setAsyncStartTime(long start) {
        this.asyncStartTime = start;
    }

    public long getAsyncStartTime() {
        return this.asyncStartTime;
    }

    public void setChannelHandlerContext(ChannelHandlerContext ctx) {
        this.channelHandlerContext = ctx;
    }

    public ChannelHandlerContext getChannelHandlerContext() {
        return this.channelHandlerContext;
    }
}

