/*
 * Decompiled with CFR 0.152.
 */
package javax.management.loading;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.ByteArrayOutputStream;
import java.io.Externalizable;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;
import java.net.URLStreamHandlerFactory;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.management.MBeanRegistration;
import javax.management.MBeanServer;
import javax.management.ObjectInstance;
import javax.management.ObjectName;
import javax.management.ServiceNotFoundException;
import javax.management.loading.ClassLoaderRepository;
import javax.management.loading.MLetContent;
import javax.management.loading.MLetMBean;
import mx4j.loading.ClassLoaderObjectInputStream;
import mx4j.loading.MLetParseException;
import mx4j.loading.MLetParser;
import mx4j.loading.MLetTag;
import mx4j.log.Log;
import mx4j.log.Logger;

public class MLet
extends URLClassLoader
implements MLetMBean,
MBeanRegistration,
Externalizable {
    private MBeanServer server;
    private ObjectName objectName;
    private boolean delegateToCLR;
    private ThreadLocal loadingOnlyLocally = new ThreadLocal();
    private ThreadLocal loadingWithRepository = new ThreadLocal();
    private String libraryDir;

    public MLet() {
        this(new URL[0]);
    }

    public MLet(URL[] urls) {
        this(urls, true);
    }

    public MLet(URL[] urls, boolean delegateToCLR) {
        super(urls);
        this.setDelegateToCLR(delegateToCLR);
        this.loadingWithRepository.set(Boolean.FALSE);
        this.loadingOnlyLocally.set(Boolean.FALSE);
    }

    public MLet(URL[] urls, ClassLoader parent) {
        this(urls, parent, true);
    }

    public MLet(URL[] urls, ClassLoader parent, boolean delegateToCLR) {
        super(urls, parent);
        this.setDelegateToCLR(delegateToCLR);
        this.loadingWithRepository.set(Boolean.FALSE);
        this.loadingOnlyLocally.set(Boolean.FALSE);
    }

    public MLet(URL[] urls, ClassLoader parent, URLStreamHandlerFactory factory) {
        this(urls, parent, factory, true);
    }

    public MLet(URL[] urls, ClassLoader parent, URLStreamHandlerFactory factory, boolean delegateToCLR) {
        super(urls, parent, factory);
        this.setDelegateToCLR(delegateToCLR);
        this.loadingWithRepository.set(Boolean.FALSE);
        this.loadingOnlyLocally.set(Boolean.FALSE);
    }

    public ObjectName preRegister(MBeanServer server, ObjectName name) throws Exception {
        this.server = server;
        this.objectName = name == null ? new ObjectName(this.server.getDefaultDomain(), "type", "MLet") : name;
        Logger logger = this.getLogger();
        if (logger.isEnabledFor(0)) {
            logger.trace("MLet service " + this.objectName + " preRegistered successfully");
        }
        return this.objectName;
    }

    public void postRegister(Boolean registrationDone) {
        Logger logger = this.getLogger();
        if (!registrationDone.booleanValue()) {
            this.server = null;
            if (logger.isEnabledFor(20)) {
                logger.info("MLet service " + this.objectName + " was not registered");
            }
        } else if (logger.isEnabledFor(0)) {
            logger.trace("MLet service " + this.objectName + " postRegistered successfully");
        }
    }

    public void preDeregister() throws Exception {
        Logger logger = this.getLogger();
        if (logger.isEnabledFor(0)) {
            logger.trace("MLet service " + this.objectName + " preDeregistered successfully");
        }
    }

    public void postDeregister() {
        Logger logger = this.getLogger();
        if (logger.isEnabledFor(0)) {
            logger.trace("MLet service " + this.objectName + " postDeregistered successfully");
        }
    }

    public void addURL(String url) throws ServiceNotFoundException {
        this.addURL(this.createURL(url));
    }

    public void addURL(URL url) {
        Logger logger = this.getLogger();
        if (!Arrays.asList(this.getURLs()).contains(url)) {
            if (logger.isEnabledFor(0)) {
                logger.trace("Adding URL to this MLet (" + this.objectName + ") classpath: " + url);
            }
            super.addURL(url);
        } else if (logger.isEnabledFor(0)) {
            logger.trace("URL already present in this MLet (" + this.objectName + ") classpath: " + url);
        }
    }

    public Class loadClass(String name, ClassLoaderRepository repository) throws ClassNotFoundException {
        if (repository == null) {
            Class cls = this.loadClassLocally(name);
            return cls;
        }
        try {
            Class cls = this.loadClassLocally(name);
            return cls;
        }
        catch (ClassNotFoundException x) {
            Class cls = this.loadClassFromRepository(name, repository);
            return cls;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Class loadClassLocally(String name) throws ClassNotFoundException {
        try {
            this.loadingOnlyLocally.set(Boolean.TRUE);
            Class<?> clazz = this.loadClass(name);
            return clazz;
        }
        finally {
            this.loadingOnlyLocally.set(Boolean.FALSE);
        }
    }

    private Class loadClassFromRepository(String name, ClassLoaderRepository repository) throws ClassNotFoundException {
        return repository.loadClassBefore(this, name);
    }

    protected Class findClass(String name) throws ClassNotFoundException {
        Logger logger = this.getLogger();
        boolean trace = logger.isEnabledFor(0);
        if (this.loadingWithRepository.get() == Boolean.TRUE) {
            if (trace) {
                logger.trace("MLet " + this + " is recursively calling itself to load class " + name + ": skipping further searches");
            }
            throw new ClassNotFoundException(name);
        }
        if (trace) {
            logger.trace("Finding class " + name + "...");
        }
        try {
            Class cls = this.findClassLocally(name);
            if (trace) {
                logger.trace("Class " + name + " found in this MLet's classpath " + this);
            }
            return cls;
        }
        catch (ClassNotFoundException x) {
            if (!this.isDelegateToCLR()) {
                if (trace) {
                    logger.trace("MLet " + this + " does not delegate to the ClassLoaderRepository");
                }
                throw x;
            }
            if (this.loadingOnlyLocally.get() == Boolean.TRUE) {
                throw x;
            }
            if (this.server == null) {
                throw x;
            }
            if (trace) {
                logger.trace("Class " + name + " not found in this MLet's classpath " + this + ", trying the ClassLoaderRepository...", x);
            }
            try {
                this.loadingWithRepository.set(Boolean.TRUE);
                ClassLoaderRepository repository = this.server.getClassLoaderRepository();
                Class cls = this.loadClassFromRepository(name, repository);
                if (trace) {
                    logger.trace("Class " + name + " found with ClassLoaderRepository " + repository);
                }
                Class clazz = cls;
                return clazz;
            }
            catch (ClassNotFoundException xx) {
                if (trace) {
                    logger.trace("Class " + name + " not found in ClassLoaderRepository, giving up", xx);
                }
                throw new ClassNotFoundException(name);
            }
            finally {
                this.loadingWithRepository.set(Boolean.FALSE);
            }
        }
    }

    private Class findClassLocally(String name) throws ClassNotFoundException {
        return super.findClass(name);
    }

    public Set getMBeansFromURL(String url) throws ServiceNotFoundException {
        return this.getMBeansFromURL(this.createURL(url));
    }

    /*
     * Loose catch block
     */
    public Set getMBeansFromURL(URL url) throws ServiceNotFoundException {
        ByteArrayOutputStream baos;
        Logger logger;
        block15: {
            if (url == null) {
                throw new ServiceNotFoundException("Cannot load MBeans from null URL");
            }
            logger = this.getLogger();
            if (logger.isEnabledFor(0)) {
                logger.trace("MLet " + this + ", reading MLET file from " + url);
            }
            InputStream is = null;
            baos = new ByteArrayOutputStream();
            BufferedOutputStream os = new BufferedOutputStream(baos);
            is = url.openStream();
            this.readFromAndWriteTo(is, os);
            Object var8_6 = null;
            try {
                if (is != null) {
                    is.close();
                }
                os.close();
            }
            catch (IOException ignored) {}
            break block15;
            {
                catch (IOException x) {
                    if (logger.isEnabledFor(0)) {
                        logger.trace("Cannot read input stream from URL " + url, x);
                    }
                    throw new ServiceNotFoundException(x.toString());
                }
            }
            catch (Throwable throwable) {
                Object var8_7 = null;
                try {
                    if (is != null) {
                        is.close();
                    }
                    os.close();
                }
                catch (IOException ignored) {
                    // empty catch block
                }
                throw throwable;
            }
        }
        String mletFileContent = null;
        try {
            mletFileContent = new String(baos.toByteArray(), "UTF-8");
        }
        catch (UnsupportedEncodingException x) {
            mletFileContent = baos.toString();
        }
        if (logger.isEnabledFor(0)) {
            logger.trace("MLet File content is:\n" + mletFileContent);
        }
        return this.parseMLetFile(mletFileContent, url);
    }

    private Set parseMLetFile(String content, URL mletFileURL) throws ServiceNotFoundException {
        Logger logger = this.getLogger();
        try {
            HashSet<Object> mbeans = new HashSet<Object>();
            MLetParser parser = new MLetParser(this);
            List tags = parser.parse(content);
            for (int i = 0; i < tags.size(); ++i) {
                MLetTag tag = (MLetTag)tags.get(i);
                String[] jars = tag.parseArchive();
                for (int j = 0; j < jars.length; ++j) {
                    String jar = jars[j];
                    URL codebase = this.handleCheck(tag, jar, mletFileURL, mbeans);
                    URL archiveURL = tag.createArchiveURL(codebase, jar);
                    this.addURL(archiveURL);
                }
                Object obj = this.createMBean(tag);
                mbeans.add(obj);
            }
            return mbeans;
        }
        catch (MLetParseException x) {
            if (logger.isEnabledFor(0)) {
                logger.trace("Cannot parse MLet file", x);
            }
            throw new ServiceNotFoundException(x.toString());
        }
    }

    private URL handleCheck(MLetTag tag, String archive, URL mletFileURL, Set mbeans) {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("codebaseURL", tag.normalizeCodeBase(mletFileURL));
        map.put("codebase", tag.getCodeBase());
        map.put("archive", tag.getArchive());
        map.put("code", tag.getCode());
        map.put("object", tag.getObject());
        map.put("name", tag.getObjectName());
        map.put("version", tag.getVersion());
        MLetContent mletContent = new MLetContent(mletFileURL, map);
        try {
            return this.check(mletContent.getVersion(), mletContent.getCodeBase(), archive, mletContent);
        }
        catch (Throwable x) {
            mbeans.add(x);
            return null;
        }
    }

    protected URL check(String version, URL codebase, String archive, MLetContent content) throws Exception {
        return codebase;
    }

    private Object createMBean(MLetTag tag) throws ServiceNotFoundException {
        if (this.server == null) {
            throw new ServiceNotFoundException("MLet not registered on the MBeanServer");
        }
        Logger logger = this.getLogger();
        if (logger.isEnabledFor(0)) {
            logger.trace("MLet " + this + ", creating MBean from\n" + tag);
        }
        try {
            Object mbean = null;
            if (tag.getObject() != null) {
                String name = tag.getObject();
                InputStream is = this.getResourceAsStream(name);
                if (is == null) {
                    throw new ServiceNotFoundException("Cannot find serialized MBean " + name + " in MLet " + this);
                }
                BufferedInputStream bis = new BufferedInputStream(is);
                ClassLoaderObjectInputStream ois = new ClassLoaderObjectInputStream(bis, this);
                mbean = ois.readObject();
            } else {
                String clsName = tag.getCode();
                Object[] args = tag.getArguments();
                String[] params = tag.getSignature();
                mbean = this.server.instantiate(clsName, this.objectName, args, params);
            }
            ObjectName objectName = tag.getObjectName();
            ObjectInstance instance = this.server.registerMBean(mbean, objectName);
            return instance;
        }
        catch (Throwable t) {
            return t;
        }
    }

    protected String findLibrary(String libraryName) {
        final String sysLibraryName = System.mapLibraryName(libraryName);
        String path = this.copyLibrary(sysLibraryName);
        if (path != null) {
            return path;
        }
        String osPath = (String)AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                StringBuffer buffer = new StringBuffer();
                buffer.append(System.getProperty("os.name")).append(File.separator);
                buffer.append(System.getProperty("os.arch")).append(File.separator);
                buffer.append(System.getProperty("os.version")).append(File.separator);
                buffer.append("lib").append(File.separator).append(sysLibraryName);
                return buffer.toString();
            }
        });
        osPath = this.removeSpaces(osPath);
        return this.copyLibrary(osPath);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive exception aggregation
     */
    private String copyLibrary(String library) {
        Logger logger = this.getLogger();
        library = library.replace('\\', '/');
        if (logger.isEnabledFor(0)) {
            logger.trace("Loading library " + library);
        }
        URL libraryURL = this.getResource(library);
        InputStream is = null;
        OutputStream os = null;
        try {
            try {
                String string;
                block17: {
                    File localLibrary;
                    URL localLibraryURL;
                    is = this.getResourceAsStream(library);
                    if (is == null) {
                        String string2 = null;
                        return string2;
                    }
                    if (!(is instanceof BufferedInputStream)) {
                        is = new BufferedInputStream(is);
                    }
                    if ((localLibraryURL = (localLibrary = new File(this.getLibraryDirectory(), library)).toURL()).equals(libraryURL)) {
                        String string3 = localLibrary.getCanonicalPath();
                        return string3;
                    }
                    try {
                        os = new BufferedOutputStream(new FileOutputStream(localLibrary));
                        this.readFromAndWriteTo(is, os);
                        string = localLibrary.getCanonicalPath();
                        if (os == null) break block17;
                    }
                    catch (Throwable throwable) {
                        if (os != null) {
                            os.close();
                        }
                        throw throwable;
                    }
                    os.close();
                }
                return string;
            }
            finally {
                if (is != null) {
                    is.close();
                }
            }
        }
        catch (IOException x) {
            if (logger.isEnabledFor(0)) {
                logger.trace("Cannot copy the library to the library directory " + this.getLibraryDirectory(), x);
            }
            return null;
        }
    }

    private void readFromAndWriteTo(InputStream is, OutputStream os) throws IOException {
        byte[] buffer = new byte[64];
        int read = -1;
        while ((read = is.read(buffer)) >= 0) {
            os.write(buffer, 0, read);
        }
    }

    private String removeSpaces(String string) {
        int space = -1;
        StringBuffer buffer = new StringBuffer();
        while ((space = string.indexOf(32)) >= 0) {
            buffer.append(string.substring(0, space));
            string = string.substring(space + 1);
        }
        buffer.append(string);
        return buffer.toString();
    }

    public String getLibraryDirectory() {
        return this.libraryDir;
    }

    public void setLibraryDirectory(String libdir) {
        this.libraryDir = libdir;
    }

    private boolean isDelegateToCLR() {
        return this.delegateToCLR;
    }

    private void setDelegateToCLR(boolean delegateToCLR) {
        this.delegateToCLR = delegateToCLR;
    }

    private URL createURL(String urlString) throws ServiceNotFoundException {
        try {
            URL url = new URL(urlString);
            return url;
        }
        catch (MalformedURLException x) {
            throw new ServiceNotFoundException(x.toString());
        }
    }

    private Logger getLogger() {
        return Log.getLogger(this.getClass().getName());
    }

    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException, UnsupportedOperationException {
        throw new UnsupportedOperationException("MLet.readExternal");
    }

    public void writeExternal(ObjectOutput out) throws IOException, UnsupportedOperationException {
        throw new UnsupportedOperationException("MLet.writeExternal");
    }
}

