/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.cache.client.internal;

import java.util.ArrayList;
import java.util.List;
import java.util.function.Supplier;
import org.apache.geode.GemFireException;
import org.apache.geode.InternalGemFireError;
import org.apache.geode.cache.client.NoAvailableServersException;
import org.apache.geode.cache.client.ServerConnectivityException;
import org.apache.geode.cache.client.ServerOperationException;
import org.apache.geode.cache.client.internal.AbstractOp;
import org.apache.geode.cache.client.internal.AbstractOpWithTimeout;
import org.apache.geode.cache.client.internal.ConnectionStats;
import org.apache.geode.cache.client.internal.PoolImpl;
import org.apache.geode.cache.client.internal.SingleHopClientExecutor;
import org.apache.geode.cache.client.internal.SingleHopOperationCallable;
import org.apache.geode.cache.client.internal.UserAttributes;
import org.apache.geode.cache.execute.Function;
import org.apache.geode.cache.execute.FunctionException;
import org.apache.geode.cache.execute.ResultCollector;
import org.apache.geode.distributed.DistributedMember;
import org.apache.geode.distributed.internal.ServerLocation;
import org.apache.geode.internal.cache.execute.AbstractExecution;
import org.apache.geode.internal.cache.execute.InternalFunctionException;
import org.apache.geode.internal.cache.execute.InternalFunctionInvocationTargetException;
import org.apache.geode.internal.cache.execute.MemberMappedArgument;
import org.apache.geode.internal.cache.execute.metrics.FunctionStatsManager;
import org.apache.geode.internal.cache.tier.sockets.ChunkedMessage;
import org.apache.geode.internal.cache.tier.sockets.Message;
import org.apache.geode.internal.cache.tier.sockets.Part;
import org.apache.geode.internal.serialization.KnownVersion;
import org.apache.geode.logging.internal.log4j.api.LogService;
import org.apache.logging.log4j.Logger;

public class ExecuteFunctionOp {
    private static final Logger logger = LogService.getLogger();
    public static final int ALL_MEMBERS_INDEX = 0;
    public static final int IGNORE_FAILED_MEMBERS_INDEX = 1;
    private static final int MAX_RETRY_INITIAL_VALUE = -1;

    private ExecuteFunctionOp() {
    }

    public static void execute(PoolImpl pool, boolean allServers, ResultCollector rc, boolean isHA, UserAttributes attributes, String[] groups, ExecuteFunctionOpImpl executeFunctionOp, Supplier<ExecuteFunctionOpImpl> executeFunctionOpSupplier, Supplier<ExecuteFunctionOpImpl> reExecuteFunctionOpSupplier) {
        ExecuteFunctionOpImpl op = executeFunctionOp;
        if (allServers && groups.length == 0) {
            List callableTasks = ExecuteFunctionOp.constructAndGetFunctionTasks(pool, attributes, executeFunctionOpSupplier);
            SingleHopClientExecutor.submitAll(callableTasks);
        } else {
            boolean reexecute = false;
            int maxRetryAttempts = -1;
            if (!isHA) {
                maxRetryAttempts = 0;
            }
            do {
                try {
                    if (reexecute) {
                        pool.execute(reExecuteFunctionOpSupplier.get(), 0);
                    } else {
                        pool.execute(op, 0);
                    }
                    reexecute = false;
                }
                catch (InternalFunctionInvocationTargetException e) {
                    if (isHA) {
                        reexecute = true;
                    }
                    rc.clearResults();
                }
                catch (ServerOperationException serverOperationException) {
                    throw serverOperationException;
                }
                catch (ServerConnectivityException se) {
                    if (maxRetryAttempts == -1) {
                        maxRetryAttempts = pool.calculateRetryAttempts(se);
                    }
                    if (maxRetryAttempts-- < 1) {
                        throw se;
                    }
                    reexecute = true;
                    rc.clearResults();
                }
            } while (reexecute);
        }
    }

    private static List constructAndGetFunctionTasks(PoolImpl pool, UserAttributes attributes, Supplier<ExecuteFunctionOpImpl> executeFunctionOpSupplier) {
        ArrayList<SingleHopOperationCallable> tasks = new ArrayList<SingleHopOperationCallable>();
        List<ServerLocation> servers = pool.getConnectionSource().getAllServers();
        if (servers == null) {
            throw new NoAvailableServersException();
        }
        for (ServerLocation server : servers) {
            AbstractOp op = executeFunctionOpSupplier.get();
            SingleHopOperationCallable task = new SingleHopOperationCallable(server, pool, op, attributes);
            tasks.add(task);
        }
        return tasks;
    }

    static byte[] getByteArrayForFlags(boolean ... flags) {
        byte[] retVal = null;
        if (flags.length > 0) {
            retVal = new byte[flags.length];
            for (int i = 0; i < flags.length; ++i) {
                retVal[i] = flags[i] ? (byte)1 : 0;
            }
        }
        return retVal;
    }

    public static class ExecuteFunctionOpImpl
    extends AbstractOpWithTimeout {
        private ResultCollector resultCollector;
        private String functionId;
        private Function function;
        private Object args;
        private MemberMappedArgument memberMappedArg;
        private byte hasResult;
        private boolean isFnSerializationReqd;
        private String[] groups;
        private byte[] flags;
        private static final int MSG_PARTS = 6;

        public ExecuteFunctionOpImpl(Function function, Object args, MemberMappedArgument memberMappedArg, ResultCollector rc, boolean isFnSerializationReqd, byte isReexecute, String[] groups, boolean allMembers, boolean ignoreFailedMembers, int timeoutMs) {
            super(62, 6, timeoutMs);
            byte fnState = AbstractExecution.getFunctionState(function.isHA(), function.hasResult(), function.optimizeForWrite());
            this.addBytes(isReexecute, fnState);
            if (isFnSerializationReqd) {
                this.getMessage().addStringOrObjPart(function);
            } else {
                this.getMessage().addStringOrObjPart(function.getId());
            }
            this.getMessage().addObjPart(args);
            this.getMessage().addObjPart(memberMappedArg);
            this.getMessage().addObjPart(groups);
            this.flags = ExecuteFunctionOp.getByteArrayForFlags(allMembers, ignoreFailedMembers);
            this.getMessage().addBytesPart(this.flags);
            this.resultCollector = rc;
            if (isReexecute == 1) {
                this.resultCollector.clearResults();
            }
            this.functionId = function.getId();
            this.function = function;
            this.args = args;
            this.memberMappedArg = memberMappedArg;
            this.hasResult = fnState;
            this.isFnSerializationReqd = isFnSerializationReqd;
            this.groups = groups;
        }

        public ExecuteFunctionOpImpl(String functionId, Object args2, MemberMappedArgument memberMappedArg, byte hasResult, ResultCollector rc, boolean isFnSerializationReqd, boolean isHA, boolean optimizeForWrite, byte isReexecute, String[] groups, boolean allMembers, boolean ignoreFailedMembers, int timeoutMs) {
            super(62, 6, timeoutMs);
            byte fnState = AbstractExecution.getFunctionState(isHA, hasResult == 1, optimizeForWrite);
            this.addBytes(isReexecute, fnState);
            this.getMessage().addStringOrObjPart(functionId);
            this.getMessage().addObjPart(args2);
            this.getMessage().addObjPart(memberMappedArg);
            this.getMessage().addObjPart(groups);
            this.flags = ExecuteFunctionOp.getByteArrayForFlags(allMembers, ignoreFailedMembers);
            this.getMessage().addBytesPart(this.flags);
            this.resultCollector = rc;
            if (isReexecute == 1) {
                this.resultCollector.clearResults();
            }
            this.functionId = functionId;
            this.args = args2;
            this.memberMappedArg = memberMappedArg;
            this.hasResult = fnState;
            this.isFnSerializationReqd = isFnSerializationReqd;
            this.groups = groups;
        }

        ExecuteFunctionOpImpl(ExecuteFunctionOpImpl op, byte isReexecute) {
            super(62, 6, op.getTimeoutMs());
            this.resultCollector = op.resultCollector;
            this.function = op.function;
            this.functionId = op.functionId;
            this.hasResult = op.hasResult;
            this.args = op.args;
            this.memberMappedArg = op.memberMappedArg;
            this.isFnSerializationReqd = op.isFnSerializationReqd;
            this.groups = op.groups;
            this.flags = op.flags;
            this.addBytes(isReexecute, this.hasResult);
            if (this.isFnSerializationReqd) {
                this.getMessage().addStringOrObjPart(this.function);
            } else {
                this.getMessage().addStringOrObjPart(this.function.getId());
            }
            this.getMessage().addObjPart(this.args);
            this.getMessage().addObjPart(this.memberMappedArg);
            this.getMessage().addObjPart(this.groups);
            this.getMessage().addBytesPart(this.flags);
            if (isReexecute == 1) {
                this.resultCollector.clearResults();
            }
        }

        private void addBytes(byte isReexecute, byte fnStateOrHasResult) {
            if (this.getTimeoutMs() == 0) {
                if (isReexecute == 1) {
                    this.getMessage().addBytesPart(new byte[]{AbstractExecution.getReexecuteFunctionState(fnStateOrHasResult)});
                } else {
                    this.getMessage().addBytesPart(new byte[]{fnStateOrHasResult});
                }
            } else {
                byte[] bytes = new byte[5];
                bytes[0] = isReexecute == 1 ? AbstractExecution.getReexecuteFunctionState(fnStateOrHasResult) : fnStateOrHasResult;
                Part.encodeInt(this.getTimeoutMs(), bytes, 1);
                this.getMessage().addBytesPart(bytes);
            }
        }

        private boolean getIgnoreFailedMembers() {
            boolean ignoreFailedMembers = false;
            if (this.flags != null && this.flags.length > 1 && this.flags[1] == 1) {
                ignoreFailedMembers = true;
            }
            return ignoreFailedMembers;
        }

        @Override
        protected Object processResponse(Message msg) throws Exception {
            ChunkedMessage executeFunctionResponseMsg = (ChunkedMessage)msg;
            try {
                executeFunctionResponseMsg.readHeader();
                switch (executeFunctionResponseMsg.getMessageType()) {
                    case 63: {
                        Object resultResponse;
                        if (logger.isDebugEnabled()) {
                            logger.debug("ExecuteFunctionOpImpl#processResponse: received message of type EXECUTE_FUNCTION_RESULT.");
                        }
                        GemFireException exception = null;
                        do {
                            executeFunctionResponseMsg.receiveChunk();
                            resultResponse = executeFunctionResponseMsg.getPart(0).getObject();
                            Object result = resultResponse instanceof ArrayList ? ((ArrayList)resultResponse).get(0) : resultResponse;
                            if (result instanceof FunctionException) {
                                FunctionException ex = (FunctionException)result;
                                if (ex instanceof InternalFunctionException || this.getIgnoreFailedMembers()) {
                                    Throwable cause = ex.getCause() == null ? ex : ex.getCause();
                                    DistributedMember memberID = (DistributedMember)((ArrayList)resultResponse).get(1);
                                    this.resultCollector.addResult(memberID, cause);
                                    FunctionStatsManager.getFunctionStats(this.functionId).incResultsReceived();
                                    continue;
                                }
                                exception = ex;
                                continue;
                            }
                            if (result instanceof Throwable) {
                                String s = "While performing a remote " + this.getOpName();
                                exception = new ServerOperationException(s, (Throwable)result);
                                continue;
                            }
                            DistributedMember memberID = (DistributedMember)((ArrayList)resultResponse).get(1);
                            this.resultCollector.addResult(memberID, result);
                            FunctionStatsManager.getFunctionStats(this.functionId).incResultsReceived();
                        } while (!executeFunctionResponseMsg.isLastChunk());
                        if (exception != null) {
                            throw exception;
                        }
                        if (logger.isDebugEnabled()) {
                            logger.debug("ExecuteFunctionOpImpl#processResponse: received all the results from server successfully.");
                        }
                        resultResponse = null;
                        return resultResponse;
                    }
                    case 2: {
                        if (logger.isDebugEnabled()) {
                            logger.debug("ExecuteFunctionOpImpl#processResponse: received message of type EXCEPTION");
                        }
                        executeFunctionResponseMsg.receiveChunk();
                        Part part0 = executeFunctionResponseMsg.getPart(0);
                        Object obj = part0.getObject();
                        if (obj instanceof FunctionException) {
                            throw (FunctionException)obj;
                        }
                        Throwable t = (Throwable)obj;
                        throw new ServerOperationException(": While performing a remote execute Function" + t.getMessage(), t);
                    }
                    case 64: {
                        if (logger.isDebugEnabled()) {
                            logger.debug("ExecuteFunctionOpImpl#processResponse: received message of type EXECUTE_FUNCTION_ERROR");
                        }
                        executeFunctionResponseMsg.receiveChunk();
                        String errorMessage = executeFunctionResponseMsg.getPart(0).getString();
                        throw new ServerOperationException(errorMessage);
                    }
                }
                throw new InternalGemFireError(String.format("Unknown message type %s", executeFunctionResponseMsg.getMessageType()));
            }
            finally {
                executeFunctionResponseMsg.clear();
            }
        }

        @Override
        protected boolean isErrorResponse(int msgType) {
            return msgType == 64;
        }

        @Override
        protected long startAttempt(ConnectionStats stats) {
            return stats.startExecuteFunction();
        }

        protected String getOpName() {
            return "executeFunction";
        }

        @Override
        protected void endSendAttempt(ConnectionStats stats, long start) {
            stats.endExecuteFunctionSend(start, this.hasFailed());
        }

        @Override
        protected void endAttempt(ConnectionStats stats, long start) {
            stats.endExecuteFunction(start, this.hasTimedOut(), this.hasFailed());
        }

        @Override
        protected Message createResponseMessage() {
            return new ChunkedMessage(1, KnownVersion.CURRENT);
        }
    }
}

