/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.cache.operations;

public abstract class OperationContext {
    public abstract OperationCode getOperationCode();

    public abstract boolean isPostOperation();

    public boolean isClientUpdate() {
        if (this.isPostOperation()) {
            switch (this.getOperationCode()) {
                case PUT: 
                case PUTALL: 
                case DESTROY: 
                case REMOVEALL: 
                case INVALIDATE: 
                case REGION_CREATE: 
                case REGION_DESTROY: 
                case REGION_CLEAR: {
                    return true;
                }
            }
        }
        return false;
    }

    @Deprecated
    public boolean isClientUpdate(OperationContext context) {
        OperationCode opCode = context.getOperationCode();
        return context.isPostOperation() && (opCode.isPut() || opCode.isPutAll() || opCode.isDestroy() || opCode.isRemoveAll() || opCode.isInvalidate() || opCode.isRegionCreate() || opCode.isRegionDestroy() || opCode.isRegionClear());
    }

    public static enum OperationCode {
        GET,
        PUT,
        PUTALL,
        REMOVEALL,
        DESTROY,
        INVALIDATE,
        REGISTER_INTEREST,
        UNREGISTER_INTEREST,
        CONTAINS_KEY,
        KEY_SET,
        QUERY,
        EXECUTE_CQ,
        STOP_CQ,
        CLOSE_CQ,
        REGION_CLEAR,
        REGION_CREATE,
        REGION_DESTROY,
        EXECUTE_FUNCTION,
        GET_DURABLE_CQS;


        @Deprecated
        public boolean isGet() {
            return this == GET;
        }

        @Deprecated
        public boolean isPut() {
            return this == PUT;
        }

        @Deprecated
        public boolean isPutAll() {
            return this == PUTALL;
        }

        @Deprecated
        public boolean isRemoveAll() {
            return this == REMOVEALL;
        }

        @Deprecated
        public boolean isDestroy() {
            return this == DESTROY;
        }

        @Deprecated
        public boolean isInvalidate() {
            return this == INVALIDATE;
        }

        @Deprecated
        public boolean isRegisterInterest() {
            return this == REGISTER_INTEREST;
        }

        @Deprecated
        public boolean isUnregisterInterest() {
            return this == UNREGISTER_INTEREST;
        }

        @Deprecated
        public boolean isContainsKey() {
            return this == CONTAINS_KEY;
        }

        @Deprecated
        public boolean isKeySet() {
            return this == KEY_SET;
        }

        @Deprecated
        public boolean isQuery() {
            return this == QUERY;
        }

        @Deprecated
        public boolean isExecuteCQ() {
            return this == EXECUTE_CQ;
        }

        @Deprecated
        public boolean isStopCQ() {
            return this == STOP_CQ;
        }

        @Deprecated
        public boolean isCloseCQ() {
            return this == CLOSE_CQ;
        }

        @Deprecated
        public boolean isRegionClear() {
            return this == REGION_CLEAR;
        }

        @Deprecated
        public boolean isRegionCreate() {
            return this == REGION_CREATE;
        }

        @Deprecated
        public boolean isRegionDestroy() {
            return this == REGION_DESTROY;
        }

        @Deprecated
        public boolean isExecuteRegionFunction() {
            return this == EXECUTE_FUNCTION;
        }

        @Deprecated
        public boolean isGetDurableCQs() {
            return this == GET_DURABLE_CQS;
        }
    }
}

