/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.cache.query.internal;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.Collection;
import java.util.Iterator;
import org.apache.geode.cache.query.SelectResults;
import org.apache.geode.cache.query.internal.Bag;
import org.apache.geode.cache.query.internal.HashingStrategy;
import org.apache.geode.cache.query.internal.ObjectIntHashMap;
import org.apache.geode.cache.query.types.ObjectType;
import org.apache.geode.internal.cache.CachePerfStats;
import org.apache.geode.internal.serialization.DataSerializableFixedID;
import org.apache.geode.internal.serialization.DeserializationContext;
import org.apache.geode.internal.serialization.KnownVersion;
import org.apache.geode.internal.serialization.SerializationContext;

public class ResultsBag
extends Bag
implements DataSerializableFixedID {
    protected ObjectIntHashMap map;

    public ResultsBag() {
        this.map = new ObjectIntHashMap();
    }

    public ResultsBag(boolean ignored) {
        super(ignored);
    }

    public ResultsBag(CachePerfStats stats) {
        super(stats);
        this.map = new ObjectIntHashMap();
    }

    protected ResultsBag(HashingStrategy strategy, CachePerfStats stats) {
        super(stats);
        this.map = new ObjectIntHashMap(strategy);
    }

    ResultsBag(Collection c, CachePerfStats stats) {
        this(stats);
        Iterator itr = c.iterator();
        while (itr.hasNext()) {
            this.add(itr.next());
        }
    }

    protected ResultsBag(Collection c, HashingStrategy strategy, CachePerfStats stats) {
        this(strategy, stats);
        Iterator itr = c.iterator();
        while (itr.hasNext()) {
            this.add(itr.next());
        }
    }

    ResultsBag(SelectResults sr, CachePerfStats stats) {
        this((Collection)sr, stats);
        this.setElementType(sr.getCollectionType().getElementType());
    }

    ResultsBag(ObjectType elementType, CachePerfStats stats) {
        this(stats);
        this.setElementType(elementType);
    }

    ResultsBag(ObjectType elementType, int initialCapacity, CachePerfStats stats) {
        this(initialCapacity, stats);
        this.setElementType(elementType);
    }

    ResultsBag(int initialCapacity, float loadFactor, CachePerfStats stats) {
        this.map = new ObjectIntHashMap(initialCapacity, loadFactor);
    }

    protected ResultsBag(int initialCapacity, float loadFactor, HashingStrategy strategy, CachePerfStats stats) {
        super(stats);
        this.map = new ObjectIntHashMap(initialCapacity, loadFactor, strategy);
    }

    ResultsBag(int initialCapacity, CachePerfStats stats) {
        super(stats);
        this.map = new ObjectIntHashMap(initialCapacity);
    }

    protected ResultsBag(int initialCapacity, HashingStrategy strategy, CachePerfStats stats) {
        super(stats);
        this.map = new ObjectIntHashMap(initialCapacity, strategy);
    }

    protected ObjectIntHashMap createMapForFromData() {
        return new ObjectIntHashMap(this.size);
    }

    public void fromData(DataInput in, DeserializationContext context) throws IOException, ClassNotFoundException {
        int occurrence;
        this.elementType = (ObjectType)context.getDeserializer().readObject(in);
        this.size = in.readInt();
        assert (this.size >= 0) : this.size;
        this.map = this.createMapForFromData();
        this.readNumNulls(in);
        for (int numLeft = this.size - this.numNulls; numLeft > 0; numLeft -= occurrence) {
            Object key = context.getDeserializer().readObject(in);
            occurrence = in.readInt();
            this.map.put(key, occurrence);
        }
    }

    public int getDSFID() {
        return 15;
    }

    public void toData(DataOutput out, SerializationContext context) throws IOException {
        int occurrence;
        context.getSerializer().writeObject((Object)this.elementType, out);
        out.writeInt(this.size());
        this.writeNumNulls(out);
        Iterator<ObjectIntHashMap.Entry> itr = this.map.entrySet().iterator();
        for (int numLeft = this.size() - this.numNulls; itr.hasNext() && numLeft > 0; numLeft -= occurrence) {
            ObjectIntHashMap.Entry entry = itr.next();
            Object key = entry.getKey();
            context.getSerializer().writeObject(key, out);
            occurrence = entry.getValue();
            if (numLeft < occurrence) {
                occurrence = numLeft;
            }
            out.writeInt(occurrence);
        }
    }

    void createIntHashMap() {
        this.map = new ObjectIntHashMap(this.size - this.numNulls);
    }

    @Override
    public boolean isModifiable() {
        return true;
    }

    public KnownVersion[] getSerializationVersions() {
        return null;
    }

    @Override
    protected int mapGet(Object element) {
        return this.map.get(element);
    }

    @Override
    protected boolean mapContainsKey(Object element) {
        return this.map.containsKey(element);
    }

    @Override
    protected void mapPut(Object element, int count) {
        this.map.put(element, count);
    }

    @Override
    protected int mapSize() {
        return this.map.size();
    }

    @Override
    protected int mapRemove(Object element) {
        return this.map.remove(element);
    }

    @Override
    protected void mapClear() {
        this.map.clear();
    }

    @Override
    protected Object getMap() {
        return this.map;
    }

    @Override
    protected int mapHashCode() {
        return this.map.hashCode();
    }

    @Override
    protected boolean mapEmpty() {
        return this.map.isEmpty();
    }

    @Override
    protected Iterator mapEntryIterator() {
        return this.map.entrySet().iterator();
    }

    @Override
    protected Iterator mapKeyIterator() {
        return this.map.keySet().iterator();
    }

    @Override
    protected Object keyFromEntry(Object entry) {
        return ((ObjectIntHashMap.Entry)entry).getKey();
    }

    @Override
    protected Integer valueFromEntry(Object entry) {
        return ((ObjectIntHashMap.Entry)entry).getValue();
    }
}

