/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.cache.query.internal.index;

import it.unimi.dsi.fastutil.objects.Object2ObjectOpenHashMap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.NavigableMap;
import java.util.Set;
import java.util.SortedMap;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentNavigableMap;
import java.util.concurrent.ConcurrentSkipListMap;
import org.apache.geode.annotations.internal.MutableForTesting;
import org.apache.geode.cache.Region;
import org.apache.geode.cache.RegionAttributes;
import org.apache.geode.cache.query.FunctionDomainException;
import org.apache.geode.cache.query.IndexStatistics;
import org.apache.geode.cache.query.IndexType;
import org.apache.geode.cache.query.NameResolutionException;
import org.apache.geode.cache.query.QueryException;
import org.apache.geode.cache.query.QueryInvocationTargetException;
import org.apache.geode.cache.query.QueryService;
import org.apache.geode.cache.query.SelectResults;
import org.apache.geode.cache.query.TypeMismatchException;
import org.apache.geode.cache.query.internal.CompiledSortCriterion;
import org.apache.geode.cache.query.internal.CompiledValue;
import org.apache.geode.cache.query.internal.ExecutionContext;
import org.apache.geode.cache.query.internal.QueryObserver;
import org.apache.geode.cache.query.internal.QueryObserverHolder;
import org.apache.geode.cache.query.internal.RuntimeIterator;
import org.apache.geode.cache.query.internal.index.AbstractIndex;
import org.apache.geode.cache.query.internal.index.CompactRangeIndex;
import org.apache.geode.cache.query.internal.index.IMQException;
import org.apache.geode.cache.query.internal.index.IndexCreationHelper;
import org.apache.geode.cache.query.internal.index.IndexManager;
import org.apache.geode.cache.query.internal.index.IndexProtocol;
import org.apache.geode.cache.query.internal.index.IndexStats;
import org.apache.geode.cache.query.internal.index.IndexStore;
import org.apache.geode.cache.query.internal.types.TypeUtils;
import org.apache.geode.cache.query.types.ObjectType;
import org.apache.geode.internal.cache.InternalCache;
import org.apache.geode.internal.cache.RegionEntry;
import org.apache.geode.internal.cache.persistence.query.CloseableIterator;

public class RangeIndex
extends AbstractIndex {
    protected volatile int valueToEntriesMapSize = 0;
    final ConcurrentNavigableMap valueToEntriesMap = new ConcurrentSkipListMap(TypeUtils.getExtendedNumericComparator());
    private final AbstractIndex.RegionEntryToValuesMap entryToValuesMap;
    protected AbstractIndex.RegionEntryToValuesMap nullMappedEntries;
    protected AbstractIndex.RegionEntryToValuesMap undefinedMappedEntries;
    protected ThreadLocal<Map> keysToHashSetMap = new ThreadLocal();
    protected ThreadLocal<List> nullEntries = new ThreadLocal();
    protected ThreadLocal<List> undefinedEntries = new ThreadLocal();
    @MutableForTesting
    public static IndexManager.TestHook testHook;

    public RangeIndex(InternalCache cache, String indexName, Region region, String fromClause, String indexedExpression, String projectionAttributes, String origFromClause, String origIndexExpr, String[] definitions, IndexStatistics stats) {
        super(cache, indexName, region, fromClause, indexedExpression, projectionAttributes, origFromClause, origIndexExpr, definitions, stats);
        RegionAttributes ra = region.getAttributes();
        this.entryToValuesMap = new AbstractIndex.RegionEntryToValuesMap(new ConcurrentHashMap(ra.getInitialCapacity(), ra.getLoadFactor(), ra.getConcurrencyLevel()), false);
        this.nullMappedEntries = new AbstractIndex.RegionEntryToValuesMap(true);
        this.undefinedMappedEntries = new AbstractIndex.RegionEntryToValuesMap(true);
    }

    @Override
    protected boolean isCompactRangeIndex() {
        return false;
    }

    @Override
    void instantiateEvaluator(IndexCreationHelper indexCreationHelper) {
        this.evaluator = new AbstractIndex.IMQEvaluator(indexCreationHelper);
    }

    @Override
    public void initializeIndex(boolean loadEntries) throws IMQException {
        long startTime = System.nanoTime();
        this.evaluator.initializeIndex(loadEntries);
        long endTime = System.nanoTime();
        this.internalIndexStats.incUpdateTime(endTime - startTime);
    }

    @Override
    void addMapping(RegionEntry entry) throws IMQException {
        this.evaluator.evaluate(entry, true);
        this.addSavedMappings(entry);
        this.clearCurrState();
    }

    @Override
    void saveMapping(Object key, Object indxResultSet, RegionEntry entry) {
        if (key == null) {
            ArrayList<Object> nullSet = this.nullEntries.get();
            if (nullSet == null) {
                nullSet = new ArrayList<Object>(1);
                this.nullEntries.set(nullSet);
            }
            nullSet.add(indxResultSet);
        } else if (key == QueryService.UNDEFINED) {
            ArrayList<Object> undefinedSet = this.undefinedEntries.get();
            if (undefinedSet == null) {
                undefinedSet = new ArrayList<Object>(1);
                this.undefinedEntries.set(undefinedSet);
            }
            if (indxResultSet != null && !indxResultSet.getClass().getName().startsWith("org.apache.geode.internal.cache.Token$") && indxResultSet != QueryService.UNDEFINED) {
                undefinedSet.add(indxResultSet);
            }
        } else {
            Object value;
            Map keysToSetMap = this.keysToHashSetMap.get();
            if (keysToSetMap == null) {
                keysToSetMap = new Object2ObjectOpenHashMap(1);
                this.keysToHashSetMap.set(keysToSetMap);
            }
            if ((value = keysToSetMap.get(key)) == null) {
                keysToSetMap.put(key, indxResultSet);
            } else if (value instanceof Collection) {
                ((Collection)value).add(indxResultSet);
            } else {
                ArrayList<Object> values = new ArrayList<Object>(2);
                values.add(indxResultSet);
                values.add(value);
                keysToSetMap.put(key, values);
            }
        }
        this.internalIndexStats.incNumUpdates();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addSavedMappings(RegionEntry entry) throws IMQException {
        List nullSet = this.nullEntries.get();
        List undefinedSet = this.undefinedEntries.get();
        Map keysMap = this.keysToHashSetMap.get();
        if (nullSet != null && nullSet.size() > 0) {
            this.internalIndexStats.incNumValues(-this.nullMappedEntries.getNumValues(entry) + nullSet.size());
            this.nullMappedEntries.replace(entry, nullSet.size() > 1 ? nullSet : nullSet.iterator().next());
        } else {
            this.internalIndexStats.incNumValues(-this.nullMappedEntries.getNumValues(entry));
            this.nullMappedEntries.remove(entry);
        }
        if (undefinedSet != null && undefinedSet.size() > 0) {
            this.internalIndexStats.incNumValues(-this.undefinedMappedEntries.getNumValues(entry) + undefinedSet.size());
            this.undefinedMappedEntries.replace(entry, undefinedSet.size() > 1 ? undefinedSet : undefinedSet.iterator().next());
        } else {
            this.internalIndexStats.incNumValues(-this.undefinedMappedEntries.getNumValues(entry));
            this.undefinedMappedEntries.remove(entry);
        }
        Object oldkeys = this.entryToValuesMap.remove(entry);
        if (keysMap != null) {
            Set keys = keysMap.keySet();
            try {
                if (oldkeys != null) {
                    if (oldkeys instanceof Collection) {
                        for (Object key : keys) {
                            ((Collection)oldkeys).remove(TypeUtils.indexKeyFor(key));
                        }
                    } else {
                        for (Object key : keys) {
                            if (!TypeUtils.indexKeyFor(key).equals(oldkeys)) continue;
                            oldkeys = null;
                        }
                    }
                }
            }
            catch (Exception ex) {
                throw new IMQException(String.format("Could not add object of type %s", oldkeys.getClass().getName()), ex);
            }
            if (keys.size() == 1) {
                Object key = keys.iterator().next();
                try {
                    Object newKey = TypeUtils.indexKeyFor(key);
                    boolean retry = false;
                    do {
                        AbstractIndex.RegionEntryToValuesMap oldValue;
                        retry = false;
                        AbstractIndex.RegionEntryToValuesMap rvMap = (AbstractIndex.RegionEntryToValuesMap)this.valueToEntriesMap.get(newKey);
                        if (rvMap == null) {
                            rvMap = new AbstractIndex.RegionEntryToValuesMap(true);
                            oldValue = this.valueToEntriesMap.putIfAbsent(newKey, rvMap);
                            if (oldValue != null) {
                                retry = true;
                                continue;
                            }
                            this.internalIndexStats.incNumKeys(1L);
                            ++this.valueToEntriesMapSize;
                        }
                        if (retry) continue;
                        oldValue = rvMap;
                        synchronized (oldValue) {
                            if (rvMap != this.valueToEntriesMap.get(newKey)) {
                                retry = true;
                            } else {
                                Object newValues = keysMap.get(key);
                                Object oldValues = rvMap.get(entry);
                                rvMap.replace(entry, newValues);
                                this.entryToValuesMap.add(entry, newKey);
                                int diff = this.calculateSizeDiff(oldValues, newValues);
                                this.internalIndexStats.incNumValues(diff);
                            }
                        }
                    } while (retry);
                }
                catch (TypeMismatchException ex) {
                    throw new IMQException(String.format("Could not add object of type %s", key.getClass().getName()), ex);
                }
            } else {
                for (Object key : keys) {
                    try {
                        Object newKey = TypeUtils.indexKeyFor(key);
                        boolean retry = false;
                        do {
                            retry = false;
                            AbstractIndex.RegionEntryToValuesMap rvMap = (AbstractIndex.RegionEntryToValuesMap)this.valueToEntriesMap.get(newKey);
                            if (rvMap == null) {
                                rvMap = new AbstractIndex.RegionEntryToValuesMap(true);
                                AbstractIndex.RegionEntryToValuesMap oldValue = this.valueToEntriesMap.putIfAbsent(newKey, rvMap);
                                if (oldValue != null) {
                                    retry = true;
                                    continue;
                                }
                                this.internalIndexStats.incNumKeys(1L);
                                ++this.valueToEntriesMapSize;
                            }
                            if (retry) continue;
                            AbstractIndex.RegionEntryToValuesMap regionEntryToValuesMap = rvMap;
                            synchronized (regionEntryToValuesMap) {
                                if (rvMap != this.valueToEntriesMap.get(newKey)) {
                                    retry = true;
                                } else {
                                    Object newValues = keysMap.get(key);
                                    Object oldValues = rvMap.get(entry);
                                    rvMap.replace(entry, newValues);
                                    this.entryToValuesMap.add(entry, newKey);
                                    int diff = this.calculateSizeDiff(oldValues, newValues);
                                    this.internalIndexStats.incNumValues(diff);
                                }
                            }
                        } while (retry);
                    }
                    catch (TypeMismatchException ex) {
                        throw new IMQException(String.format("Could not add object of type %s", key.getClass().getName()), ex);
                    }
                }
            }
        }
        if (oldkeys != null) {
            this.removeOldMapping(entry, oldkeys);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void removeOldMapping(RegionEntry entry, Object oldkeys) throws IMQException {
        if (oldkeys instanceof Collection) {
            for (Object key : (Iterable)oldkeys) {
                AbstractIndex.RegionEntryToValuesMap rvMap = (AbstractIndex.RegionEntryToValuesMap)this.valueToEntriesMap.get(key);
                if (rvMap == null) {
                    throw new IMQException(String.format("Indexed object's class %s compareTo function is errorneous.", oldkeys.getClass().getName()));
                }
                this.internalIndexStats.incNumValues(-rvMap.getNumValues(entry));
                rvMap.remove(entry);
                if (rvMap.getNumEntries() != 0) continue;
                AbstractIndex.RegionEntryToValuesMap regionEntryToValuesMap = rvMap;
                synchronized (regionEntryToValuesMap) {
                    if (rvMap.getNumEntries() == 0 && this.valueToEntriesMap.remove(key, rvMap)) {
                        this.internalIndexStats.incNumKeys(-1L);
                        --this.valueToEntriesMapSize;
                    }
                }
            }
        } else {
            AbstractIndex.RegionEntryToValuesMap rvMap = (AbstractIndex.RegionEntryToValuesMap)this.valueToEntriesMap.get(oldkeys);
            if (rvMap == null) {
                throw new IMQException(String.format("Indexed object's class %s compareTo function is errorneous.", oldkeys.getClass().getName()));
            }
            this.internalIndexStats.incNumValues(-rvMap.getNumValues(entry));
            rvMap.remove(entry);
            if (rvMap.getNumEntries() == 0) {
                AbstractIndex.RegionEntryToValuesMap regionEntryToValuesMap = rvMap;
                synchronized (regionEntryToValuesMap) {
                    if (rvMap.getNumEntries() == 0 && this.valueToEntriesMap.remove(oldkeys, rvMap)) {
                        this.internalIndexStats.incNumKeys(-1L);
                        --this.valueToEntriesMapSize;
                    }
                }
            }
        }
    }

    private int calculateSizeDiff(Object oldValues, Object newValues) {
        int oldSize = 0;
        int newSize = 0;
        if (oldValues != null) {
            oldSize = oldValues instanceof Collection ? -((Collection)oldValues).size() : -1;
        }
        if (newValues != null) {
            newSize = newValues instanceof Collection ? ((Collection)newValues).size() : 1;
        }
        return oldSize + newSize;
    }

    public void clearCurrState() {
        this.nullEntries.remove();
        this.undefinedEntries.remove();
        this.keysToHashSetMap.remove();
    }

    @Override
    public boolean clear() throws QueryException {
        throw new UnsupportedOperationException("Not yet implemented");
    }

    @Override
    public ObjectType getResultSetType() {
        return this.evaluator.getIndexResultSetType();
    }

    @Override
    public IndexType getType() {
        return IndexType.FUNCTIONAL;
    }

    @Override
    void addMapping(Object key, Object value, RegionEntry entry) throws IMQException {
        if (key == null) {
            this.nullMappedEntries.add(entry, value);
            this.internalIndexStats.incNumValues(1);
        } else if (key == QueryService.UNDEFINED) {
            if (value != null && !value.getClass().getName().startsWith("org.apache.geode.internal.cache.Token$") && value != QueryService.UNDEFINED) {
                this.undefinedMappedEntries.add(entry, value);
                this.internalIndexStats.incNumValues(1);
            }
        } else {
            try {
                Object newKey = TypeUtils.indexKeyFor(key);
                AbstractIndex.RegionEntryToValuesMap rvMap = (AbstractIndex.RegionEntryToValuesMap)this.valueToEntriesMap.get(newKey);
                if (rvMap == null) {
                    rvMap = new AbstractIndex.RegionEntryToValuesMap(true);
                    this.valueToEntriesMap.put(newKey, rvMap);
                    this.internalIndexStats.incNumKeys(1L);
                    ++this.valueToEntriesMapSize;
                }
                rvMap.add(entry, value);
                this.entryToValuesMap.add(entry, newKey);
                this.internalIndexStats.incNumValues(1);
            }
            catch (TypeMismatchException ex) {
                throw new IMQException(String.format("Could not add object of type %s", key.getClass().getName()), ex);
            }
        }
        this.internalIndexStats.incNumUpdates();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    void removeMapping(RegionEntry entry, int opCode) throws IMQException {
        if (opCode == 1 || opCode == 4) {
            return;
        }
        Object values = this.entryToValuesMap.get(entry);
        if (values == null) {
            if (this.nullMappedEntries.containsEntry(entry)) {
                this.internalIndexStats.incNumValues(-this.nullMappedEntries.getNumValues(entry));
                this.nullMappedEntries.remove(entry);
            } else {
                this.internalIndexStats.incNumValues(-this.undefinedMappedEntries.getNumValues(entry));
                this.undefinedMappedEntries.remove(entry);
            }
        } else if (values instanceof Collection) {
            for (Object key : (Iterable)values) {
                AbstractIndex.RegionEntryToValuesMap rvMap = (AbstractIndex.RegionEntryToValuesMap)this.valueToEntriesMap.get(key);
                this.internalIndexStats.incNumValues(-rvMap.getNumValues(entry));
                rvMap.remove(entry);
                if (rvMap.getNumEntries() != 0) continue;
                AbstractIndex.RegionEntryToValuesMap regionEntryToValuesMap = rvMap;
                synchronized (regionEntryToValuesMap) {
                    if (rvMap.getNumEntries() == 0 && this.valueToEntriesMap.remove(key, rvMap)) {
                        this.internalIndexStats.incNumKeys(-1L);
                        --this.valueToEntriesMapSize;
                    }
                }
            }
            this.entryToValuesMap.remove(entry);
        } else {
            AbstractIndex.RegionEntryToValuesMap rvMap = (AbstractIndex.RegionEntryToValuesMap)this.valueToEntriesMap.get(values);
            if (rvMap == null) {
                throw new IMQException(String.format("Indexed object's class %s compareTo function is errorneous.", values.getClass().getName()));
            }
            this.internalIndexStats.incNumValues(-rvMap.getNumValues(entry));
            rvMap.remove(entry);
            if (rvMap.getNumEntries() == 0) {
                AbstractIndex.RegionEntryToValuesMap regionEntryToValuesMap = rvMap;
                synchronized (regionEntryToValuesMap) {
                    if (rvMap.getNumEntries() == 0 && this.valueToEntriesMap.remove(values, rvMap)) {
                        this.internalIndexStats.incNumKeys(-1L);
                        --this.valueToEntriesMapSize;
                    }
                }
            }
            this.entryToValuesMap.remove(entry);
        }
        this.internalIndexStats.incNumUpdates();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List queryEquijoinCondition(IndexProtocol indx, ExecutionContext context) throws TypeMismatchException, FunctionDomainException, NameResolutionException, QueryInvocationTargetException {
        ArrayList arrayList;
        long start = this.updateIndexUseStats();
        ((AbstractIndex)indx).updateIndexUseStats();
        ArrayList data = new ArrayList();
        Iterator<Object> inner = null;
        try {
            Iterator outer = this.valueToEntriesMap.entrySet().iterator();
            inner = indx instanceof CompactRangeIndex ? ((CompactRangeIndex)indx).getIndexStorage().iterator(null) : ((RangeIndex)indx).getValueToEntriesMap().entrySet().iterator();
            Map.Entry outerEntry = null;
            Object innerEntry = null;
            Object outerKey = null;
            Object innerKey = null;
            boolean incrementInner = true;
            block2: while (outer.hasNext()) {
                outerEntry = outer.next();
                outerKey = outerEntry.getKey();
                while (!incrementInner || inner.hasNext()) {
                    int compare;
                    if (incrementInner) {
                        innerEntry = inner.next();
                        innerKey = innerEntry instanceof IndexStore.IndexStoreEntry ? ((IndexStore.IndexStoreEntry)innerEntry).getDeserializedKey() : ((Map.Entry)innerEntry).getKey();
                    }
                    if ((compare = ((Comparable)outerKey).compareTo(innerKey)) == 0) {
                        CloseableIterator<IndexStore.IndexStoreEntry> innerValue = null;
                        innerValue = innerEntry instanceof IndexStore.IndexStoreEntry ? ((CompactRangeIndex)indx).getIndexStorage().get(outerKey) : (CloseableIterator<IndexStore.IndexStoreEntry>)((Map.Entry)innerEntry).getValue();
                        this.populateListForEquiJoin(data, outerEntry.getValue(), innerValue, context, outerEntry.getKey());
                        incrementInner = true;
                        continue block2;
                    }
                    if (compare < 0) {
                        incrementInner = false;
                        continue block2;
                    }
                    incrementInner = true;
                }
                break block2;
            }
            arrayList = data;
            ((AbstractIndex)indx).updateIndexUseEndStats(start);
        }
        catch (Throwable throwable) {
            ((AbstractIndex)indx).updateIndexUseEndStats(start);
            this.updateIndexUseEndStats(start);
            if (inner != null && indx instanceof CompactRangeIndex) {
                inner.close();
            }
            throw throwable;
        }
        this.updateIndexUseEndStats(start);
        if (inner != null && indx instanceof CompactRangeIndex) {
            ((CloseableIterator)inner).close();
        }
        return arrayList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public int getSizeEstimate(Object key, int operator, int matchLevel) throws TypeMismatchException {
        int size = 0;
        long start = this.updateIndexUseStats(false);
        try {
            switch (operator) {
                case 13: {
                    if (key == null) {
                        size = this.nullMappedEntries.getNumValues();
                        return size;
                    }
                    if (key == QueryService.UNDEFINED) {
                        size = this.undefinedMappedEntries.getNumValues();
                        return size;
                    }
                    key = TypeUtils.indexKeyFor(key);
                    AbstractIndex.RegionEntryToValuesMap valMap = (AbstractIndex.RegionEntryToValuesMap)this.valueToEntriesMap.get(key = this.getPdxStringForIndexedPdxKeys(key));
                    size = valMap == null ? 0 : valMap.getNumValues();
                    return size;
                }
                case 20: 
                case 21: {
                    size = this.region.size();
                    if (key == null) {
                        return size -= this.nullMappedEntries.getNumValues();
                    }
                    if (key == QueryService.UNDEFINED) {
                        return size -= this.undefinedMappedEntries.getNumValues();
                    }
                    key = TypeUtils.indexKeyFor(key);
                    AbstractIndex.RegionEntryToValuesMap valMap = (AbstractIndex.RegionEntryToValuesMap)this.valueToEntriesMap.get(key = this.getPdxStringForIndexedPdxKeys(key));
                    return size -= valMap == null ? 0 : valMap.getNumValues();
                }
                case 18: 
                case 22: {
                    if (matchLevel <= 0 && key instanceof Number) {
                        int totalSize = this.valueToEntriesMapSize;
                        if (testHook != null) {
                            testHook.hook(1);
                        }
                        if (totalSize > 1) {
                            Number keyAsNum = (Number)key;
                            int x = 0;
                            Map.Entry firstEntry = this.valueToEntriesMap.firstEntry();
                            Map.Entry lastEntry = this.valueToEntriesMap.lastEntry();
                            if (firstEntry != null && lastEntry != null) {
                                Number first = (Number)firstEntry.getKey();
                                Number last = (Number)lastEntry.getKey();
                                if (first.doubleValue() != last.doubleValue()) {
                                    x = (int)((keyAsNum.doubleValue() - first.doubleValue()) * (double)totalSize / (last.doubleValue() - first.doubleValue()));
                                }
                            }
                            if (x < 0) {
                                x = 0;
                            }
                            size = x;
                            return size;
                        }
                        size = this.valueToEntriesMap.containsKey(key) ? 1 : 0;
                        return size;
                    }
                    size = Integer.MAX_VALUE;
                    return size;
                }
                case 19: 
                case 23: {
                    if (matchLevel <= 0 && key instanceof Number) {
                        int totalSize = this.valueToEntriesMapSize;
                        if (testHook != null) {
                            testHook.hook(2);
                        }
                        if (totalSize > 1) {
                            Number keyAsNum = (Number)key;
                            int x = 0;
                            Map.Entry firstEntry = this.valueToEntriesMap.firstEntry();
                            Map.Entry lastEntry = this.valueToEntriesMap.lastEntry();
                            if (firstEntry != null && lastEntry != null) {
                                Number first = (Number)firstEntry.getKey();
                                Number last = (Number)lastEntry.getKey();
                                if (first.doubleValue() != last.doubleValue()) {
                                    double totalRange = last.doubleValue() - first.doubleValue();
                                    assert (totalRange != 0.0) : this.valueToEntriesMap.keySet();
                                    double part = last.doubleValue() - keyAsNum.doubleValue();
                                    x = (int)(part * (double)totalSize / totalRange);
                                }
                            }
                            if (x < 0) {
                                x = 0;
                            }
                            size = x;
                            return size;
                        }
                        size = this.valueToEntriesMap.containsKey(key) ? 1 : 0;
                        return size;
                    }
                    size = Integer.MAX_VALUE;
                    return size;
                }
            }
            return size;
        }
        finally {
            this.updateIndexUseEndStats(start, false);
        }
    }

    private void evaluate(Object key, int operator, Collection results, Set keysToRemove, int limit, ExecutionContext context) throws TypeMismatchException {
        key = TypeUtils.indexKeyFor(key);
        Boolean orderByClause = (Boolean)context.cacheGet("can_apply_orderby_at_index");
        boolean multiColOrderBy = false;
        boolean asc = true;
        List orderByAttrs = null;
        if (orderByClause != null && orderByClause.booleanValue()) {
            orderByAttrs = (List)context.cacheGet("orderby");
            CompiledSortCriterion csc = (CompiledSortCriterion)orderByAttrs.get(0);
            asc = !csc.getCriterion();
            multiColOrderBy = orderByAttrs.size() > 1;
        }
        limit = multiColOrderBy ? -1 : limit;
        try {
            switch (operator) {
                case 13: {
                    assert (keysToRemove == null);
                    this.addValuesToResult(this.valueToEntriesMap.get(key), results, keysToRemove, limit, context);
                    break;
                }
                case 22: {
                    NavigableMap sm = this.valueToEntriesMap.headMap(key, false);
                    sm = asc ? sm : sm.descendingMap();
                    this.addValuesToResult(sm, results, keysToRemove, limit, context);
                    break;
                }
                case 18: {
                    NavigableMap sm = this.valueToEntriesMap.headMap(key, true);
                    sm = asc ? sm : sm.descendingMap();
                    this.addValuesToResult(sm, results, keysToRemove, limit, context);
                    break;
                }
                case 23: {
                    NavigableMap sm = this.valueToEntriesMap.tailMap(key, false);
                    sm = asc ? sm : sm.descendingMap();
                    this.addValuesToResult(sm, results, keysToRemove, limit, context);
                    break;
                }
                case 19: {
                    NavigableMap sm = this.valueToEntriesMap.tailMap(key, true);
                    sm = asc ? sm : sm.descendingMap();
                    this.addValuesToResult(sm, results, keysToRemove, limit, context);
                    break;
                }
                case 20: 
                case 21: {
                    NavigableMap sm = this.valueToEntriesMap;
                    if (!asc) {
                        sm = sm.descendingMap();
                    }
                    if (keysToRemove == null) {
                        this.addValuesToResultSingleKeyToRemove(sm, results, key, limit, context);
                    } else {
                        keysToRemove.add(key);
                        this.addValuesToResult(sm, results, keysToRemove, limit, context);
                    }
                    this.nullMappedEntries.addValuesToCollection(results, limit, context);
                    this.undefinedMappedEntries.addValuesToCollection(results, limit, context);
                    break;
                }
                default: {
                    throw new IllegalArgumentException(String.format("Operator, %s", operator));
                }
            }
        }
        catch (ClassCastException ex) {
            if (operator == 13) {
                return;
            }
            if (operator == 20 || operator == 21) {
                NavigableMap sm = this.valueToEntriesMap;
                if (!asc) {
                    sm = sm.descendingMap();
                }
                this.addValuesToResult(sm, results, keysToRemove, limit, context);
                this.nullMappedEntries.addValuesToCollection(results, limit, context);
                this.undefinedMappedEntries.addValuesToCollection(results, limit, context);
            }
            throw new TypeMismatchException("", ex);
        }
    }

    private void evaluate(Object key, int operator, Collection results, CompiledValue iterOps, RuntimeIterator runtimeItr, ExecutionContext context, List projAttrib, SelectResults intermediateResults, boolean isIntersection, int limit, boolean applyOrderBy, List orderByAttribs) throws TypeMismatchException, FunctionDomainException, NameResolutionException, QueryInvocationTargetException {
        key = TypeUtils.indexKeyFor(key);
        boolean multiColOrderBy = false;
        boolean asc = true;
        if (applyOrderBy) {
            CompiledSortCriterion csc = (CompiledSortCriterion)orderByAttribs.get(0);
            asc = !csc.getCriterion();
            multiColOrderBy = orderByAttribs.size() > 1;
        }
        limit = multiColOrderBy ? -1 : limit;
        try {
            switch (operator) {
                case 13: {
                    this.addValuesToResult(this.valueToEntriesMap.get(key), results, null, iterOps, runtimeItr, context, projAttrib, intermediateResults, isIntersection, limit);
                    break;
                }
                case 22: {
                    NavigableMap sm = this.valueToEntriesMap.headMap(key, false);
                    sm = asc ? sm : sm.descendingMap();
                    this.addValuesToResult(sm, results, null, iterOps, runtimeItr, context, projAttrib, intermediateResults, isIntersection, limit);
                    break;
                }
                case 18: {
                    NavigableMap sm = this.valueToEntriesMap.headMap(key, true);
                    sm = asc ? sm : sm.descendingMap();
                    this.addValuesToResult(sm, results, null, iterOps, runtimeItr, context, projAttrib, intermediateResults, isIntersection, limit);
                    break;
                }
                case 23: {
                    NavigableMap sm = this.valueToEntriesMap.tailMap(key, false);
                    sm = asc ? sm : sm.descendingMap();
                    this.addValuesToResult(sm, results, null, iterOps, runtimeItr, context, projAttrib, intermediateResults, isIntersection, limit);
                    break;
                }
                case 19: {
                    NavigableMap sm = this.valueToEntriesMap.tailMap(key, true);
                    sm = asc ? sm : sm.descendingMap();
                    this.addValuesToResult(sm, results, null, iterOps, runtimeItr, context, projAttrib, intermediateResults, isIntersection, limit);
                    break;
                }
                case 20: 
                case 21: {
                    NavigableMap sm = this.valueToEntriesMap;
                    if (!asc) {
                        sm = sm.descendingMap();
                    }
                    this.addValuesToResult(sm, results, key, iterOps, runtimeItr, context, projAttrib, intermediateResults, isIntersection, limit);
                    this.nullMappedEntries.addValuesToCollection(results, iterOps, runtimeItr, context, projAttrib, intermediateResults, isIntersection, limit);
                    this.undefinedMappedEntries.addValuesToCollection(results, iterOps, runtimeItr, context, projAttrib, intermediateResults, isIntersection, limit);
                    break;
                }
                default: {
                    throw new IllegalArgumentException("Operator = " + operator);
                }
            }
        }
        catch (ClassCastException ex) {
            if (operator == 13) {
                return;
            }
            if (operator == 20 || operator == 21) {
                NavigableMap sm = this.valueToEntriesMap;
                if (!asc) {
                    sm = sm.descendingMap();
                }
                this.addValuesToResult(sm, results, key, iterOps, runtimeItr, context, projAttrib, intermediateResults, isIntersection, limit);
                this.nullMappedEntries.addValuesToCollection(results, iterOps, runtimeItr, context, projAttrib, intermediateResults, isIntersection, limit);
                this.undefinedMappedEntries.addValuesToCollection(results, iterOps, runtimeItr, context, projAttrib, intermediateResults, isIntersection, limit);
            }
            throw new TypeMismatchException("", ex);
        }
    }

    private void addValuesToResult(Object entriesMap, Collection result, Set keysToRemove, int limit, ExecutionContext context) {
        if (entriesMap == null || result == null) {
            return;
        }
        QueryObserver observer = QueryObserverHolder.getInstance();
        if (this.verifyLimit(result, limit)) {
            observer.limitAppliedAtIndexLevel(this, limit, result);
            return;
        }
        if (entriesMap instanceof SortedMap) {
            if (((Map)entriesMap).isEmpty()) {
                return;
            }
            SortedMap sortedMap = (SortedMap)entriesMap;
            Iterator entriesIter = sortedMap.entrySet().iterator();
            Map.Entry entry = null;
            while (entriesIter.hasNext()) {
                entry = entriesIter.next();
                Object key = entry.getKey();
                if (keysToRemove != null && keysToRemove.remove(key)) continue;
                AbstractIndex.RegionEntryToValuesMap rvMap = (AbstractIndex.RegionEntryToValuesMap)entry.getValue();
                rvMap.addValuesToCollection(result, limit, context);
                if (!this.verifyLimit(result, limit)) continue;
                observer.limitAppliedAtIndexLevel(this, limit, result);
                return;
            }
        } else if (entriesMap instanceof AbstractIndex.RegionEntryToValuesMap) {
            AbstractIndex.RegionEntryToValuesMap rvMap = (AbstractIndex.RegionEntryToValuesMap)entriesMap;
            rvMap.addValuesToCollection(result, limit, context);
            if (limit != -1 && result.size() == limit) {
                observer.limitAppliedAtIndexLevel(this, limit, result);
                return;
            }
        } else {
            throw new RuntimeException("Problem in index query");
        }
    }

    private void addValuesToResultSingleKeyToRemove(Object entriesMap, Collection result, Object keyToRemove, int limit, ExecutionContext context) {
        if (entriesMap == null || result == null) {
            return;
        }
        QueryObserver observer = QueryObserverHolder.getInstance();
        if (this.verifyLimit(result, limit)) {
            observer.limitAppliedAtIndexLevel(this, limit, result);
            return;
        }
        assert (entriesMap instanceof SortedMap);
        Iterator entriesIter = ((Map)entriesMap).entrySet().iterator();
        Map.Entry entry = null;
        boolean foundKeyToRemove = false;
        while (entriesIter.hasNext()) {
            entry = entriesIter.next();
            if (foundKeyToRemove || !keyToRemove.equals(entry.getKey())) {
                AbstractIndex.RegionEntryToValuesMap rvMap = (AbstractIndex.RegionEntryToValuesMap)entry.getValue();
                rvMap.addValuesToCollection(result, limit, context);
                if (!this.verifyLimit(result, limit)) continue;
                observer.limitAppliedAtIndexLevel(this, limit, result);
                return;
            }
            foundKeyToRemove = true;
        }
    }

    private void addValuesToResult(Object entriesMap, Collection result, Object keyToRemove, CompiledValue iterOps, RuntimeIterator runtimeItr, ExecutionContext context, List projAttrib, SelectResults intermediateResults, boolean isIntersection, int limit) throws FunctionDomainException, TypeMismatchException, NameResolutionException, QueryInvocationTargetException {
        boolean limitApplied = false;
        if (entriesMap == null || result == null) {
            QueryObserver observer;
            if (this.verifyLimit(result, limit) && (observer = QueryObserverHolder.getInstance()) != null) {
                observer.limitAppliedAtIndexLevel(this, limit, result);
            }
            return;
        }
        QueryObserver observer = QueryObserverHolder.getInstance();
        if (entriesMap instanceof SortedMap) {
            Iterator entriesIter = ((Map)entriesMap).entrySet().iterator();
            Map.Entry entry = null;
            boolean foundKeyToRemove = false;
            if (keyToRemove == null) {
                foundKeyToRemove = true;
            }
            while (entriesIter.hasNext()) {
                entry = entriesIter.next();
                if (foundKeyToRemove || !keyToRemove.equals(entry.getKey())) {
                    AbstractIndex.RegionEntryToValuesMap rvMap = (AbstractIndex.RegionEntryToValuesMap)entry.getValue();
                    rvMap.addValuesToCollection(result, iterOps, runtimeItr, context, projAttrib, intermediateResults, isIntersection, limit);
                    if (!this.verifyLimit(result, limit)) continue;
                    observer.limitAppliedAtIndexLevel(this, limit, result);
                    break;
                }
                foundKeyToRemove = true;
            }
        } else if (entriesMap instanceof AbstractIndex.RegionEntryToValuesMap) {
            AbstractIndex.RegionEntryToValuesMap rvMap = (AbstractIndex.RegionEntryToValuesMap)entriesMap;
            rvMap.addValuesToCollection(result, iterOps, runtimeItr, context, projAttrib, intermediateResults, isIntersection, limit);
        } else {
            throw new RuntimeException("Problem in index query");
        }
    }

    @Override
    void recreateIndexData() throws IMQException {
        int updates;
        int numValues;
        this.valueToEntriesMap.clear();
        this.entryToValuesMap.clear();
        this.nullMappedEntries.clear();
        this.undefinedMappedEntries.clear();
        int numKeys = (int)this.internalIndexStats.getNumberOfKeys();
        if (numKeys > 0) {
            this.internalIndexStats.incNumKeys(-numKeys);
        }
        if ((numValues = (int)this.internalIndexStats.getNumberOfValues()) > 0) {
            this.internalIndexStats.incNumValues(-numValues);
        }
        if ((updates = (int)this.internalIndexStats.getNumUpdates()) > 0) {
            this.internalIndexStats.incNumUpdates(updates);
        }
        this.initializeIndex(true);
    }

    @Override
    void lockedQuery(Object key, int operator, Collection results, CompiledValue iterOps, RuntimeIterator runtimeItr, ExecutionContext context, List projAttrib, SelectResults intermediateResults, boolean isIntersection) throws TypeMismatchException, FunctionDomainException, NameResolutionException, QueryInvocationTargetException {
        block14: {
            boolean applyOrderBy;
            List orderByAttrs;
            int limit;
            block15: {
                NavigableMap sm;
                boolean asc;
                boolean multiColOrderBy;
                block13: {
                    limit = -1;
                    Boolean applyLimit = (Boolean)context.cacheGet("can_apply_limit_at_index");
                    if (applyLimit != null && applyLimit.booleanValue()) {
                        limit = (Integer)context.cacheGet("limit");
                    }
                    Boolean orderByClause = (Boolean)context.cacheGet("can_apply_orderby_at_index");
                    multiColOrderBy = false;
                    orderByAttrs = null;
                    asc = true;
                    applyOrderBy = false;
                    if (orderByClause != null && orderByClause.booleanValue()) {
                        orderByAttrs = (List)context.cacheGet("orderby");
                        CompiledSortCriterion csc = (CompiledSortCriterion)orderByAttrs.get(0);
                        asc = !csc.getCriterion();
                        multiColOrderBy = orderByAttrs.size() > 1;
                        applyOrderBy = true;
                    }
                    if (key != null) break block13;
                    switch (operator) {
                        case 13: {
                            this.nullMappedEntries.addValuesToCollection(results, iterOps, runtimeItr, context, projAttrib, intermediateResults, isIntersection, limit);
                            break block14;
                        }
                        case 20: 
                        case 21: {
                            sm = this.valueToEntriesMap;
                            if (!asc) {
                                sm = sm.descendingMap();
                            }
                            this.addValuesToResult(sm, results, null, iterOps, runtimeItr, context, projAttrib, intermediateResults, isIntersection, multiColOrderBy ? -1 : limit);
                            this.undefinedMappedEntries.addValuesToCollection(results, iterOps, runtimeItr, context, projAttrib, intermediateResults, isIntersection, limit);
                            break block14;
                        }
                        default: {
                            throw new IllegalArgumentException("Invalid Operator");
                        }
                    }
                }
                if (key != QueryService.UNDEFINED) break block15;
                switch (operator) {
                    case 13: {
                        this.undefinedMappedEntries.addValuesToCollection(results, iterOps, runtimeItr, context, projAttrib, intermediateResults, isIntersection, limit);
                        break block14;
                    }
                    case 20: 
                    case 21: {
                        sm = this.valueToEntriesMap;
                        if (!asc) {
                            sm = sm.descendingMap();
                        }
                        this.addValuesToResult(sm, results, null, iterOps, runtimeItr, context, projAttrib, intermediateResults, isIntersection, multiColOrderBy ? -1 : limit);
                        this.nullMappedEntries.addValuesToCollection(results, iterOps, runtimeItr, context, projAttrib, intermediateResults, isIntersection, limit);
                        break block14;
                    }
                    default: {
                        throw new IllegalArgumentException("Invalid Operator");
                    }
                }
            }
            if (this.isEmpty()) {
                return;
            }
            key = this.getPdxStringForIndexedPdxKeys(key);
            this.evaluate(key, operator, results, iterOps, runtimeItr, context, projAttrib, intermediateResults, isIntersection, limit, applyOrderBy, orderByAttrs);
        }
    }

    @Override
    void lockedQuery(Object key, int operator, Collection results, Set keysToRemove, ExecutionContext context) throws TypeMismatchException {
        block12: {
            int limit;
            block13: {
                NavigableMap sm;
                boolean asc;
                block11: {
                    limit = -1;
                    Boolean orderByClause = (Boolean)context.cacheGet("can_apply_orderby_at_index");
                    asc = true;
                    List orderByAttrs = null;
                    boolean multiColOrderBy = false;
                    if (orderByClause != null && orderByClause.booleanValue()) {
                        orderByAttrs = (List)context.cacheGet("orderby");
                        CompiledSortCriterion csc = (CompiledSortCriterion)orderByAttrs.get(0);
                        asc = !csc.getCriterion();
                        multiColOrderBy = orderByAttrs.size() > 1;
                    }
                    int n = limit = multiColOrderBy ? -1 : limit;
                    if (key != null) break block11;
                    switch (operator) {
                        case 13: {
                            this.nullMappedEntries.addValuesToCollection(results, limit, context);
                            break block12;
                        }
                        case 20: 
                        case 21: {
                            sm = this.valueToEntriesMap;
                            if (!asc) {
                                sm = sm.descendingMap();
                            }
                            this.addValuesToResult(sm, results, keysToRemove, limit, context);
                            this.undefinedMappedEntries.addValuesToCollection(results, limit, context);
                            break block12;
                        }
                        default: {
                            throw new IllegalArgumentException("Invalid Operator");
                        }
                    }
                }
                if (key != QueryService.UNDEFINED) break block13;
                switch (operator) {
                    case 13: {
                        this.undefinedMappedEntries.addValuesToCollection(results, limit, context);
                        break block12;
                    }
                    case 20: 
                    case 21: {
                        sm = this.valueToEntriesMap.headMap(key, false);
                        sm = asc ? sm : sm.descendingMap();
                        this.addValuesToResult(sm, results, keysToRemove, limit, context);
                        this.nullMappedEntries.addValuesToCollection(results, limit, context);
                        break block12;
                    }
                    default: {
                        throw new IllegalArgumentException("Invalid Operator");
                    }
                }
            }
            if (this.isEmpty()) {
                return;
            }
            key = this.getPdxStringForIndexedPdxKeys(key);
            this.evaluate(key, operator, results, keysToRemove, limit, context);
        }
    }

    @Override
    void lockedQuery(Object lowerBoundKey, int lowerBoundOperator, Object upperBoundKey, int upperBoundOperator, Collection results, Set keysToRemove, ExecutionContext context) throws TypeMismatchException {
        int limit = -1;
        Boolean orderByClause = (Boolean)context.cacheGet("can_apply_orderby_at_index");
        boolean multiColOrderBy = false;
        List orderByAttrs = null;
        boolean asc = true;
        if (orderByClause != null && orderByClause.booleanValue()) {
            orderByAttrs = (List)context.cacheGet("orderby");
            CompiledSortCriterion csc = (CompiledSortCriterion)orderByAttrs.get(0);
            asc = !csc.getCriterion();
            multiColOrderBy = orderByAttrs.size() > 1;
        }
        int n = limit = multiColOrderBy ? -1 : limit;
        if (this.isEmpty()) {
            return;
        }
        lowerBoundKey = TypeUtils.indexKeyFor(lowerBoundKey);
        upperBoundKey = TypeUtils.indexKeyFor(upperBoundKey);
        lowerBoundKey = this.getPdxStringForIndexedPdxKeys(lowerBoundKey);
        upperBoundKey = this.getPdxStringForIndexedPdxKeys(upperBoundKey);
        boolean lowerBoundInclusive = lowerBoundOperator == 19;
        boolean upperBoundInclusive = upperBoundOperator == 18;
        NavigableMap dataset = this.valueToEntriesMap.subMap(lowerBoundKey, lowerBoundInclusive, upperBoundKey, upperBoundInclusive);
        dataset = asc ? dataset : dataset.descendingMap();
        Object lowerBoundKeyToRemove = null;
        this.addValuesToResult(dataset, results, keysToRemove, limit, context);
    }

    @Override
    public boolean containsEntry(RegionEntry entry) {
        return this.entryToValuesMap.containsEntry(entry) || this.nullMappedEntries.containsEntry(entry) || this.undefinedMappedEntries.containsEntry(entry);
    }

    public String dump() {
        StringBuilder sb = new StringBuilder(this.toString()).append(" {\n");
        sb.append("Null Values\n");
        for (Map.Entry mapEntry : this.nullMappedEntries.entrySet()) {
            RegionEntry e = (RegionEntry)mapEntry.getKey();
            Object value = mapEntry.getValue();
            sb.append("  RegionEntry.key = ").append(e.getKey());
            sb.append("  Value.type = ").append(value.getClass().getName());
            if (value instanceof Collection) {
                sb.append("  Value.size = ").append(((Collection)value).size());
            }
            sb.append("\n");
        }
        sb.append(" -----------------------------------------------\n");
        sb.append("Undefined Values\n");
        for (Map.Entry mapEntry : this.undefinedMappedEntries.entrySet()) {
            RegionEntry e = (RegionEntry)mapEntry.getKey();
            Object value = mapEntry.getValue();
            sb.append("  RegionEntry.key = ").append(e.getKey());
            sb.append("  Value.type = ").append(value.getClass().getName());
            if (value instanceof Collection) {
                sb.append("  Value.size = ").append(((Collection)value).size());
            }
            sb.append("\n");
        }
        sb.append(" -----------------------------------------------\n");
        for (Map.Entry indexEntry : this.valueToEntriesMap.entrySet()) {
            sb.append(" Key = ").append(indexEntry.getKey()).append("\n");
            sb.append(" Value Type = ").append(" ").append(indexEntry.getValue().getClass().getName()).append("\n");
            if (indexEntry.getValue() instanceof Map) {
                sb.append(" Value Size = ").append(" ").append(((Map)indexEntry.getValue()).size()).append("\n");
            }
            for (Map.Entry mapEntry : ((AbstractIndex.RegionEntryToValuesMap)indexEntry.getValue()).entrySet()) {
                RegionEntry e = (RegionEntry)mapEntry.getKey();
                Object value = mapEntry.getValue();
                sb.append("  RegionEntry.key = ").append(e.getKey());
                sb.append("  Value.type = ").append(value.getClass().getName());
                if (value instanceof Collection) {
                    sb.append("  Value.size = ").append(((Collection)value).size());
                }
                sb.append("\n");
            }
            sb.append(" -----------------------------------------------\n");
        }
        sb.append("}// Index ").append(this.getName()).append(" end");
        return sb.toString();
    }

    public static void setTestHook(IndexManager.TestHook hook) {
        testHook = hook;
    }

    @Override
    protected AbstractIndex.InternalIndexStatistics createStats(String indexName) {
        return new RangeIndexStatistics(indexName);
    }

    @Override
    public boolean isEmpty() {
        return this.valueToEntriesMapSize == 0;
    }

    @Override
    public Map getValueToEntriesMap() {
        return this.valueToEntriesMap;
    }

    class RangeIndexStatistics
    extends AbstractIndex.InternalIndexStatistics {
        private IndexStats vsdStats;

        public RangeIndexStatistics(String indexName) {
            this.vsdStats = new IndexStats(RangeIndex.this.getRegion().getCache().getDistributedSystem(), indexName);
        }

        @Override
        public long getNumUpdates() {
            return this.vsdStats.getNumUpdates();
        }

        @Override
        public void incNumValues(int delta) {
            this.vsdStats.incNumValues(delta);
        }

        @Override
        public void updateNumKeys(long numKeys) {
            this.vsdStats.updateNumKeys(numKeys);
        }

        @Override
        public void incNumKeys(long numKeys) {
            this.vsdStats.incNumKeys(numKeys);
        }

        @Override
        public void incNumUpdates() {
            this.vsdStats.incNumUpdates();
        }

        @Override
        public void incNumUpdates(int delta) {
            this.vsdStats.incNumUpdates(delta);
        }

        @Override
        public void incUpdateTime(long delta) {
            this.vsdStats.incUpdateTime(delta);
        }

        @Override
        public void incUpdatesInProgress(int delta) {
            this.vsdStats.incUpdatesInProgress(delta);
        }

        @Override
        public void incNumUses() {
            this.vsdStats.incNumUses();
        }

        @Override
        public void incUseTime(long delta) {
            this.vsdStats.incUseTime(delta);
        }

        @Override
        public void incUsesInProgress(int delta) {
            this.vsdStats.incUsesInProgress(delta);
        }

        @Override
        public void incReadLockCount(int delta) {
            this.vsdStats.incReadLockCount(delta);
        }

        @Override
        public long getTotalUpdateTime() {
            return this.vsdStats.getTotalUpdateTime();
        }

        @Override
        public long getTotalUses() {
            return this.vsdStats.getTotalUses();
        }

        @Override
        public long getNumberOfKeys() {
            return this.vsdStats.getNumberOfKeys();
        }

        @Override
        public long getNumberOfValues() {
            return this.vsdStats.getNumberOfValues();
        }

        @Override
        public long getNumberOfValues(Object key) {
            if (key == null) {
                return RangeIndex.this.nullMappedEntries.getNumValues();
            }
            if (key == QueryService.UNDEFINED) {
                return RangeIndex.this.undefinedMappedEntries.getNumValues();
            }
            AbstractIndex.RegionEntryToValuesMap rvMap = (AbstractIndex.RegionEntryToValuesMap)RangeIndex.this.valueToEntriesMap.get(key);
            if (rvMap == null) {
                return 0L;
            }
            return rvMap.getNumValues();
        }

        @Override
        public int getReadLockCount() {
            return this.vsdStats.getReadLockCount();
        }

        @Override
        public void close() {
            this.vsdStats.close();
        }

        public String toString() {
            StringBuilder sb = new StringBuilder();
            sb.append("No Keys = ").append(this.getNumberOfKeys()).append("\n");
            sb.append("No Values = ").append(this.getNumberOfValues()).append("\n");
            sb.append("No Uses = ").append(this.getTotalUses()).append("\n");
            sb.append("No Updates = ").append(this.getNumUpdates()).append("\n");
            sb.append("Total Update time = ").append(this.getTotalUpdateTime()).append("\n");
            return sb.toString();
        }
    }
}

