/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.distributed.internal;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.geode.CancelException;
import org.apache.geode.GemFireIOException;
import org.apache.geode.annotations.VisibleForTesting;
import org.apache.geode.annotations.internal.MakeNotStatic;
import org.apache.geode.cache.server.CacheServer;
import org.apache.geode.distributed.DistributedMember;
import org.apache.geode.distributed.internal.ClusterDistributionManager;
import org.apache.geode.distributed.internal.DistributionAdvisee;
import org.apache.geode.distributed.internal.DistributionManager;
import org.apache.geode.distributed.internal.MembershipListener;
import org.apache.geode.distributed.internal.ProfileListener;
import org.apache.geode.distributed.internal.membership.InternalDistributedMember;
import org.apache.geode.internal.Assert;
import org.apache.geode.internal.InternalDataSerializer;
import org.apache.geode.internal.cache.CacheDistributionAdvisor;
import org.apache.geode.internal.cache.DistributedRegion;
import org.apache.geode.internal.cache.InternalRegion;
import org.apache.geode.internal.cache.UpdateAttributesProcessor;
import org.apache.geode.internal.cache.persistence.PersistentMemberID;
import org.apache.geode.internal.cache.versions.VersionSource;
import org.apache.geode.internal.logging.log4j.LogMarker;
import org.apache.geode.internal.serialization.DataSerializableFixedID;
import org.apache.geode.internal.serialization.DeserializationContext;
import org.apache.geode.internal.serialization.KnownVersion;
import org.apache.geode.internal.serialization.SerializationContext;
import org.apache.geode.internal.util.ArrayUtils;
import org.apache.geode.logging.internal.log4j.api.LogService;
import org.apache.logging.log4j.Logger;

public class DistributionAdvisor {
    private static final Logger logger = LogService.getLogger();
    private static final int START_VERSION_NUMBER = Integer.getInteger("gemfire.DistributionAdvisor.startVersionNumber", 1);
    private static final int START_SERIAL_NUMBER = Integer.getInteger("gemfire.Cache.startSerialNumber", 1);
    @MakeNotStatic
    private static final AtomicInteger serialNumberSequencer = new AtomicInteger(START_SERIAL_NUMBER);
    public static final int ILLEGAL_SERIAL = -1;
    private static final int ROLLOVER_THRESHOLD = Integer.getInteger("gemfire.CacheDistributionAdvisor.rolloverThreshold", 1000);
    private static final int ROLLOVER_THRESHOLD_UPPER = Integer.MAX_VALUE - ROLLOVER_THRESHOLD;
    private static final int ROLLOVER_THRESHOLD_LOWER = Integer.MIN_VALUE + ROLLOVER_THRESHOLD;
    private final AtomicInteger profileVersionSequencer = new AtomicInteger(START_VERSION_NUMBER);
    private final OperationMonitor operationMonitor = logger.isDebugEnabled() ? new ThreadTrackingOperationMonitor(this) : new OperationMonitor(this);
    private volatile boolean initialized;
    private final Object initializeLock = new Object();
    private boolean membershipClosed;
    private final Map<ProfileId, Integer> removedProfiles = new HashMap<ProfileId, Integer>();
    protected volatile Profile[] profiles = new Profile[0];
    private int numActiveProfiles;
    protected volatile long profilesVersion = 0L;
    private final ConcurrentMap<MembershipListener, Boolean> membershipListeners = new ConcurrentHashMap<MembershipListener, Boolean>();
    private final ConcurrentMap<ProfileListener, Boolean> profileListeners = new ConcurrentHashMap<ProfileListener, Boolean>();
    private volatile InitializationListener initializationListener;
    private final DistributionAdvisee advisee;
    private final MembershipListener membershipListener;

    protected DistributionAdvisor(DistributionAdvisee advisee) {
        this.advisee = advisee;
        this.membershipListener = new MembershipListener(){

            @Override
            public void memberDeparted(DistributionManager distributionManager, InternalDistributedMember id, boolean crashed) {
                boolean shouldSync = crashed && DistributionAdvisor.this.shouldSyncForCrashedMember(id);
                Profile profile = DistributionAdvisor.this.getProfile(id);
                boolean removed = DistributionAdvisor.this.removeId(id, crashed, false, true);
                if (removed && shouldSync) {
                    DistributionAdvisor.this.syncForCrashedMember(id, profile);
                }
            }
        };
    }

    protected void initialize() {
        this.getDistributionManager().addMembershipListener(this.membershipListener);
    }

    public boolean shouldSyncForCrashedMember(InternalDistributedMember id) {
        return this.advisee instanceof DistributedRegion && ((InternalRegion)((Object)this.advisee)).shouldSyncForCrashedMember(id);
    }

    public void syncForCrashedMember(InternalDistributedMember id, Profile profile) {
        CacheDistributionAdvisor.CacheProfile cacheProfile;
        PersistentMemberID persistentId;
        DistributedRegion dr = this.getRegionForDeltaGII();
        if (dr == null) {
            return;
        }
        boolean isDebugEnabled = logger.isDebugEnabled();
        if (isDebugEnabled) {
            logger.debug("da.syncForCrashedMember will sync region in cache's timer for region: {}", (Object)dr);
        }
        VersionSource<DistributedMember> lostVersionID = (persistentId = this.getPersistentID(cacheProfile = (CacheDistributionAdvisor.CacheProfile)profile)) != null ? persistentId.getVersionMember() : id;
        long delay = this.getDelay(dr);
        if (dr.getDataPolicy().withPersistence() && persistentId == null) {
            if (logger.isDebugEnabled()) {
                logger.debug("da.syncForCrashedMember skipping sync because crashed member is not persistent: {}", (Object)id);
            }
            return;
        }
        dr.scheduleSynchronizeForLostMember(id, lostVersionID, delay);
        if (dr.getConcurrencyChecksEnabled()) {
            dr.setRegionSynchronizeScheduled(lostVersionID);
        }
    }

    @VisibleForTesting
    PersistentMemberID getPersistentID(CacheDistributionAdvisor.CacheProfile cp) {
        return cp.persistentID;
    }

    @VisibleForTesting
    long getDelay(DistributedRegion dr) {
        return dr.getGemFireCache().getCacheServers().stream().mapToLong(CacheServer::getMaximumTimeBetweenPings).max().orElse(0L);
    }

    @VisibleForTesting
    MembershipListener getMembershipListener() {
        return this.membershipListener;
    }

    public DistributedRegion getRegionForDeltaGII() {
        if (this.advisee instanceof DistributedRegion) {
            return (DistributedRegion)this.advisee;
        }
        return null;
    }

    protected String toStringWithProfiles() {
        StringBuilder sb = new StringBuilder(this.toString());
        sb.append(" with profiles=(");
        Profile[] profs = this.profiles;
        for (int i = 0; i < profs.length; ++i) {
            if (i > 0) {
                sb.append(", ");
            }
            sb.append(profs[i]);
        }
        sb.append(")");
        return sb.toString();
    }

    protected int incrementAndGetVersion() {
        return this.profileVersionSequencer.incrementAndGet();
    }

    public static int createSerialNumber() {
        int result;
        while ((result = serialNumberSequencer.incrementAndGet()) == -1) {
        }
        return result;
    }

    public DistributionManager getDistributionManager() {
        return this.getAdvisee().getDistributionManager();
    }

    private DistributionManager getDistributionManagerWithNoCheck() {
        return this.getAdvisee().getSystem().getDM();
    }

    public DistributionAdvisee getAdvisee() {
        return this.advisee;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close() {
        try {
            DistributionAdvisor distributionAdvisor = this;
            synchronized (distributionAdvisor) {
                this.membershipClosed = true;
                this.operationMonitor.close();
            }
            this.getDistributionManagerWithNoCheck().removeMembershipListener(this.membershipListener);
        }
        catch (CancelException cancelException) {
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    public Set<InternalDistributedMember> addMembershipListenerAndAdviseGeneric(MembershipListener listener) {
        this.initializationGate();
        this.membershipListeners.putIfAbsent(listener, Boolean.TRUE);
        return this.adviseGeneric();
    }

    public void addMembershipListener(MembershipListener listener) {
        this.membershipListeners.putIfAbsent(listener, Boolean.TRUE);
    }

    public void setInitializationListener(InitializationListener listener) {
        this.initializationListener = listener;
    }

    public boolean addProfileChangeListener(ProfileListener listener) {
        return null == this.profileListeners.putIfAbsent(listener, Boolean.TRUE);
    }

    public void removeProfileChangeListener(ProfileListener listener) {
        this.profileListeners.remove(listener);
    }

    public boolean removeMembershipListener(MembershipListener listener) {
        return this.membershipListeners.remove(listener) != null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setInitialized() {
        Object object = this.initializeLock;
        synchronized (object) {
            this.initialized = true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean initializationGate() {
        if (this.initialized) {
            return false;
        }
        boolean exchangedProfiles = false;
        try {
            Object object = this.initializeLock;
            synchronized (object) {
                block10: {
                    if (this.initialized) break block10;
                    exchangedProfiles = true;
                    this.exchangeProfiles();
                    boolean bl = true;
                    return bl;
                }
            }
        }
        finally {
            if (exchangedProfiles && this.initializationListener != null) {
                this.initializationListener.initialized();
            }
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isInitialized() {
        Object object = this.initializeLock;
        synchronized (object) {
            return this.initialized;
        }
    }

    public boolean pollIsInitialized() {
        return this.initialized;
    }

    public void dumpProfiles(String infoMsg) {
        Profile[] profs = this.profiles;
        StringBuilder buf = new StringBuilder(2000);
        if (infoMsg != null) {
            buf.append(infoMsg);
            buf.append(": ");
        }
        buf.append("FYI, DUMPING PROFILES IN ");
        buf.append(this);
        buf.append(":").append(System.lineSeparator());
        buf.append("My Profile=");
        buf.append(this.getAdvisee().getProfile());
        buf.append(System.lineSeparator()).append("Other Profiles:").append(System.lineSeparator());
        for (Profile prof : profs) {
            buf.append("\t");
            buf.append(prof);
            buf.append(System.lineSeparator());
        }
        if (logger.isDebugEnabled()) {
            logger.debug(buf.toString());
        }
    }

    public boolean putProfile(Profile profile) {
        return this.putProfile(profile, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized boolean putProfile(Profile newProfile, boolean forceProfile) {
        try {
            boolean bl = this.doPutProfile(newProfile, forceProfile);
            return bl;
        }
        finally {
            if (logger.isTraceEnabled(LogMarker.DISTRIBUTION_ADVISOR_VERBOSE)) {
                logger.trace(LogMarker.DISTRIBUTION_ADVISOR_VERBOSE, "putProfile exiting {}", (Object)this.toStringWithProfiles());
            }
        }
    }

    protected boolean isCurrentMember(Profile p) {
        return this.getDistributionManager().isCurrentMember(p.getDistributedMember());
    }

    private synchronized boolean doPutProfile(Profile newProfile, boolean forceProfile) {
        boolean doAddOrUpdate;
        assert (newProfile != null);
        if (!forceProfile && !this.isCurrentMember(newProfile)) {
            if (logger.isTraceEnabled(LogMarker.DISTRIBUTION_ADVISOR_VERBOSE)) {
                logger.trace(LogMarker.DISTRIBUTION_ADVISOR_VERBOSE, "putProfile: ignoring {}; not in current view for {}", (Object)newProfile.getDistributedMember(), (Object)this.getAdvisee().getFullPath());
            }
            return false;
        }
        Integer removedSerialNumber = this.removedProfiles.get(newProfile.getId());
        if (removedSerialNumber != null && !DistributionAdvisor.isNewerSerialNumber(newProfile.getSerialNumber(), removedSerialNumber)) {
            if (logger.isTraceEnabled(LogMarker.DISTRIBUTION_ADVISOR_VERBOSE)) {
                logger.trace(LogMarker.DISTRIBUTION_ADVISOR_VERBOSE, "putProfile: Skipping putProfile: {} is not newer than serialNumber {} for {}", (Object)newProfile, (Object)removedSerialNumber, (Object)this.getAdvisee().getFullPath());
            }
            return false;
        }
        Profile oldProfile = this.getProfile(newProfile.getId());
        boolean isTraceEnabled_DistributionAdvisor = logger.isTraceEnabled(LogMarker.DISTRIBUTION_ADVISOR_VERBOSE);
        if (isTraceEnabled_DistributionAdvisor) {
            logger.trace(LogMarker.DISTRIBUTION_ADVISOR_VERBOSE, "putProfile: Updating existing profile: {} with new profile: {} for {}", (Object)oldProfile, (Object)newProfile, (Object)this.getAdvisee().getFullPath());
        }
        if (oldProfile != null && !this.isNewerProfile(newProfile, oldProfile)) {
            if (isTraceEnabled_DistributionAdvisor) {
                logger.trace(LogMarker.DISTRIBUTION_ADVISOR_VERBOSE, "putProfile: Ignoring {} because it's older than or same as {} for {}", (Object)newProfile, (Object)oldProfile, (Object)this.getAdvisee().getFullPath());
            }
            return false;
        }
        if (newProfile.initialMembershipVersion == 0L) {
            if (oldProfile != null) {
                newProfile.initialMembershipVersion = oldProfile.initialMembershipVersion;
            } else if (!this.membershipClosed) {
                this.operationMonitor.initNewProfile(newProfile);
            }
        } else {
            this.operationMonitor.forceNewMembershipVersion();
        }
        if (isTraceEnabled_DistributionAdvisor) {
            logger.trace(LogMarker.DISTRIBUTION_ADVISOR_VERBOSE, "DistributionAdvisor ({}) putProfile: {}", (Object)this, (Object)newProfile);
        }
        if (!(doAddOrUpdate = this.evaluateProfiles(newProfile, oldProfile))) {
            return false;
        }
        if (this.basicAddProfile(newProfile)) {
            this.profileCreated(newProfile);
            this.notifyListenersProfileAdded(newProfile);
            this.notifyListenersMemberAdded(newProfile.getDistributedMember());
        } else {
            this.notifyListenersProfileUpdated(newProfile);
            this.profileUpdated(newProfile);
        }
        return true;
    }

    protected boolean evaluateProfiles(Profile newProfile, Profile oldProfile) {
        return true;
    }

    private boolean isNewerProfile(Profile newProfile, Profile oldProfile) {
        boolean newIsNewer;
        boolean versionRolled;
        Assert.assertHoldsLock(this, true);
        boolean isNewer = true;
        int oldSerial = oldProfile.getSerialNumber();
        int newSerial = newProfile.getSerialNumber();
        boolean serialRolled = oldSerial > ROLLOVER_THRESHOLD_UPPER && newSerial < ROLLOVER_THRESHOLD_LOWER;
        int oldVersion = oldProfile.getVersion();
        int newVersion = newProfile.getVersion();
        boolean bl = versionRolled = oldVersion > ROLLOVER_THRESHOLD_UPPER && newVersion < ROLLOVER_THRESHOLD_LOWER;
        if (oldSerial == newSerial) {
            newIsNewer = versionRolled || oldVersion < newVersion;
        } else {
            boolean bl2 = newIsNewer = serialRolled || oldSerial < newSerial;
        }
        if (!newIsNewer) {
            isNewer = false;
        }
        return isNewer;
    }

    public static boolean isNewerSerialNumber(int newSerialNumber, int oldSerialNumber) {
        boolean serialRolled = oldSerialNumber > ROLLOVER_THRESHOLD_UPPER && newSerialNumber < ROLLOVER_THRESHOLD_LOWER;
        return serialRolled || oldSerialNumber < newSerialNumber;
    }

    public void forceNewMembershipVersion() {
        this.operationMonitor.forceNewMembershipVersion();
    }

    public long startOperation() {
        return this.operationMonitor.startOperation();
    }

    public void endOperation(long version) {
        this.operationMonitor.endOperation(version);
    }

    public void waitForCurrentOperations() {
        this.operationMonitor.waitForCurrentOperations();
    }

    void waitForCurrentOperations(Logger alertLogger, long warnMS, long severeAlertMS) {
        this.operationMonitor.waitForCurrentOperations(alertLogger, warnMS, severeAlertMS);
    }

    protected boolean stillInView(ProfileId id) {
        if (id instanceof InternalDistributedMember) {
            InternalDistributedMember memberId = (InternalDistributedMember)id;
            return this.getDistributionManager().getViewMembers().contains(memberId);
        }
        return false;
    }

    private boolean basicRemoveId(ProfileId memberId, boolean crashed, boolean destroyed) {
        Profile profileRemoved;
        boolean isDebugEnabled = logger.isTraceEnabled(LogMarker.DISTRIBUTION_ADVISOR_VERBOSE);
        if (isDebugEnabled) {
            logger.trace(LogMarker.DISTRIBUTION_ADVISOR_VERBOSE, "DistributionAdvisor ({}) removeId {}", (Object)this, (Object)memberId);
        }
        if ((profileRemoved = this.basicRemoveMemberId(memberId)) == null) {
            if (isDebugEnabled) {
                logger.trace(LogMarker.DISTRIBUTION_ADVISOR_VERBOSE, "DistributionAdvisor.removeId: no profile to remove for {}", (Object)memberId);
            }
            return false;
        }
        if (isDebugEnabled) {
            logger.trace(LogMarker.DISTRIBUTION_ADVISOR_VERBOSE, "DistributionAdvisor.removeId: removed profile for {}", (Object)memberId);
        }
        this.profileRemoved(profileRemoved);
        this.notifyListenersProfileRemoved(profileRemoved, destroyed);
        this.notifyListenersMemberRemoved(profileRemoved.getDistributedMember(), crashed);
        profileRemoved.cleanUp();
        return true;
    }

    private void removeProfile(Profile profile) {
        this.removeId(profile.getId(), false, false, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean removeId(ProfileId memberId, boolean crashed, boolean destroyed, boolean fromMembershipListener) {
        boolean result;
        try {
            result = this.doRemoveId(memberId, crashed, destroyed, fromMembershipListener);
        }
        finally {
            if (logger.isTraceEnabled(LogMarker.DISTRIBUTION_ADVISOR_VERBOSE)) {
                logger.trace(LogMarker.DISTRIBUTION_ADVISOR_VERBOSE, "removeId {} exiting {}", (Object)memberId, (Object)this.toStringWithProfiles());
            }
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean doRemoveId(ProfileId memberId, boolean crashed, boolean destroyed, boolean fromMembershipListener) {
        boolean isDebugEnabled_DA = logger.isTraceEnabled(LogMarker.DISTRIBUTION_ADVISOR_VERBOSE);
        if (isDebugEnabled_DA) {
            logger.trace(LogMarker.DISTRIBUTION_ADVISOR_VERBOSE, "removeId: removing member {} from resource {}", (Object)memberId, (Object)this.getAdvisee().getFullPath());
        }
        DistributionAdvisor distributionAdvisor = this;
        synchronized (distributionAdvisor) {
            if (!fromMembershipListener) {
                boolean result = false;
                Profile profileToRemove = this.getProfile(memberId);
                while (profileToRemove != null) {
                    result = true;
                    if (isDebugEnabled_DA) {
                        logger.trace(LogMarker.DISTRIBUTION_ADVISOR_VERBOSE, "removeId: tracking removal of {}", (Object)profileToRemove);
                    }
                    this.removedProfiles.put(profileToRemove.getDistributedMember(), profileToRemove.getSerialNumber());
                    this.basicRemoveId(profileToRemove.getId(), crashed, destroyed);
                    profileToRemove = this.getProfile(memberId);
                }
                return result;
            }
            this.removedProfiles.remove(memberId);
            boolean result = this.basicRemoveId(memberId, crashed, destroyed);
            while (this.basicRemoveId(memberId, crashed, destroyed)) {
            }
            return result;
        }
    }

    public boolean removeIdWithSerial(InternalDistributedMember memberId, int serialNum, boolean regionDestroyed) {
        if (logger.isTraceEnabled(LogMarker.DISTRIBUTION_ADVISOR_VERBOSE)) {
            logger.trace(LogMarker.DISTRIBUTION_ADVISOR_VERBOSE, "removeIdWithSerial: removing member {} with serial {} from resource {}", (Object)memberId, (Object)serialNum, (Object)this.getAdvisee().getName());
        }
        Assert.assertTrue(serialNum != -1);
        return this.updateRemovedProfiles(memberId, serialNum, regionDestroyed);
    }

    private synchronized boolean updateRemovedProfiles(InternalDistributedMember memberId, int serialNum, boolean regionDestroyed) {
        boolean isDebugEnabled_DA = logger.isTraceEnabled(LogMarker.DISTRIBUTION_ADVISOR_VERBOSE);
        if (isDebugEnabled_DA) {
            logger.trace(LogMarker.DISTRIBUTION_ADVISOR_VERBOSE, "updateRemovedProfiles: ensure member {} with serial {} is removed from region {}", (Object)memberId, (Object)serialNum, (Object)this.getAdvisee().getFullPath());
        }
        boolean removedId = false;
        if (this.stillInView(memberId)) {
            Integer oldSerial;
            boolean isNews = true;
            Profile profileToRemove = this.getProfile(memberId);
            if (profileToRemove != null && DistributionAdvisor.isNewerSerialNumber(profileToRemove.serialNumber, serialNum)) {
                if (isDebugEnabled_DA) {
                    logger.trace(LogMarker.DISTRIBUTION_ADVISOR_VERBOSE, "updateRemovedProfiles: member {} has profile {} which is newer than serial {}", (Object)memberId, (Object)profileToRemove, (Object)serialNum);
                }
                isNews = false;
            }
            if (isNews && (oldSerial = this.removedProfiles.get(memberId)) != null && DistributionAdvisor.isNewerSerialNumber(oldSerial, serialNum)) {
                if (isDebugEnabled_DA) {
                    logger.trace(LogMarker.DISTRIBUTION_ADVISOR_VERBOSE, "updateRemovedProfiles: member {} sent removal of serial {} but we hae already removed {}", (Object)memberId, (Object)serialNum, (Object)oldSerial);
                }
                isNews = false;
            }
            if (isNews) {
                if (isDebugEnabled_DA) {
                    logger.trace(LogMarker.DISTRIBUTION_ADVISOR_VERBOSE, "updateRemovedProfiles: adding serial {} for member {} to removedProfiles", (Object)serialNum, (Object)memberId);
                }
                this.removedProfiles.put(memberId, serialNum);
                removedId = this.basicRemoveId(memberId, false, regionDestroyed);
            }
        } else {
            if (isDebugEnabled_DA) {
                logger.trace(LogMarker.DISTRIBUTION_ADVISOR_VERBOSE, "updateRemovedProfiles: garbage collecting member {}", (Object)memberId);
            }
            this.removedProfiles.remove(memberId);
            removedId = this.basicRemoveId(memberId, false, regionDestroyed);
        }
        if (isDebugEnabled_DA) {
            logger.trace(LogMarker.DISTRIBUTION_ADVISOR_VERBOSE, "updateRemovedProfiles: removedId = {}", (Object)removedId);
        }
        return removedId;
    }

    public synchronized boolean containsId(InternalDistributedMember memberId) {
        return this.indexOfMemberId(memberId) > -1;
    }

    public synchronized int getNumProfiles() {
        return this.numActiveProfiles;
    }

    private void setNumActiveProfiles(int newValue) {
        this.numActiveProfiles = newValue;
    }

    public Profile getProfile(ProfileId id) {
        Profile[] allProfiles = this.profiles;
        boolean isIDM = id instanceof InternalDistributedMember;
        for (Profile allProfile : allProfiles) {
            if (!(isIDM ? allProfile.getDistributedMember().equals(id) : allProfile.getId().equals(id))) continue;
            return allProfile;
        }
        return null;
    }

    public void exchangeProfiles() {
        Assert.assertHoldsLock(this, false);
        Assert.assertHoldsLock(this.initializeLock, true);
        new UpdateAttributesProcessor(this.getAdvisee()).distribute(true);
        this.setInitialized();
    }

    public Profile createProfile() {
        Profile newProfile = this.instantiateProfile(this.getDistributionManager().getId(), this.incrementAndGetVersion());
        this.getAdvisee().fillInProfile(newProfile);
        return newProfile;
    }

    protected Profile instantiateProfile(InternalDistributedMember memberId, int version) {
        return new Profile(memberId, version);
    }

    public Set<InternalDistributedMember> adviseGeneric() {
        return this.adviseFilter(null);
    }

    public Set adviseProfileExchange() {
        DistributionAdvisor advisor;
        Assert.assertTrue(!this.isInitialized());
        DistributionAdvisee advisee = this.getAdvisee();
        do {
            if ((advisee = advisee.getParentAdvisee()) != null) continue;
            return this.getDefaultDistributionMembers();
        } while (!(advisor = advisee.getDistributionAdvisor()).isInitialized());
        return advisor.adviseFilter(null);
    }

    private Set<InternalDistributedMember> getDefaultDistributionMembers() {
        if (!this.useAdminMembersForDefault()) {
            return this.getDistributionManager().getOtherDistributionManagerIds();
        }
        return this.getDistributionManager().getAllOtherMembers();
    }

    public boolean useAdminMembersForDefault() {
        return false;
    }

    private void notifyListenersMemberAdded(InternalDistributedMember member) {
        for (MembershipListener membershipListener : this.membershipListeners.keySet()) {
            try {
                membershipListener.memberJoined(this.getDistributionManagerWithNoCheck(), member);
            }
            catch (Exception e) {
                logger.warn("Ignoring exception during member joined listener notification", (Throwable)e);
            }
        }
    }

    private void notifyListenersMemberRemoved(InternalDistributedMember member, boolean crashed) {
        for (MembershipListener membershipListener : this.membershipListeners.keySet()) {
            try {
                membershipListener.memberDeparted(this.getDistributionManagerWithNoCheck(), member, crashed);
            }
            catch (Exception e) {
                logger.warn("Ignoring exception during member departed listener notification", (Throwable)e);
            }
        }
    }

    private void notifyListenersProfileRemoved(Profile profile, boolean destroyed) {
        for (ProfileListener profileListener : this.profileListeners.keySet()) {
            profileListener.profileRemoved(profile, destroyed);
        }
    }

    private void notifyListenersProfileAdded(Profile profile) {
        for (ProfileListener profileListener : this.profileListeners.keySet()) {
            profileListener.profileCreated(profile);
        }
    }

    private void notifyListenersProfileUpdated(Profile profile) {
        for (ProfileListener profileListener : this.profileListeners.keySet()) {
            profileListener.profileUpdated(profile);
        }
    }

    protected void profileCreated(Profile profile) {
    }

    protected void profileUpdated(Profile profile) {
    }

    protected void profileRemoved(Profile profile) {
    }

    protected Set<InternalDistributedMember> adviseFilter(Filter f) {
        Profile[] locProfiles;
        this.initializationGate();
        HashSet<InternalDistributedMember> recipients = null;
        for (Profile profile : locProfiles = this.profiles) {
            if (f != null && !f.include(profile)) continue;
            if (recipients == null) {
                recipients = new HashSet<InternalDistributedMember>();
            }
            recipients.add(profile.getDistributedMember());
        }
        if (recipients == null) {
            return Collections.emptySet();
        }
        return recipients;
    }

    protected boolean satisfiesFilter(Filter f) {
        Profile[] locProfiles;
        this.initializationGate();
        for (Profile p : locProfiles = this.profiles) {
            if (!f.include(p)) continue;
            return true;
        }
        return false;
    }

    public <T> boolean accept(ProfileVisitor<T> visitor, T aggregate) {
        this.initializationGate();
        Profile[] locProfiles = this.profiles;
        int numProfiles = locProfiles.length;
        for (int index = 0; index < numProfiles; ++index) {
            Profile p = locProfiles[index];
            if (visitor.visit(this, p, index, numProfiles, aggregate)) continue;
            return false;
        }
        return true;
    }

    protected List<Profile> fetchProfiles(Filter f) {
        Profile[] locProfiles;
        this.initializationGate();
        List<Profile> result = null;
        for (Profile profile : locProfiles = this.profiles) {
            if (f != null && !f.include(profile)) continue;
            if (result == null) {
                result = new ArrayList<Profile>(locProfiles.length);
            }
            result.add(profile);
        }
        result = result == null ? Collections.emptyList() : Collections.unmodifiableList(result);
        return result;
    }

    public Set<InternalDistributedMember> adviseProfileUpdate() {
        return this.adviseGeneric();
    }

    public Set<InternalDistributedMember> adviseProfileRemove() {
        return this.adviseGeneric();
    }

    private synchronized boolean basicAddProfile(Profile p) {
        int index = this.indexOfMemberId(p.getId());
        if (index >= 0) {
            Profile[] oldProfiles = this.profiles;
            oldProfiles[index] = p;
            this.profiles = oldProfiles;
            ++this.profilesVersion;
            return false;
        }
        Object[] snap = this.profiles;
        Profile[] newProfiles = (Profile[])ArrayUtils.insert(snap, snap.length, p);
        Objects.requireNonNull(newProfiles);
        this.profiles = newProfiles;
        ++this.profilesVersion;
        this.setNumActiveProfiles(newProfiles.length);
        return true;
    }

    private synchronized Profile basicRemoveMemberId(ProfileId id) {
        int i = this.indexOfMemberId(id);
        if (i >= 0) {
            Profile profileRemoved = this.profiles[i];
            this.basicRemoveIndex(i);
            return profileRemoved;
        }
        return null;
    }

    private int indexOfMemberId(ProfileId id) {
        Assert.assertHoldsLock(this, true);
        Profile[] profs = this.profiles;
        for (int i = 0; i < profs.length; ++i) {
            Profile p = profs[i];
            if (!(id instanceof InternalDistributedMember ? p.getDistributedMember().equals(id) : p.getId().equals(id))) continue;
            return i;
        }
        return -1;
    }

    private void basicRemoveIndex(int index) {
        Assert.assertHoldsLock(this, true);
        Profile[] oldProfiles = this.profiles;
        Profile[] newProfiles = new Profile[oldProfiles.length - 1];
        System.arraycopy(oldProfiles, 0, newProfiles, 0, index);
        System.arraycopy(oldProfiles, index + 1, newProfiles, index, newProfiles.length - index);
        this.profiles = newProfiles;
        ++this.profilesVersion;
        if (this.numActiveProfiles > 0) {
            --this.numActiveProfiles;
        }
    }

    private static class ThreadTrackingOperationMonitor
    extends OperationMonitor {
        private final Map<Thread, ExceptionWrapper> currentVersionOperationThreads = new HashMap<Thread, ExceptionWrapper>();
        private final Map<Thread, ExceptionWrapper> previousVersionOperationThreads = new HashMap<Thread, ExceptionWrapper>();

        private ThreadTrackingOperationMonitor(DistributionAdvisor distributionAdvisor) {
            super(distributionAdvisor);
        }

        @Override
        void logNewOperation() {
            this.currentVersionOperationThreads.put(Thread.currentThread(), new ExceptionWrapper(new Exception("stack trace")));
        }

        @Override
        void logEndOperation(boolean newOp) {
            if (newOp) {
                this.currentVersionOperationThreads.remove(Thread.currentThread());
            } else {
                this.previousVersionOperationThreads.remove(Thread.currentThread());
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        void logWaitOnOperationsWarning(Logger alertLogger, long warnMS) {
            super.logWaitOnOperationsWarning(alertLogger, warnMS);
            ThreadTrackingOperationMonitor threadTrackingOperationMonitor = this;
            synchronized (threadTrackingOperationMonitor) {
                logger.debug("Waiting for these threads: {}", this.previousVersionOperationThreads);
                logger.debug("New version threads are {}", this.currentVersionOperationThreads);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        void logWaitOnOperationsSevere(Logger alertLogger, long severeAlertMS) {
            super.logWaitOnOperationsSevere(alertLogger, severeAlertMS);
            ThreadTrackingOperationMonitor threadTrackingOperationMonitor = this;
            synchronized (threadTrackingOperationMonitor) {
                logger.debug("Waiting for these threads: {}", this.previousVersionOperationThreads);
                logger.debug("New version threads are {}", this.currentVersionOperationThreads);
            }
        }

        @Override
        void membershipVersionChanged() {
            super.membershipVersionChanged();
            this.previousVersionOperationThreads.putAll(this.currentVersionOperationThreads);
            this.currentVersionOperationThreads.clear();
        }

        private static class ExceptionWrapper {
            private final Exception exception;

            private ExceptionWrapper(Exception exception) {
                this.exception = exception;
            }

            public String toString() {
                final StringBuilder builder = new StringBuilder(500);
                OutputStream os = new OutputStream(){

                    @Override
                    public void write(int i) {
                        builder.append((char)i);
                    }
                };
                PrintStream stream = new PrintStream(os);
                this.exception.printStackTrace(stream);
                return builder.toString();
            }
        }
    }

    private static class OperationMonitor {
        private final DistributionAdvisor distributionAdvisor;
        private long membershipVersion;
        private long previousVersionOpCount;
        private long currentVersionOpCount;
        private boolean closed;

        private OperationMonitor(DistributionAdvisor distributionAdvisor) {
            this.distributionAdvisor = distributionAdvisor;
        }

        private synchronized void incrementMembershipVersion() {
            ++this.membershipVersion;
        }

        private synchronized void forceNewMembershipVersion() {
            if (!this.closed) {
                this.incrementMembershipVersion();
                this.previousVersionOpCount += this.currentVersionOpCount;
                this.currentVersionOpCount = 0L;
                this.membershipVersionChanged();
            }
        }

        private synchronized long startOperation() {
            this.logNewOperation();
            ++this.currentVersionOpCount;
            return this.membershipVersion;
        }

        private synchronized void endOperation(long version) {
            if (version == this.membershipVersion) {
                --this.currentVersionOpCount;
                this.logEndOperation(true);
            } else {
                --this.previousVersionOpCount;
                this.logEndOperation(false);
            }
        }

        private void waitForCurrentOperations() {
            long timeout = 1000L * (long)this.distributionAdvisor.getDistributionManager().getSystem().getConfig().getAckWaitThreshold();
            this.waitForCurrentOperations(logger, timeout, timeout * 2L);
        }

        private void waitForCurrentOperations(Logger alertLogger, long warnMS, long severeAlertMS) {
            long startTime = System.currentTimeMillis();
            long warnTime = startTime + warnMS;
            long severeAlertTime = startTime + severeAlertMS;
            boolean warned = false;
            boolean severeAlertIssued = false;
            while (this.operationsAreInProgress()) {
                try {
                    Thread.sleep(50L);
                }
                catch (InterruptedException e) {
                    throw new GemFireIOException("State flush interrupted");
                }
                long now = System.currentTimeMillis();
                if (!warned && System.currentTimeMillis() >= warnTime) {
                    warned = true;
                    this.logWaitOnOperationsWarning(alertLogger, warnMS);
                    continue;
                }
                if (!warned || severeAlertIssued || now < severeAlertTime) continue;
                this.logWaitOnOperationsSevere(alertLogger, severeAlertMS);
                severeAlertIssued = true;
            }
            if (warned) {
                alertLogger.info("Wait for current operations completed");
            }
        }

        private synchronized boolean operationsAreInProgress() {
            return this.previousVersionOpCount > 0L;
        }

        private synchronized void initNewProfile(Profile newProfile) {
            ++this.membershipVersion;
            newProfile.initialMembershipVersion = this.membershipVersion;
            this.previousVersionOpCount += this.currentVersionOpCount;
            this.currentVersionOpCount = 0L;
            this.membershipVersionChanged();
        }

        synchronized void close() {
            this.previousVersionOpCount = 0L;
            this.currentVersionOpCount = 0L;
            this.closed = true;
        }

        void logNewOperation() {
        }

        void logEndOperation(boolean newOperation) {
        }

        void logWaitOnOperationsSevere(Logger alertLogger, long severeAlertMS) {
            alertLogger.fatal("This thread has been stalled for {} milliseconds waiting for current operations to complete.  Something may be blocking operations.", (Object)severeAlertMS);
        }

        void logWaitOnOperationsWarning(Logger alertLogger, long warnMS) {
            alertLogger.warn("This thread has been stalled for {} milliseconds waiting for current operations to complete.", (Object)warnMS);
        }

        void membershipVersionChanged() {
        }
    }

    public static class Profile
    implements DataSerializableFixedID {
        public InternalDistributedMember peerMemberId;
        public int version;
        public int serialNumber = -1;
        public transient long initialMembershipVersion;

        public Profile() {
        }

        public Profile(InternalDistributedMember memberId, int version) {
            if (memberId == null) {
                throw new IllegalArgumentException("memberId cannot be null");
            }
            this.peerMemberId = memberId;
            this.version = version;
        }

        public ProfileId getId() {
            return this.peerMemberId;
        }

        public int getVersion() {
            return this.version;
        }

        public int getSerialNumber() {
            return this.serialNumber;
        }

        public int hashCode() {
            return this.getId().hashCode();
        }

        public boolean equals(Object obj) {
            if (obj == this) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (!this.getClass().equals(obj.getClass())) {
                return false;
            }
            return this.getId().equals(((Profile)obj).getId());
        }

        public InternalDistributedMember getDistributedMember() {
            return this.peerMemberId;
        }

        public int getDSFID() {
            return 103;
        }

        public void toData(DataOutput out, SerializationContext context) throws IOException {
            InternalDataSerializer.invokeToData(this.peerMemberId, out);
            out.writeInt(this.version);
            out.writeInt(this.serialNumber);
        }

        public void fromData(DataInput in, DeserializationContext context) throws IOException, ClassNotFoundException {
            this.peerMemberId = new InternalDistributedMember();
            InternalDataSerializer.invokeFromData(this.peerMemberId, in);
            this.version = in.readInt();
            this.serialNumber = in.readInt();
        }

        public void processIncoming(ClusterDistributionManager dm, String adviseePath, boolean removeProfile, boolean exchangeProfiles, List<Profile> replyProfiles) {
            if (logger.isDebugEnabled()) {
                logger.debug("While processing UpdateAttributes message ignored incoming profile: {}", (Object)this);
            }
        }

        protected void handleDistributionAdvisee(DistributionAdvisee advisee, boolean removeProfile, boolean exchangeProfiles, List<Profile> replyProfiles) {
            DistributionAdvisor da;
            if (advisee != null && (da = advisee.getDistributionAdvisor()) != null) {
                if (removeProfile) {
                    da.removeProfile(this);
                } else {
                    da.putProfile(this);
                }
                if (exchangeProfiles) {
                    replyProfiles.add(advisee.getProfile());
                }
            }
        }

        public String toString() {
            StringBuilder sb = this.getToStringHeader();
            sb.append("@").append(System.identityHashCode(this)).append("(");
            this.fillInToString(sb);
            sb.append(")");
            return sb.toString();
        }

        public void cleanUp() {
        }

        public StringBuilder getToStringHeader() {
            return new StringBuilder("Profile");
        }

        public void fillInToString(StringBuilder sb) {
            sb.append("memberId=").append(this.peerMemberId);
            sb.append("; version=").append(this.version);
            sb.append("; serialNumber=").append(this.serialNumber);
            sb.append("; initialMembershipVersion=").append(this.initialMembershipVersion);
        }

        public KnownVersion[] getSerializationVersions() {
            return null;
        }
    }

    public static interface ProfileId {
    }

    @FunctionalInterface
    protected static interface Filter {
        public boolean include(Profile var1);
    }

    @FunctionalInterface
    public static interface ProfileVisitor<T> {
        public boolean visit(DistributionAdvisor var1, Profile var2, int var3, int var4, T var5);
    }

    @FunctionalInterface
    public static interface InitializationListener {
        public void initialized();
    }
}

