/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.distributed.internal.deadlock;

import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectStreamClass;
import java.io.Serializable;
import java.lang.management.LockInfo;
import java.lang.management.ManagementFactory;
import java.lang.management.MonitorInfo;
import java.lang.management.ThreadInfo;
import java.lang.management.ThreadMXBean;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.geode.distributed.internal.deadlock.Dependency;
import org.apache.geode.distributed.internal.deadlock.DependencyGraph;
import org.apache.geode.distributed.internal.deadlock.DependencyMonitorManager;
import org.apache.geode.distributed.internal.deadlock.LocalLockInfo;
import org.apache.geode.distributed.internal.deadlock.LocalThread;
import org.apache.geode.distributed.internal.deadlock.ThreadReference;

public class DeadlockDetector {
    DependencyGraph graph = new DependencyGraph();

    public void addDependencies(Set<Dependency> dependencies) {
        this.graph.addEdges(dependencies);
    }

    public LinkedList<Dependency> findDeadlock() {
        return this.graph.findCycle();
    }

    public DependencyGraph getDependencyGraph() {
        return this.graph;
    }

    public DependencyGraph findDependencyGraph(ThreadReference thread) {
        return this.graph.getSubGraph(thread);
    }

    public static Set<Dependency> collectAllDependencies(Serializable locality) {
        ThreadMXBean bean = ManagementFactory.getThreadMXBean();
        ThreadInfo[] infos = bean.dumpAllThreads(true, true);
        HashSet<Dependency> results = new HashSet<Dependency>();
        HashMap<Long, ThreadInfo> threadInfos = new HashMap<Long, ThreadInfo>();
        for (ThreadInfo info : infos) {
            Dependency<LocalLockInfo, LocalThread> dependency;
            if (info == null) continue;
            for (MonitorInfo monitor : info.getLockedMonitors()) {
                dependency = new Dependency<LocalLockInfo, LocalThread>(new LocalLockInfo(locality, monitor), new LocalThread(locality, info));
                results.add(dependency);
            }
            for (LockInfo sync : info.getLockedSynchronizers()) {
                dependency = new Dependency<LocalLockInfo, LocalThread>(new LocalLockInfo(locality, sync), new LocalThread(locality, info));
                results.add(dependency);
            }
            LockInfo waitingFor = info.getLockInfo();
            if (waitingFor != null) {
                Dependency<LocalThread, LocalLockInfo> dependency2 = new Dependency<LocalThread, LocalLockInfo>(new LocalThread(locality, info), new LocalLockInfo(locality, waitingFor));
                results.add(dependency2);
            }
            threadInfos.put(info.getThreadId(), info);
        }
        Set<Dependency> monitoredDependencies = DeadlockDetector.collectFromDependencyMonitor(bean, locality, threadInfos);
        results.addAll(monitoredDependencies);
        return results;
    }

    public static String prettyFormat(Collection<Dependency> deadlock) {
        StringBuilder text = new StringBuilder();
        LinkedHashSet<LocalThread> threads = new LinkedHashSet<LocalThread>();
        HashSet seenDependers = new HashSet();
        StringBuilder lastDependsOn = text;
        StringBuilder lastDepender = text;
        for (Dependency dep : deadlock) {
            Object depender = dep.getDepender();
            Object dependsOn = dep.getDependsOn();
            String dependerString = lastDependsOn.equals(depender) ? "which" : (lastDepender.equals(depender) ? "and" : String.valueOf(depender));
            lastDepender = depender;
            lastDependsOn = dependsOn;
            String also = seenDependers.contains(depender) ? " also" : "";
            seenDependers.add(depender);
            if (depender instanceof LocalThread) {
                text.append(dependerString).append(" is").append(also).append(" waiting on ").append(dependsOn).append("\n");
                threads.add((LocalThread)depender);
            } else if (dependsOn instanceof LocalThread) {
                text.append(dependerString).append(" is held by thread ").append(dependsOn).append("\n");
                threads.add((LocalThread)dependsOn);
            } else {
                text.append(dependerString).append(" is").append(also).append(" waiting for ").append(dependsOn).append("\n");
            }
            text.append("\n");
        }
        text.append("\nStack traces for involved threads\n");
        for (LocalThread threadInfo : threads) {
            text.append(threadInfo.getLocatility()).append(":").append(threadInfo.getThreadStack()).append("\n\n");
        }
        return text.toString();
    }

    public static List<Dependency> sortDependencies(Collection<Dependency> dependencies) {
        LinkedList<Dependency> result = new LinkedList<Dependency>();
        for (Dependency dep : dependencies) {
            boolean added = false;
            for (int i = 0; i < result.size(); ++i) {
                Dependency other = (Dependency)result.get(i);
                if (other.depender.equals(dep.depender)) {
                    result.add(i, dep);
                    added = true;
                    break;
                }
                if (!other.depender.equals(dep.dependsOn)) continue;
                result.add(i, dep);
                added = true;
                break;
            }
            if (added) continue;
            result.add(dep);
        }
        return result;
    }

    public static String prettyFormat(DependencyGraph graph) {
        return DeadlockDetector.prettyFormat(graph.getEdges());
    }

    public static ThreadReference getThreadReference(String locality, Thread thread) {
        ThreadMXBean bean = ManagementFactory.getThreadMXBean();
        ThreadInfo info = bean.getThreadInfo(thread.getId(), Integer.MAX_VALUE);
        return new LocalThread((Serializable)((Object)locality), info);
    }

    private static Set<Dependency> collectFromDependencyMonitor(ThreadMXBean bean, Serializable locality, Map<Long, ThreadInfo> threadInfos) {
        ThreadInfo info;
        HashSet<Dependency> results = new HashSet<Dependency>();
        Set<Dependency<Serializable, Thread>> heldResources = DependencyMonitorManager.getHeldResources();
        for (Dependency<Serializable, Thread> dep : heldResources) {
            Thread thread = dep.getDependsOn();
            Serializable resource = dep.getDepender();
            info = threadInfos.get(thread.getId());
            if (info == null) {
                info = bean.getThreadInfo(thread.getId());
            }
            if (info == null) continue;
            results.add(new Dependency<Serializable, LocalThread>(resource, new LocalThread(locality, info)));
        }
        Set<Dependency<Thread, Serializable>> blockedThreads = DependencyMonitorManager.getBlockedThreads();
        for (Dependency<Thread, Serializable> dep : blockedThreads) {
            Thread thread = dep.getDepender();
            info = threadInfos.get(thread.getId());
            if (info == null) {
                info = bean.getThreadInfo(thread.getId());
            }
            Serializable resource = dep.getDependsOn();
            results.add(new Dependency<LocalThread, Serializable>(new LocalThread(locality, info), resource));
        }
        return results;
    }

    private static DependencyGraph loadGraphs(int startingAt, String ... mainArgs) throws Exception {
        if (mainArgs.length < startingAt + 1) {
            return DeadlockDetector.loadGraph("thread_dependency_graph.ser");
        }
        DependencyGraph result = new DependencyGraph();
        for (int i = startingAt; i < mainArgs.length; ++i) {
            String filename = mainArgs[i];
            DependencyGraph gr = DeadlockDetector.loadGraph(filename);
            if (gr == null) {
                return null;
            }
            result.addEdges(gr.getEdges());
        }
        return result;
    }

    /*
     * Exception decompiling
     */
    private static DependencyGraph loadGraph(String filename) throws Exception {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 4 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private static void printHelp() {
        System.out.println("DeadlockDetector reads serialized graphs of the state of the distributed");
        System.out.println("system created by collectDependencies.");
        System.out.println();
        System.out.println("usage: ");
        System.out.println("[print | findImpasse | findCycle | findObject objectName ] file1 ...");
        System.out.println();
        System.out.println("print - prints all dependencies and threads in the graph");
        System.out.println("findImpasse - looks for either a deadlock or the longest call chain in the graph");
        System.out.println("findCycle - looks for a deadlock");
        System.out.println("findObject - finds the given object (thread, lock, message) by name/partial name and finds all call chains leading to that object");
    }

    public static void main(String ... args) throws Exception {
        if (args.length == 0) {
            DeadlockDetector.printHelp();
            return;
        }
        switch (args[0]) {
            case "print": {
                DependencyGraph graph = DeadlockDetector.loadGraphs(1, args);
                System.out.println(DeadlockDetector.prettyFormat(graph));
                break;
            }
            case "findCycle": {
                DependencyGraph graph = DeadlockDetector.loadGraphs(1, args);
                LinkedList<Dependency> cycle = graph.findCycle();
                if (cycle == null) {
                    System.out.println("no deadlock found");
                    break;
                }
                System.out.println("deadlocked threads: \n" + cycle);
                break;
            }
            case "findImpasse": {
                DependencyGraph graph = DeadlockDetector.loadGraphs(1, args);
                graph = graph.findLongestCallChain();
                if (graph == null) {
                    System.out.println("no long call chain could be found!");
                    break;
                }
                System.out.println("longest call chain: \n" + DeadlockDetector.prettyFormat(graph));
                break;
            }
            case "findObject": {
                DependencyGraph graph = DeadlockDetector.loadGraphs(2, args);
                List<DependencyGraph> graphs = graph.findDependenciesWith(args[1]);
                if (graphs.isEmpty()) {
                    System.out.println("thread not found! Try using the print command to see all threads and locate the name of the one you're interested in?");
                    break;
                }
                int numGraphs = graphs.size();
                int i = 0;
                System.out.println("findObject \"" + args[1] + "\"\n\n");
                for (DependencyGraph g : graphs) {
                    System.out.println("graph " + ++i + " of " + numGraphs + ":");
                    System.out.println(DeadlockDetector.prettyFormat(DeadlockDetector.sortDependencies(g.getEdges())));
                    if (i >= numGraphs) continue;
                    System.out.println("\n\n\n");
                }
                break;
            }
            default: {
                DeadlockDetector.printHelp();
            }
        }
    }

    private static class DDObjectInputStream
    extends ObjectInputStream {
        public DDObjectInputStream(InputStream stream) throws IOException {
            super(stream);
        }

        protected Class resolveClass(ObjectStreamClass desc) throws IOException, ClassNotFoundException {
            String className = desc.getName();
            if (className.startsWith("com.gemstone.gemfire")) {
                className = "org.apache.geode" + className.substring("com.gemstone.gemfire".length());
            }
            try {
                Class<?> clazz = Class.forName(className);
                return clazz;
            }
            catch (ClassNotFoundException ex) {
                return super.resolveClass(desc);
            }
        }
    }
}

