/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.internal;

import java.net.URL;
import java.net.URLClassLoader;

public class ChildFirstClassLoader
extends URLClassLoader {
    public ChildFirstClassLoader() {
        super(new URL[0]);
    }

    public ChildFirstClassLoader(URL[] urls) {
        super(urls);
    }

    public ChildFirstClassLoader(URL[] urls, ClassLoader parent) {
        super(urls, parent);
    }

    @Override
    public void addURL(URL url) {
        super.addURL(url);
    }

    public Class loadClass(String name) throws ClassNotFoundException {
        return this.loadClass(name, false);
    }

    protected Class loadClass(String name, boolean resolve) throws ClassNotFoundException {
        Class c = null;
        c = this.findLoadedClass(name);
        if (c == null) {
            try {
                c = this.findClass(name);
            }
            catch (ClassNotFoundException classNotFoundException) {
                // empty catch block
            }
        }
        if (c == null) {
            try {
                c = this.searchParent(name);
            }
            catch (ClassNotFoundException | NoClassDefFoundError throwable) {
                // empty catch block
            }
        }
        if (resolve) {
            this.resolveClass(c);
        }
        return c;
    }

    @Override
    public URL getResource(String name) {
        URL url = null;
        if (url == null) {
            url = this.findResource(name);
        }
        if (url == null) {
            url = super.getResource(name);
        }
        return url;
    }

    protected Class searchParent(String name) throws ClassNotFoundException {
        Class<?> c = this.getParent() != null ? this.getParent().loadClass(name) : ChildFirstClassLoader.getSystemClassLoader().loadClass(name);
        return c;
    }
}

