/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.internal.cache;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.apache.geode.DataSerializer;
import org.apache.geode.InternalGemFireException;
import org.apache.geode.annotations.Immutable;
import org.apache.geode.cache.CacheEvent;
import org.apache.geode.cache.EntryNotFoundException;
import org.apache.geode.cache.Operation;
import org.apache.geode.distributed.DistributedMember;
import org.apache.geode.distributed.internal.ClusterDistributionManager;
import org.apache.geode.distributed.internal.membership.InternalDistributedMember;
import org.apache.geode.internal.InternalDataSerializer;
import org.apache.geode.internal.cache.CacheDistributionAdvisor;
import org.apache.geode.internal.cache.DistributedCacheOperation;
import org.apache.geode.internal.cache.DistributedRegion;
import org.apache.geode.internal.cache.EventID;
import org.apache.geode.internal.cache.FilterRoutingInfo;
import org.apache.geode.internal.cache.InternalCacheEvent;
import org.apache.geode.internal.cache.RegionEventImpl;
import org.apache.geode.internal.cache.persistence.DiskStoreID;
import org.apache.geode.internal.cache.versions.VersionSource;
import org.apache.geode.internal.serialization.DeserializationContext;
import org.apache.geode.internal.serialization.KnownVersion;
import org.apache.geode.internal.serialization.SerializationContext;
import org.apache.geode.internal.serialization.SerializationVersions;

public class DistributedTombstoneOperation
extends DistributedCacheOperation {
    private final Map<VersionSource, Long> regionGCVersions;
    private TOperation op;

    public static DistributedTombstoneOperation gc(DistributedRegion region, EventID eventId) {
        RegionEventImpl rev = new RegionEventImpl(region, Operation.REGION_EXPIRE_DESTROY, null, false, region.getMyId());
        rev.setEventID(eventId);
        DistributedTombstoneOperation top = new DistributedTombstoneOperation(rev);
        top.op = TOperation.GC;
        return top;
    }

    private DistributedTombstoneOperation(RegionEventImpl rev) {
        super(rev);
        this.regionGCVersions = ((DistributedRegion)rev.getRegion()).getVersionVector().getTombstoneGCVector();
    }

    @Override
    protected boolean supportsAdjunctMessaging() {
        return false;
    }

    @Override
    boolean isOperationReliable() {
        return false;
    }

    @Override
    protected DistributedCacheOperation.CacheOperationMessage createMessage() {
        TombstoneMessage mssg = new TombstoneMessage();
        mssg.regionGCVersions = this.regionGCVersions;
        mssg.eventID = this.event.getEventId();
        mssg.op = this.op;
        return mssg;
    }

    @Override
    protected FilterRoutingInfo.FilterInfo getLocalFilterRouting(FilterRoutingInfo frInfo) {
        return null;
    }

    @Override
    protected Set getRecipients() {
        CacheDistributionAdvisor advisor = this.getRegion().getCacheDistributionAdvisor();
        return advisor.adviseInvalidateRegion();
    }

    public Map<VersionSource, Long> getRegionGCVersions() {
        return this.regionGCVersions;
    }

    @Override
    public boolean supportsDirectAck() {
        return false;
    }

    public static class TombstoneMessage
    extends DistributedCacheOperation.CacheOperationMessage
    implements SerializationVersions {
        protected Map<VersionSource, Long> regionGCVersions;
        protected TOperation op;
        protected EventID eventID;
        @Immutable
        private static final KnownVersion[] serializationVersions = null;

        @Override
        public int getProcessorType() {
            return 73;
        }

        @Override
        protected InternalCacheEvent createEvent(DistributedRegion rgn) throws EntryNotFoundException {
            RegionEventImpl event = this.createRegionEvent(rgn);
            event.setEventID(this.eventID);
            return event;
        }

        protected RegionEventImpl createRegionEvent(DistributedRegion rgn) {
            RegionEventImpl event = new RegionEventImpl(rgn, this.getOperation(), this.callbackArg, true, this.getSender());
            event.setEventID(this.eventID);
            return event;
        }

        @Override
        protected boolean operateOnRegion(CacheEvent event, ClusterDistributionManager dm) throws EntryNotFoundException {
            boolean sendReply = true;
            DistributedRegion region = (DistributedRegion)event.getRegion();
            region.getCachePerfStats().incTombstoneGCCount();
            FilterRoutingInfo.FilterInfo routing = null;
            if (this.filterRouting != null) {
                routing = this.filterRouting.getFilterInfo(region.getMyId());
            }
            region.expireTombstones(this.regionGCVersions, this.eventID, routing);
            this.appliedOperation = true;
            return sendReply;
        }

        public int getDSFID() {
            return -69;
        }

        @Override
        public KnownVersion[] getSerializationVersions() {
            return serializationVersions;
        }

        @Override
        public void fromData(DataInput in, DeserializationContext context) throws IOException, ClassNotFoundException {
            super.fromData(in, context);
            this.op = TOperation.values()[in.readByte()];
            int count = in.readInt();
            this.regionGCVersions = new HashMap<VersionSource, Long>(count);
            boolean persistent = in.readBoolean();
            for (int i = 0; i < count; ++i) {
                VersionSource<DistributedMember> mbr;
                if (persistent) {
                    DiskStoreID id = new DiskStoreID();
                    InternalDataSerializer.invokeFromData(id, in);
                    mbr = id;
                } else {
                    mbr = InternalDistributedMember.readEssentialData(in);
                }
                this.regionGCVersions.put(mbr, in.readLong());
            }
            this.eventID = (EventID)DataSerializer.readObject(in);
        }

        @Override
        public void toData(DataOutput out, SerializationContext context) throws IOException {
            VersionSource firstEntry;
            super.toData(out, context);
            out.writeByte(this.op.ordinal());
            out.writeInt(this.regionGCVersions.size());
            boolean persistent = false;
            String msg = "Found mixed membership ids while serializing Tombstone GC message.";
            if (!this.regionGCVersions.isEmpty() && (firstEntry = this.regionGCVersions.keySet().iterator().next()) instanceof DiskStoreID) {
                persistent = true;
            }
            out.writeBoolean(persistent);
            for (Map.Entry<VersionSource, Long> entry : this.regionGCVersions.entrySet()) {
                VersionSource member = entry.getKey();
                if (member instanceof DiskStoreID) {
                    if (!persistent) {
                        throw new InternalGemFireException(msg);
                    }
                    InternalDataSerializer.invokeToData((DiskStoreID)member, out);
                } else {
                    if (persistent) {
                        throw new InternalGemFireException(msg);
                    }
                    ((InternalDistributedMember)member).writeEssentialData(out);
                }
                out.writeLong(entry.getValue());
            }
            DataSerializer.writeObject(this.eventID, out);
        }

        @Override
        protected void appendFields(StringBuilder buff) {
            super.appendFields(buff);
            buff.append("; op=").append((Object)this.op);
            buff.append("; eventID=").append(this.eventID);
            buff.append("; regionGCVersions=").append(this.regionGCVersions);
        }
    }

    private static enum TOperation {
        GC;

    }
}

