/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.internal.cache;

import java.util.Collection;
import java.util.List;
import java.util.ServiceConfigurationError;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.geode.cache.Cache;
import org.apache.geode.cache.wan.GatewaySender;
import org.apache.geode.internal.cache.EntryEventImpl;

public class TXLastEventInTransactionUtils {
    public static EntryEventImpl getLastTransactionEventInGroupedTxForWANSender(List<EntryEventImpl> callbacks, Cache cache) throws ServiceConfigurationError {
        if (TXLastEventInTransactionUtils.checkNoSendersGroupTransactionEvents(callbacks, cache)) {
            return null;
        }
        List<Set> senderIdsPerEvent = TXLastEventInTransactionUtils.getGroupingSendersPerEvent(callbacks, cache);
        if (senderIdsPerEvent.stream().distinct().count() > 1L) {
            String info = TXLastEventInTransactionUtils.eventsAndSendersPerEventToString(callbacks, senderIdsPerEvent);
            throw new ServiceConfigurationError("Not all events go to the same senders that group transactions. " + info);
        }
        return callbacks.get(callbacks.size() - 1);
    }

    private static String eventsAndSendersPerEventToString(List<EntryEventImpl> callbacks, List<Set> senderIdsPerEvent) {
        StringBuilder buf = new StringBuilder();
        for (int i = 0; i < callbacks.size(); ++i) {
            buf.append("Event[");
            buf.append(i);
            buf.append("]: ");
            buf.append(callbacks.get(i));
            buf.append(", senders for Event[");
            buf.append(i);
            buf.append("]: ");
            buf.append(senderIdsPerEvent.get(i));
            buf.append("; ");
        }
        return buf.toString();
    }

    private static boolean checkNoSendersGroupTransactionEvents(List<EntryEventImpl> callbacks, Cache cache) throws ServiceConfigurationError {
        for (String senderId : TXLastEventInTransactionUtils.getSenderIdsForEvents(callbacks)) {
            GatewaySender sender = cache.getGatewaySender(senderId);
            if (sender == null || !sender.mustGroupTransactionEvents()) continue;
            return false;
        }
        return true;
    }

    private static Set<String> getSenderIdsForEvents(List<EntryEventImpl> callbacks) {
        return callbacks.stream().map(event -> event.getRegion().getAllGatewaySenderIds()).flatMap(Collection::stream).collect(Collectors.toSet());
    }

    private static List<Set> getGroupingSendersPerEvent(List<EntryEventImpl> callbacks, Cache cache) throws ServiceConfigurationError {
        List<Set> senderIdsPerEvent = callbacks.stream().map(event -> event.getRegion().getAllGatewaySenderIds().stream().filter(senderId -> TXLastEventInTransactionUtils.doesSenderGroupTransactionEvents(cache, senderId)).collect(Collectors.toSet())).collect(Collectors.toList());
        return senderIdsPerEvent;
    }

    private static boolean doesSenderGroupTransactionEvents(Cache cache, String senderId) throws ServiceConfigurationError {
        GatewaySender sender = cache.getGatewaySender(senderId);
        if (sender == null) {
            throw new ServiceConfigurationError("No information for senderId: " + senderId);
        }
        return sender.mustGroupTransactionEvents();
    }

    static boolean isLastTransactionEvent(boolean isConfigError, EntryEventImpl lastTransactionEvent, EntryEventImpl entryEvent) {
        return isConfigError || lastTransactionEvent == null || entryEvent.equals(lastTransactionEvent);
    }
}

