/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.internal.cache.execute;

import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.TimeUnit;
import org.apache.geode.InternalGemFireException;
import org.apache.geode.SystemFailure;
import org.apache.geode.annotations.internal.MakeNotStatic;
import org.apache.geode.cache.client.internal.ProxyCache;
import org.apache.geode.cache.execute.Function;
import org.apache.geode.cache.execute.FunctionContext;
import org.apache.geode.cache.execute.FunctionException;
import org.apache.geode.cache.execute.FunctionInvocationTargetException;
import org.apache.geode.cache.execute.FunctionService;
import org.apache.geode.cache.execute.ResultCollector;
import org.apache.geode.cache.execute.ResultSender;
import org.apache.geode.cache.query.QueryInvalidException;
import org.apache.geode.distributed.DistributedMember;
import org.apache.geode.distributed.internal.ClusterDistributionManager;
import org.apache.geode.distributed.internal.DistributionManager;
import org.apache.geode.distributed.internal.membership.InternalDistributedMember;
import org.apache.geode.internal.cache.execute.BucketMovedException;
import org.apache.geode.internal.cache.execute.InternalExecution;
import org.apache.geode.internal.cache.execute.InternalFunctionInvocationTargetException;
import org.apache.geode.internal.cache.execute.InternalResultSender;
import org.apache.geode.internal.cache.execute.LocalResultCollector;
import org.apache.geode.internal.cache.execute.LocalResultCollectorImpl;
import org.apache.geode.internal.cache.execute.MemberMappedArgument;
import org.apache.geode.internal.cache.execute.PartitionedRegionFunctionResultSender;
import org.apache.geode.internal.cache.execute.metrics.FunctionStats;
import org.apache.geode.internal.cache.execute.metrics.FunctionStatsManager;
import org.apache.geode.internal.cache.tier.sockets.ServerConnection;
import org.apache.geode.logging.internal.log4j.api.LogService;
import org.apache.logging.log4j.Logger;

public abstract class AbstractExecution
implements InternalExecution {
    private static final Logger logger = LogService.getLogger();
    public static final int DEFAULT_CLIENT_FUNCTION_TIMEOUT = 0;
    private static final String CLIENT_FUNCTION_TIMEOUT_SYSTEM_PROPERTY = "gemfire.CLIENT_FUNCTION_TIMEOUT";
    private static final Integer timeoutMsSystemProperty = Integer.getInteger("gemfire.CLIENT_FUNCTION_TIMEOUT", 0);
    boolean isMemberMappedArgument;
    protected MemberMappedArgument memberMappedArg;
    protected Object args;
    protected ResultCollector rc;
    protected Set filter = new HashSet();
    protected volatile boolean isReExecute = false;
    volatile boolean isClientServerMode = false;
    Set<String> failedNodes = new HashSet<String>();
    protected boolean isFnSerializationReqd;
    private Collection<InternalDistributedMember> executionNodes = null;
    private ExecutionNodesListener executionNodesListener = null;
    boolean waitOnException = false;
    boolean forwardExceptions = false;
    private boolean ignoreDepartedMembers = false;
    protected ProxyCache proxyCache;
    private final int timeoutMs;
    @MakeNotStatic
    private static final ConcurrentHashMap<String, byte[]> idToFunctionAttributes = new ConcurrentHashMap();
    public static final byte NO_HA_NO_HASRESULT_NO_OPTIMIZEFORWRITE = 0;
    public static final byte NO_HA_HASRESULT_NO_OPTIMIZEFORWRITE = 2;
    public static final byte HA_HASRESULT_NO_OPTIMIZEFORWRITE = 3;
    public static final byte NO_HA_NO_HASRESULT_OPTIMIZEFORWRITE = 4;
    public static final byte NO_HA_HASRESULT_OPTIMIZEFORWRITE = 6;
    public static final byte HA_HASRESULT_OPTIMIZEFORWRITE = 7;
    public static final byte HA_HASRESULT_NO_OPTIMIZEFORWRITE_REEXECUTE = 11;
    public static final byte HA_HASRESULT_OPTIMIZEFORWRITE_REEXECUTE = 15;

    public static byte getFunctionState(boolean isHA, boolean hasResult, boolean optimizeForWrite) {
        if (isHA) {
            if (hasResult) {
                if (optimizeForWrite) {
                    return 7;
                }
                return 3;
            }
            return 1;
        }
        if (hasResult) {
            if (optimizeForWrite) {
                return 6;
            }
            return 2;
        }
        if (optimizeForWrite) {
            return 4;
        }
        return 0;
    }

    public static byte getReexecuteFunctionState(byte fnState) {
        if (fnState == 3) {
            return 11;
        }
        if (fnState == 7) {
            return 15;
        }
        throw new InternalGemFireException("Wrong fnState provided.");
    }

    protected AbstractExecution() {
        this.timeoutMs = timeoutMsSystemProperty >= 0 ? timeoutMsSystemProperty : 0;
    }

    protected AbstractExecution(AbstractExecution ae) {
        if (ae.args != null) {
            this.args = ae.args;
        }
        if (ae.rc != null) {
            this.rc = ae.rc;
        }
        if (ae.memberMappedArg != null) {
            this.memberMappedArg = ae.memberMappedArg;
        }
        this.isMemberMappedArgument = ae.isMemberMappedArgument;
        this.isClientServerMode = ae.isClientServerMode;
        if (ae.proxyCache != null) {
            this.proxyCache = ae.proxyCache;
        }
        this.isFnSerializationReqd = ae.isFnSerializationReqd;
        this.timeoutMs = ae.timeoutMs;
    }

    protected AbstractExecution(AbstractExecution ae, boolean isReExecute) {
        this(ae);
        this.isReExecute = isReExecute;
    }

    public Object getArgumentsForMember(String memberId) {
        if (!this.isMemberMappedArgument) {
            return this.args;
        }
        return this.memberMappedArg.getArgumentsForMember(memberId);
    }

    public MemberMappedArgument getMemberMappedArgument() {
        return this.memberMappedArg;
    }

    public Object getArguments() {
        return this.args;
    }

    public ResultCollector getResultCollector() {
        return this.rc;
    }

    public Set getFilter() {
        return this.filter;
    }

    public AbstractExecution setIsReExecute() {
        this.isReExecute = true;
        if (this.executionNodesListener != null) {
            this.executionNodesListener.reset();
        }
        return this;
    }

    public boolean isReExecute() {
        return this.isReExecute;
    }

    public Set<String> getFailedNodes() {
        return this.failedNodes;
    }

    public void addFailedNode(String failedNode) {
        this.failedNodes.add(failedNode);
    }

    public void clearFailedNodes() {
        this.failedNodes.clear();
    }

    public boolean isClientServerMode() {
        return this.isClientServerMode;
    }

    public boolean isFnSerializationReqd() {
        return this.isFnSerializationReqd;
    }

    public void setExecutionNodes(Set<InternalDistributedMember> nodes) {
        if (this.executionNodes != null) {
            this.executionNodes = nodes;
            if (this.executionNodesListener != null) {
                this.executionNodesListener.afterExecutionNodesSet(this);
            }
        }
    }

    public void executeFunctionOnLocalPRNode(Function fn, FunctionContext cx, PartitionedRegionFunctionResultSender sender, DistributionManager dm, boolean isTx) {
        if (dm instanceof ClusterDistributionManager && !isTx) {
            if (ServerConnection.isExecuteFunctionOnLocalNodeOnly() == 1) {
                ServerConnection.executeFunctionOnLocalNodeOnly((byte)3);
                this.executeFunctionLocally(fn, cx, sender, dm);
                if (!sender.isLastResultReceived() && fn.hasResult()) {
                    sender.setException(new FunctionException(String.format("The function, %s, did not send last result", fn.getId())));
                }
            } else {
                ClusterDistributionManager newDM = (ClusterDistributionManager)dm;
                newDM.getExecutors().getFunctionExecutor().execute(() -> {
                    this.executeFunctionLocally(fn, cx, sender, newDM);
                    if (!sender.isLastResultReceived() && fn.hasResult()) {
                        sender.setException(new FunctionException(String.format("The function, %s, did not send last result", fn.getId())));
                    }
                });
            }
        } else {
            this.executeFunctionLocally(fn, cx, sender, dm);
            if (!sender.isLastResultReceived() && fn.hasResult()) {
                sender.setException(new FunctionException(String.format("The function, %s, did not send last result", fn.getId())));
            }
        }
    }

    public void executeFunctionOnLocalNode(Function<?> fn, FunctionContext cx, ResultSender sender, DistributionManager dm, boolean isTx) {
        if (dm instanceof ClusterDistributionManager && !isTx) {
            ClusterDistributionManager newDM = (ClusterDistributionManager)dm;
            newDM.getExecutors().getFunctionExecutor().execute(() -> {
                this.executeFunctionLocally(fn, cx, sender, newDM);
                if (!((InternalResultSender)sender).isLastResultReceived() && fn.hasResult()) {
                    ((InternalResultSender)sender).setException(new FunctionException(String.format("The function, %s, did not send last result", fn.getId())));
                }
            });
        } else {
            this.executeFunctionLocally(fn, cx, sender, dm);
            if (!((InternalResultSender)sender).isLastResultReceived() && fn.hasResult()) {
                ((InternalResultSender)sender).setException(new FunctionException(String.format("The function, %s, did not send last result", fn.getId())));
            }
        }
    }

    private void executeFunctionLocally(Function<?> fn, FunctionContext cx, ResultSender sender, DistributionManager dm) {
        FunctionStats stats = FunctionStatsManager.getFunctionStats(fn.getId(), dm.getSystem());
        long start = stats.startFunctionExecution(fn.hasResult());
        try {
            if (logger.isDebugEnabled()) {
                logger.debug("Executing Function: {} on local node with context: {}", (Object)fn.getId(), (Object)cx.toString());
            }
            fn.execute(cx);
            stats.endFunctionExecution(start, fn.hasResult());
        }
        catch (FunctionInvocationTargetException fite) {
            FunctionException functionException = fn.isHA() ? new FunctionException(new InternalFunctionInvocationTargetException(fite.getMessage())) : new FunctionException(fite);
            this.handleException(functionException, fn, sender, dm, start);
        }
        catch (BucketMovedException bme) {
            FunctionException functionException = fn.isHA() ? new FunctionException(new InternalFunctionInvocationTargetException(bme)) : new FunctionException(bme);
            this.handleException(functionException, fn, sender, dm, start);
        }
        catch (VirtualMachineError e) {
            SystemFailure.initiateFailure(e);
            throw e;
        }
        catch (Throwable t) {
            SystemFailure.checkFailure();
            this.handleException(t, fn, sender, dm, start);
        }
    }

    public ResultCollector execute(String functionName) {
        return this.execute(functionName, (long)this.getTimeoutMs(), TimeUnit.MILLISECONDS);
    }

    public ResultCollector execute(String functionName, long timeout, TimeUnit unit) {
        if (functionName == null) {
            throw new FunctionException("The input function for the execute function request is null");
        }
        this.isFnSerializationReqd = false;
        Function functionObject = FunctionService.getFunction(functionName);
        if (functionObject == null) {
            throw new FunctionException(String.format("Function named %s is not registered to FunctionService", functionName));
        }
        return this.executeFunction(functionObject, timeout, unit);
    }

    public ResultCollector execute(Function function, long timeout, TimeUnit unit) throws FunctionException {
        if (function == null) {
            throw new FunctionException("The input function for the execute function request is null");
        }
        if (function.isHA() && !function.hasResult()) {
            throw new FunctionException("For Functions with isHA true, hasResult must also be true.");
        }
        String id = function.getId();
        if (id == null) {
            throw new IllegalArgumentException("The Function#getID() returned null");
        }
        this.isFnSerializationReqd = true;
        return this.executeFunction(function, timeout, unit);
    }

    public ResultCollector execute(Function function) throws FunctionException {
        return this.execute(function, (long)this.getTimeoutMs(), TimeUnit.MILLISECONDS);
    }

    @Override
    public void setWaitOnExceptionFlag(boolean waitOnException) {
        this.setForwardExceptions(waitOnException);
        this.waitOnException = waitOnException;
    }

    public boolean getWaitOnExceptionFlag() {
        return this.waitOnException;
    }

    @Override
    public void setForwardExceptions(boolean forward) {
        this.forwardExceptions = forward;
    }

    public boolean isForwardExceptions() {
        return this.forwardExceptions;
    }

    @Override
    public void setIgnoreDepartedMembers(boolean ignore) {
        this.ignoreDepartedMembers = ignore;
        if (ignore) {
            this.setWaitOnExceptionFlag(true);
        }
    }

    public boolean isIgnoreDepartedMembers() {
        return this.ignoreDepartedMembers;
    }

    protected abstract ResultCollector executeFunction(Function var1, long var2, TimeUnit var4);

    public abstract void validateExecution(Function var1, Set<? extends DistributedMember> var2);

    public LocalResultCollector<?, ?> getLocalResultCollector(Function function, ResultCollector<?, ?> rc) {
        if (rc instanceof LocalResultCollector) {
            return (LocalResultCollector)rc;
        }
        return new LocalResultCollectorImpl(function, rc, this);
    }

    public byte[] getFunctionAttributes(String functionId) {
        if (functionId == null) {
            throw new FunctionException(String.format("%s passed is null", "functionId instance "));
        }
        return idToFunctionAttributes.get(functionId);
    }

    public void removeFunctionAttributes(String functionId) {
        idToFunctionAttributes.remove(functionId);
    }

    void addFunctionAttributes(String functionId, byte[] functionAttributes) {
        idToFunctionAttributes.put(functionId, functionAttributes);
    }

    private void handleException(Throwable functionException, Function fn, ResultSender sender, DistributionManager dm, long startTime) {
        FunctionStats stats = FunctionStatsManager.getFunctionStats(fn.getId(), dm.getSystem());
        if (logger.isDebugEnabled()) {
            logger.debug("Exception occurred on local node while executing Function: {}", (Object)fn.getId(), (Object)functionException);
        }
        stats.endFunctionExecutionWithException(startTime, fn.hasResult());
        if (fn.hasResult()) {
            if (this.waitOnException || this.forwardExceptions) {
                if (functionException instanceof FunctionException && functionException.getCause() instanceof QueryInvalidException) {
                    functionException = new FunctionException(functionException.getLocalizedMessage());
                }
                sender.lastResult(functionException);
            } else {
                ((InternalResultSender)sender).setException(functionException);
            }
        } else {
            logger.warn("Exception occurred on local node while executing Function:", functionException);
        }
    }

    int getTimeoutMs() {
        return this.timeoutMs;
    }

    public static interface ExecutionNodesListener {
        public void afterExecutionNodesSet(AbstractExecution var1);

        public void reset();
    }
}

