/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.internal.cache.tier.sockets.command;

import java.io.IOException;
import java.util.HashSet;
import java.util.Set;
import org.apache.geode.annotations.Immutable;
import org.apache.geode.cache.Region;
import org.apache.geode.cache.execute.Function;
import org.apache.geode.cache.execute.FunctionException;
import org.apache.geode.cache.execute.FunctionInvocationTargetException;
import org.apache.geode.cache.execute.FunctionService;
import org.apache.geode.cache.operations.ExecuteFunctionOperationContext;
import org.apache.geode.cache.query.QueryInvocationTargetException;
import org.apache.geode.internal.cache.DistributedRegion;
import org.apache.geode.internal.cache.PartitionedRegion;
import org.apache.geode.internal.cache.execute.AbstractExecution;
import org.apache.geode.internal.cache.execute.DistributedRegionFunctionExecutor;
import org.apache.geode.internal.cache.execute.InternalFunctionInvocationTargetException;
import org.apache.geode.internal.cache.execute.MemberMappedArgument;
import org.apache.geode.internal.cache.execute.PartitionedRegionFunctionExecutor;
import org.apache.geode.internal.cache.execute.ServerToClientFunctionResultSender;
import org.apache.geode.internal.cache.execute.ServerToClientFunctionResultSender65;
import org.apache.geode.internal.cache.tier.CachedRegionHelper;
import org.apache.geode.internal.cache.tier.Command;
import org.apache.geode.internal.cache.tier.ServerSideHandshake;
import org.apache.geode.internal.cache.tier.sockets.BaseCommand;
import org.apache.geode.internal.cache.tier.sockets.ChunkedMessage;
import org.apache.geode.internal.cache.tier.sockets.Message;
import org.apache.geode.internal.cache.tier.sockets.Part;
import org.apache.geode.internal.cache.tier.sockets.ServerConnection;
import org.apache.geode.internal.security.AuthorizeRequest;
import org.apache.geode.internal.security.SecurityService;
import org.apache.geode.internal.serialization.KnownVersion;

public class ExecuteRegionFunction66
extends BaseCommand {
    @Immutable
    private static final ExecuteRegionFunction66 singleton = new ExecuteRegionFunction66();

    public static Command getCommand() {
        return singleton;
    }

    ExecuteRegionFunction66() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void cmdExecute(Message clientMessage, ServerConnection serverConnection, SecurityService securityService, long start) throws IOException {
        byte isReExecute;
        boolean isBucketsAsFilter;
        String regionName = null;
        Object function = null;
        Object args = null;
        MemberMappedArgument memberMappedArg = null;
        Set<Object> filter = null;
        byte hasResult = 0;
        Set<Object> removedNodesSet = null;
        int partNumber = 0;
        byte functionState = 0;
        int functionTimeout = 0;
        try {
            byte[] bytes = clientMessage.getPart(0).getSerializedForm();
            functionState = bytes[0];
            if (bytes.length >= 5 && serverConnection.getClientVersion().ordinal() >= KnownVersion.GFE_8009.ordinal()) {
                functionTimeout = Part.decodeInt(bytes, 1);
            }
            if ((hasResult = functionState != 1 ? (byte)((functionState & 2) - 1) : functionState) == 1) {
                serverConnection.setAsTrue(2);
                serverConnection.setAsTrue(3);
            }
            regionName = clientMessage.getPart(1).getCachedString();
            function = clientMessage.getPart(2).getStringOrObject();
            args = clientMessage.getPart(3).getObject();
            Part part = clientMessage.getPart(4);
            memberMappedArg = this.extractMemberMappedArgument(part);
            byte[] flags = clientMessage.getPart(5).getSerializedForm();
            if (serverConnection.getClientVersion().ordinal() > KnownVersion.GFE_81.ordinal()) {
                isBucketsAsFilter = (flags[0] & 2) != 0;
                isReExecute = (flags[0] & 1) != 0 ? (byte)1 : 0;
            } else {
                isReExecute = flags[0];
                isBucketsAsFilter = false;
            }
            int filterSize = clientMessage.getPart(6).getInt();
            filter = this.populateFilters(clientMessage, filterSize);
            partNumber = 7 + filterSize;
            int removedNodesSize = clientMessage.getPart(partNumber).getInt();
            removedNodesSet = this.populateRemovedNodes(clientMessage, removedNodesSize, partNumber);
        }
        catch (ClassNotFoundException exception) {
            logger.warn(String.format("Exception on server while executing function : %s", function), (Throwable)exception);
            if (hasResult == 1) {
                ExecuteRegionFunction66.writeChunkedException(clientMessage, exception, serverConnection);
            } else {
                ExecuteRegionFunction66.writeException(clientMessage, exception, false, serverConnection);
            }
            serverConnection.setAsTrue(1);
            return;
        }
        if (function == null || regionName == null) {
            String message = this.generateNullArgumentMessage(regionName, function);
            logger.warn("{}: {}", (Object)serverConnection.getName(), (Object)message);
            this.sendError(hasResult, clientMessage, message, serverConnection);
            return;
        }
        CachedRegionHelper crHelper = serverConnection.getCachedRegionHelper();
        Region region = crHelper.getRegion(regionName);
        if (region == null) {
            String message = String.format("The region named %s was not found during execute Function request.", regionName);
            logger.warn("{}: {}", (Object)serverConnection.getName(), (Object)message);
            this.sendError(hasResult, clientMessage, message, serverConnection);
            return;
        }
        ServerSideHandshake handshake = serverConnection.getHandshake();
        int earlierClientReadTimeout = handshake.getClientReadTimeout();
        handshake.setClientReadTimeout(functionTimeout);
        ServerToClientFunctionResultSender resultSender = null;
        Function functionObject = null;
        try {
            if (function instanceof String) {
                functionObject = FunctionService.getFunction((String)function);
                if (!this.validateFunctionObject(clientMessage, serverConnection, function, hasResult, functionState, functionObject)) {
                    return;
                }
            } else {
                functionObject = (Function)function;
            }
            functionObject.getRequiredPermissions(regionName, args).forEach(securityService::authorize);
            ExecuteFunctionOperationContext executeContext = this.getAuthorizedExecuteFunctionOperationContext(args, filter, functionObject.optimizeForWrite(), serverConnection.getAuthzRequest(), functionObject.getId(), region.getFullPath());
            ChunkedMessage m = serverConnection.getFunctionResponseMessage();
            m.setTransactionId(clientMessage.getTransactionId());
            resultSender = new ServerToClientFunctionResultSender65(m, 60, serverConnection, functionObject, executeContext);
            AbstractExecution execution = this.createExecution(args, memberMappedArg, isBucketsAsFilter, filter, removedNodesSet, region, resultSender);
            if (execution instanceof PartitionedRegionFunctionExecutor && hasResult == 1 && filter != null && filter.size() == 1) {
                ServerConnection.executeFunctionOnLocalNodeOnly((byte)1);
            }
            if (isReExecute == 1) {
                execution = execution.setIsReExecute();
            }
            if (logger.isDebugEnabled()) {
                logger.debug("Executing Function: {} on Server: {} with Execution: {} functionState={} reExecute={} hasResult={}", (Object)functionObject.getId(), (Object)serverConnection, (Object)execution, (Object)functionState, (Object)isReExecute, (Object)hasResult);
            }
            if (hasResult == 1) {
                this.executeFunctionWithResult(function, functionState, functionObject, execution);
            } else {
                this.executeFunctionNoResult(function, functionState, functionObject, execution);
                this.writeReply(clientMessage, serverConnection);
            }
        }
        catch (IOException ioe) {
            logger.warn(String.format("Exception on server while executing function : %s", function), (Throwable)ioe);
            String message = "Server could not send the reply";
            this.sendException(hasResult, clientMessage, "Server could not send the reply", serverConnection, ioe);
        }
        catch (FunctionException fe) {
            String message = fe.getMessage();
            Throwable cause = fe.getCause();
            if (cause instanceof FunctionInvocationTargetException || cause instanceof QueryInvocationTargetException) {
                this.logFunctionExceptionCause(function, functionObject, fe, message, cause);
                resultSender.setException(fe);
            } else if (this.setLastResultReceived(resultSender)) {
                logger.warn(String.format("Exception on server while executing function : %s", function), (Throwable)fe);
                this.sendException(hasResult, clientMessage, message, serverConnection, fe);
            }
        }
        catch (Exception e) {
            if (this.setLastResultReceived(resultSender)) {
                logger.warn(String.format("Exception on server while executing function : %s", function), (Throwable)e);
                String message = e.getMessage();
                this.sendException(hasResult, clientMessage, message, serverConnection, e);
            }
        }
        finally {
            handshake.setClientReadTimeout(earlierClientReadTimeout);
            ServerConnection.executeFunctionOnLocalNodeOnly((byte)0);
        }
    }

    void logFunctionExceptionCause(Object function, Function<?> functionObject, FunctionException fe, String message, Object cause) {
        if (cause instanceof InternalFunctionInvocationTargetException) {
            if (logger.isDebugEnabled()) {
                logger.debug(String.format("Exception on server while executing function: %s", function), (Throwable)fe);
            }
        } else if (functionObject.isHA()) {
            logger.warn("Exception on server while executing function : {}", (Object)(function + " :" + message));
        } else {
            logger.warn(String.format("Exception on server while executing function : %s", function), (Throwable)fe);
        }
    }

    AbstractExecution createExecution(Object args, MemberMappedArgument memberMappedArg, boolean isBucketsAsFilter, Set<Object> filter, Set<Object> removedNodesSet, Region region, ServerToClientFunctionResultSender resultSender) {
        AbstractExecution execution = (AbstractExecution)FunctionService.onRegion(region);
        execution = execution instanceof PartitionedRegionFunctionExecutor ? new PartitionedRegionFunctionExecutor((PartitionedRegion)region, filter, args, memberMappedArg, resultSender, removedNodesSet, isBucketsAsFilter) : new DistributedRegionFunctionExecutor((DistributedRegion)region, filter, args, memberMappedArg, resultSender);
        return execution;
    }

    boolean validateFunctionObject(Message clientMessage, ServerConnection serverConnection, Object function, byte hasResult, byte functionState, Function<?> functionObject) throws IOException {
        if (functionObject == null) {
            String message = String.format("The function, %s, has not been registered", function);
            logger.warn("{}: {}", (Object)serverConnection.getName(), (Object)message);
            this.sendError(hasResult, clientMessage, message, serverConnection);
            return false;
        }
        byte functionStateOnServerSide = AbstractExecution.getFunctionState(functionObject.isHA(), functionObject.hasResult(), functionObject.optimizeForWrite());
        if (logger.isDebugEnabled()) {
            logger.debug("Function State on server side: {} on client: {}", (Object)functionStateOnServerSide, (Object)functionState);
        }
        if (functionStateOnServerSide != functionState) {
            String message = String.format("Function attributes at client and server don't match: %s", function);
            logger.warn("{}: {}", (Object)serverConnection.getName(), (Object)message);
            this.sendError(hasResult, clientMessage, message, serverConnection);
            return false;
        }
        return true;
    }

    String generateNullArgumentMessage(String regionName, Object function) {
        String message = null;
        if (regionName == null) {
            message = "The input region for the execute function request is null";
        } else if (function == null) {
            message = "The input function for the execute function request is null";
        }
        return message;
    }

    MemberMappedArgument extractMemberMappedArgument(Part part) throws IOException, ClassNotFoundException {
        Object obj;
        MemberMappedArgument memberMappedArg = null;
        if (part != null && (obj = part.getObject()) instanceof MemberMappedArgument) {
            memberMappedArg = (MemberMappedArgument)obj;
        }
        return memberMappedArg;
    }

    Set<Object> populateRemovedNodes(Message clientMessage, int removedNodesSize, int partNumber) throws IOException, ClassNotFoundException {
        HashSet<Object> removedNodesSet = null;
        if (removedNodesSize != 0) {
            removedNodesSet = new HashSet<Object>();
            ++partNumber;
            for (int i = 0; i < removedNodesSize; ++i) {
                removedNodesSet.add(clientMessage.getPart(partNumber + i).getStringOrObject());
            }
        }
        return removedNodesSet;
    }

    Set<Object> populateFilters(Message clientMessage, int filterSize) throws IOException, ClassNotFoundException {
        HashSet<Object> filter = null;
        if (filterSize != 0) {
            filter = new HashSet<Object>();
            int partNumber = 7;
            for (int i = 0; i < filterSize; ++i) {
                filter.add(clientMessage.getPart(partNumber + i).getStringOrObject());
            }
        }
        return filter;
    }

    ExecuteFunctionOperationContext getAuthorizedExecuteFunctionOperationContext(Object args, Set<Object> filter, boolean optimizedForWrite, AuthorizeRequest authzRequest, String functionName, String regionPath) {
        ExecuteFunctionOperationContext executeContext = null;
        if (authzRequest != null) {
            executeContext = authzRequest.executeFunctionAuthorize(functionName, regionPath, filter, args, optimizedForWrite);
        }
        return executeContext;
    }

    void executeFunctionNoResult(Object function, byte functionState, Function<?> functionObject, AbstractExecution execution) {
        if (function instanceof String) {
            switch (functionState) {
                case 0: {
                    execution.execute((String)function);
                    break;
                }
                case 4: {
                    execution.execute((String)function);
                }
            }
        } else {
            execution.execute(functionObject);
        }
    }

    void executeFunctionWithResult(Object function, byte functionState, Function<?> functionObject, AbstractExecution execution) {
        if (function instanceof String) {
            switch (functionState) {
                case 2: {
                    execution.execute((String)function).getResult();
                    break;
                }
                case 3: {
                    execution.execute((String)function).getResult();
                    break;
                }
                case 7: {
                    execution.execute((String)function).getResult();
                    break;
                }
                case 6: {
                    execution.execute((String)function).getResult();
                }
            }
        } else {
            execution.execute(functionObject).getResult();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void sendException(byte hasResult, Message msg, String message, ServerConnection serverConnection, Throwable e) throws IOException {
        Message message2 = msg;
        synchronized (message2) {
            if (hasResult == 1) {
                ExecuteRegionFunction66.writeFunctionResponseException(msg, 2, message, serverConnection, e);
            } else {
                ExecuteRegionFunction66.writeException(msg, e, false, serverConnection);
            }
            serverConnection.setAsTrue(1);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void sendError(byte hasResult, Message msg, String message, ServerConnection serverConnection) throws IOException {
        Message message2 = msg;
        synchronized (message2) {
            if (hasResult == 1) {
                ExecuteRegionFunction66.writeFunctionResponseError(msg, 61, message, serverConnection);
            } else {
                ExecuteRegionFunction66.writeErrorResponse(msg, 61, message, serverConnection);
            }
            serverConnection.setAsTrue(1);
        }
    }

    protected static void writeFunctionResponseException(Message origMsg, int messageType, String message, ServerConnection serverConnection, Throwable e) throws IOException {
        ChunkedMessage functionResponseMsg = serverConnection.getFunctionResponseMessage();
        ChunkedMessage chunkedResponseMsg = serverConnection.getChunkedResponseMessage();
        int numParts = 0;
        if (functionResponseMsg.headerHasBeenSent()) {
            if (e instanceof FunctionException && e.getCause() instanceof InternalFunctionInvocationTargetException) {
                functionResponseMsg.setNumberOfParts(3);
                functionResponseMsg.addObjPart(e);
                functionResponseMsg.addStringPart(BaseCommand.getExceptionTrace(e));
                InternalFunctionInvocationTargetException fe = (InternalFunctionInvocationTargetException)e.getCause();
                functionResponseMsg.addObjPart(fe.getFailedNodeSet());
                numParts = 3;
            } else {
                functionResponseMsg.setNumberOfParts(2);
                functionResponseMsg.addObjPart(e);
                functionResponseMsg.addStringPart(BaseCommand.getExceptionTrace(e));
                numParts = 2;
            }
            if (logger.isDebugEnabled()) {
                logger.debug("{}: Sending exception chunk while reply in progress: ", (Object)serverConnection.getName(), (Object)e);
            }
            functionResponseMsg.setServerConnection(serverConnection);
            functionResponseMsg.setLastChunkAndNumParts(true, numParts);
            functionResponseMsg.sendChunk(serverConnection);
        } else {
            chunkedResponseMsg.setMessageType(messageType);
            chunkedResponseMsg.setTransactionId(origMsg.getTransactionId());
            chunkedResponseMsg.sendHeader();
            if (e instanceof FunctionException && e.getCause() instanceof InternalFunctionInvocationTargetException) {
                chunkedResponseMsg.setNumberOfParts(3);
                chunkedResponseMsg.addObjPart(e);
                chunkedResponseMsg.addStringPart(BaseCommand.getExceptionTrace(e));
                InternalFunctionInvocationTargetException fe = (InternalFunctionInvocationTargetException)e.getCause();
                chunkedResponseMsg.addObjPart(fe.getFailedNodeSet());
                numParts = 3;
            } else {
                chunkedResponseMsg.setNumberOfParts(2);
                chunkedResponseMsg.addObjPart(e);
                chunkedResponseMsg.addStringPart(BaseCommand.getExceptionTrace(e));
                numParts = 2;
            }
            if (logger.isDebugEnabled()) {
                logger.debug("{}: Sending exception chunk: ", (Object)serverConnection.getName(), (Object)e);
            }
            chunkedResponseMsg.setServerConnection(serverConnection);
            chunkedResponseMsg.setLastChunkAndNumParts(true, numParts);
            chunkedResponseMsg.sendChunk(serverConnection);
        }
    }
}

