/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.internal.net;

import java.io.IOException;
import java.net.InetSocketAddress;
import java.net.Socket;
import javax.net.ssl.SSLSocketFactory;
import org.apache.geode.GemFireConfigException;
import org.apache.geode.SystemConnectException;
import org.apache.geode.distributed.internal.tcpserver.AdvancedSocketCreatorImpl;
import org.apache.geode.distributed.internal.tcpserver.ConnectionWatcher;
import org.apache.geode.distributed.internal.tcpserver.HostAndPort;
import org.apache.geode.distributed.internal.tcpserver.TcpSocketCreatorImpl;
import org.apache.geode.distributed.internal.tcpserver.TcpSocketFactory;
import org.apache.geode.internal.net.SocketCreator;

class SCAdvancedSocketCreator
extends AdvancedSocketCreatorImpl {
    final SocketCreator coreSocketCreator;

    protected SCAdvancedSocketCreator(SocketCreator socketCreator) {
        super((TcpSocketCreatorImpl)socketCreator);
        this.coreSocketCreator = socketCreator;
    }

    public void handshakeIfSocketIsSSL(Socket socket, int timeout) throws IOException {
        this.coreSocketCreator.handshakeIfSocketIsSSL(socket, timeout);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Socket connect(HostAndPort addr, int timeout, ConnectionWatcher optionalWatcher, boolean allowClientSocketFactory, int socketBufferSize, boolean useSSL, TcpSocketFactory socketFactory) throws IOException {
        this.coreSocketCreator.printConfig();
        if (!useSSL) {
            return super.connect(addr, timeout, optionalWatcher, allowClientSocketFactory, socketBufferSize, useSSL, socketFactory);
        }
        InetSocketAddress sockaddr = addr.getSocketInetAddress();
        if (this.coreSocketCreator.getSslContext() == null) {
            throw new GemFireConfigException("SSL not configured correctly, Please look at previous error");
        }
        Socket socket = socketFactory.createSocket();
        socket.setKeepAlive(ENABLE_TCP_KEEP_ALIVE);
        if (socketBufferSize != -1) {
            socket.setReceiveBufferSize(socketBufferSize);
        }
        try {
            if (optionalWatcher != null) {
                optionalWatcher.beforeConnect(socket);
            }
            socket.connect(sockaddr, Math.max(timeout, 0));
            SSLSocketFactory sf = this.coreSocketCreator.getSslContext().getSocketFactory();
            socket = sf.createSocket(socket, addr.getHostName(), addr.getPort(), true);
            this.coreSocketCreator.configureClientSSLSocket(socket, addr, timeout);
            Socket socket2 = socket;
            return socket2;
        }
        finally {
            if (optionalWatcher != null) {
                optionalWatcher.afterConnect(socket);
            }
        }
    }

    protected RuntimeException problemCreatingSocketInPortRangeException(String s, IOException e) {
        return new GemFireConfigException(s, e);
    }

    protected RuntimeException noFreePortException(String reason) {
        return new SystemConnectException(reason);
    }

    protected Socket createCustomClientSocket(HostAndPort addr) throws IOException {
        if (this.coreSocketCreator.getClientSocketFactory() != null) {
            InetSocketAddress inetSocketAddress = addr.getSocketInetAddress();
            return this.coreSocketCreator.getClientSocketFactory().createSocket(inetSocketAddress.getAddress(), inetSocketAddress.getPort());
        }
        return null;
    }
}

