/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.management.internal;

import java.net.UnknownHostException;
import org.apache.geode.CancelCriterion;
import org.apache.geode.distributed.internal.DistributionAdvisee;
import org.apache.geode.distributed.internal.DistributionAdvisor;
import org.apache.geode.distributed.internal.DistributionConfig;
import org.apache.geode.distributed.internal.DistributionManager;
import org.apache.geode.distributed.internal.InternalDistributedSystem;
import org.apache.geode.internal.cache.InternalCacheForClientAccess;
import org.apache.geode.internal.inet.LocalHostUtil;
import org.apache.geode.internal.net.SSLConfig;
import org.apache.geode.internal.net.SSLConfigurationFactory;
import org.apache.geode.internal.security.SecurableCommunicationChannel;
import org.apache.geode.management.ManagementService;
import org.apache.geode.management.internal.JmxManagerAdvisor;
import org.apache.geode.management.internal.SystemManagementService;

public class JmxManagerAdvisee
implements DistributionAdvisee {
    private final int serialNumber = DistributionAdvisor.createSerialNumber();
    private final InternalCacheForClientAccess cache;
    private JmxManagerAdvisor.JmxManagerProfile myMostRecentProfile;

    public JmxManagerAdvisee(InternalCacheForClientAccess cache) {
        this.cache = cache;
    }

    @Override
    public DistributionManager getDistributionManager() {
        return this.cache.getDistributionManager();
    }

    @Override
    public CancelCriterion getCancelCriterion() {
        return this.cache.getCancelCriterion();
    }

    @Override
    public DistributionAdvisor getDistributionAdvisor() {
        return this.cache.getJmxManagerAdvisor();
    }

    @Override
    public DistributionAdvisor.Profile getProfile() {
        return this.cache.getJmxManagerAdvisor().createProfile();
    }

    @Override
    public DistributionAdvisee getParentAdvisee() {
        return null;
    }

    @Override
    public InternalDistributedSystem getSystem() {
        return this.cache.getInternalDistributedSystem();
    }

    @Override
    public String getName() {
        return this.cache.getName();
    }

    @Override
    public String getFullPath() {
        return "JmxManager";
    }

    @Override
    public void fillInProfile(DistributionAdvisor.Profile profile) {
        assert (profile instanceof JmxManagerAdvisor.JmxManagerProfile);
        JmxManagerAdvisor.JmxManagerProfile jmxp = (JmxManagerAdvisor.JmxManagerProfile)profile;
        DistributionConfig dc = this.getSystem().getConfig();
        boolean jmxManager = dc.getJmxManager();
        String host = "";
        int port = 0;
        boolean ssl = false;
        boolean started = false;
        SystemManagementService service = (SystemManagementService)ManagementService.getExistingManagementService(this.cache);
        if (service != null) {
            jmxManager = service.isManagerCreated();
            started = service.isManager();
        }
        if (jmxManager) {
            port = dc.getJmxManagerPort();
            boolean usingJdkConfig = false;
            if (port == 0 && (port = Integer.getInteger("com.sun.management.jmxremote.port", 0).intValue()) != 0) {
                usingJdkConfig = true;
                ssl = true;
                if (System.getProperty("com.sun.management.jmxremote.ssl") != null) {
                    ssl = Boolean.getBoolean("com.sun.management.jmxremote.ssl");
                }
            }
            if (port != 0) {
                if (!usingJdkConfig) {
                    SSLConfig jmxSSL = SSLConfigurationFactory.getSSLConfigForComponent(dc, SecurableCommunicationChannel.JMX);
                    ssl = jmxSSL.isEnabled();
                    host = dc.getJmxManagerHostnameForClients();
                    if (host == null || host.equals("")) {
                        host = dc.getJmxManagerBindAddress();
                    }
                }
                if (host == null || host.equals("")) {
                    try {
                        host = LocalHostUtil.getLocalHost().getHostAddress();
                    }
                    catch (UnknownHostException ex) {
                        host = "127.0.0.1";
                    }
                }
            }
        }
        jmxp.setInfo(jmxManager, host, port, ssl, started);
        this.myMostRecentProfile = jmxp;
    }

    @Override
    public int getSerialNumber() {
        return this.serialNumber;
    }

    public JmxManagerAdvisor.JmxManagerProfile getMyMostRecentProfile() {
        return this.myMostRecentProfile;
    }

    void initProfile(JmxManagerAdvisor.JmxManagerProfile p) {
        this.myMostRecentProfile = p;
    }
}

