/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.management.internal;

import java.util.List;
import java.util.Set;
import org.apache.geode.distributed.internal.DistributionManager;
import org.apache.geode.distributed.internal.MembershipListener;
import org.apache.geode.distributed.internal.membership.InternalDistributedMember;
import org.apache.geode.logging.internal.log4j.api.LogService;
import org.apache.geode.management.internal.SystemManagementService;
import org.apache.logging.log4j.Logger;

public class ManagementMembershipListener
implements MembershipListener {
    private static final Logger logger = LogService.getLogger();
    private SystemManagementService service;

    public ManagementMembershipListener(SystemManagementService service) {
        this.service = service;
    }

    @Override
    public void memberDeparted(DistributionManager distributionManager, InternalDistributedMember id, boolean crashed) {
        if (logger.isDebugEnabled()) {
            logger.debug("ManagementMembershipListener member departed.. {}", (Object)id.getId());
        }
        if (this.service.isManager()) {
            if (logger.isDebugEnabled()) {
                logger.debug("Removing member artifacts for {} from manager ", (Object)id.getId());
            }
            this.service.getFederatingManager().removeMember(id, crashed);
        }
        this.service.getUniversalListenerContainer().memberDeparted(id, crashed);
    }

    @Override
    public void memberJoined(DistributionManager distributionManager, InternalDistributedMember id) {
        if (logger.isDebugEnabled()) {
            logger.debug("ManagementMembershipListener member joined .. {}", (Object)id.getId());
        }
        if (this.service.isManager()) {
            if (logger.isDebugEnabled()) {
                logger.debug("Adding member artifacts for {} to manager ", (Object)id.getId());
            }
            this.service.getFederatingManager().addMember(id);
        }
        this.service.getUniversalListenerContainer().memberJoined(id);
    }

    @Override
    public void memberSuspect(DistributionManager distributionManager, InternalDistributedMember id, InternalDistributedMember whoSuspected, String reason) {
        if (logger.isDebugEnabled()) {
            logger.debug("ManagementMembershipListener member suspected .. {}", (Object)id.getId());
        }
        if (this.service.isManager()) {
            if (logger.isDebugEnabled()) {
                logger.debug("Suspecting member {}", (Object)id.getId());
            }
            this.service.getFederatingManager().suspectMember(id, whoSuspected, reason);
        }
    }

    @Override
    public void quorumLost(DistributionManager distributionManager, Set<InternalDistributedMember> failures, List<InternalDistributedMember> remaining) {
    }
}

