/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.management.internal.configuration.mutators;

import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.commons.lang3.NotImplementedException;
import org.apache.commons.lang3.StringUtils;
import org.apache.geode.cache.configuration.CacheConfig;
import org.apache.geode.cache.configuration.RegionConfig;
import org.apache.geode.distributed.ConfigurationPersistenceService;
import org.apache.geode.lang.Identifiable;
import org.apache.geode.management.configuration.Region;
import org.apache.geode.management.internal.configuration.converters.RegionConverter;
import org.apache.geode.management.internal.configuration.mutators.CacheConfigurationManager;

public class RegionConfigManager
extends CacheConfigurationManager<Region> {
    private final RegionConverter converter = new RegionConverter();

    public RegionConfigManager(ConfigurationPersistenceService service) {
        super(service);
    }

    @Override
    public void add(Region configElement, CacheConfig existingConfig) {
        existingConfig.getRegions().add((RegionConfig)this.converter.fromConfigObject(configElement));
    }

    @Override
    public void update(Region config, CacheConfig existing) {
        throw new NotImplementedException("Not implemented yet");
    }

    @Override
    public void delete(Region config, CacheConfig existing) {
        existing.getRegions().removeIf(i -> i.getId().equals(config.getId()));
    }

    @Override
    public List<Region> list(Region filter, CacheConfig existing) {
        Stream<Object> stream = existing.getRegions().stream();
        if (StringUtils.isNotBlank((CharSequence)filter.getName())) {
            stream = stream.filter(r -> filter.getName().equals(r.getName()));
        }
        return stream.map(this.converter::fromXmlObject).filter(Objects::nonNull).collect(Collectors.toList());
    }

    @Override
    public Region get(Region config, CacheConfig existing) {
        return (Region)this.converter.fromXmlObject(Identifiable.find(existing.getRegions(), (String)config.getId()));
    }

    @Override
    public void checkCompatibility(Region incoming, String group, Region existing) {
        String existingType;
        String incomingType;
        if (incoming.getType().equals((Object)existing.getType())) {
            return;
        }
        if (!incoming.getType().name().contains("PROXY") && !existing.getType().name().contains("PROXY")) {
            this.raiseIncompatibilityError(incoming, group, existing);
        }
        if (!(incomingType = incoming.getType().name().split("_")[0]).equals(existingType = existing.getType().name().split("_")[0])) {
            this.raiseIncompatibilityError(incoming, group, existing);
        }
    }

    private void raiseIncompatibilityError(Region incoming, String group, Region existing) {
        throw new IllegalArgumentException(this.getDescription(incoming) + " is not compatible with " + group + "'s existing " + this.getDescription(existing) + ".");
    }

    private String getDescription(Region regionConfig) {
        return "Region '" + regionConfig.getName() + "' of type '" + regionConfig.getType() + "'";
    }
}

