/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.internal.cache.entries;

import java.util.UUID;
import org.apache.geode.annotations.Immutable;
import org.apache.geode.internal.cache.InlineKeyHelper;
import org.apache.geode.internal.cache.RegionEntry;
import org.apache.geode.internal.cache.RegionEntryContext;
import org.apache.geode.internal.cache.RegionEntryFactory;
import org.apache.geode.internal.cache.entries.VersionedStatsDiskRegionEntry;
import org.apache.geode.internal.cache.entries.VersionedStatsDiskRegionEntryHeapIntKey;
import org.apache.geode.internal.cache.entries.VersionedStatsDiskRegionEntryHeapLongKey;
import org.apache.geode.internal.cache.entries.VersionedStatsDiskRegionEntryHeapObjectKey;
import org.apache.geode.internal.cache.entries.VersionedStatsDiskRegionEntryHeapStringKey1;
import org.apache.geode.internal.cache.entries.VersionedStatsDiskRegionEntryHeapStringKey2;
import org.apache.geode.internal.cache.entries.VersionedStatsDiskRegionEntryHeapUUIDKey;

public abstract class VersionedStatsDiskRegionEntryHeap
extends VersionedStatsDiskRegionEntry {
    @Immutable
    private static final VersionedStatsDiskRegionEntryHeapFactory factory = new VersionedStatsDiskRegionEntryHeapFactory();

    public VersionedStatsDiskRegionEntryHeap(RegionEntryContext context, Object value) {
        super(context, value);
    }

    public static RegionEntryFactory getEntryFactory() {
        return factory;
    }

    private static class VersionedStatsDiskRegionEntryHeapFactory
    implements RegionEntryFactory {
        private VersionedStatsDiskRegionEntryHeapFactory() {
        }

        @Override
        public RegionEntry createEntry(RegionEntryContext context, Object key, Object value) {
            if (InlineKeyHelper.INLINE_REGION_KEYS) {
                Class<?> keyClass = key.getClass();
                if (keyClass == Integer.class) {
                    return new VersionedStatsDiskRegionEntryHeapIntKey(context, (Integer)key, value);
                }
                if (keyClass == Long.class) {
                    return new VersionedStatsDiskRegionEntryHeapLongKey(context, (Long)key, value);
                }
                if (keyClass == String.class) {
                    String skey = (String)key;
                    Boolean info = InlineKeyHelper.canStringBeInlineEncoded(skey);
                    if (info != null) {
                        boolean byteEncoded = info;
                        if (skey.length() <= InlineKeyHelper.getMaxInlineStringKey(1, byteEncoded)) {
                            return new VersionedStatsDiskRegionEntryHeapStringKey1(context, skey, value, byteEncoded);
                        }
                        return new VersionedStatsDiskRegionEntryHeapStringKey2(context, skey, value, byteEncoded);
                    }
                } else if (keyClass == UUID.class) {
                    return new VersionedStatsDiskRegionEntryHeapUUIDKey(context, (UUID)key, value);
                }
            }
            return new VersionedStatsDiskRegionEntryHeapObjectKey(context, key, value);
        }

        @Override
        public Class getEntryClass() {
            return VersionedStatsDiskRegionEntryHeapObjectKey.class;
        }

        @Override
        public RegionEntryFactory makeVersioned() {
            return this;
        }

        @Override
        public RegionEntryFactory makeOnHeap() {
            return this;
        }
    }
}

