/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.internal.size;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.ObjectStreamException;
import java.io.Serializable;
import java.util.Map;
import java.util.Properties;
import org.apache.geode.annotations.Immutable;
import org.apache.geode.cache.Declarable;
import org.apache.geode.cache.util.ObjectSizer;
import org.apache.geode.internal.size.ReflectionObjectSizer;
import org.apache.geode.internal.size.WellKnownClassSizer;
import org.apache.geode.internal.util.concurrent.CopyOnWriteWeakHashMap;

public class SizeClassOnceObjectSizer
implements ObjectSizer,
Serializable,
Declarable {
    @Immutable
    private static final SizeClassOnceObjectSizer INSTANCE = new SizeClassOnceObjectSizer();
    private final transient Map<Class, Integer> savedSizes = new CopyOnWriteWeakHashMap<Class, Integer>();
    private final transient ReflectionObjectSizer sizer = ReflectionObjectSizer.getInstance();

    @Override
    public int sizeof(Object o) {
        if (o == null) {
            return 0;
        }
        int wellKnownObjectSize = WellKnownClassSizer.sizeof(o);
        if (wellKnownObjectSize != 0) {
            return wellKnownObjectSize;
        }
        Class<?> clazz = o.getClass();
        Integer size = this.savedSizes.get(clazz);
        if (size == null) {
            size = this.sizer.sizeof(o);
            this.savedSizes.put(clazz, size);
        }
        return size;
    }

    public static SizeClassOnceObjectSizer getInstance() {
        return INSTANCE;
    }

    private void writeObject(ObjectOutputStream out) throws IOException {
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
    }

    private Object readResolve() throws ObjectStreamException {
        return INSTANCE;
    }

    private SizeClassOnceObjectSizer() {
    }

    @Override
    public void init(Properties props) {
    }
}

