/*
 * Decompiled with CFR 0.152.
 */
package org.grails.forge.application.generator;

import com.fizzed.rocker.RockerModel;
import io.micronaut.core.annotation.NonNull;
import io.micronaut.core.annotation.Nullable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import org.grails.forge.application.ApplicationType;
import org.grails.forge.application.OperatingSystem;
import org.grails.forge.application.Project;
import org.grails.forge.build.BuildPlugin;
import org.grails.forge.build.BuildProperties;
import org.grails.forge.build.dependencies.Coordinate;
import org.grails.forge.build.dependencies.CoordinateResolver;
import org.grails.forge.build.dependencies.Dependency;
import org.grails.forge.build.dependencies.DependencyContext;
import org.grails.forge.build.dependencies.LookupFailedException;
import org.grails.forge.build.dependencies.Scope;
import org.grails.forge.build.gradle.GradleRepository;
import org.grails.forge.feature.Feature;
import org.grails.forge.feature.Features;
import org.grails.forge.feature.build.gradle.GradleBuildSrc;
import org.grails.forge.feature.config.ApplicationConfiguration;
import org.grails.forge.feature.config.BootstrapConfiguration;
import org.grails.forge.feature.config.Configuration;
import org.grails.forge.feature.other.template.markdownLink;
import org.grails.forge.options.GormImpl;
import org.grails.forge.options.JdkVersion;
import org.grails.forge.options.Language;
import org.grails.forge.options.Options;
import org.grails.forge.options.ServletImpl;
import org.grails.forge.options.TestFramework;
import org.grails.forge.options.TestRockerModelProvider;
import org.grails.forge.template.RockerTemplate;
import org.grails.forge.template.RockerWritable;
import org.grails.forge.template.Template;
import org.grails.forge.template.Writable;
import org.grails.forge.util.VersionInfo;

public class GeneratorContext
implements DependencyContext {
    private final Project project;
    private final OperatingSystem operatingSystem;
    private final CoordinateResolver coordinateResolver;
    private final BuildProperties buildProperties = new BuildProperties();
    private final ApplicationConfiguration configuration = new ApplicationConfiguration();
    private final Map<String, ApplicationConfiguration> applicationEnvironmentConfiguration = new LinkedHashMap<String, ApplicationConfiguration>();
    private final Map<String, BootstrapConfiguration> bootstrapEnvironmentConfiguration = new LinkedHashMap<String, BootstrapConfiguration>();
    private final BootstrapConfiguration bootstrapConfiguration = new BootstrapConfiguration();
    private final Set<Configuration> otherConfiguration = new HashSet<Configuration>();
    private final Map<String, Template> templates = new LinkedHashMap<String, Template>();
    private final List<Writable> helpTemplates = new ArrayList<Writable>(8);
    private final ApplicationType command;
    private final Features features;
    private final Options options;
    private final Set<Dependency> dependencies = new HashSet<Dependency>();
    private final Set<Dependency> buildscriptDependencies = new HashSet<Dependency>();
    private final Set<GradleRepository> buildRepositories;
    private final Set<GradleRepository> repositories;
    private final Set<BuildPlugin> buildPlugins = new HashSet<BuildPlugin>();

    public GeneratorContext(Project project, ApplicationType type, Options options, @Nullable OperatingSystem operatingSystem, Set<Feature> features, CoordinateResolver coordinateResolver) {
        this.command = type;
        this.project = project;
        this.operatingSystem = operatingSystem;
        this.coordinateResolver = coordinateResolver;
        this.features = new Features(this, features, options);
        this.options = options;
        String grailsVersion = VersionInfo.getGrailsVersion();
        Set<GradleRepository> repositories = GradleRepository.getDefaultRepositories(grailsVersion);
        this.buildRepositories = repositories;
        this.repositories = repositories;
        this.buildProperties.put("grailsVersion", grailsVersion);
    }

    public void addTemplate(String name, Template template) {
        this.templates.put(name, template);
    }

    public void removeTemplate(String name) {
        this.templates.remove(name);
    }

    public void addHelpTemplate(Writable writable) {
        this.helpTemplates.add(writable);
    }

    public void addHelpLink(String label, String href) {
        this.addHelpTemplate(new RockerWritable(markdownLink.template(label, href)));
    }

    @NonNull
    public BuildProperties getBuildProperties() {
        return this.buildProperties;
    }

    @NonNull
    public ApplicationConfiguration getConfiguration() {
        return this.configuration;
    }

    @Nullable
    public ApplicationConfiguration getConfiguration(String env) {
        return this.applicationEnvironmentConfiguration.get(env);
    }

    @NonNull
    public ApplicationConfiguration getConfiguration(String env, ApplicationConfiguration defaultConfig) {
        return this.applicationEnvironmentConfiguration.computeIfAbsent(env, key -> defaultConfig);
    }

    @Nullable
    public BootstrapConfiguration getBootstrapConfiguration(String env) {
        return this.bootstrapEnvironmentConfiguration.get(env);
    }

    @NonNull
    public BootstrapConfiguration getBootstrapConfiguration(String env, BootstrapConfiguration defaultConfig) {
        return this.bootstrapEnvironmentConfiguration.computeIfAbsent(env, key -> defaultConfig);
    }

    @NonNull
    public BootstrapConfiguration getBootstrapConfiguration() {
        return this.bootstrapConfiguration;
    }

    public void addConfiguration(@NonNull Configuration configuration) {
        this.otherConfiguration.add(configuration);
    }

    @NonNull
    public Set<Configuration> getAllConfigurations() {
        HashSet<Configuration> allConfigurations = new HashSet<Configuration>();
        allConfigurations.add(this.configuration);
        allConfigurations.add(this.bootstrapConfiguration);
        allConfigurations.addAll(this.applicationEnvironmentConfiguration.values());
        allConfigurations.addAll(this.bootstrapEnvironmentConfiguration.values());
        allConfigurations.addAll(this.otherConfiguration);
        return allConfigurations;
    }

    @NonNull
    public Map<String, Template> getTemplates() {
        return Collections.unmodifiableMap(this.templates);
    }

    @NonNull
    public List<Writable> getHelpTemplates() {
        return Collections.unmodifiableList(this.helpTemplates);
    }

    @NonNull
    public TestFramework getTestFramework() {
        return this.options.getTestFramework();
    }

    @NonNull
    public GormImpl getGorm() {
        return this.options.getGormImpl();
    }

    @NonNull
    public ServletImpl getServlet() {
        return this.options.getServletImpl();
    }

    @NonNull
    public Project getProject() {
        return this.project;
    }

    @NonNull
    public ApplicationType getApplicationType() {
        return this.command;
    }

    @NonNull
    public Features getFeatures() {
        return this.features;
    }

    @NonNull
    public JdkVersion getJdkVersion() {
        return this.options.getJavaVersion();
    }

    @Nullable
    public OperatingSystem getOperatingSystem() {
        return this.operatingSystem;
    }

    public void applyFeatures() {
        ArrayList<Feature> features = new ArrayList<Feature>(this.features.getFeatures());
        features.sort(Comparator.comparingInt(Feature::getOrder));
        for (Feature feature : features) {
            feature.apply(this);
        }
    }

    public boolean isFeaturePresent(Class<? extends Feature> feature) {
        return this.features.isFeaturePresent(feature);
    }

    public <T extends Feature> Optional<T> getFeature(Class<T> feature) {
        return this.features.getFeature(feature);
    }

    public <T extends Feature> T getRequiredFeature(Class<T> feature) {
        return this.features.getRequiredFeature(feature);
    }

    public String getSourcePath(String path) {
        return Language.DEFAULT_OPTION.getSourcePath(path);
    }

    public String getTestSourcePath(String path) {
        return this.getTestFramework().getSourcePath(path, Language.DEFAULT_OPTION);
    }

    public String getIntegrationTestSourcePath(String path) {
        return this.getTestFramework().getIntegrationSourcePath(path, Language.DEFAULT_OPTION);
    }

    RockerModel parseModel(RockerModel javaTemplate, RockerModel groovyTemplate) {
        return groovyTemplate;
    }

    public void addTemplate(String name, String path, TestRockerModelProvider testRockerModelProvider) {
        RockerModel rockerModel = testRockerModelProvider.findModel(Language.DEFAULT_OPTION, this.getTestFramework());
        if (rockerModel != null) {
            this.addTemplate(name, new RockerTemplate(path, rockerModel));
        }
    }

    public void addTemplate(String templateName, String triggerFile, RockerModel javaTemplate, RockerModel groovyTemplate) {
        RockerModel rockerModel = this.parseModel(javaTemplate, groovyTemplate);
        this.addTemplate(templateName, new RockerTemplate(triggerFile, rockerModel));
    }

    @Override
    public void addDependency(@NonNull Dependency dependency) {
        if (dependency.requiresLookup()) {
            Coordinate coordinate = this.coordinateResolver.resolve(dependency.getArtifactId()).orElseThrow(() -> new LookupFailedException(dependency.getArtifactId()));
            this.dependencies.add(dependency.resolved(coordinate));
        } else {
            this.dependencies.add(dependency);
        }
    }

    @Override
    public void addBuildscriptDependency(@NonNull Dependency dependency) {
        if (dependency.requiresLookup()) {
            Coordinate coordinate = this.coordinateResolver.resolve(dependency.getArtifactId()).orElseThrow(() -> new LookupFailedException(dependency.getArtifactId()));
            this.addBuildscriptDependencyBasedOnFeatures(dependency.resolved(coordinate));
        } else {
            this.addBuildscriptDependencyBasedOnFeatures(dependency);
        }
    }

    private void addBuildscriptDependencyBasedOnFeatures(@NonNull Dependency dependency) {
        if (this.getFeature(GradleBuildSrc.class).isPresent()) {
            this.buildscriptDependencies.add(dependency);
        } else {
            this.buildscriptDependencies.add(dependency.scope(Scope.CLASSPATH));
        }
    }

    @NonNull
    public Set<Dependency> getDependencies() {
        return this.dependencies;
    }

    @NonNull
    public Set<Dependency> getBuildscriptDependencies() {
        return this.buildscriptDependencies;
    }

    @NonNull
    public Set<GradleRepository> getRepositories() {
        return this.repositories;
    }

    @NonNull
    public Set<GradleRepository> getBuildRepositories() {
        return this.buildRepositories;
    }

    public void addBuildPlugin(BuildPlugin buildPlugin) {
        if (buildPlugin.requiresLookup()) {
            this.buildPlugins.add(buildPlugin.resolved(this.coordinateResolver));
        } else {
            this.buildPlugins.add(buildPlugin);
        }
    }

    public Coordinate resolveCoordinate(String artifactId) {
        return this.coordinateResolver.resolve(artifactId).orElseThrow(() -> new LookupFailedException(artifactId));
    }

    public Set<BuildPlugin> getBuildPlugins() {
        return this.buildPlugins;
    }
}

