/*
 * Decompiled with CFR 0.152.
 */
package org.grails.forge.feature.migration;

import jakarta.inject.Singleton;
import org.grails.forge.application.generator.GeneratorContext;
import org.grails.forge.build.dependencies.Dependency;
import org.grails.forge.feature.migration.MigrationFeature;
import org.grails.forge.feature.migration.templates.dbMigrationGradle;
import org.grails.forge.template.RockerWritable;
import org.grails.forge.template.URLTemplate;
import org.grails.forge.util.VersionInfo;

@Singleton
public class DatabaseMigrationPlugin
implements MigrationFeature {
    @Override
    public String getName() {
        return "database-migration";
    }

    @Override
    public String getTitle() {
        return "Database Migration";
    }

    @Override
    public String getDescription() {
        return "Add support for Liquibase database migrations. The Database Migration Plugin helps you manage database schema changes while developing Grails applications.";
    }

    @Override
    public String getThirdPartyDocumentation() {
        return "https://docs.liquibase.com/home.html";
    }

    @Override
    public String getDocumentation() {
        return "https://docs.grails.org/" + VersionInfo.getDocumentationVersion() + "/grails-data/hibernate5/manual/index.html#databaseMigration";
    }

    @Override
    public void apply(GeneratorContext generatorContext) {
        String srcDirPath = this.getSrcDirPath();
        generatorContext.addBuildscriptDependency(Dependency.builder().groupId("org.apache.grails").artifactId("grails-data-hibernate5-dbmigration").buildSrc().extension(new RockerWritable(dbMigrationGradle.template(srcDirPath))));
        generatorContext.addDependency(Dependency.builder().groupId("org.apache.grails").artifactId("grails-data-hibernate5-dbmigration").implementation());
        ClassLoader classLoader = Thread.currentThread().getContextClassLoader();
        generatorContext.addTemplate(srcDirPath, new URLTemplate(srcDirPath + "/.gitkeep", classLoader.getResource(".gitkeep")));
    }

    private String getSrcDirPath() {
        return "grails-app/migrations";
    }
}

