/*
 *  Licensed to the Apache Software Foundation (ASF) under one
 *  or more contributor license agreements.  See the NOTICE file
 *  distributed with this work for additional information
 *  regarding copyright ownership.  The ASF licenses this file
 *  to you under the Apache License, Version 2.0 (the
 *  "License"); you may not use this file except in compliance
 *  with the License.  You may obtain a copy of the License at
 *
 *    https://www.apache.org/licenses/LICENSE-2.0
 *
 *  Unless required by applicable law or agreed to in writing,
 *  software distributed under the License is distributed on an
 *  "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 *  KIND, either express or implied.  See the License for the
 *  specific language governing permissions and limitations
 *  under the License.
 */
package org.grails.datastore.gorm.mongo

import grails.persistence.Entity
import org.apache.grails.data.mongo.core.GrailsDataMongoTckManager
import org.apache.grails.data.testing.tck.base.GrailsDataTckSpec
import spock.lang.Issue

class DefaultSortOrderSpec extends GrailsDataTckSpec<GrailsDataMongoTckManager> {
    void setupSpec() {
        manager.domainClasses.addAll([SOBook])
    }

    @Issue('GPMONGODB-181')
    void 'Test that default sort order works correctly'() {
        given: "A domain model with default sort order"
        (2..10).each {
            new SOBook(title: 'The History of the English Speaking People volume ' + it, published: new Date(), isbn: it).save(flush: true)
        }
        new SOBook(title: 'The History of the English Speaking People volume ' + 1, published: new Date(), isbn: 1).save(flush: true)

        when: "The model is queried"
        def books = SOBook.list()

        then: "The sort order is correct"
        books[0].isbn == 1
        books[1].isbn == 2
    }
}

@Entity
class SOBook {
    Long id
    String title
    Date published
    Integer isbn

    static mapping = {
        sort isbn: 'asc'
    }
}
