/*
 * Decompiled with CFR 0.152.
 */
package org.apache.gravitino.server.authorization;

import java.lang.reflect.Array;
import java.security.Principal;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;
import java.util.concurrent.Executors;
import java.util.function.Function;
import org.apache.gravitino.Config;
import org.apache.gravitino.Configs;
import org.apache.gravitino.Entity;
import org.apache.gravitino.GravitinoEnv;
import org.apache.gravitino.MetadataObject;
import org.apache.gravitino.Metalake;
import org.apache.gravitino.NameIdentifier;
import org.apache.gravitino.authorization.AuthorizationRequestContext;
import org.apache.gravitino.authorization.GravitinoAuthorizer;
import org.apache.gravitino.dto.tag.MetadataObjectDTO;
import org.apache.gravitino.server.authorization.GravitinoAuthorizerProvider;
import org.apache.gravitino.server.authorization.expression.AuthorizationExpressionEvaluator;
import org.apache.gravitino.utils.MetadataObjectUtil;
import org.apache.gravitino.utils.NameIdentifierUtil;
import org.apache.gravitino.utils.PrincipalUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MetadataAuthzHelper {
    private static final Logger LOG = LoggerFactory.getLogger(MetadataAuthzHelper.class);
    private static volatile Executor executor = null;

    private MetadataAuthzHelper() {
    }

    public static Metalake[] filterMetalakes(Metalake[] metalakes, String expression) {
        AuthorizationRequestContext authorizationRequestContext = new AuthorizationRequestContext();
        return MetadataAuthzHelper.doFilter(expression, metalakes, PrincipalUtils.getCurrentPrincipal(), GravitinoAuthorizerProvider.getInstance().getGravitinoAuthorizer(), authorizationRequestContext, metalake -> {
            String metalakeName = metalake.name();
            return MetadataAuthzHelper.splitMetadataNames(metalakeName, Entity.EntityType.METALAKE, NameIdentifierUtil.ofMetalake((String)metalakeName));
        }, unused -> null);
    }

    public static MetadataObjectDTO[] filterMetadataObject(String metalake, MetadataObjectDTO[] metadataObjects) {
        return MetadataAuthzHelper.doFilter("CAN_ACCESS_METADATA", metadataObjects, PrincipalUtils.getCurrentPrincipal(), GravitinoAuthorizerProvider.getInstance().getGravitinoAuthorizer(), new AuthorizationRequestContext(), metadataObject -> MetadataAuthzHelper.splitMetadataNames(metalake, MetadataObjectUtil.toEntityType((MetadataObject.Type)metadataObject.type()), MetadataObjectUtil.toEntityIdent((String)metalake, (MetadataObject)metadataObject)), metadataObject -> MetadataObjectUtil.toEntityType((MetadataObject.Type)metadataObject.type()));
    }

    public static MetadataObject[] filterMetadataObject(String metalake, MetadataObject[] metadataObjects) {
        return MetadataAuthzHelper.doFilter("CAN_ACCESS_METADATA", metadataObjects, PrincipalUtils.getCurrentPrincipal(), GravitinoAuthorizerProvider.getInstance().getGravitinoAuthorizer(), new AuthorizationRequestContext(), metadataObject -> MetadataAuthzHelper.splitMetadataNames(metalake, MetadataObjectUtil.toEntityType((MetadataObject.Type)metadataObject.type()), MetadataObjectUtil.toEntityIdent((String)metalake, (MetadataObject)metadataObject)), metadataObject -> MetadataObjectUtil.toEntityType((MetadataObject.Type)metadataObject.type()));
    }

    public static NameIdentifier[] filterByExpression(String metalake, String expression, Entity.EntityType entityType, NameIdentifier[] nameIdentifiers) {
        return MetadataAuthzHelper.filterByExpression(metalake, expression, entityType, nameIdentifiers, e -> e);
    }

    public static boolean checkAccess(NameIdentifier identifier, Entity.EntityType entityType, String expression) {
        if (!MetadataAuthzHelper.enableAuthorization()) {
            return true;
        }
        String metalake = NameIdentifierUtil.getMetalake((NameIdentifier)identifier);
        Map<Entity.EntityType, NameIdentifier> nameIdentifierMap = MetadataAuthzHelper.splitMetadataNames(metalake, entityType, identifier);
        AuthorizationExpressionEvaluator authorizationExpressionEvaluator = new AuthorizationExpressionEvaluator(expression);
        return authorizationExpressionEvaluator.evaluate(nameIdentifierMap, new AuthorizationRequestContext());
    }

    public static <E> E[] filterByExpression(String metalake, String expression, Entity.EntityType entityType, E[] entities, Function<E, NameIdentifier> toNameIdentifier) {
        GravitinoAuthorizer authorizer = GravitinoAuthorizerProvider.getInstance().getGravitinoAuthorizer();
        AuthorizationRequestContext authorizationRequestContext = new AuthorizationRequestContext();
        return MetadataAuthzHelper.doFilter(expression, entities, PrincipalUtils.getCurrentPrincipal(), authorizer, authorizationRequestContext, entity -> {
            NameIdentifier nameIdentifier = (NameIdentifier)toNameIdentifier.apply(entity);
            return MetadataAuthzHelper.splitMetadataNames(metalake, entityType, nameIdentifier);
        }, unused -> null);
    }

    public static <E> E[] filterByExpression(String metalake, String expression, Entity.EntityType entityType, E[] entities, Function<E, NameIdentifier> toNameIdentifier, Principal currentPrincipal, GravitinoAuthorizer authorizer) {
        AuthorizationRequestContext authorizationRequestContext = new AuthorizationRequestContext();
        return MetadataAuthzHelper.doFilter(expression, entities, currentPrincipal, authorizer, authorizationRequestContext, entity -> {
            NameIdentifier nameIdentifier = (NameIdentifier)toNameIdentifier.apply(entity);
            return MetadataAuthzHelper.splitMetadataNames(metalake, entityType, nameIdentifier);
        }, unused -> null);
    }

    private static <E> E[] doFilter(String expression, E[] entities, Principal currentPrincipal, GravitinoAuthorizer authorizer, AuthorizationRequestContext authorizationRequestContext, Function<E, Map<Entity.EntityType, NameIdentifier>> extractMetadataNamesMap, Function<E, Entity.EntityType> extractEntityType) {
        if (!MetadataAuthzHelper.enableAuthorization()) {
            return entities;
        }
        MetadataAuthzHelper.checkExecutor();
        authorizationRequestContext.setOriginalAuthorizationExpression(expression);
        ArrayList<CompletableFuture<Object>> futures = new ArrayList<CompletableFuture<Object>>();
        for (Object entity : entities) {
            futures.add(CompletableFuture.supplyAsync(() -> {
                try {
                    return PrincipalUtils.doAs((Principal)currentPrincipal, () -> {
                        AuthorizationExpressionEvaluator authorizationExpressionEvaluator = new AuthorizationExpressionEvaluator(expression, authorizer);
                        return authorizationExpressionEvaluator.evaluate((Map<Entity.EntityType, NameIdentifier>)((Map)extractMetadataNamesMap.apply(entity)), authorizationRequestContext, currentPrincipal, Optional.ofNullable((Entity.EntityType)extractEntityType.apply(entity)).map(Enum::name)) ? entity : null;
                    });
                }
                catch (Exception e) {
                    LOG.error("GravitinoAuthorize error:{}", (Object)e.getMessage(), (Object)e);
                    return null;
                }
            }, executor));
        }
        return futures.stream().map(CompletableFuture::join).filter(Objects::nonNull).toArray(size -> (Object[])Array.newInstance(entities.getClass().getComponentType(), size));
    }

    public static Map<Entity.EntityType, NameIdentifier> splitMetadataNames(String metalake, Entity.EntityType entityType, NameIdentifier nameIdentifier) {
        HashMap<Entity.EntityType, NameIdentifier> nameIdentifierMap = new HashMap<Entity.EntityType, NameIdentifier>();
        nameIdentifierMap.put(Entity.EntityType.METALAKE, NameIdentifierUtil.ofMetalake((String)metalake));
        while (entityType != Entity.EntityType.METALAKE) {
            nameIdentifierMap.put(entityType, nameIdentifier);
            entityType = NameIdentifierUtil.parentEntityType((Entity.EntityType)entityType);
            nameIdentifier = NameIdentifierUtil.parentNameIdentifier((NameIdentifier)nameIdentifier, (Entity.EntityType)entityType);
        }
        return nameIdentifierMap;
    }

    private static boolean enableAuthorization() {
        Config config = GravitinoEnv.getInstance().config();
        return config != null && (Boolean)config.get(Configs.ENABLE_AUTHORIZATION) != false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static void checkExecutor() {
        if (executor != null) return;
        Class<MetadataAuthzHelper> clazz = MetadataAuthzHelper.class;
        synchronized (MetadataAuthzHelper.class) {
            if (executor != null) return;
            executor = Executors.newFixedThreadPool((Integer)GravitinoEnv.getInstance().config().get(Configs.GRAVITINO_AUTHORIZATION_THREAD_POOL_SIZE), runnable -> {
                Thread thread = new Thread(runnable);
                thread.setDaemon(true);
                thread.setName("MetadataFilterHelper-ThreadPool-" + thread.getId());
                return thread;
            });
            // ** MonitorExit[var0] (shouldn't be in output)
            return;
        }
    }
}

