/*
 * Decompiled with CFR 0.152.
 */
package org.apache.gravitino.authorization;

import java.io.Closeable;
import java.security.Principal;
import org.apache.gravitino.Entity;
import org.apache.gravitino.GravitinoEnv;
import org.apache.gravitino.MetadataObject;
import org.apache.gravitino.NameIdentifier;
import org.apache.gravitino.authorization.AuthorizationRequestContext;
import org.apache.gravitino.authorization.Privilege;
import org.apache.gravitino.meta.RoleEntity;
import org.apache.gravitino.utils.NameIdentifierUtil;

public interface GravitinoAuthorizer
extends Closeable {
    public void initialize();

    public boolean authorize(Principal var1, String var2, MetadataObject var3, Privilege.Name var4, AuthorizationRequestContext var5);

    public boolean deny(Principal var1, String var2, MetadataObject var3, Privilege.Name var4, AuthorizationRequestContext var5);

    public boolean isOwner(Principal var1, String var2, MetadataObject var3, AuthorizationRequestContext var4);

    public boolean isServiceAdmin();

    public boolean isSelf(Entity.EntityType var1, NameIdentifier var2);

    public boolean isMetalakeUser(String var1);

    public boolean hasSetOwnerPermission(String var1, String var2, String var3, AuthorizationRequestContext var4);

    public boolean hasMetadataPrivilegePermission(String var1, String var2, String var3, AuthorizationRequestContext var4);

    public void handleRolePrivilegeChange(Long var1);

    default public void handleRolePrivilegeChange(String metalake, String roleName) {
        try {
            RoleEntity entity = GravitinoEnv.getInstance().entityStore().get(NameIdentifierUtil.ofRole(metalake, roleName), Entity.EntityType.ROLE, RoleEntity.class);
            this.handleRolePrivilegeChange(entity.id());
        }
        catch (Exception e) {
            throw new RuntimeException("Can not get Role Entity", e);
        }
    }

    public void handleMetadataOwnerChange(String var1, Long var2, NameIdentifier var3, Entity.EntityType var4);
}

