/*
 * Decompiled with CFR 0.152.
 */
package org.apache.gravitino.hook;

import java.io.IOException;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.apache.gravitino.Entity;
import org.apache.gravitino.GravitinoEnv;
import org.apache.gravitino.authorization.AuthorizationUtils;
import org.apache.gravitino.authorization.Owner;
import org.apache.gravitino.authorization.OwnerDispatcher;
import org.apache.gravitino.exceptions.InUseException;
import org.apache.gravitino.exceptions.JobTemplateAlreadyExistsException;
import org.apache.gravitino.exceptions.NoSuchJobException;
import org.apache.gravitino.exceptions.NoSuchJobTemplateException;
import org.apache.gravitino.job.JobOperationDispatcher;
import org.apache.gravitino.job.JobTemplateChange;
import org.apache.gravitino.meta.JobEntity;
import org.apache.gravitino.meta.JobTemplateEntity;
import org.apache.gravitino.utils.NameIdentifierUtil;
import org.apache.gravitino.utils.PrincipalUtils;

public class JobHookDispatcher
implements JobOperationDispatcher {
    private final JobOperationDispatcher jobOperationDispatcher;

    public JobHookDispatcher(JobOperationDispatcher jobOperationDispatcher) {
        this.jobOperationDispatcher = jobOperationDispatcher;
    }

    @Override
    public List<JobTemplateEntity> listJobTemplates(String metalake) {
        return this.jobOperationDispatcher.listJobTemplates(metalake);
    }

    @Override
    public void registerJobTemplate(String metalake, JobTemplateEntity jobTemplateEntity) throws JobTemplateAlreadyExistsException {
        AuthorizationUtils.checkCurrentUser(metalake, PrincipalUtils.getCurrentUserName());
        this.jobOperationDispatcher.registerJobTemplate(metalake, jobTemplateEntity);
        OwnerDispatcher ownerManager = GravitinoEnv.getInstance().ownerDispatcher();
        if (ownerManager != null) {
            ownerManager.setOwner(metalake, NameIdentifierUtil.toMetadataObject(jobTemplateEntity.nameIdentifier(), Entity.EntityType.JOB_TEMPLATE), PrincipalUtils.getCurrentUserName(), Owner.Type.USER);
        }
    }

    @Override
    public JobTemplateEntity getJobTemplate(String metalake, String jobTemplateName) throws NoSuchJobTemplateException {
        return this.jobOperationDispatcher.getJobTemplate(metalake, jobTemplateName);
    }

    @Override
    public boolean deleteJobTemplate(String metalake, String jobTemplateName) throws InUseException {
        return this.jobOperationDispatcher.deleteJobTemplate(metalake, jobTemplateName);
    }

    @Override
    public JobTemplateEntity alterJobTemplate(String metalake, String jobTemplateName, JobTemplateChange ... changes) throws NoSuchJobTemplateException, IllegalArgumentException {
        return this.jobOperationDispatcher.alterJobTemplate(metalake, jobTemplateName, changes);
    }

    @Override
    public List<JobEntity> listJobs(String metalake, Optional<String> jobTemplateName) throws NoSuchJobTemplateException {
        return this.jobOperationDispatcher.listJobs(metalake, jobTemplateName);
    }

    @Override
    public JobEntity getJob(String metalake, String jobId) throws NoSuchJobException {
        return this.jobOperationDispatcher.getJob(metalake, jobId);
    }

    @Override
    public JobEntity runJob(String metalake, String jobTemplateName, Map<String, String> jobConf) throws NoSuchJobTemplateException {
        AuthorizationUtils.checkCurrentUser(metalake, PrincipalUtils.getCurrentUserName());
        JobEntity jobEntity = this.jobOperationDispatcher.runJob(metalake, jobTemplateName, jobConf);
        OwnerDispatcher ownerManager = GravitinoEnv.getInstance().ownerDispatcher();
        if (ownerManager != null) {
            ownerManager.setOwner(metalake, NameIdentifierUtil.toMetadataObject(jobEntity.nameIdentifier(), Entity.EntityType.JOB), PrincipalUtils.getCurrentUserName(), Owner.Type.USER);
        }
        return jobEntity;
    }

    @Override
    public JobEntity cancelJob(String metalake, String jobId) throws NoSuchJobException {
        return this.jobOperationDispatcher.cancelJob(metalake, jobId);
    }

    @Override
    public void close() throws IOException {
        this.jobOperationDispatcher.close();
    }
}

