/*
 * Decompiled with CFR 0.152.
 */
package org.apache.gravitino.storage.relational.mapper.provider.base;

import java.util.List;
import org.apache.gravitino.storage.relational.po.StatisticPO;
import org.apache.ibatis.annotations.Param;

public class StatisticBaseSQLProvider {
    public String batchInsertStatisticPOsOnDuplicateKeyUpdate(@Param(value="statisticPOs") List<StatisticPO> statisticPOs) {
        return "<script>INSERT INTO statistic_meta (statistic_id, statistic_name, statistic_value, metalake_id, metadata_object_id, metadata_object_type, audit_info, current_version, last_version, deleted_at) VALUES <foreach collection='statisticPOs' item='item' separator=','>(#{item.statisticId}, #{item.statisticName}, #{item.statisticValue}, #{item.metalakeId}, #{item.metadataObjectId}, #{item.metadataObjectType}, #{item.auditInfo}, #{item.currentVersion}, #{item.lastVersion}, #{item.deletedAt})</foreach> ON DUPLICATE KEY UPDATE   statistic_value = VALUES(statistic_value),  audit_info = VALUES(audit_info),  current_version = VALUES(current_version),  last_version = VALUES(last_version),  deleted_at = VALUES(deleted_at)</script>";
    }

    public String batchDeleteStatisticPOs(@Param(value="entityId") Long entityId, @Param(value="statisticNames") List<String> statisticNames) {
        return "<script>UPDATE statistic_meta" + this.softDeleteSQL() + " WHERE  statistic_name IN (<foreach collection='statisticNames' item='item' separator=','> #{item}</foreach> ) AND deleted_at = 0 AND metadata_object_id = #{entityId}</script>";
    }

    public String softDeleteStatisticsByEntityId(@Param(value="entityId") Long entityId) {
        return "UPDATE statistic_meta" + this.softDeleteSQL() + " WHERE metadata_object_id = #{entityId} AND deleted_at = 0";
    }

    public String listStatisticPOsByEntityId(@Param(value="metalakeId") Long metalakeId, @Param(value="entityId") Long entityId) {
        return "SELECT statistic_id as statisticId, statistic_name as statisticName, metalake_id as metalakeId, statistic_value as statisticValue, metadata_object_id as metadataObjectId, metadata_object_type as metadataObjectType, audit_info as auditInfo, current_version as currentVersion, last_version as lastVersion, deleted_at as deletedAt FROM statistic_meta WHERE metadata_object_id = #{entityId} AND deleted_at = 0 AND metalake_id = #{metalakeId}";
    }

    public String softDeleteStatisticsByMetalakeId(@Param(value="metalakeId") Long metalakeId) {
        return "UPDATE statistic_meta stat " + this.softDeleteSQL() + " WHERE stat.metalake_id = #{metalakeId} AND stat.deleted_at = 0";
    }

    public String softDeleteStatisticsByCatalogId(@Param(value="catalogId") Long catalogId) {
        return "UPDATE statistic_meta stat " + this.softDeleteSQL() + " WHERE stat.deleted_at = 0 AND EXISTS ( SELECT ct.catalog_id FROM catalog_meta ct WHERE ct.catalog_id = #{catalogId} AND ct.catalog_id = stat.metadata_object_id AND stat.metadata_object_type = 'CATALOG' UNION SELECT st.catalog_id FROM schema_meta st WHERE st.catalog_id = #{catalogId} AND st.schema_id = stat.metadata_object_id AND stat.metadata_object_type = 'SCHEMA' UNION SELECT tt.catalog_id FROM topic_meta tt WHERE tt.catalog_id = #{catalogId} AND tt.topic_id = stat.metadata_object_id AND stat.metadata_object_type = 'TOPIC' UNION SELECT tat.catalog_id FROM table_meta tat WHERE tat.catalog_id = #{catalogId} AND tat.table_id = stat.metadata_object_id AND stat.metadata_object_type = 'TABLE' UNION SELECT ft.catalog_id FROM fileset_meta ft WHERE ft.catalog_id = #{catalogId} AND ft.fileset_id = stat.metadata_object_id AND stat.metadata_object_type = 'FILESET' UNION SELECT mt.catalog_id FROM model_meta mt WHERE mt.catalog_id = #{catalogId} AND mt.model_id = stat.metadata_object_id AND stat.metadata_object_type = 'MODEL')";
    }

    public String softDeleteStatisticsBySchemaId(@Param(value="schemaId") Long schemaId) {
        return "UPDATE statistic_meta stat " + this.softDeleteSQL() + " WHERE stat.deleted_at = 0 AND EXISTS ( SELECT st.schema_id FROM schema_meta st WHERE st.schema_id = #{schemaId} AND st.schema_id = stat.metadata_object_id AND stat.metadata_object_type = 'SCHEMA' UNION SELECT tt.schema_id FROM topic_meta tt WHERE tt.schema_id = #{schemaId} AND tt.topic_id = stat.metadata_object_id AND stat.metadata_object_type = 'TOPIC' UNION SELECT tat.schema_id FROM table_meta tat WHERE tat.schema_id = #{schemaId} AND tat.table_id = stat.metadata_object_id AND stat.metadata_object_type = 'TABLE' UNION SELECT ft.schema_id FROM fileset_meta ft WHERE ft.schema_id = #{schemaId} AND ft.fileset_id = stat.metadata_object_id AND stat.metadata_object_type = 'FILESET' UNION SELECT mt.schema_id FROM model_meta mt WHERE mt.schema_id = #{schemaId} AND mt.model_id = stat.metadata_object_id AND stat.metadata_object_type = 'MODEL')";
    }

    public String deleteStatisticsByLegacyTimeline(@Param(value="legacyTimeline") Long legacyTimeline, @Param(value="limit") int limit) {
        return "DELETE FROM statistic_meta WHERE deleted_at > 0 AND deleted_at < #{legacyTimeline} LIMIT #{limit}";
    }

    protected String softDeleteSQL() {
        return " SET deleted_at = (UNIX_TIMESTAMP() * 1000.0) + EXTRACT(MICROSECOND FROM CURRENT_TIMESTAMP(3)) / 1000 ";
    }
}

