/*
 * Decompiled with CFR 0.152.
 */
package org.apache.gravitino.storage.relational.service;

import com.codahale.metrics.Meter;
import com.codahale.metrics.MetricRegistry;
import com.codahale.metrics.Timer;
import java.io.IOException;
import java.lang.annotation.Annotation;
import java.util.List;
import java.util.Locale;
import java.util.stream.Collectors;
import org.apache.gravitino.Entity;
import org.apache.gravitino.NameIdentifier;
import org.apache.gravitino.Namespace;
import org.apache.gravitino.exceptions.IllegalNamespaceException;
import org.apache.gravitino.exceptions.NoSuchEntityException;
import org.apache.gravitino.meta.JobEntity;
import org.apache.gravitino.metrics.MethodMonitorAspect;
import org.apache.gravitino.metrics.Monitored;
import org.apache.gravitino.metrics.source.MetricsSource;
import org.apache.gravitino.storage.relational.mapper.JobMetaMapper;
import org.apache.gravitino.storage.relational.po.JobPO;
import org.apache.gravitino.storage.relational.service.EntityIdService;
import org.apache.gravitino.storage.relational.utils.ExceptionUtils;
import org.apache.gravitino.storage.relational.utils.SessionUtils;
import org.apache.gravitino.utils.NamespaceUtil;
import org.aspectj.lang.JoinPoint;
import org.aspectj.lang.ProceedingJoinPoint;
import org.aspectj.lang.Signature;
import org.aspectj.runtime.internal.Conversions;
import org.aspectj.runtime.reflect.Factory;

public class JobMetaService {
    private static final JobMetaService INSTANCE;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_0;
    private static /* synthetic */ Annotation ajc$anno$0;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_1;
    private static /* synthetic */ Annotation ajc$anno$1;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_2;
    private static /* synthetic */ Annotation ajc$anno$2;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_3;
    private static /* synthetic */ Annotation ajc$anno$3;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_4;
    private static /* synthetic */ Annotation ajc$anno$4;

    private JobMetaService() {
    }

    public static JobMetaService getInstance() {
        return INSTANCE;
    }

    @Monitored(metricsSource="gravitino-relational-store", baseMetricName="listJobsByNamespace")
    public List<JobEntity> listJobsByNamespace(Namespace ns) {
        Namespace namespace = ns;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_0, (Object)this, (Object)this, (Object)namespace);
        MethodMonitorAspect methodMonitorAspect = MethodMonitorAspect.aspectOf();
        ProceedingJoinPoint proceedingJoinPoint = (ProceedingJoinPoint)joinPoint;
        Annotation annotation = ajc$anno$0;
        if (annotation == null) {
            annotation = ajc$anno$0 = JobMetaService.class.getDeclaredMethod("listJobsByNamespace", Namespace.class).getAnnotation(Monitored.class);
        }
        return (List)JobMetaService.listJobsByNamespace_aroundBody1$advice(this, namespace, joinPoint, methodMonitorAspect, proceedingJoinPoint, (Monitored)annotation);
    }

    @Monitored(metricsSource="gravitino-relational-store", baseMetricName="getJobByIdentifier")
    public JobEntity getJobByIdentifier(NameIdentifier ident) {
        NameIdentifier nameIdentifier = ident;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_1, (Object)this, (Object)this, (Object)nameIdentifier);
        MethodMonitorAspect methodMonitorAspect = MethodMonitorAspect.aspectOf();
        ProceedingJoinPoint proceedingJoinPoint = (ProceedingJoinPoint)joinPoint;
        Annotation annotation = ajc$anno$1;
        if (annotation == null) {
            annotation = ajc$anno$1 = JobMetaService.class.getDeclaredMethod("getJobByIdentifier", NameIdentifier.class).getAnnotation(Monitored.class);
        }
        return (JobEntity)JobMetaService.getJobByIdentifier_aroundBody3$advice(this, nameIdentifier, joinPoint, methodMonitorAspect, proceedingJoinPoint, (Monitored)annotation);
    }

    @Monitored(metricsSource="gravitino-relational-store", baseMetricName="insertJob")
    public void insertJob(JobEntity jobEntity, boolean overwrite) throws IOException {
        JobEntity jobEntity2 = jobEntity;
        boolean bl = overwrite;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_2, (Object)this, (Object)this, (Object)jobEntity2, (Object)Conversions.booleanObject((boolean)bl));
        MethodMonitorAspect methodMonitorAspect = MethodMonitorAspect.aspectOf();
        ProceedingJoinPoint proceedingJoinPoint = (ProceedingJoinPoint)joinPoint;
        Annotation annotation = ajc$anno$2;
        if (annotation == null) {
            annotation = ajc$anno$2 = JobMetaService.class.getDeclaredMethod("insertJob", JobEntity.class, Boolean.TYPE).getAnnotation(Monitored.class);
        }
        JobMetaService.insertJob_aroundBody5$advice(this, jobEntity2, bl, joinPoint, methodMonitorAspect, proceedingJoinPoint, (Monitored)annotation);
    }

    @Monitored(metricsSource="gravitino-relational-store", baseMetricName="deleteJob")
    public boolean deleteJob(NameIdentifier jobIdent) {
        NameIdentifier nameIdentifier = jobIdent;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_3, (Object)this, (Object)this, (Object)nameIdentifier);
        MethodMonitorAspect methodMonitorAspect = MethodMonitorAspect.aspectOf();
        ProceedingJoinPoint proceedingJoinPoint = (ProceedingJoinPoint)joinPoint;
        Annotation annotation = ajc$anno$3;
        if (annotation == null) {
            annotation = ajc$anno$3 = JobMetaService.class.getDeclaredMethod("deleteJob", NameIdentifier.class).getAnnotation(Monitored.class);
        }
        return Conversions.booleanValue((Object)JobMetaService.deleteJob_aroundBody7$advice(this, nameIdentifier, joinPoint, methodMonitorAspect, proceedingJoinPoint, (Monitored)annotation));
    }

    @Monitored(metricsSource="gravitino-relational-store", baseMetricName="deleteJobsByLegacyTimeline")
    public int deleteJobsByLegacyTimeline(long legacyTimeline, int limit) {
        long l = legacyTimeline;
        int n = limit;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_4, (Object)this, (Object)this, (Object)Conversions.longObject((long)l), (Object)Conversions.intObject((int)n));
        MethodMonitorAspect methodMonitorAspect = MethodMonitorAspect.aspectOf();
        ProceedingJoinPoint proceedingJoinPoint = (ProceedingJoinPoint)joinPoint;
        Annotation annotation = ajc$anno$4;
        if (annotation == null) {
            annotation = ajc$anno$4 = JobMetaService.class.getDeclaredMethod("deleteJobsByLegacyTimeline", Long.TYPE, Integer.TYPE).getAnnotation(Monitored.class);
        }
        return Conversions.intValue((Object)JobMetaService.deleteJobsByLegacyTimeline_aroundBody9$advice(this, l, n, joinPoint, methodMonitorAspect, proceedingJoinPoint, (Monitored)annotation));
    }

    private long parseJobRunId(String jobRunId) {
        if (jobRunId == null || !jobRunId.startsWith("job-") || jobRunId.length() <= "job-".length()) {
            throw new NoSuchEntityException("Invalid job run ID format %s", new Object[]{jobRunId});
        }
        try {
            return Long.parseLong(jobRunId.substring("job-".length()));
        }
        catch (NumberFormatException e) {
            throw new NoSuchEntityException("Invalid job run ID format %s", new Object[]{jobRunId});
        }
    }

    private static /* synthetic */ JobPO lambda$getJobByIdentifier$4(String metalakeName, long jobRunIdLong, JobMetaMapper mapper) {
        return mapper.selectJobPOByMetalakeAndRunId(metalakeName, jobRunIdLong);
    }

    static {
        JobMetaService.ajc$preClinit();
        INSTANCE = new JobMetaService();
    }

    private static final /* synthetic */ List listJobsByNamespace_aroundBody0(JobMetaService ajc$this, Namespace ns, JoinPoint joinPoint) {
        String metalakeName = ns.level(0);
        if (ns.length() == 3) {
            List jobPOs = SessionUtils.getWithoutCommit(JobMetaMapper.class, mapper -> mapper.listJobPOsByMetalake(metalakeName));
            return jobPOs.stream().map(po -> JobPO.fromJobPO(po, ns)).collect(Collectors.toList());
        }
        if (ns.length() == 4) {
            NameIdentifier jobTemplateIdent = NameIdentifier.of((String[])ns.levels());
            String jobTemplateName = jobTemplateIdent.name();
            List jobPOs = SessionUtils.getWithoutCommit(JobMetaMapper.class, mapper -> mapper.listJobPOsByMetalakeAndTemplate(metalakeName, jobTemplateName));
            return jobPOs.stream().map(po -> JobPO.fromJobPO(po, NamespaceUtil.ofJob(metalakeName))).collect(Collectors.toList());
        }
        throw new IllegalNamespaceException("Invalid namespace for listing jobs: %s", new Object[]{ns});
    }

    private static final /* synthetic */ Object listJobsByNamespace_aroundBody1$advice(JobMetaService ajc$this, Namespace ns, JoinPoint thisJoinPoint, MethodMonitorAspect ajc$aspectInstance, ProceedingJoinPoint pjp, Monitored monitored) {
        List list;
        block10: {
            if (MethodMonitorAspect.ajc$inlineAccessFieldGet$org_apache_gravitino_metrics_MethodMonitorAspect$org_apache_gravitino_metrics_MethodMonitorAspect$metricsSystem(ajc$aspectInstance) == null) {
                ProceedingJoinPoint proceedingJoinPoint = pjp;
                return JobMetaService.listJobsByNamespace_aroundBody0(ajc$this, ns, (JoinPoint)proceedingJoinPoint);
            }
            MetricsSource metricsSource = MethodMonitorAspect.ajc$inlineAccessFieldGet$org_apache_gravitino_metrics_MethodMonitorAspect$org_apache_gravitino_metrics_MethodMonitorAspect$metricsSystem(ajc$aspectInstance).getMetricsSource(monitored.metricsSource());
            if (metricsSource == null) {
                MethodMonitorAspect.ajc$inlineAccessFieldGet$org_apache_gravitino_metrics_MethodMonitorAspect$org_apache_gravitino_metrics_MethodMonitorAspect$LOG().warn("MetricsSource {} is not registered in MetricsSystem, skip monitoring for method {}", (Object)monitored.metricsSource(), (Object)pjp.getSignature().toShortString());
                ProceedingJoinPoint proceedingJoinPoint = pjp;
                return JobMetaService.listJobsByNamespace_aroundBody0(ajc$this, ns, (JoinPoint)proceedingJoinPoint);
            }
            String baseMetricName = monitored.baseMetricName();
            Timer timer = metricsSource.getTimer(MetricRegistry.name((String)baseMetricName, (String[])new String[]{"total"}));
            Meter successMeter = metricsSource.getMeter(MetricRegistry.name((String)baseMetricName, (String[])new String[]{"success"}));
            Meter failureMeter = metricsSource.getMeter(MetricRegistry.name((String)baseMetricName, (String[])new String[]{"failure"}));
            Timer.Context ignore = timer.time();
            try {
                ProceedingJoinPoint proceedingJoinPoint = pjp;
                List result = JobMetaService.listJobsByNamespace_aroundBody0(ajc$this, ns, (JoinPoint)proceedingJoinPoint);
                successMeter.mark();
                list = result;
                if (ignore == null) break block10;
            }
            catch (Throwable throwable) {
                try {
                    if (ignore != null) {
                        try {
                            ignore.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (Throwable t) {
                    failureMeter.mark();
                    throw t;
                }
            }
            ignore.close();
        }
        return list;
    }

    private static final /* synthetic */ JobEntity getJobByIdentifier_aroundBody2(JobMetaService ajc$this, NameIdentifier ident, JoinPoint joinPoint) {
        long jobRunIdLong;
        String metalakeName = ident.namespace().level(0);
        JobPO jobPO = SessionUtils.getWithoutCommit(JobMetaMapper.class, arg_0 -> JobMetaService.lambda$getJobByIdentifier$4(metalakeName, jobRunIdLong = ajc$this.parseJobRunId(ident.name()), arg_0));
        if (jobPO == null) {
            throw new NoSuchEntityException("No such %s entity: %s", new Object[]{Entity.EntityType.JOB.name().toLowerCase(Locale.ROOT), ident.toString()});
        }
        return JobPO.fromJobPO(jobPO, ident.namespace());
    }

    private static final /* synthetic */ Object getJobByIdentifier_aroundBody3$advice(JobMetaService ajc$this, NameIdentifier ident, JoinPoint thisJoinPoint, MethodMonitorAspect ajc$aspectInstance, ProceedingJoinPoint pjp, Monitored monitored) {
        JobEntity jobEntity;
        block10: {
            if (MethodMonitorAspect.ajc$inlineAccessFieldGet$org_apache_gravitino_metrics_MethodMonitorAspect$org_apache_gravitino_metrics_MethodMonitorAspect$metricsSystem(ajc$aspectInstance) == null) {
                ProceedingJoinPoint proceedingJoinPoint = pjp;
                return JobMetaService.getJobByIdentifier_aroundBody2(ajc$this, ident, (JoinPoint)proceedingJoinPoint);
            }
            MetricsSource metricsSource = MethodMonitorAspect.ajc$inlineAccessFieldGet$org_apache_gravitino_metrics_MethodMonitorAspect$org_apache_gravitino_metrics_MethodMonitorAspect$metricsSystem(ajc$aspectInstance).getMetricsSource(monitored.metricsSource());
            if (metricsSource == null) {
                MethodMonitorAspect.ajc$inlineAccessFieldGet$org_apache_gravitino_metrics_MethodMonitorAspect$org_apache_gravitino_metrics_MethodMonitorAspect$LOG().warn("MetricsSource {} is not registered in MetricsSystem, skip monitoring for method {}", (Object)monitored.metricsSource(), (Object)pjp.getSignature().toShortString());
                ProceedingJoinPoint proceedingJoinPoint = pjp;
                return JobMetaService.getJobByIdentifier_aroundBody2(ajc$this, ident, (JoinPoint)proceedingJoinPoint);
            }
            String baseMetricName = monitored.baseMetricName();
            Timer timer = metricsSource.getTimer(MetricRegistry.name((String)baseMetricName, (String[])new String[]{"total"}));
            Meter successMeter = metricsSource.getMeter(MetricRegistry.name((String)baseMetricName, (String[])new String[]{"success"}));
            Meter failureMeter = metricsSource.getMeter(MetricRegistry.name((String)baseMetricName, (String[])new String[]{"failure"}));
            Timer.Context ignore = timer.time();
            try {
                ProceedingJoinPoint proceedingJoinPoint = pjp;
                JobEntity result = JobMetaService.getJobByIdentifier_aroundBody2(ajc$this, ident, (JoinPoint)proceedingJoinPoint);
                successMeter.mark();
                jobEntity = result;
                if (ignore == null) break block10;
            }
            catch (Throwable throwable) {
                try {
                    if (ignore != null) {
                        try {
                            ignore.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (Throwable t) {
                    failureMeter.mark();
                    throw t;
                }
            }
            ignore.close();
        }
        return jobEntity;
    }

    private static final /* synthetic */ void insertJob_aroundBody4(JobMetaService ajc$this, JobEntity jobEntity, boolean overwrite, JoinPoint joinPoint) {
        String metalakeName = jobEntity.namespace().level(0);
        try {
            long metalakeId = EntityIdService.getEntityId(NameIdentifier.of((String[])new String[]{metalakeName}), Entity.EntityType.METALAKE);
            JobPO.JobPOBuilder builder = JobPO.builder().withMetalakeId(metalakeId);
            JobPO jobPO = JobPO.initializeJobPO(jobEntity, builder);
            SessionUtils.doWithCommit(JobMetaMapper.class, mapper -> {
                if (overwrite) {
                    mapper.insertJobMetaOnDuplicateKeyUpdate(jobPO);
                } else {
                    mapper.insertJobMeta(jobPO);
                }
            });
        }
        catch (RuntimeException e) {
            ExceptionUtils.checkSQLException(e, Entity.EntityType.JOB, jobEntity.id().toString());
        }
    }

    private static final /* synthetic */ Object insertJob_aroundBody5$advice(JobMetaService ajc$this, JobEntity jobEntity, boolean overwrite, JoinPoint thisJoinPoint, MethodMonitorAspect ajc$aspectInstance, ProceedingJoinPoint pjp, Monitored monitored) {
        Object var14_19;
        block10: {
            if (MethodMonitorAspect.ajc$inlineAccessFieldGet$org_apache_gravitino_metrics_MethodMonitorAspect$org_apache_gravitino_metrics_MethodMonitorAspect$metricsSystem(ajc$aspectInstance) == null) {
                ProceedingJoinPoint proceedingJoinPoint = pjp;
                JobMetaService.insertJob_aroundBody4(ajc$this, jobEntity, overwrite, (JoinPoint)proceedingJoinPoint);
                return null;
            }
            MetricsSource metricsSource = MethodMonitorAspect.ajc$inlineAccessFieldGet$org_apache_gravitino_metrics_MethodMonitorAspect$org_apache_gravitino_metrics_MethodMonitorAspect$metricsSystem(ajc$aspectInstance).getMetricsSource(monitored.metricsSource());
            if (metricsSource == null) {
                MethodMonitorAspect.ajc$inlineAccessFieldGet$org_apache_gravitino_metrics_MethodMonitorAspect$org_apache_gravitino_metrics_MethodMonitorAspect$LOG().warn("MetricsSource {} is not registered in MetricsSystem, skip monitoring for method {}", (Object)monitored.metricsSource(), (Object)pjp.getSignature().toShortString());
                ProceedingJoinPoint proceedingJoinPoint = pjp;
                JobMetaService.insertJob_aroundBody4(ajc$this, jobEntity, overwrite, (JoinPoint)proceedingJoinPoint);
                return null;
            }
            String baseMetricName = monitored.baseMetricName();
            Timer timer = metricsSource.getTimer(MetricRegistry.name((String)baseMetricName, (String[])new String[]{"total"}));
            Meter successMeter = metricsSource.getMeter(MetricRegistry.name((String)baseMetricName, (String[])new String[]{"success"}));
            Meter failureMeter = metricsSource.getMeter(MetricRegistry.name((String)baseMetricName, (String[])new String[]{"failure"}));
            Timer.Context ignore = timer.time();
            try {
                ProceedingJoinPoint proceedingJoinPoint = pjp;
                JobMetaService.insertJob_aroundBody4(ajc$this, jobEntity, overwrite, (JoinPoint)proceedingJoinPoint);
                Object result = null;
                successMeter.mark();
                var14_19 = result;
                if (ignore == null) break block10;
            }
            catch (Throwable throwable) {
                try {
                    if (ignore != null) {
                        try {
                            ignore.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (Throwable t) {
                    failureMeter.mark();
                    throw t;
                }
            }
            ignore.close();
        }
        return var14_19;
    }

    private static final /* synthetic */ boolean deleteJob_aroundBody6(JobMetaService ajc$this, NameIdentifier jobIdent, JoinPoint joinPoint) {
        long jobRunIdLong = ajc$this.parseJobRunId(jobIdent.name());
        int result = SessionUtils.doWithCommitAndFetchResult(JobMetaMapper.class, mapper -> mapper.softDeleteJobMetaByRunId(jobRunIdLong));
        return result > 0;
    }

    private static final /* synthetic */ Object deleteJob_aroundBody7$advice(JobMetaService ajc$this, NameIdentifier jobIdent, JoinPoint thisJoinPoint, MethodMonitorAspect ajc$aspectInstance, ProceedingJoinPoint pjp, Monitored monitored) {
        Object object;
        block10: {
            if (MethodMonitorAspect.ajc$inlineAccessFieldGet$org_apache_gravitino_metrics_MethodMonitorAspect$org_apache_gravitino_metrics_MethodMonitorAspect$metricsSystem(ajc$aspectInstance) == null) {
                ProceedingJoinPoint proceedingJoinPoint = pjp;
                return Conversions.booleanObject((boolean)JobMetaService.deleteJob_aroundBody6(ajc$this, jobIdent, (JoinPoint)proceedingJoinPoint));
            }
            MetricsSource metricsSource = MethodMonitorAspect.ajc$inlineAccessFieldGet$org_apache_gravitino_metrics_MethodMonitorAspect$org_apache_gravitino_metrics_MethodMonitorAspect$metricsSystem(ajc$aspectInstance).getMetricsSource(monitored.metricsSource());
            if (metricsSource == null) {
                MethodMonitorAspect.ajc$inlineAccessFieldGet$org_apache_gravitino_metrics_MethodMonitorAspect$org_apache_gravitino_metrics_MethodMonitorAspect$LOG().warn("MetricsSource {} is not registered in MetricsSystem, skip monitoring for method {}", (Object)monitored.metricsSource(), (Object)pjp.getSignature().toShortString());
                ProceedingJoinPoint proceedingJoinPoint = pjp;
                return Conversions.booleanObject((boolean)JobMetaService.deleteJob_aroundBody6(ajc$this, jobIdent, (JoinPoint)proceedingJoinPoint));
            }
            String baseMetricName = monitored.baseMetricName();
            Timer timer = metricsSource.getTimer(MetricRegistry.name((String)baseMetricName, (String[])new String[]{"total"}));
            Meter successMeter = metricsSource.getMeter(MetricRegistry.name((String)baseMetricName, (String[])new String[]{"success"}));
            Meter failureMeter = metricsSource.getMeter(MetricRegistry.name((String)baseMetricName, (String[])new String[]{"failure"}));
            Timer.Context ignore = timer.time();
            try {
                ProceedingJoinPoint proceedingJoinPoint = pjp;
                Object result = Conversions.booleanObject((boolean)JobMetaService.deleteJob_aroundBody6(ajc$this, jobIdent, (JoinPoint)proceedingJoinPoint));
                successMeter.mark();
                object = result;
                if (ignore == null) break block10;
            }
            catch (Throwable throwable) {
                try {
                    if (ignore != null) {
                        try {
                            ignore.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (Throwable t) {
                    failureMeter.mark();
                    throw t;
                }
            }
            ignore.close();
        }
        return object;
    }

    private static final /* synthetic */ int deleteJobsByLegacyTimeline_aroundBody8(JobMetaService ajc$this, long legacyTimeline, int limit, JoinPoint joinPoint) {
        SessionUtils.doWithCommit(JobMetaMapper.class, mapper -> mapper.softDeleteJobMetasByLegacyTimeline(legacyTimeline));
        return SessionUtils.doWithCommitAndFetchResult(JobMetaMapper.class, mapper -> mapper.deleteJobMetasByLegacyTimeline(legacyTimeline, limit));
    }

    private static final /* synthetic */ Object deleteJobsByLegacyTimeline_aroundBody9$advice(JobMetaService ajc$this, long legacyTimeline, int limit, JoinPoint thisJoinPoint, MethodMonitorAspect ajc$aspectInstance, ProceedingJoinPoint pjp, Monitored monitored) {
        Object object;
        block10: {
            if (MethodMonitorAspect.ajc$inlineAccessFieldGet$org_apache_gravitino_metrics_MethodMonitorAspect$org_apache_gravitino_metrics_MethodMonitorAspect$metricsSystem(ajc$aspectInstance) == null) {
                ProceedingJoinPoint proceedingJoinPoint = pjp;
                return Conversions.intObject((int)JobMetaService.deleteJobsByLegacyTimeline_aroundBody8(ajc$this, legacyTimeline, limit, (JoinPoint)proceedingJoinPoint));
            }
            MetricsSource metricsSource = MethodMonitorAspect.ajc$inlineAccessFieldGet$org_apache_gravitino_metrics_MethodMonitorAspect$org_apache_gravitino_metrics_MethodMonitorAspect$metricsSystem(ajc$aspectInstance).getMetricsSource(monitored.metricsSource());
            if (metricsSource == null) {
                MethodMonitorAspect.ajc$inlineAccessFieldGet$org_apache_gravitino_metrics_MethodMonitorAspect$org_apache_gravitino_metrics_MethodMonitorAspect$LOG().warn("MetricsSource {} is not registered in MetricsSystem, skip monitoring for method {}", (Object)monitored.metricsSource(), (Object)pjp.getSignature().toShortString());
                ProceedingJoinPoint proceedingJoinPoint = pjp;
                return Conversions.intObject((int)JobMetaService.deleteJobsByLegacyTimeline_aroundBody8(ajc$this, legacyTimeline, limit, (JoinPoint)proceedingJoinPoint));
            }
            String baseMetricName = monitored.baseMetricName();
            Timer timer = metricsSource.getTimer(MetricRegistry.name((String)baseMetricName, (String[])new String[]{"total"}));
            Meter successMeter = metricsSource.getMeter(MetricRegistry.name((String)baseMetricName, (String[])new String[]{"success"}));
            Meter failureMeter = metricsSource.getMeter(MetricRegistry.name((String)baseMetricName, (String[])new String[]{"failure"}));
            Timer.Context ignore = timer.time();
            try {
                ProceedingJoinPoint proceedingJoinPoint = pjp;
                Object result = Conversions.intObject((int)JobMetaService.deleteJobsByLegacyTimeline_aroundBody8(ajc$this, legacyTimeline, limit, (JoinPoint)proceedingJoinPoint));
                successMeter.mark();
                object = result;
                if (ignore == null) break block10;
            }
            catch (Throwable throwable) {
                try {
                    if (ignore != null) {
                        try {
                            ignore.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (Throwable t) {
                    failureMeter.mark();
                    throw t;
                }
            }
            ignore.close();
        }
        return object;
    }

    private static /* synthetic */ void ajc$preClinit() {
        Factory factory = new Factory("JobMetaService.java", JobMetaService.class);
        ajc$tjp_0 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "listJobsByNamespace", "org.apache.gravitino.storage.relational.service.JobMetaService", "org.apache.gravitino.Namespace", "ns", "", "java.util.List"), 57);
        ajc$tjp_1 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "getJobByIdentifier", "org.apache.gravitino.storage.relational.service.JobMetaService", "org.apache.gravitino.NameIdentifier", "ident", "", "org.apache.gravitino.meta.JobEntity"), 87);
        ajc$tjp_2 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "insertJob", "org.apache.gravitino.storage.relational.service.JobMetaService", "org.apache.gravitino.meta.JobEntity:boolean", "jobEntity:overwrite", "java.io.IOException", "void"), 105);
        ajc$tjp_3 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "deleteJob", "org.apache.gravitino.storage.relational.service.JobMetaService", "org.apache.gravitino.NameIdentifier", "jobIdent", "", "boolean"), 130);
        ajc$tjp_4 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "deleteJobsByLegacyTimeline", "org.apache.gravitino.storage.relational.service.JobMetaService", "long:int", "legacyTimeline:limit", "", "int"), 142);
    }
}

