/*
 * Decompiled with CFR 0.152.
 */
package org.apache.gravitino.storage.relational.service;

import com.codahale.metrics.Meter;
import com.codahale.metrics.MetricRegistry;
import com.codahale.metrics.Timer;
import com.google.common.base.Preconditions;
import java.io.IOException;
import java.lang.annotation.Annotation;
import java.util.List;
import java.util.Locale;
import java.util.Objects;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.apache.gravitino.Entity;
import org.apache.gravitino.HasIdentifier;
import org.apache.gravitino.NameIdentifier;
import org.apache.gravitino.Namespace;
import org.apache.gravitino.exceptions.NoSuchEntityException;
import org.apache.gravitino.meta.JobTemplateEntity;
import org.apache.gravitino.metrics.MethodMonitorAspect;
import org.apache.gravitino.metrics.Monitored;
import org.apache.gravitino.metrics.source.MetricsSource;
import org.apache.gravitino.storage.relational.mapper.JobMetaMapper;
import org.apache.gravitino.storage.relational.mapper.JobTemplateMetaMapper;
import org.apache.gravitino.storage.relational.po.JobTemplatePO;
import org.apache.gravitino.storage.relational.service.EntityIdService;
import org.apache.gravitino.storage.relational.utils.ExceptionUtils;
import org.apache.gravitino.storage.relational.utils.SessionUtils;
import org.aspectj.lang.JoinPoint;
import org.aspectj.lang.ProceedingJoinPoint;
import org.aspectj.lang.Signature;
import org.aspectj.runtime.internal.Conversions;
import org.aspectj.runtime.reflect.Factory;

public class JobTemplateMetaService {
    private static final JobTemplateMetaService INSTANCE;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_0;
    private static /* synthetic */ Annotation ajc$anno$0;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_1;
    private static /* synthetic */ Annotation ajc$anno$1;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_2;
    private static /* synthetic */ Annotation ajc$anno$2;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_3;
    private static /* synthetic */ Annotation ajc$anno$3;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_4;
    private static /* synthetic */ Annotation ajc$anno$4;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_5;
    private static /* synthetic */ Annotation ajc$anno$5;

    private JobTemplateMetaService() {
    }

    public static JobTemplateMetaService getInstance() {
        return INSTANCE;
    }

    @Monitored(metricsSource="gravitino-relational-store", baseMetricName="listJobTemplatesByNamespace")
    public List<JobTemplateEntity> listJobTemplatesByNamespace(Namespace ns) {
        Namespace namespace = ns;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_0, (Object)this, (Object)this, (Object)namespace);
        MethodMonitorAspect methodMonitorAspect = MethodMonitorAspect.aspectOf();
        ProceedingJoinPoint proceedingJoinPoint = (ProceedingJoinPoint)joinPoint;
        Annotation annotation = ajc$anno$0;
        if (annotation == null) {
            annotation = ajc$anno$0 = JobTemplateMetaService.class.getDeclaredMethod("listJobTemplatesByNamespace", Namespace.class).getAnnotation(Monitored.class);
        }
        return (List)JobTemplateMetaService.listJobTemplatesByNamespace_aroundBody1$advice(this, namespace, joinPoint, methodMonitorAspect, proceedingJoinPoint, (Monitored)annotation);
    }

    @Monitored(metricsSource="gravitino-relational-store", baseMetricName="getJobTemplateByIdentifier")
    public JobTemplateEntity getJobTemplateByIdentifier(NameIdentifier jobTemplateIdent) {
        NameIdentifier nameIdentifier = jobTemplateIdent;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_1, (Object)this, (Object)this, (Object)nameIdentifier);
        MethodMonitorAspect methodMonitorAspect = MethodMonitorAspect.aspectOf();
        ProceedingJoinPoint proceedingJoinPoint = (ProceedingJoinPoint)joinPoint;
        Annotation annotation = ajc$anno$1;
        if (annotation == null) {
            annotation = ajc$anno$1 = JobTemplateMetaService.class.getDeclaredMethod("getJobTemplateByIdentifier", NameIdentifier.class).getAnnotation(Monitored.class);
        }
        return (JobTemplateEntity)JobTemplateMetaService.getJobTemplateByIdentifier_aroundBody3$advice(this, nameIdentifier, joinPoint, methodMonitorAspect, proceedingJoinPoint, (Monitored)annotation);
    }

    @Monitored(metricsSource="gravitino-relational-store", baseMetricName="insertJobTemplate")
    public void insertJobTemplate(JobTemplateEntity jobTemplateEntity, boolean overwrite) throws IOException {
        JobTemplateEntity jobTemplateEntity2 = jobTemplateEntity;
        boolean bl = overwrite;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_2, (Object)this, (Object)this, (Object)jobTemplateEntity2, (Object)Conversions.booleanObject((boolean)bl));
        MethodMonitorAspect methodMonitorAspect = MethodMonitorAspect.aspectOf();
        ProceedingJoinPoint proceedingJoinPoint = (ProceedingJoinPoint)joinPoint;
        Annotation annotation = ajc$anno$2;
        if (annotation == null) {
            annotation = ajc$anno$2 = JobTemplateMetaService.class.getDeclaredMethod("insertJobTemplate", JobTemplateEntity.class, Boolean.TYPE).getAnnotation(Monitored.class);
        }
        JobTemplateMetaService.insertJobTemplate_aroundBody5$advice(this, jobTemplateEntity2, bl, joinPoint, methodMonitorAspect, proceedingJoinPoint, (Monitored)annotation);
    }

    @Monitored(metricsSource="gravitino-relational-store", baseMetricName="deleteJobTemplate")
    public boolean deleteJobTemplate(NameIdentifier jobTemplateIdent) {
        NameIdentifier nameIdentifier = jobTemplateIdent;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_3, (Object)this, (Object)this, (Object)nameIdentifier);
        MethodMonitorAspect methodMonitorAspect = MethodMonitorAspect.aspectOf();
        ProceedingJoinPoint proceedingJoinPoint = (ProceedingJoinPoint)joinPoint;
        Annotation annotation = ajc$anno$3;
        if (annotation == null) {
            annotation = ajc$anno$3 = JobTemplateMetaService.class.getDeclaredMethod("deleteJobTemplate", NameIdentifier.class).getAnnotation(Monitored.class);
        }
        return Conversions.booleanValue((Object)JobTemplateMetaService.deleteJobTemplate_aroundBody7$advice(this, nameIdentifier, joinPoint, methodMonitorAspect, proceedingJoinPoint, (Monitored)annotation));
    }

    @Monitored(metricsSource="gravitino-relational-store", baseMetricName="deleteJobTemplatesByLegacyTimeline")
    public int deleteJobTemplatesByLegacyTimeline(long legacyTimeline, int limit) {
        long l = legacyTimeline;
        int n = limit;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_4, (Object)this, (Object)this, (Object)Conversions.longObject((long)l), (Object)Conversions.intObject((int)n));
        MethodMonitorAspect methodMonitorAspect = MethodMonitorAspect.aspectOf();
        ProceedingJoinPoint proceedingJoinPoint = (ProceedingJoinPoint)joinPoint;
        Annotation annotation = ajc$anno$4;
        if (annotation == null) {
            annotation = ajc$anno$4 = JobTemplateMetaService.class.getDeclaredMethod("deleteJobTemplatesByLegacyTimeline", Long.TYPE, Integer.TYPE).getAnnotation(Monitored.class);
        }
        return Conversions.intValue((Object)JobTemplateMetaService.deleteJobTemplatesByLegacyTimeline_aroundBody9$advice(this, l, n, joinPoint, methodMonitorAspect, proceedingJoinPoint, (Monitored)annotation));
    }

    @Monitored(metricsSource="gravitino-relational-store", baseMetricName="updateJobTemplate")
    public <E extends Entity & HasIdentifier> JobTemplateEntity updateJobTemplate(NameIdentifier jobTemplateIdent, Function<E, E> updater) throws IOException {
        NameIdentifier nameIdentifier = jobTemplateIdent;
        Function<E, E> function = updater;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_5, (Object)this, (Object)this, (Object)nameIdentifier, function);
        MethodMonitorAspect methodMonitorAspect = MethodMonitorAspect.aspectOf();
        ProceedingJoinPoint proceedingJoinPoint = (ProceedingJoinPoint)joinPoint;
        Annotation annotation = ajc$anno$5;
        if (annotation == null) {
            annotation = ajc$anno$5 = JobTemplateMetaService.class.getDeclaredMethod("updateJobTemplate", NameIdentifier.class, Function.class).getAnnotation(Monitored.class);
        }
        return (JobTemplateEntity)JobTemplateMetaService.updateJobTemplate_aroundBody11$advice(this, nameIdentifier, function, joinPoint, methodMonitorAspect, proceedingJoinPoint, (Monitored)annotation);
    }

    private JobTemplatePO getJobTemplatePO(NameIdentifier jobTemplateIdent) {
        String jobTemplateName;
        String metalakeName = jobTemplateIdent.namespace().level(0);
        JobTemplatePO jobTemplatePO = SessionUtils.getWithoutCommit(JobTemplateMetaMapper.class, arg_0 -> JobTemplateMetaService.lambda$getJobTemplatePO$9(metalakeName, jobTemplateName = jobTemplateIdent.name(), arg_0));
        if (jobTemplatePO == null) {
            throw new NoSuchEntityException("No such %s entity: %s", new Object[]{Entity.EntityType.JOB_TEMPLATE.name().toLowerCase(Locale.ROOT), jobTemplateName});
        }
        return jobTemplatePO;
    }

    public long getJobTemplateIdByMetalakeIdAndName(long metalakeId, String name) {
        Long jobTemplateId = SessionUtils.getWithoutCommit(JobTemplateMetaMapper.class, mapper -> mapper.selectJobTemplateIdByMetalakeAndName(metalakeId, name));
        if (jobTemplateId == null) {
            throw new NoSuchEntityException("No such %s entity: %s", new Object[]{Entity.EntityType.JOB_TEMPLATE.name().toLowerCase(Locale.ROOT), name});
        }
        return jobTemplateId;
    }

    private static /* synthetic */ JobTemplatePO lambda$getJobTemplatePO$9(String metalakeName, String jobTemplateName, JobTemplateMetaMapper mapper) {
        return mapper.selectJobTemplatePOByMetalakeAndName(metalakeName, jobTemplateName);
    }

    static {
        JobTemplateMetaService.ajc$preClinit();
        INSTANCE = new JobTemplateMetaService();
    }

    private static final /* synthetic */ List listJobTemplatesByNamespace_aroundBody0(JobTemplateMetaService ajc$this, Namespace ns, JoinPoint joinPoint) {
        String metalakeName = ns.level(0);
        List jobTemplatePOs = SessionUtils.getWithoutCommit(JobTemplateMetaMapper.class, mapper -> mapper.listJobTemplatePOsByMetalake(metalakeName));
        return jobTemplatePOs.stream().map(p -> JobTemplatePO.fromJobTemplatePO(p, ns)).collect(Collectors.toList());
    }

    private static final /* synthetic */ Object listJobTemplatesByNamespace_aroundBody1$advice(JobTemplateMetaService ajc$this, Namespace ns, JoinPoint thisJoinPoint, MethodMonitorAspect ajc$aspectInstance, ProceedingJoinPoint pjp, Monitored monitored) {
        List list;
        block10: {
            if (MethodMonitorAspect.ajc$inlineAccessFieldGet$org_apache_gravitino_metrics_MethodMonitorAspect$org_apache_gravitino_metrics_MethodMonitorAspect$metricsSystem(ajc$aspectInstance) == null) {
                ProceedingJoinPoint proceedingJoinPoint = pjp;
                return JobTemplateMetaService.listJobTemplatesByNamespace_aroundBody0(ajc$this, ns, (JoinPoint)proceedingJoinPoint);
            }
            MetricsSource metricsSource = MethodMonitorAspect.ajc$inlineAccessFieldGet$org_apache_gravitino_metrics_MethodMonitorAspect$org_apache_gravitino_metrics_MethodMonitorAspect$metricsSystem(ajc$aspectInstance).getMetricsSource(monitored.metricsSource());
            if (metricsSource == null) {
                MethodMonitorAspect.ajc$inlineAccessFieldGet$org_apache_gravitino_metrics_MethodMonitorAspect$org_apache_gravitino_metrics_MethodMonitorAspect$LOG().warn("MetricsSource {} is not registered in MetricsSystem, skip monitoring for method {}", (Object)monitored.metricsSource(), (Object)pjp.getSignature().toShortString());
                ProceedingJoinPoint proceedingJoinPoint = pjp;
                return JobTemplateMetaService.listJobTemplatesByNamespace_aroundBody0(ajc$this, ns, (JoinPoint)proceedingJoinPoint);
            }
            String baseMetricName = monitored.baseMetricName();
            Timer timer = metricsSource.getTimer(MetricRegistry.name((String)baseMetricName, (String[])new String[]{"total"}));
            Meter successMeter = metricsSource.getMeter(MetricRegistry.name((String)baseMetricName, (String[])new String[]{"success"}));
            Meter failureMeter = metricsSource.getMeter(MetricRegistry.name((String)baseMetricName, (String[])new String[]{"failure"}));
            Timer.Context ignore = timer.time();
            try {
                ProceedingJoinPoint proceedingJoinPoint = pjp;
                List result = JobTemplateMetaService.listJobTemplatesByNamespace_aroundBody0(ajc$this, ns, (JoinPoint)proceedingJoinPoint);
                successMeter.mark();
                list = result;
                if (ignore == null) break block10;
            }
            catch (Throwable throwable) {
                try {
                    if (ignore != null) {
                        try {
                            ignore.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (Throwable t) {
                    failureMeter.mark();
                    throw t;
                }
            }
            ignore.close();
        }
        return list;
    }

    private static final /* synthetic */ JobTemplateEntity getJobTemplateByIdentifier_aroundBody2(JobTemplateMetaService ajc$this, NameIdentifier jobTemplateIdent, JoinPoint joinPoint) {
        JobTemplatePO jobTemplatePO = ajc$this.getJobTemplatePO(jobTemplateIdent);
        return JobTemplatePO.fromJobTemplatePO(jobTemplatePO, jobTemplateIdent.namespace());
    }

    private static final /* synthetic */ Object getJobTemplateByIdentifier_aroundBody3$advice(JobTemplateMetaService ajc$this, NameIdentifier jobTemplateIdent, JoinPoint thisJoinPoint, MethodMonitorAspect ajc$aspectInstance, ProceedingJoinPoint pjp, Monitored monitored) {
        JobTemplateEntity jobTemplateEntity;
        block10: {
            if (MethodMonitorAspect.ajc$inlineAccessFieldGet$org_apache_gravitino_metrics_MethodMonitorAspect$org_apache_gravitino_metrics_MethodMonitorAspect$metricsSystem(ajc$aspectInstance) == null) {
                ProceedingJoinPoint proceedingJoinPoint = pjp;
                return JobTemplateMetaService.getJobTemplateByIdentifier_aroundBody2(ajc$this, jobTemplateIdent, (JoinPoint)proceedingJoinPoint);
            }
            MetricsSource metricsSource = MethodMonitorAspect.ajc$inlineAccessFieldGet$org_apache_gravitino_metrics_MethodMonitorAspect$org_apache_gravitino_metrics_MethodMonitorAspect$metricsSystem(ajc$aspectInstance).getMetricsSource(monitored.metricsSource());
            if (metricsSource == null) {
                MethodMonitorAspect.ajc$inlineAccessFieldGet$org_apache_gravitino_metrics_MethodMonitorAspect$org_apache_gravitino_metrics_MethodMonitorAspect$LOG().warn("MetricsSource {} is not registered in MetricsSystem, skip monitoring for method {}", (Object)monitored.metricsSource(), (Object)pjp.getSignature().toShortString());
                ProceedingJoinPoint proceedingJoinPoint = pjp;
                return JobTemplateMetaService.getJobTemplateByIdentifier_aroundBody2(ajc$this, jobTemplateIdent, (JoinPoint)proceedingJoinPoint);
            }
            String baseMetricName = monitored.baseMetricName();
            Timer timer = metricsSource.getTimer(MetricRegistry.name((String)baseMetricName, (String[])new String[]{"total"}));
            Meter successMeter = metricsSource.getMeter(MetricRegistry.name((String)baseMetricName, (String[])new String[]{"success"}));
            Meter failureMeter = metricsSource.getMeter(MetricRegistry.name((String)baseMetricName, (String[])new String[]{"failure"}));
            Timer.Context ignore = timer.time();
            try {
                ProceedingJoinPoint proceedingJoinPoint = pjp;
                JobTemplateEntity result = JobTemplateMetaService.getJobTemplateByIdentifier_aroundBody2(ajc$this, jobTemplateIdent, (JoinPoint)proceedingJoinPoint);
                successMeter.mark();
                jobTemplateEntity = result;
                if (ignore == null) break block10;
            }
            catch (Throwable throwable) {
                try {
                    if (ignore != null) {
                        try {
                            ignore.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (Throwable t) {
                    failureMeter.mark();
                    throw t;
                }
            }
            ignore.close();
        }
        return jobTemplateEntity;
    }

    private static final /* synthetic */ void insertJobTemplate_aroundBody4(JobTemplateMetaService ajc$this, JobTemplateEntity jobTemplateEntity, boolean overwrite, JoinPoint joinPoint) {
        String metalakeName = jobTemplateEntity.namespace().level(0);
        try {
            Long metalakeId = EntityIdService.getEntityId(NameIdentifier.of((String[])new String[]{metalakeName}), Entity.EntityType.METALAKE);
            JobTemplatePO.JobTemplatePOBuilder builder = JobTemplatePO.builder().withMetalakeId(metalakeId);
            JobTemplatePO jobTemplatePO = JobTemplatePO.initializeJobTemplatePO(jobTemplateEntity, builder);
            SessionUtils.doWithCommit(JobTemplateMetaMapper.class, mapper -> {
                if (overwrite) {
                    mapper.insertJobTemplateMetaOnDuplicateKeyUpdate(jobTemplatePO);
                } else {
                    mapper.insertJobTemplateMeta(jobTemplatePO);
                }
            });
        }
        catch (RuntimeException e) {
            ExceptionUtils.checkSQLException(e, Entity.EntityType.JOB_TEMPLATE, jobTemplateEntity.name());
            throw e;
        }
    }

    private static final /* synthetic */ Object insertJobTemplate_aroundBody5$advice(JobTemplateMetaService ajc$this, JobTemplateEntity jobTemplateEntity, boolean overwrite, JoinPoint thisJoinPoint, MethodMonitorAspect ajc$aspectInstance, ProceedingJoinPoint pjp, Monitored monitored) {
        Object var14_19;
        block10: {
            if (MethodMonitorAspect.ajc$inlineAccessFieldGet$org_apache_gravitino_metrics_MethodMonitorAspect$org_apache_gravitino_metrics_MethodMonitorAspect$metricsSystem(ajc$aspectInstance) == null) {
                ProceedingJoinPoint proceedingJoinPoint = pjp;
                JobTemplateMetaService.insertJobTemplate_aroundBody4(ajc$this, jobTemplateEntity, overwrite, (JoinPoint)proceedingJoinPoint);
                return null;
            }
            MetricsSource metricsSource = MethodMonitorAspect.ajc$inlineAccessFieldGet$org_apache_gravitino_metrics_MethodMonitorAspect$org_apache_gravitino_metrics_MethodMonitorAspect$metricsSystem(ajc$aspectInstance).getMetricsSource(monitored.metricsSource());
            if (metricsSource == null) {
                MethodMonitorAspect.ajc$inlineAccessFieldGet$org_apache_gravitino_metrics_MethodMonitorAspect$org_apache_gravitino_metrics_MethodMonitorAspect$LOG().warn("MetricsSource {} is not registered in MetricsSystem, skip monitoring for method {}", (Object)monitored.metricsSource(), (Object)pjp.getSignature().toShortString());
                ProceedingJoinPoint proceedingJoinPoint = pjp;
                JobTemplateMetaService.insertJobTemplate_aroundBody4(ajc$this, jobTemplateEntity, overwrite, (JoinPoint)proceedingJoinPoint);
                return null;
            }
            String baseMetricName = monitored.baseMetricName();
            Timer timer = metricsSource.getTimer(MetricRegistry.name((String)baseMetricName, (String[])new String[]{"total"}));
            Meter successMeter = metricsSource.getMeter(MetricRegistry.name((String)baseMetricName, (String[])new String[]{"success"}));
            Meter failureMeter = metricsSource.getMeter(MetricRegistry.name((String)baseMetricName, (String[])new String[]{"failure"}));
            Timer.Context ignore = timer.time();
            try {
                ProceedingJoinPoint proceedingJoinPoint = pjp;
                JobTemplateMetaService.insertJobTemplate_aroundBody4(ajc$this, jobTemplateEntity, overwrite, (JoinPoint)proceedingJoinPoint);
                Object result = null;
                successMeter.mark();
                var14_19 = result;
                if (ignore == null) break block10;
            }
            catch (Throwable throwable) {
                try {
                    if (ignore != null) {
                        try {
                            ignore.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (Throwable t) {
                    failureMeter.mark();
                    throw t;
                }
            }
            ignore.close();
        }
        return var14_19;
    }

    private static final /* synthetic */ boolean deleteJobTemplate_aroundBody6(JobTemplateMetaService ajc$this, NameIdentifier jobTemplateIdent, JoinPoint joinPoint) {
        String metalakeName = jobTemplateIdent.namespace().level(0);
        String jobTemplateName = jobTemplateIdent.name();
        AtomicInteger result = new AtomicInteger(0);
        SessionUtils.doMultipleWithCommit(() -> SessionUtils.doWithoutCommit(JobMetaMapper.class, mapper -> mapper.softDeleteJobMetaByMetalakeAndTemplate(metalakeName, jobTemplateName)), () -> result.set(SessionUtils.getWithoutCommit(JobTemplateMetaMapper.class, mapper -> mapper.softDeleteJobTemplateMetaByMetalakeAndName(metalakeName, jobTemplateName))));
        return result.get() > 0;
    }

    private static final /* synthetic */ Object deleteJobTemplate_aroundBody7$advice(JobTemplateMetaService ajc$this, NameIdentifier jobTemplateIdent, JoinPoint thisJoinPoint, MethodMonitorAspect ajc$aspectInstance, ProceedingJoinPoint pjp, Monitored monitored) {
        Object object;
        block10: {
            if (MethodMonitorAspect.ajc$inlineAccessFieldGet$org_apache_gravitino_metrics_MethodMonitorAspect$org_apache_gravitino_metrics_MethodMonitorAspect$metricsSystem(ajc$aspectInstance) == null) {
                ProceedingJoinPoint proceedingJoinPoint = pjp;
                return Conversions.booleanObject((boolean)JobTemplateMetaService.deleteJobTemplate_aroundBody6(ajc$this, jobTemplateIdent, (JoinPoint)proceedingJoinPoint));
            }
            MetricsSource metricsSource = MethodMonitorAspect.ajc$inlineAccessFieldGet$org_apache_gravitino_metrics_MethodMonitorAspect$org_apache_gravitino_metrics_MethodMonitorAspect$metricsSystem(ajc$aspectInstance).getMetricsSource(monitored.metricsSource());
            if (metricsSource == null) {
                MethodMonitorAspect.ajc$inlineAccessFieldGet$org_apache_gravitino_metrics_MethodMonitorAspect$org_apache_gravitino_metrics_MethodMonitorAspect$LOG().warn("MetricsSource {} is not registered in MetricsSystem, skip monitoring for method {}", (Object)monitored.metricsSource(), (Object)pjp.getSignature().toShortString());
                ProceedingJoinPoint proceedingJoinPoint = pjp;
                return Conversions.booleanObject((boolean)JobTemplateMetaService.deleteJobTemplate_aroundBody6(ajc$this, jobTemplateIdent, (JoinPoint)proceedingJoinPoint));
            }
            String baseMetricName = monitored.baseMetricName();
            Timer timer = metricsSource.getTimer(MetricRegistry.name((String)baseMetricName, (String[])new String[]{"total"}));
            Meter successMeter = metricsSource.getMeter(MetricRegistry.name((String)baseMetricName, (String[])new String[]{"success"}));
            Meter failureMeter = metricsSource.getMeter(MetricRegistry.name((String)baseMetricName, (String[])new String[]{"failure"}));
            Timer.Context ignore = timer.time();
            try {
                ProceedingJoinPoint proceedingJoinPoint = pjp;
                Object result = Conversions.booleanObject((boolean)JobTemplateMetaService.deleteJobTemplate_aroundBody6(ajc$this, jobTemplateIdent, (JoinPoint)proceedingJoinPoint));
                successMeter.mark();
                object = result;
                if (ignore == null) break block10;
            }
            catch (Throwable throwable) {
                try {
                    if (ignore != null) {
                        try {
                            ignore.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (Throwable t) {
                    failureMeter.mark();
                    throw t;
                }
            }
            ignore.close();
        }
        return object;
    }

    private static final /* synthetic */ int deleteJobTemplatesByLegacyTimeline_aroundBody8(JobTemplateMetaService ajc$this, long legacyTimeline, int limit, JoinPoint joinPoint) {
        return SessionUtils.doWithCommitAndFetchResult(JobTemplateMetaMapper.class, mapper -> mapper.deleteJobTemplateMetasByLegacyTimeline(legacyTimeline, limit));
    }

    private static final /* synthetic */ Object deleteJobTemplatesByLegacyTimeline_aroundBody9$advice(JobTemplateMetaService ajc$this, long legacyTimeline, int limit, JoinPoint thisJoinPoint, MethodMonitorAspect ajc$aspectInstance, ProceedingJoinPoint pjp, Monitored monitored) {
        Object object;
        block10: {
            if (MethodMonitorAspect.ajc$inlineAccessFieldGet$org_apache_gravitino_metrics_MethodMonitorAspect$org_apache_gravitino_metrics_MethodMonitorAspect$metricsSystem(ajc$aspectInstance) == null) {
                ProceedingJoinPoint proceedingJoinPoint = pjp;
                return Conversions.intObject((int)JobTemplateMetaService.deleteJobTemplatesByLegacyTimeline_aroundBody8(ajc$this, legacyTimeline, limit, (JoinPoint)proceedingJoinPoint));
            }
            MetricsSource metricsSource = MethodMonitorAspect.ajc$inlineAccessFieldGet$org_apache_gravitino_metrics_MethodMonitorAspect$org_apache_gravitino_metrics_MethodMonitorAspect$metricsSystem(ajc$aspectInstance).getMetricsSource(monitored.metricsSource());
            if (metricsSource == null) {
                MethodMonitorAspect.ajc$inlineAccessFieldGet$org_apache_gravitino_metrics_MethodMonitorAspect$org_apache_gravitino_metrics_MethodMonitorAspect$LOG().warn("MetricsSource {} is not registered in MetricsSystem, skip monitoring for method {}", (Object)monitored.metricsSource(), (Object)pjp.getSignature().toShortString());
                ProceedingJoinPoint proceedingJoinPoint = pjp;
                return Conversions.intObject((int)JobTemplateMetaService.deleteJobTemplatesByLegacyTimeline_aroundBody8(ajc$this, legacyTimeline, limit, (JoinPoint)proceedingJoinPoint));
            }
            String baseMetricName = monitored.baseMetricName();
            Timer timer = metricsSource.getTimer(MetricRegistry.name((String)baseMetricName, (String[])new String[]{"total"}));
            Meter successMeter = metricsSource.getMeter(MetricRegistry.name((String)baseMetricName, (String[])new String[]{"success"}));
            Meter failureMeter = metricsSource.getMeter(MetricRegistry.name((String)baseMetricName, (String[])new String[]{"failure"}));
            Timer.Context ignore = timer.time();
            try {
                ProceedingJoinPoint proceedingJoinPoint = pjp;
                Object result = Conversions.intObject((int)JobTemplateMetaService.deleteJobTemplatesByLegacyTimeline_aroundBody8(ajc$this, legacyTimeline, limit, (JoinPoint)proceedingJoinPoint));
                successMeter.mark();
                object = result;
                if (ignore == null) break block10;
            }
            catch (Throwable throwable) {
                try {
                    if (ignore != null) {
                        try {
                            ignore.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (Throwable t) {
                    failureMeter.mark();
                    throw t;
                }
            }
            ignore.close();
        }
        return object;
    }

    private static final /* synthetic */ JobTemplateEntity updateJobTemplate_aroundBody10(JobTemplateMetaService ajc$this, NameIdentifier jobTemplateIdent, Function updater, JoinPoint joinPoint) {
        Integer result;
        JobTemplatePO oldJobTemplatePO = ajc$this.getJobTemplatePO(jobTemplateIdent);
        JobTemplateEntity oldJobTemplateEntity = JobTemplatePO.fromJobTemplatePO(oldJobTemplatePO, jobTemplateIdent.namespace());
        JobTemplateEntity newJobTemplateEntity = (JobTemplateEntity)updater.apply(oldJobTemplateEntity);
        Preconditions.checkArgument((boolean)Objects.equals(oldJobTemplateEntity.id(), newJobTemplateEntity.id()), (String)"The updated job templated id: %s is not equal to the old one: %s, which is unexpected", (Object)newJobTemplateEntity.id(), (Object)oldJobTemplateEntity.id());
        JobTemplatePO.JobTemplatePOBuilder newBuilder = JobTemplatePO.builder().withMetalakeId(oldJobTemplatePO.metalakeId());
        JobTemplatePO newJobTemplatePO = JobTemplatePO.updateJobTemplatePO(oldJobTemplatePO, newJobTemplateEntity, newBuilder);
        try {
            result = SessionUtils.doWithCommitAndFetchResult(JobTemplateMetaMapper.class, mapper -> mapper.updateJobTemplateMeta(newJobTemplatePO, oldJobTemplatePO));
        }
        catch (RuntimeException e) {
            ExceptionUtils.checkSQLException(e, Entity.EntityType.JOB_TEMPLATE, oldJobTemplateEntity.name());
            throw e;
        }
        if (result == null || result == 0) {
            throw new NoSuchEntityException("No such %s entity: %s", new Object[]{Entity.EntityType.JOB_TEMPLATE.name().toLowerCase(Locale.ROOT), oldJobTemplateEntity.name()});
        }
        if (result > 1) {
            throw new IOException(String.format("Failed to update job template: %s, because more than one rows are updated: %d", oldJobTemplateEntity.name(), result));
        }
        return newJobTemplateEntity;
    }

    private static final /* synthetic */ Object updateJobTemplate_aroundBody11$advice(JobTemplateMetaService ajc$this, NameIdentifier jobTemplateIdent, Function updater, JoinPoint thisJoinPoint, MethodMonitorAspect ajc$aspectInstance, ProceedingJoinPoint pjp, Monitored monitored) {
        JobTemplateEntity jobTemplateEntity;
        block10: {
            if (MethodMonitorAspect.ajc$inlineAccessFieldGet$org_apache_gravitino_metrics_MethodMonitorAspect$org_apache_gravitino_metrics_MethodMonitorAspect$metricsSystem(ajc$aspectInstance) == null) {
                ProceedingJoinPoint proceedingJoinPoint = pjp;
                return JobTemplateMetaService.updateJobTemplate_aroundBody10(ajc$this, jobTemplateIdent, updater, (JoinPoint)proceedingJoinPoint);
            }
            MetricsSource metricsSource = MethodMonitorAspect.ajc$inlineAccessFieldGet$org_apache_gravitino_metrics_MethodMonitorAspect$org_apache_gravitino_metrics_MethodMonitorAspect$metricsSystem(ajc$aspectInstance).getMetricsSource(monitored.metricsSource());
            if (metricsSource == null) {
                MethodMonitorAspect.ajc$inlineAccessFieldGet$org_apache_gravitino_metrics_MethodMonitorAspect$org_apache_gravitino_metrics_MethodMonitorAspect$LOG().warn("MetricsSource {} is not registered in MetricsSystem, skip monitoring for method {}", (Object)monitored.metricsSource(), (Object)pjp.getSignature().toShortString());
                ProceedingJoinPoint proceedingJoinPoint = pjp;
                return JobTemplateMetaService.updateJobTemplate_aroundBody10(ajc$this, jobTemplateIdent, updater, (JoinPoint)proceedingJoinPoint);
            }
            String baseMetricName = monitored.baseMetricName();
            Timer timer = metricsSource.getTimer(MetricRegistry.name((String)baseMetricName, (String[])new String[]{"total"}));
            Meter successMeter = metricsSource.getMeter(MetricRegistry.name((String)baseMetricName, (String[])new String[]{"success"}));
            Meter failureMeter = metricsSource.getMeter(MetricRegistry.name((String)baseMetricName, (String[])new String[]{"failure"}));
            Timer.Context ignore = timer.time();
            try {
                ProceedingJoinPoint proceedingJoinPoint = pjp;
                JobTemplateEntity result = JobTemplateMetaService.updateJobTemplate_aroundBody10(ajc$this, jobTemplateIdent, updater, (JoinPoint)proceedingJoinPoint);
                successMeter.mark();
                jobTemplateEntity = result;
                if (ignore == null) break block10;
            }
            catch (Throwable throwable) {
                try {
                    if (ignore != null) {
                        try {
                            ignore.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (Throwable t) {
                    failureMeter.mark();
                    throw t;
                }
            }
            ignore.close();
        }
        return jobTemplateEntity;
    }

    private static /* synthetic */ void ajc$preClinit() {
        Factory factory = new Factory("JobTemplateMetaService.java", JobTemplateMetaService.class);
        ajc$tjp_0 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "listJobTemplatesByNamespace", "org.apache.gravitino.storage.relational.service.JobTemplateMetaService", "org.apache.gravitino.Namespace", "ns", "", "java.util.List"), 60);
        ajc$tjp_1 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "getJobTemplateByIdentifier", "org.apache.gravitino.storage.relational.service.JobTemplateMetaService", "org.apache.gravitino.NameIdentifier", "jobTemplateIdent", "", "org.apache.gravitino.meta.JobTemplateEntity"), 75);
        ajc$tjp_2 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "insertJobTemplate", "org.apache.gravitino.storage.relational.service.JobTemplateMetaService", "org.apache.gravitino.meta.JobTemplateEntity:boolean", "jobTemplateEntity:overwrite", "java.io.IOException", "void"), 84);
        ajc$tjp_3 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "deleteJobTemplate", "org.apache.gravitino.storage.relational.service.JobTemplateMetaService", "org.apache.gravitino.NameIdentifier", "jobTemplateIdent", "", "boolean"), 113);
        ajc$tjp_4 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "deleteJobTemplatesByLegacyTimeline", "org.apache.gravitino.storage.relational.service.JobTemplateMetaService", "long:int", "legacyTimeline:limit", "", "int"), 137);
        ajc$tjp_5 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "updateJobTemplate", "org.apache.gravitino.storage.relational.service.JobTemplateMetaService", "org.apache.gravitino.NameIdentifier:java.util.function.Function", "jobTemplateIdent:updater", "java.io.IOException", "org.apache.gravitino.meta.JobTemplateEntity"), 147);
    }
}

