/*
 * Decompiled with CFR 0.152.
 */
package com.lancedb.lance.namespace.model;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.StringJoiner;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

@JsonPropertyOrder(value={"columns", "query"})
public class StringFtsQuery {
    public static final String JSON_PROPERTY_COLUMNS = "columns";
    @Nullable
    private List<String> columns = new ArrayList<String>();
    public static final String JSON_PROPERTY_QUERY = "query";
    @Nonnull
    private String query;

    public StringFtsQuery columns(@Nullable List<String> columns) {
        this.columns = columns;
        return this;
    }

    public StringFtsQuery addColumnsItem(String columnsItem) {
        if (this.columns == null) {
            this.columns = new ArrayList<String>();
        }
        this.columns.add(columnsItem);
        return this;
    }

    @Nullable
    @JsonProperty(value="columns")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public List<String> getColumns() {
        return this.columns;
    }

    @JsonProperty(value="columns")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setColumns(@Nullable List<String> columns) {
        this.columns = columns;
    }

    public StringFtsQuery query(@Nonnull String query) {
        this.query = query;
        return this;
    }

    @Nonnull
    @JsonProperty(value="query")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public String getQuery() {
        return this.query;
    }

    @JsonProperty(value="query")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setQuery(@Nonnull String query) {
        this.query = query;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        StringFtsQuery stringFtsQuery = (StringFtsQuery)o;
        return Objects.equals(this.columns, stringFtsQuery.columns) && Objects.equals(this.query, stringFtsQuery.query);
    }

    public int hashCode() {
        return Objects.hash(this.columns, this.query);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class StringFtsQuery {\n");
        sb.append("    columns: ").append(this.toIndentedString(this.columns)).append("\n");
        sb.append("    query: ").append(this.toIndentedString(this.query)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public String toUrlQueryString() {
        return this.toUrlQueryString(null);
    }

    public String toUrlQueryString(String prefix) {
        String suffix = "";
        String containerSuffix = "";
        String containerPrefix = "";
        if (prefix == null) {
            prefix = "";
        } else {
            prefix = prefix + "[";
            suffix = "]";
            containerSuffix = "]";
            containerPrefix = "[";
        }
        StringJoiner joiner = new StringJoiner("&");
        if (this.getColumns() != null) {
            for (int i = 0; i < this.getColumns().size(); ++i) {
                try {
                    joiner.add(String.format("%scolumns%s%s=%s", prefix, suffix, "".equals(suffix) ? "" : String.format("%s%d%s", containerPrefix, i, containerSuffix), URLEncoder.encode(String.valueOf(this.getColumns().get(i)), "UTF-8").replaceAll("\\+", "%20")));
                    continue;
                }
                catch (UnsupportedEncodingException e) {
                    throw new RuntimeException(e);
                }
            }
        }
        if (this.getQuery() != null) {
            try {
                joiner.add(String.format("%squery%s=%s", prefix, suffix, URLEncoder.encode(String.valueOf(this.getQuery()), "UTF-8").replaceAll("\\+", "%20")));
            }
            catch (UnsupportedEncodingException e) {
                throw new RuntimeException(e);
            }
        }
        return joiner.toString();
    }
}

