/*
 * Decompiled with CFR 0.152.
 */
package org.testng.reporters.jq;

import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.testng.ISuite;
import org.testng.ISuiteResult;
import org.testng.ITestContext;
import org.testng.ITestResult;
import org.testng.collections.Lists;
import org.testng.reporters.XMLStringBuffer;
import org.testng.reporters.jq.BasePanel;
import org.testng.reporters.jq.INavigatorPanel;
import org.testng.reporters.jq.Model;
import org.testng.reporters.jq.ResultsByClass;

public class NavigatorPanel
extends BasePanel {
    private List<INavigatorPanel> m_panels;

    public NavigatorPanel(Model model, List<INavigatorPanel> list) {
        super(model);
        this.m_panels = list;
    }

    @Override
    public void generate(XMLStringBuffer xMLStringBuffer) {
        xMLStringBuffer.push("div", "class", "navigator-root");
        xMLStringBuffer.push("div", "class", "navigator-suite-header");
        xMLStringBuffer.addRequired("span", "All suites");
        xMLStringBuffer.push("a", "class", "collapse-all-link", "href", "#", "title", "Collapse/expand all the suites");
        xMLStringBuffer.push("img", "src", "collapseall.gif", "class", "collapse-all-icon");
        xMLStringBuffer.pop("img");
        xMLStringBuffer.pop("a");
        xMLStringBuffer.pop("div");
        for (ISuite iSuite : this.getSuites()) {
            if (iSuite.getResults().size() == 0) continue;
            String string = "suite-" + NavigatorPanel.suiteToTag(iSuite);
            XMLStringBuffer xMLStringBuffer2 = new XMLStringBuffer(xMLStringBuffer.getCurrentIndent());
            Map<String, ISuiteResult> map = iSuite.getResults();
            int n = 0;
            int n2 = 0;
            int n3 = 0;
            for (ISuiteResult iSuiteResult : map.values()) {
                ITestContext iTestContext = iSuiteResult.getTestContext();
                n += iTestContext.getFailedTests().size();
                n2 += iTestContext.getSkippedTests().size();
                n3 += iTestContext.getPassedTests().size();
            }
            xMLStringBuffer2.push("div", "class", "suite");
            xMLStringBuffer2.push("div", "class", "rounded-window");
            xMLStringBuffer2.push("div", "class", "suite-header light-rounded-window-top");
            xMLStringBuffer2.push("a", "href", "#", "panel-name", string, "class", "navigator-link");
            xMLStringBuffer2.addOptional("span", iSuite.getName(), "class", "suite-name border-" + this.getModel().getStatusForSuite(iSuite.getName()));
            xMLStringBuffer2.pop("a");
            xMLStringBuffer2.pop("div");
            xMLStringBuffer2.push("div", "class", "navigator-suite-content");
            this.generateInfo(xMLStringBuffer2, iSuite);
            this.generateResult(xMLStringBuffer2, n, n2, n3, iSuite, string);
            xMLStringBuffer2.pop("ul");
            xMLStringBuffer2.pop("div");
            xMLStringBuffer2.pop("div");
            xMLStringBuffer2.pop("div");
            xMLStringBuffer2.pop("div");
            xMLStringBuffer2.pop("div");
            xMLStringBuffer.addString(xMLStringBuffer2.toXML());
        }
        xMLStringBuffer.pop("div");
    }

    private void generateResult(XMLStringBuffer xMLStringBuffer, int n, int n2, int n3, ISuite iSuite, String string) {
        xMLStringBuffer.push("div", "class", "result-section");
        xMLStringBuffer.push("div", "class", "suite-section-title");
        xMLStringBuffer.addRequired("span", "Results");
        xMLStringBuffer.pop("div");
        int n4 = n + n2 + n3;
        String string2 = String.format("%s, %s %s %s", NavigatorPanel.pluralize(n4, "method"), NavigatorPanel.maybe(n, "failed", ", "), NavigatorPanel.maybe(n2, "skipped", ", "), NavigatorPanel.maybe(n3, "passed", ""));
        xMLStringBuffer.push("div", "class", "suite-section-content");
        xMLStringBuffer.push("ul");
        xMLStringBuffer.push("li");
        xMLStringBuffer.addOptional("span", string2, "class", "method-stats");
        xMLStringBuffer.pop("li");
        this.generateMethodList("Failed methods", new ResultsByStatus(iSuite, "failed", 2), string, xMLStringBuffer);
        this.generateMethodList("Skipped methods", new ResultsByStatus(iSuite, "skipped", 3), string, xMLStringBuffer);
        this.generateMethodList("Passed methods", new ResultsByStatus(iSuite, "passed", 1), string, xMLStringBuffer);
    }

    private void generateInfo(XMLStringBuffer xMLStringBuffer, ISuite iSuite) {
        xMLStringBuffer.push("div", "class", "suite-section-title");
        xMLStringBuffer.addRequired("span", "Info");
        xMLStringBuffer.pop("div");
        xMLStringBuffer.push("div", "class", "suite-section-content");
        xMLStringBuffer.push("ul");
        for (INavigatorPanel iNavigatorPanel : this.m_panels) {
            this.addLinkTo(xMLStringBuffer, iNavigatorPanel, iSuite);
        }
        xMLStringBuffer.pop("ul");
        xMLStringBuffer.pop("div");
    }

    private void addLinkTo(XMLStringBuffer xMLStringBuffer, INavigatorPanel iNavigatorPanel, ISuite iSuite) {
        String string = iNavigatorPanel.getNavigatorLink(iSuite);
        xMLStringBuffer.push("li");
        xMLStringBuffer.push("a", "href", "#", "panel-name", iNavigatorPanel.getPanelName(iSuite), "class", "navigator-link ");
        String string2 = iNavigatorPanel.getClassName();
        if (string2 != null) {
            xMLStringBuffer.addOptional("span", string, "class", string2);
        } else {
            xMLStringBuffer.addOptional("span", string);
        }
        xMLStringBuffer.pop("a");
        xMLStringBuffer.pop("li");
    }

    private static String maybe(int n, String string, String string2) {
        return n > 0 ? n + " " + string + string2 : "";
    }

    private List<ITestResult> getMethodsByStatus(ISuite iSuite, int n) {
        List<ITestResult> list = Lists.newArrayList();
        List<ITestResult> list2 = this.getModel().getTestResults(iSuite);
        for (ITestResult iTestResult : list2) {
            if (iTestResult.getStatus() != n) continue;
            list.add(iTestResult);
        }
        Collections.sort(list, ResultsByClass.METHOD_NAME_COMPARATOR);
        return list;
    }

    private void generateMethodList(String string, IResultProvider iResultProvider, String string2, XMLStringBuffer xMLStringBuffer) {
        XMLStringBuffer xMLStringBuffer2 = new XMLStringBuffer(xMLStringBuffer.getCurrentIndent());
        String string3 = iResultProvider.getType();
        String string4 = Model.getImage(string3);
        xMLStringBuffer2.push("li");
        xMLStringBuffer2.addRequired("span", string, "class", "method-list-title " + string3);
        xMLStringBuffer2.push("span", "class", "show-or-hide-methods " + string3);
        xMLStringBuffer2.addRequired("a", " (hide)", "href", "#", "class", "hide-methods " + string3 + " " + string2, "panel-name", string2);
        xMLStringBuffer2.addRequired("a", " (show)", "href", "#", "class", "show-methods " + string3 + " " + string2, "panel-name", string2);
        xMLStringBuffer2.pop("span");
        xMLStringBuffer2.push("div", "class", "method-list-content " + string3 + " " + string2);
        int n = 0;
        List<ITestResult> list = iResultProvider.getResults();
        if (list != null) {
            Collections.sort(list, ResultsByClass.METHOD_NAME_COMPARATOR);
            for (ITestResult iTestResult : list) {
                String string5 = Model.getTestResultName(iTestResult);
                xMLStringBuffer2.push("span");
                xMLStringBuffer2.addEmptyElement("img", "src", string4, "width", "3%");
                xMLStringBuffer2.addRequired("a", string5, "href", "#", "hash-for-method", this.getModel().getTag(iTestResult), "panel-name", string2, "title", iTestResult.getTestClass().getName(), "class", "method navigator-link");
                xMLStringBuffer2.pop("span");
                xMLStringBuffer2.addEmptyElement("br");
                ++n;
            }
        }
        xMLStringBuffer2.pop("div");
        xMLStringBuffer2.pop("li");
        if (n > 0) {
            xMLStringBuffer.addString(xMLStringBuffer2.toXML());
        }
    }

    private class ResultsByStatus
    extends BaseResultProvider {
        private final int m_status;

        public ResultsByStatus(ISuite iSuite, String string, int n) {
            super(iSuite, string);
            this.m_status = n;
        }

        @Override
        public List<ITestResult> getResults() {
            return NavigatorPanel.this.getMethodsByStatus(this.m_suite, this.m_status);
        }
    }

    private static abstract class BaseResultProvider
    implements IResultProvider {
        protected ISuite m_suite;
        protected String m_type;

        public BaseResultProvider(ISuite iSuite, String string) {
            this.m_suite = iSuite;
            this.m_type = string;
        }

        @Override
        public String getType() {
            return this.m_type;
        }
    }

    private static interface IResultProvider {
        public List<ITestResult> getResults();

        public String getType();
    }
}

