/*
 * Decompiled with CFR 0.152.
 */
package org.testng;

import java.lang.reflect.Array;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.StreamSupport;
import org.testng.collections.Lists;
import org.testng.internal.EclipseInterface;

public class Assert {
    public static final String ARRAY_MISMATCH_TEMPLATE = "arrays differ firstly at element [%d]; expected value is <%s> but was <%s>. %s";

    protected Assert() {
    }

    public static void assertTrue(boolean condition, String message) {
        if (!condition) {
            Assert.failNotEquals(condition, Boolean.TRUE, message);
        }
    }

    public static void assertTrue(boolean condition) {
        Assert.assertTrue(condition, null);
    }

    public static void assertFalse(boolean condition, String message) {
        if (condition) {
            Assert.failNotEquals(condition, Boolean.FALSE, message);
        }
    }

    public static void assertFalse(boolean condition) {
        Assert.assertFalse(condition, null);
    }

    public static void fail(String message, Throwable realCause) {
        AssertionError ae = new AssertionError((Object)message);
        ((Throwable)((Object)ae)).initCause(realCause);
        throw ae;
    }

    public static void fail(String message) {
        throw new AssertionError((Object)message);
    }

    public static void fail() {
        Assert.fail(null);
    }

    public static void assertEquals(Object actual, Object expected, String message) {
        if (expected != null && expected.getClass().isArray()) {
            Assert.assertArrayEquals(actual, expected, message);
            return;
        }
        Assert.assertEqualsImpl(actual, expected, message);
    }

    private static boolean areEqual(Object actual, Object expected) {
        if (expected != null && expected.getClass().isArray()) {
            return Assert.areArraysEqual(actual, expected);
        }
        return Assert.areEqualImpl(actual, expected);
    }

    private static void assertEqualsImpl(Object actual, Object expected, String message) {
        boolean equal = Assert.areEqualImpl(actual, expected);
        if (!equal) {
            Assert.failNotEquals(actual, expected, message);
        }
    }

    private static void assertNotEqualsImpl(Object actual, Object expected, String message) {
        boolean notEqual = Assert.areNotEqualImpl(actual, expected);
        if (!notEqual) {
            Assert.failEquals(actual, expected, message);
        }
    }

    private static boolean areNotEqualImpl(Object actual, Object expected) {
        if (expected == null) {
            return actual != null;
        }
        if (actual == null) {
            return true;
        }
        return !expected.equals(actual);
    }

    private static boolean areEqualImpl(Object actual, Object expected) {
        if (expected == null && actual == null) {
            return true;
        }
        if (expected == null || actual == null) {
            return false;
        }
        return expected.equals(actual) && actual.equals(expected);
    }

    private static String getArrayNotEqualReason(Object actual, Object expected) {
        if (Objects.equals(actual, expected)) {
            return null;
        }
        if (null == expected) {
            return "expected a null array, but not null found";
        }
        if (null == actual) {
            return "expected not null array, but null found";
        }
        if (!actual.getClass().isArray()) {
            return "not an array";
        }
        int expectedLength = Array.getLength(expected);
        if (expectedLength != Array.getLength(actual)) {
            return "array lengths are not the same";
        }
        for (int i = 0; i < expectedLength; ++i) {
            Object _expected;
            Object _actual = Array.get(actual, i);
            if (Assert.areEqual(_actual, _expected = Array.get(expected, i))) continue;
            return "(values at index " + i + " are not the same)";
        }
        return null;
    }

    private static boolean areArraysEqual(Object actual, Object expected) {
        return Assert.getArrayNotEqualReason(actual, expected) == null;
    }

    private static void assertArrayEquals(Object actual, Object expected, String message) {
        String reason = Assert.getArrayNotEqualReason(actual, expected);
        if (null != reason) {
            Assert.failNotEquals(actual, expected, message == null ? "" : message + " (" + message + ")");
        }
    }

    private static void assertArrayNotEquals(Object actual, Object expected, String message) {
        String reason = Assert.getArrayNotEqualReason(actual, expected);
        if (null == reason) {
            Assert.failEquals(actual, expected, message);
        }
    }

    public static void assertEquals(byte[] actual, byte[] expected) {
        Assert.assertEquals(actual, expected, "");
    }

    public static void assertEquals(byte[] actual, byte[] expected, String message) {
        if (Assert.checkRefEqualityAndLength(actual, expected, message)) {
            return;
        }
        for (int i = 0; i < expected.length; ++i) {
            if (expected[i] == actual[i]) continue;
            Assert.fail(String.format(ARRAY_MISMATCH_TEMPLATE, i, Byte.toString(expected[i]), Byte.toString(actual[i]), message));
        }
    }

    public static void assertEquals(short[] actual, short[] expected) {
        Assert.assertEquals(actual, expected, "");
    }

    public static void assertEquals(short[] actual, short[] expected, String message) {
        if (Assert.checkRefEqualityAndLength(actual, expected, message)) {
            return;
        }
        for (int i = 0; i < expected.length; ++i) {
            if (expected[i] == actual[i]) continue;
            Assert.fail(String.format(ARRAY_MISMATCH_TEMPLATE, i, Short.toString(expected[i]), Short.toString(actual[i]), message));
        }
    }

    public static void assertEquals(int[] actual, int[] expected) {
        Assert.assertEquals(actual, expected, "");
    }

    public static void assertEquals(int[] actual, int[] expected, String message) {
        if (Assert.checkRefEqualityAndLength(actual, expected, message)) {
            return;
        }
        for (int i = 0; i < expected.length; ++i) {
            if (expected[i] == actual[i]) continue;
            Assert.fail(String.format(ARRAY_MISMATCH_TEMPLATE, i, Integer.toString(expected[i]), Integer.toString(actual[i]), message));
        }
    }

    public static void assertEquals(boolean[] actual, boolean[] expected) {
        Assert.assertEquals(actual, expected, "");
    }

    public static void assertEquals(boolean[] actual, boolean[] expected, String message) {
        if (Assert.checkRefEqualityAndLength(actual, expected, message)) {
            return;
        }
        for (int i = 0; i < expected.length; ++i) {
            if (expected[i] == actual[i]) continue;
            Assert.fail(String.format(ARRAY_MISMATCH_TEMPLATE, i, Boolean.toString(expected[i]), Boolean.toString(actual[i]), message));
        }
    }

    public static void assertEquals(char[] actual, char[] expected) {
        Assert.assertEquals(actual, expected, "");
    }

    public static void assertEquals(char[] actual, char[] expected, String message) {
        if (Assert.checkRefEqualityAndLength(actual, expected, message)) {
            return;
        }
        for (int i = 0; i < expected.length; ++i) {
            if (expected[i] == actual[i]) continue;
            Assert.fail(String.format(ARRAY_MISMATCH_TEMPLATE, i, Character.toString(expected[i]), Character.toString(actual[i]), message));
        }
    }

    public static void assertEquals(float[] actual, float[] expected) {
        Assert.assertEquals(actual, expected, "");
    }

    public static void assertEquals(float[] actual, float[] expected, String message) {
        if (Assert.checkRefEqualityAndLength(actual, expected, message)) {
            return;
        }
        for (int i = 0; i < expected.length; ++i) {
            Assert.assertEquals(actual[i], expected[i], String.format(ARRAY_MISMATCH_TEMPLATE, i, Float.toString(expected[i]), Float.toString(actual[i]), message));
        }
    }

    public static void assertEquals(float[] actual, float[] expected, float delta) {
        Assert.assertEquals(actual, expected, delta, "");
    }

    public static void assertEquals(float[] actual, float[] expected, float delta, String message) {
        if (Assert.checkRefEqualityAndLength(actual, expected, message)) {
            return;
        }
        for (int i = 0; i < expected.length; ++i) {
            Assert.assertEquals(actual[i], expected[i], delta, String.format(ARRAY_MISMATCH_TEMPLATE, i, Float.toString(expected[i]), Float.toString(actual[i]), message));
        }
    }

    public static void assertEquals(double[] actual, double[] expected) {
        Assert.assertEquals(actual, expected, "");
    }

    public static void assertEquals(double[] actual, double[] expected, String message) {
        if (Assert.checkRefEqualityAndLength(actual, expected, message)) {
            return;
        }
        for (int i = 0; i < expected.length; ++i) {
            Assert.assertEquals(actual[i], expected[i], String.format(ARRAY_MISMATCH_TEMPLATE, i, Double.toString(expected[i]), Double.toString(actual[i]), message));
        }
    }

    public static void assertEquals(double[] actual, double[] expected, double delta) {
        Assert.assertEquals(actual, expected, delta, "");
    }

    public static void assertEquals(double[] actual, double[] expected, double delta, String message) {
        if (Assert.checkRefEqualityAndLength(actual, expected, message)) {
            return;
        }
        for (int i = 0; i < expected.length; ++i) {
            Assert.assertEquals(actual[i], expected[i], delta, String.format(ARRAY_MISMATCH_TEMPLATE, i, Double.toString(expected[i]), Double.toString(actual[i]), message));
        }
    }

    public static void assertEquals(long[] actual, long[] expected) {
        Assert.assertEquals(actual, expected, "");
    }

    public static void assertEquals(long[] actual, long[] expected, String message) {
        if (Assert.checkRefEqualityAndLength(actual, expected, message)) {
            return;
        }
        for (int i = 0; i < expected.length; ++i) {
            if (expected[i] == actual[i]) continue;
            Assert.fail(String.format(ARRAY_MISMATCH_TEMPLATE, i, Long.toString(expected[i]), Long.toString(actual[i]), message));
        }
    }

    private static boolean checkRefEqualityAndLength(Object actualArray, Object expectedArray, String message) {
        if (expectedArray == actualArray) {
            return true;
        }
        if (null == expectedArray) {
            Assert.fail("expectedArray a null array, but not null found. " + message);
        }
        if (null == actualArray) {
            Assert.fail("expectedArray not null array, but null found. " + message);
        }
        Assert.assertEquals(Array.getLength(actualArray), Array.getLength(expectedArray), "arrays don't have the same size. " + message);
        return false;
    }

    public static void assertEquals(Object actual, Object expected) {
        Assert.assertEquals(actual, expected, null);
    }

    public static void assertEquals(String actual, String expected, String message) {
        Assert.assertEquals((Object)actual, (Object)expected, message);
    }

    public static void assertEquals(String actual, String expected) {
        Assert.assertEquals(actual, expected, null);
    }

    private static boolean areEqual(double actual, double expected, double delta) {
        return !(Double.isInfinite(expected) ? expected != actual : (Double.isNaN(expected) ? !Double.isNaN(actual) : !(Math.abs(expected - actual) <= delta)));
    }

    public static void assertEquals(double actual, double expected, double delta, String message) {
        if (!Assert.areEqual(actual, expected, delta)) {
            Assert.failNotEquals(actual, expected, message);
        }
    }

    public static void assertEquals(double actual, double expected, double delta) {
        Assert.assertEquals(actual, expected, delta, null);
    }

    public static void assertEquals(double actual, double expected, String message) {
        if (Double.isNaN(expected)) {
            if (!Double.isNaN(actual)) {
                Assert.failNotEquals(actual, expected, message);
            }
        } else if (actual != expected) {
            Assert.failNotEquals(actual, expected, message);
        }
    }

    public static void assertEquals(Double actual, double expected, String message) {
        Assert.assertEquals((Object)actual, (Object)expected, message);
    }

    public static void assertEquals(double actual, Double expected, String message) {
        Assert.assertEquals((Object)actual, (Object)expected, message);
    }

    public static void assertEquals(double actual, double expected) {
        Assert.assertEquals(actual, expected, null);
    }

    public static void assertEquals(Double actual, double expected) {
        Assert.assertEquals((Object)actual, (Object)expected, null);
    }

    public static void assertEquals(double actual, Double expected) {
        Assert.assertEquals((Object)actual, (Object)expected, null);
    }

    private static boolean areEqual(float actual, float expected, float delta) {
        return !(Float.isInfinite(expected) ? expected != actual : (Float.isNaN(expected) ? !Float.isNaN(actual) : !(Math.abs(expected - actual) <= delta)));
    }

    public static void assertEquals(float actual, float expected, float delta, String message) {
        if (!Assert.areEqual(actual, expected, delta)) {
            Assert.failNotEquals(Float.valueOf(actual), Float.valueOf(expected), message);
        }
    }

    public static void assertEquals(float actual, float expected, float delta) {
        Assert.assertEquals(actual, expected, delta, null);
    }

    public static void assertEquals(float actual, float expected, String message) {
        if (Float.isNaN(expected)) {
            if (!Float.isNaN(actual)) {
                Assert.failNotEquals(Float.valueOf(actual), Float.valueOf(expected), message);
            }
        } else if (actual != expected) {
            Assert.failNotEquals(Float.valueOf(actual), Float.valueOf(expected), message);
        }
    }

    public static void assertEquals(Float actual, float expected, String message) {
        Assert.assertEquals((Object)actual, (Object)Float.valueOf(expected), message);
    }

    public static void assertEquals(float actual, Float expected, String message) {
        Assert.assertEquals((Object)Float.valueOf(actual), (Object)expected, message);
    }

    public static void assertEquals(float actual, float expected) {
        Assert.assertEquals(actual, expected, null);
    }

    public static void assertEquals(Float actual, float expected) {
        Assert.assertEquals((Object)actual, (Object)Float.valueOf(expected), null);
    }

    public static void assertEquals(float actual, Float expected) {
        Assert.assertEquals((Object)Float.valueOf(actual), (Object)expected, null);
    }

    public static void assertEquals(long actual, long expected, String message) {
        Assert.assertEquals((Object)actual, (Object)expected, message);
    }

    public static void assertEquals(Long actual, long expected, String message) {
        Assert.assertEquals((Object)actual, (Object)expected, message);
    }

    public static void assertEquals(long actual, Long expected, String message) {
        Assert.assertEquals((Object)actual, (Object)expected, message);
    }

    public static void assertEquals(long actual, long expected) {
        Assert.assertEquals(actual, expected, null);
    }

    public static void assertEquals(Long actual, long expected) {
        Assert.assertEquals((Object)actual, (Object)expected, null);
    }

    public static void assertEquals(long actual, Long expected) {
        Assert.assertEquals((Object)actual, (Object)expected, null);
    }

    public static void assertEquals(boolean actual, boolean expected, String message) {
        Assert.assertEquals((Object)actual, (Object)expected, message);
    }

    public static void assertEquals(Boolean actual, boolean expected, String message) {
        Assert.assertEquals((Object)actual, (Object)expected, message);
    }

    public static void assertEquals(boolean actual, Boolean expected, String message) {
        Assert.assertEquals((Object)actual, (Object)expected, message);
    }

    public static void assertEquals(boolean actual, boolean expected) {
        Assert.assertEquals(actual, expected, null);
    }

    public static void assertEquals(Boolean actual, boolean expected) {
        Assert.assertEquals((Object)actual, (Object)expected, null);
    }

    public static void assertEquals(boolean actual, Boolean expected) {
        Assert.assertEquals((Object)actual, (Object)expected, null);
    }

    public static void assertEquals(byte actual, byte expected, String message) {
        Assert.assertEquals((Object)actual, (Object)expected, message);
    }

    public static void assertEquals(Byte actual, byte expected, String message) {
        Assert.assertEquals((Object)actual, (Object)expected, message);
    }

    public static void assertEquals(byte actual, Byte expected, String message) {
        Assert.assertEquals((Object)actual, (Object)expected, message);
    }

    public static void assertEquals(byte actual, byte expected) {
        Assert.assertEquals(actual, expected, null);
    }

    public static void assertEquals(Byte actual, byte expected) {
        Assert.assertEquals((Object)actual, (Object)expected, null);
    }

    public static void assertEquals(byte actual, Byte expected) {
        Assert.assertEquals((Object)actual, (Object)expected, null);
    }

    public static void assertEquals(char actual, char expected, String message) {
        Assert.assertEquals((Object)Character.valueOf(actual), (Object)Character.valueOf(expected), message);
    }

    public static void assertEquals(Character actual, char expected, String message) {
        Assert.assertEquals((Object)actual, (Object)Character.valueOf(expected), message);
    }

    public static void assertEquals(char actual, Character expected, String message) {
        Assert.assertEquals((Object)Character.valueOf(actual), (Object)expected, message);
    }

    public static void assertEquals(char actual, char expected) {
        Assert.assertEquals(actual, expected, null);
    }

    public static void assertEquals(Character actual, char expected) {
        Assert.assertEquals((Object)actual, (Object)Character.valueOf(expected), null);
    }

    public static void assertEquals(char actual, Character expected) {
        Assert.assertEquals((Object)Character.valueOf(actual), (Object)expected, null);
    }

    public static void assertEquals(short actual, short expected, String message) {
        Assert.assertEquals((Object)actual, (Object)expected, message);
    }

    public static void assertEquals(Short actual, short expected, String message) {
        Assert.assertEquals((Object)actual, (Object)expected, message);
    }

    public static void assertEquals(short actual, Short expected, String message) {
        Assert.assertEquals((Object)actual, (Object)expected, message);
    }

    public static void assertEquals(short actual, short expected) {
        Assert.assertEquals(actual, expected, null);
    }

    public static void assertEquals(Short actual, short expected) {
        Assert.assertEquals((Object)actual, (Object)expected, null);
    }

    public static void assertEquals(short actual, Short expected) {
        Assert.assertEquals((Object)actual, (Object)expected, null);
    }

    public static void assertEquals(int actual, int expected, String message) {
        Assert.assertEquals((Object)actual, (Object)expected, message);
    }

    public static void assertEquals(Integer actual, int expected, String message) {
        Assert.assertEquals((Object)actual, (Object)expected, message);
    }

    public static void assertEquals(int actual, Integer expected, String message) {
        Assert.assertEquals((Object)actual, (Object)expected, message);
    }

    public static void assertEquals(int actual, int expected) {
        Assert.assertEquals(actual, expected, null);
    }

    public static void assertEquals(Integer actual, int expected) {
        Assert.assertEquals((Object)actual, (Object)expected, null);
    }

    public static void assertEquals(int actual, Integer expected) {
        Assert.assertEquals((Object)actual, (Object)expected, null);
    }

    public static void assertNotNull(Object object) {
        Assert.assertNotNull(object, null);
    }

    public static void assertNotNull(Object object, String message) {
        if (object == null) {
            String formatted = "";
            if (message != null) {
                formatted = message + " ";
            }
            Assert.fail(formatted + "expected object to not be null");
        }
    }

    public static void assertNull(Object object) {
        Assert.assertNull(object, null);
    }

    public static void assertNull(Object object, String message) {
        if (object != null) {
            Assert.failNotSame(object, null, message);
        }
    }

    public static void assertSame(Object actual, Object expected, String message) {
        if (expected == actual) {
            return;
        }
        Assert.failNotSame(actual, expected, message);
    }

    public static void assertSame(Object actual, Object expected) {
        Assert.assertSame(actual, expected, null);
    }

    public static void assertNotSame(Object actual, Object expected, String message) {
        if (expected == actual) {
            Assert.failSame(actual, expected, message);
        }
    }

    public static void assertNotSame(Object actual, Object expected) {
        Assert.assertNotSame(actual, expected, null);
    }

    private static void failSame(Object actual, Object expected, String message) {
        String formatted = "";
        if (message != null) {
            formatted = message + " ";
        }
        Assert.fail(formatted + EclipseInterface.ASSERT_LEFT2 + expected + EclipseInterface.ASSERT_MIDDLE + actual + EclipseInterface.ASSERT_RIGHT);
    }

    private static void failNotSame(Object actual, Object expected, String message) {
        String formatted = "";
        if (message != null) {
            formatted = message + " ";
        }
        Assert.fail(formatted + EclipseInterface.ASSERT_EQUAL_LEFT + expected + EclipseInterface.ASSERT_MIDDLE + actual + EclipseInterface.ASSERT_RIGHT);
    }

    private static void failNotEquals(Object actual, Object expected, String message) {
        Assert.fail(Assert.format(actual, expected, message, true));
    }

    private static void failEquals(Object actual, Object expected, String message) {
        Assert.fail(Assert.format(actual, expected, message, false));
    }

    static String format(Object actual, Object expected, String message, boolean isAssertEquals) {
        String formatted = "";
        if (null != message) {
            formatted = message + " ";
        }
        if (isAssertEquals) {
            return formatted + EclipseInterface.ASSERT_EQUAL_LEFT + expected + EclipseInterface.ASSERT_MIDDLE + actual + EclipseInterface.ASSERT_RIGHT;
        }
        return formatted + EclipseInterface.ASSERT_UNEQUAL_LEFT + expected + EclipseInterface.ASSERT_MIDDLE + actual + EclipseInterface.ASSERT_RIGHT;
    }

    public static void assertEquals(Collection<?> actual, Collection<?> expected) {
        Assert.assertEquals(actual, expected, null);
    }

    public static void assertEquals(Collection<?> actual, Collection<?> expected, String message) {
        if (actual == expected) {
            return;
        }
        if (actual == null || expected == null) {
            if (message != null) {
                Assert.fail(message);
            } else {
                Assert.fail("Collections not equal: expected: " + expected + " and actual: " + actual);
            }
        }
        Assert.assertEquals(actual.size(), expected.size(), (message == null ? "" : message + ": ") + "lists don't have the same size");
        Iterator<?> actIt = actual.iterator();
        Iterator<?> expIt = expected.iterator();
        int i = -1;
        while (actIt.hasNext() && expIt.hasNext()) {
            Object e = expIt.next();
            Object a = actIt.next();
            String explanation = "Lists differ at element [" + ++i + "]: " + e + " != " + a;
            String errorMessage = message == null ? explanation : message + ": " + explanation;
            Assert.assertEqualsImpl(a, e, errorMessage);
        }
    }

    public static void assertEquals(Iterator<?> actual, Iterator<?> expected) {
        Assert.assertEquals(actual, expected, null);
    }

    public static void assertEquals(Iterator<?> actual, Iterator<?> expected, String message) {
        String errorMessage;
        String explanation;
        if (actual == expected) {
            return;
        }
        if (actual == null || expected == null) {
            String msg = message != null ? message : "Iterators not equal: expected: " + expected + " and actual: " + actual;
            Assert.fail(msg);
        }
        int i = -1;
        while (actual.hasNext() && expected.hasNext()) {
            Object e = expected.next();
            Object a = actual.next();
            String explanation2 = "Iterators differ at element [" + ++i + "]: " + e + " != " + a;
            String errorMessage2 = message == null ? explanation2 : message + ": " + explanation2;
            Assert.assertEqualsImpl(a, e, errorMessage2);
        }
        if (actual.hasNext()) {
            explanation = "Actual iterator returned more elements than the expected iterator.";
            errorMessage = message == null ? explanation : message + ": " + explanation;
            Assert.fail(errorMessage);
        } else if (expected.hasNext()) {
            explanation = "Expected iterator returned more elements than the actual iterator.";
            errorMessage = message == null ? explanation : message + ": " + explanation;
            Assert.fail(errorMessage);
        }
    }

    public static void assertEquals(Iterable<?> actual, Iterable<?> expected) {
        Assert.assertEquals(actual, expected, null);
    }

    public static void assertEquals(Iterable<?> actual, Iterable<?> expected, String message) {
        if (actual == expected) {
            return;
        }
        if (actual == null || expected == null) {
            if (message != null) {
                Assert.fail(message);
            } else {
                Assert.fail("Iterables not equal: expected: " + expected + " and actual: " + actual);
            }
        }
        Iterator<?> actIt = actual.iterator();
        Iterator<?> expIt = expected.iterator();
        Assert.assertEquals(actIt, expIt, message);
    }

    public static void assertEquals(Object[] actual, Object[] expected, String message) {
        if (Arrays.equals(actual, expected)) {
            return;
        }
        if (actual == null && expected != null || actual != null && expected == null) {
            if (message != null) {
                Assert.fail(message);
            } else {
                Assert.fail("Arrays not equal: expected: " + Arrays.toString(expected) + " and actual: " + Arrays.toString(actual));
            }
        }
        if (actual.length != expected.length) {
            Assert.failAssertNoEqual("Arrays do not have the same size:" + actual.length + " != " + expected.length, message);
        }
        for (int i = 0; i < expected.length; ++i) {
            String errorMessage;
            Object e = expected[i];
            Object a = actual[i];
            String explanation = "Arrays differ at element [" + i + "]: " + e + " != " + a;
            String string = errorMessage = message == null ? explanation : message + ": " + explanation;
            if (a == null && e == null) continue;
            if (a == null && e != null || a != null && e == null) {
                Assert.failNotEquals(a, e, message);
            }
            if (e.getClass().isArray()) {
                Assert.assertEquals(a, e, errorMessage);
                continue;
            }
            Assert.assertEqualsImpl(a, e, errorMessage);
        }
    }

    public static void assertEqualsNoOrder(Object[] actual, Object[] expected, String message) {
        if (actual == expected) {
            return;
        }
        if (actual == null || expected == null) {
            Assert.failAssertNoEqual("Arrays not equal: expected: " + Arrays.toString(expected) + " and actual: " + Arrays.toString(actual), message);
        }
        if (actual.length != expected.length) {
            Assert.failAssertNoEqual("Arrays do not have the same size:" + actual.length + " != " + expected.length, message);
        }
        List<Object> actualCollection = Lists.newArrayList(actual);
        for (Object o : expected) {
            actualCollection.remove(o);
        }
        if (!actualCollection.isEmpty()) {
            Assert.failAssertNoEqual("Arrays not equal: expected: " + Arrays.toString(expected) + " and actual: " + Arrays.toString(actual), message);
        }
    }

    public static void assertEqualsNoOrder(Collection<?> actual, Collection<?> expected, String message) {
        List<?> actualCollection = Lists.newArrayList(actual);
        actualCollection.removeAll(expected);
        if (!actualCollection.isEmpty()) {
            Assert.failAssertNoEqual("Collections not equal: expected: " + expected + " and actual: " + actual, message);
        }
    }

    public static void assertEqualsNoOrder(Iterator<?> actual, Iterator<?> expected, String message) {
        List<?> actualCollection = Lists.newArrayList(actual);
        actualCollection.removeAll(Lists.newArrayList(expected));
        if (!actualCollection.isEmpty()) {
            Assert.failAssertNoEqual("Iterators not equal: expected: " + Assert.toString(expected) + " and actual: " + Assert.toString(actual), message);
        }
    }

    private static String toString(Iterator<?> iterator) {
        if (iterator == null) {
            return null;
        }
        Iterable iterable = () -> iterator;
        return StreamSupport.stream(iterable.spliterator(), false).map(Object::toString).collect(Collectors.joining(", "));
    }

    private static void failAssertNoEqual(String defaultMessage, String message) {
        if (message != null) {
            Assert.fail(message);
        } else {
            Assert.fail(defaultMessage);
        }
    }

    public static void assertEquals(Object[] actual, Object[] expected) {
        Assert.assertEquals(actual, expected, null);
    }

    public static void assertEqualsNoOrder(Object[] actual, Object[] expected) {
        Assert.assertEqualsNoOrder(actual, expected, null);
    }

    public static void assertEqualsNoOrder(Collection<?> actual, Collection<?> expected) {
        Assert.assertEqualsNoOrder(actual, expected, null);
    }

    public static void assertEqualsNoOrder(Iterator<?> actual, Iterator<?> expected) {
        Assert.assertEqualsNoOrder(actual, expected, null);
    }

    public static void assertEquals(Set<?> actual, Set<?> expected) {
        Assert.assertEquals(actual, expected, null);
    }

    private static String getNotEqualReason(Collection<?> actual, Collection<?> expected) {
        if (actual == expected) {
            return null;
        }
        if (actual == null || expected == null) {
            return "Collections not equal: expected: " + expected + " and actual: " + actual;
        }
        if (!Objects.equals(actual, expected)) {
            return "Collections differ: expected " + expected + " but got " + actual;
        }
        return Assert.getNotEqualReason(actual.iterator(), expected.iterator());
    }

    private static String getNotEqualReason(Iterator<?> actual, Iterator<?> expected) {
        if (actual == expected) {
            return null;
        }
        if (actual == null || expected == null) {
            return "Iterators not equal: expected: " + Assert.toString(expected) + " and actual: " + Assert.toString(actual);
        }
        while (actual.hasNext() && expected.hasNext()) {
            if (Objects.equals(actual.next(), expected.next())) continue;
            return "Iterators not same element order: expected: " + Assert.toString(expected) + " and actual: " + Assert.toString(actual);
        }
        return null;
    }

    private static String getNotEqualReason(Set<?> actual, Set<?> expected) {
        if (actual == expected) {
            return null;
        }
        if (actual == null || expected == null) {
            return "Sets not equal: expected: " + expected + " and actual: " + actual;
        }
        if (!Objects.equals(actual, expected)) {
            return "Sets differ: expected " + expected + " but got " + actual;
        }
        return null;
    }

    public static void assertEquals(Set<?> actual, Set<?> expected, String message) {
        String notEqualReason = Assert.getNotEqualReason(actual, expected);
        if (null != notEqualReason) {
            if (message == null) {
                Assert.fail(notEqualReason);
            } else {
                Assert.fail(message);
            }
        }
    }

    private static String getNotEqualDeepReason(Set<?> actual, Set<?> expected) {
        if (Objects.equals(actual, expected)) {
            return null;
        }
        if (actual == null || expected == null) {
            return "Sets not equal: expected: " + expected + " and actual: " + actual;
        }
        if (expected.size() != actual.size()) {
            return "Sets not equal: expected: " + expected + " and actual: " + actual;
        }
        Iterator<?> actualIterator = actual.iterator();
        for (Object expectedValue : expected) {
            Object value = actualIterator.next();
            if (expectedValue.getClass().isArray()) {
                String arrayNotEqualReason = Assert.getArrayNotEqualReason(value, expectedValue);
                if (arrayNotEqualReason == null) continue;
                return arrayNotEqualReason;
            }
            if (Assert.areEqualImpl(value, expected)) continue;
            return "Sets not equal: expected: " + expectedValue + " and actual: " + value;
        }
        return null;
    }

    public static void assertEqualsDeep(Set<?> actual, Set<?> expected, String message) {
        String notEqualDeepReason = Assert.getNotEqualDeepReason(actual, expected);
        if (notEqualDeepReason != null) {
            if (message == null) {
                Assert.fail(notEqualDeepReason);
            } else {
                Assert.fail(message);
            }
        }
    }

    public static void assertEquals(Map<?, ?> actual, Map<?, ?> expected) {
        Assert.assertEquals(actual, expected, null);
    }

    private static String getNotEqualReason(Map<?, ?> actual, Map<?, ?> expected) {
        if (Objects.equals(actual, expected)) {
            return null;
        }
        if (actual == null || expected == null) {
            return "Maps not equal: expected: " + expected + " and actual: " + actual;
        }
        if (actual.size() != expected.size()) {
            return "Maps do not have the same size:" + actual.size() + " != " + expected.size();
        }
        Set<Map.Entry<?, ?>> entrySet = actual.entrySet();
        Iterator<Map.Entry<?, ?>> iterator = entrySet.iterator();
        while (iterator.hasNext()) {
            Map.Entry<?, ?> anEntrySet;
            Map.Entry<?, ?> entry = anEntrySet = iterator.next();
            Object key = entry.getKey();
            Object value = entry.getValue();
            Object expectedValue = expected.get(key);
            String assertMessage = "Maps do not match for key:" + key + " actual:" + value + " expected:" + expectedValue;
            if (Assert.areEqualImpl(value, expectedValue)) continue;
            return assertMessage;
        }
        return null;
    }

    public static void assertEquals(Map<?, ?> actual, Map<?, ?> expected, String message) {
        String notEqualReason = Assert.getNotEqualReason(actual, expected);
        if (notEqualReason != null) {
            if (message == null) {
                Assert.fail(notEqualReason);
            } else {
                Assert.fail(message);
            }
        }
    }

    public static void assertEqualsDeep(Map<?, ?> actual, Map<?, ?> expected) {
        Assert.assertEqualsDeep(actual, expected, null);
    }

    private static String getNotEqualDeepReason(Map<?, ?> actual, Map<?, ?> expected) {
        if (Objects.equals(actual, expected)) {
            return null;
        }
        if (actual == null || expected == null) {
            return "Maps not equal: expected: " + expected + " and actual: " + actual;
        }
        if (actual.size() != expected.size()) {
            return "Maps do not have the same size:" + actual.size() + " != " + expected.size();
        }
        Set<Map.Entry<?, ?>> entrySet = actual.entrySet();
        Iterator<Map.Entry<?, ?>> iterator = entrySet.iterator();
        while (iterator.hasNext()) {
            Map.Entry<?, ?> anEntrySet;
            Map.Entry<?, ?> entry = anEntrySet = iterator.next();
            Object key = entry.getKey();
            Object value = entry.getValue();
            Object expectedValue = expected.get(key);
            String assertMessage = "Maps do not match for key:" + key + " actual:" + value + " expected:" + expectedValue;
            if (!(expectedValue.getClass().isArray() ? !Assert.areArraysEqual(value, expectedValue) : !Assert.areEqualImpl(value, expectedValue))) continue;
            return assertMessage;
        }
        return null;
    }

    public static void assertEqualsDeep(Map<?, ?> actual, Map<?, ?> expected, String message) {
        String notEqualDeepReason = Assert.getNotEqualDeepReason(actual, expected);
        if (notEqualDeepReason != null) {
            if (message == null) {
                Assert.fail(notEqualDeepReason);
            } else {
                Assert.fail(message);
            }
        }
    }

    public static void assertNotEquals(Object actual, Object expected, String message) {
        if (expected != null && expected.getClass().isArray()) {
            Assert.assertArrayNotEquals(actual, expected, message);
            return;
        }
        Assert.assertNotEqualsImpl(actual, expected, message);
    }

    public static void assertNotEquals(Object[] actual, Object[] expected, String message) {
        Assert.assertArrayNotEquals(actual, expected, message);
    }

    public static void assertNotEquals(Iterator<?> actual, Iterator<?> expected, String message) {
        String notEqualReason = Assert.getNotEqualReason(actual, expected);
        if (notEqualReason == null) {
            Assert.fail(Assert.format(actual, expected, message, false));
        }
    }

    public static void assertNotEquals(Collection<?> actual, Collection<?> expected, String message) {
        String notEqualReason = Assert.getNotEqualReason(actual, expected);
        if (notEqualReason == null) {
            Assert.fail(Assert.format(actual, expected, message, false));
        }
    }

    public static void assertNotEquals(Object actual, Object expected) {
        Assert.assertNotEquals(actual, expected, null);
    }

    public static void assertNotEquals(Collection<?> actual, Collection<?> expected) {
        Assert.assertNotEquals(actual, expected, null);
    }

    public static void assertNotEquals(Iterator<?> actual, Iterator<?> expected) {
        Assert.assertNotEquals(actual, expected, null);
    }

    static void assertNotEquals(String actual, String expected, String message) {
        Assert.assertNotEquals((Object)actual, (Object)expected, message);
    }

    static void assertNotEquals(String actual, String expectec) {
        Assert.assertNotEquals(actual, expectec, null);
    }

    static void assertNotEquals(long actual, long expected, String message) {
        Assert.assertNotEquals((Object)actual, (Object)expected, message);
    }

    static void assertNotEquals(long actual, long expected) {
        Assert.assertNotEquals(actual, expected, null);
    }

    static void assertNotEquals(boolean actual, boolean expected, String message) {
        Assert.assertNotEquals((Object)actual, (Object)expected, message);
    }

    static void assertNotEquals(boolean actual, boolean expected) {
        Assert.assertNotEquals(actual, expected, null);
    }

    static void assertNotEquals(byte actual, byte expected, String message) {
        Assert.assertNotEquals((Object)actual, (Object)expected, message);
    }

    static void assertNotEquals(byte actual, byte expected) {
        Assert.assertNotEquals(actual, expected, null);
    }

    static void assertNotEquals(char actual, char expected, String message) {
        Assert.assertNotEquals(Character.valueOf(actual), Character.valueOf(expected), message);
    }

    static void assertNotEquals(char actual, char expected) {
        Assert.assertNotEquals(actual, expected, null);
    }

    static void assertNotEquals(short actual, short expected, String message) {
        Assert.assertNotEquals((Object)actual, (Object)expected, message);
    }

    static void assertNotEquals(short actual, short expected) {
        Assert.assertNotEquals(actual, expected, null);
    }

    static void assertNotEquals(int actual, int expected, String message) {
        Assert.assertNotEquals((Object)actual, (Object)expected, message);
    }

    static void assertNotEquals(int actual, int expected) {
        Assert.assertNotEquals(actual, expected, null);
    }

    public static void assertNotEquals(float actual, float expected, float delta, String message) {
        if (Assert.areEqual(actual, expected, delta)) {
            Assert.fail(Assert.format(Float.valueOf(actual), Float.valueOf(expected), message, false));
        }
    }

    public static void assertNotEquals(float actual, float expected, float delta) {
        Assert.assertNotEquals(actual, expected, delta, null);
    }

    public static void assertNotEquals(double actual, double expected, double delta, String message) {
        if (Assert.areEqual(actual, expected, delta)) {
            Assert.fail(Assert.format(actual, expected, message, false));
        }
    }

    public static void assertNotEquals(Set<?> actual, Set<?> expected) {
        Assert.assertNotEquals(actual, expected, null);
    }

    public static void assertNotEquals(Set<?> actual, Set<?> expected, String message) {
        String notEqualReason = Assert.getNotEqualReason(actual, expected);
        if (notEqualReason == null) {
            Assert.fail(Assert.format(actual, expected, message, false));
        }
    }

    public static void assertNotEqualsDeep(Set<?> actual, Set<?> expected) {
        Assert.assertNotEqualsDeep(actual, expected, null);
    }

    public static void assertNotEqualsDeep(Set<?> actual, Set<?> expected, String message) {
        String notEqualDeepReason = Assert.getNotEqualDeepReason(actual, expected);
        if (notEqualDeepReason == null) {
            Assert.fail(Assert.format(actual, expected, message, false));
        }
    }

    public static void assertNotEquals(Map<?, ?> actual, Map<?, ?> expected) {
        Assert.assertNotEquals(actual, expected, null);
    }

    public static void assertNotEquals(Map<?, ?> actual, Map<?, ?> expected, String message) {
        String notEqualReason = Assert.getNotEqualReason(actual, expected);
        if (notEqualReason == null) {
            Assert.fail(Assert.format(actual, expected, message, false));
        }
    }

    public static void assertNotEqualsDeep(Map<?, ?> actual, Map<?, ?> expected) {
        Assert.assertNotEqualsDeep(actual, expected, null);
    }

    public static void assertNotEqualsDeep(Map<?, ?> actual, Map<?, ?> expected, String message) {
        String notEqualDeepReason = Assert.getNotEqualDeepReason(actual, expected);
        if (notEqualDeepReason == null) {
            Assert.fail(Assert.format(actual, expected, message, false));
        }
    }

    public static void assertNotEquals(double actual, double expected, double delta) {
        Assert.assertNotEquals(actual, expected, delta, null);
    }

    public static void assertThrows(ThrowingRunnable runnable) {
        Assert.assertThrows(Throwable.class, runnable);
    }

    public static <T extends Throwable> void assertThrows(Class<T> throwableClass, ThrowingRunnable runnable) {
        Assert.expectThrows(throwableClass, runnable);
    }

    public static <T extends Throwable> T expectThrows(Class<T> throwableClass, ThrowingRunnable runnable) {
        try {
            runnable.run();
        }
        catch (Throwable t) {
            if (throwableClass.isInstance(t)) {
                return (T)((Throwable)throwableClass.cast(t));
            }
            String mismatchMessage = String.format("Expected %s to be thrown, but %s was thrown", throwableClass.getSimpleName(), t.getClass().getSimpleName());
            throw new AssertionError(mismatchMessage, t);
        }
        String message = String.format("Expected %s to be thrown, but nothing was thrown", throwableClass.getSimpleName());
        throw new AssertionError((Object)message);
    }

    public static interface ThrowingRunnable {
        public void run() throws Throwable;
    }
}

