/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs.server.namenode;

import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.ConcurrentModificationException;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.classification.InterfaceStability;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hdfs.server.namenode.TreePath;
import org.apache.hadoop.hdfs.server.namenode.TreeWalk;

@InterfaceAudience.Public
@InterfaceStability.Unstable
public class FSTreeWalk
extends TreeWalk {
    private final Path root;
    private final FileSystem fs;

    public FSTreeWalk(Path root, Configuration conf) throws IOException {
        this.root = root;
        this.fs = root.getFileSystem(conf);
    }

    @Override
    protected Iterable<TreePath> getChildren(TreePath path, long id, TreeWalk.TreeIterator i) {
        if (!path.getFileStatus().isDirectory()) {
            return Collections.emptyList();
        }
        try {
            ArrayList<TreePath> ret = new ArrayList<TreePath>();
            for (FileStatus s : this.fs.listStatus(path.getFileStatus().getPath())) {
                ret.add(new TreePath(s, id, i, this.fs));
            }
            return ret;
        }
        catch (FileNotFoundException e) {
            throw new ConcurrentModificationException("FS modified");
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public TreeWalk.TreeIterator iterator() {
        try {
            return new FSTreeIterator(this.root);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    class FSTreeIterator
    extends TreeWalk.TreeIterator {
        private FSTreeIterator() {
        }

        FSTreeIterator(TreePath p) {
            this.getPendingQueue().addFirst(new TreePath(p.getFileStatus(), p.getParentId(), this, FSTreeWalk.this.fs));
        }

        FSTreeIterator(Path p) throws IOException {
            try {
                FileStatus s = FSTreeWalk.this.fs.getFileStatus(FSTreeWalk.this.root);
                this.getPendingQueue().addFirst(new TreePath(s, -1L, this, FSTreeWalk.this.fs));
            }
            catch (FileNotFoundException e) {
                if (p.equals((Object)FSTreeWalk.this.root)) {
                    throw e;
                }
                throw new ConcurrentModificationException("FS modified");
            }
        }

        @Override
        public TreeWalk.TreeIterator fork() {
            if (this.getPendingQueue().isEmpty()) {
                return new FSTreeIterator();
            }
            return new FSTreeIterator(this.getPendingQueue().removeFirst());
        }
    }
}

