/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.server.resourcemanager.recovery;

import com.google.common.annotations.VisibleForTesting;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.Closeable;
import java.io.DataInput;
import java.io.DataInputStream;
import java.io.DataOutput;
import java.io.DataOutputStream;
import java.io.File;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.LocalFileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.fs.permission.FsPermission;
import org.apache.hadoop.io.IOUtils;
import org.apache.hadoop.security.token.delegation.DelegationKey;
import org.apache.hadoop.yarn.api.records.ApplicationAttemptId;
import org.apache.hadoop.yarn.api.records.ApplicationId;
import org.apache.hadoop.yarn.api.records.ReservationId;
import org.apache.hadoop.yarn.exceptions.YarnRuntimeException;
import org.apache.hadoop.yarn.proto.YarnProtos;
import org.apache.hadoop.yarn.proto.YarnServerResourceManagerRecoveryProtos;
import org.apache.hadoop.yarn.security.client.RMDelegationTokenIdentifier;
import org.apache.hadoop.yarn.security.client.YARNDelegationTokenIdentifier;
import org.apache.hadoop.yarn.server.records.Version;
import org.apache.hadoop.yarn.server.resourcemanager.DBManager;
import org.apache.hadoop.yarn.server.resourcemanager.recovery.RMStateStore;
import org.apache.hadoop.yarn.server.resourcemanager.recovery.RMStateStoreUtils;
import org.apache.hadoop.yarn.server.resourcemanager.recovery.records.AMRMTokenSecretManagerState;
import org.apache.hadoop.yarn.server.resourcemanager.recovery.records.ApplicationAttemptStateData;
import org.apache.hadoop.yarn.server.resourcemanager.recovery.records.ApplicationStateData;
import org.apache.hadoop.yarn.server.resourcemanager.recovery.records.Epoch;
import org.apache.hadoop.yarn.server.resourcemanager.recovery.records.RMDelegationTokenIdentifierData;
import org.apache.hadoop.yarn.server.resourcemanager.recovery.records.impl.pb.AMRMTokenSecretManagerStatePBImpl;
import org.apache.hadoop.yarn.server.resourcemanager.recovery.records.impl.pb.ApplicationAttemptStateDataPBImpl;
import org.apache.hadoop.yarn.server.resourcemanager.recovery.records.impl.pb.ApplicationStateDataPBImpl;
import org.apache.hadoop.yarn.server.utils.LeveldbIterator;
import org.fusesource.leveldbjni.JniDBFactory;
import org.iq80.leveldb.DB;
import org.iq80.leveldb.DBException;
import org.iq80.leveldb.Options;
import org.iq80.leveldb.WriteBatch;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LeveldbRMStateStore
extends RMStateStore {
    public static final Logger LOG = LoggerFactory.getLogger(LeveldbRMStateStore.class);
    private static final String SEPARATOR = "/";
    private static final String DB_NAME = "yarn-rm-state";
    private static final String RM_DT_MASTER_KEY_KEY_PREFIX = "RMDTSecretManagerRoot/DelegationKey_";
    private static final String RM_DT_TOKEN_KEY_PREFIX = "RMDTSecretManagerRoot/RMDelegationToken_";
    private static final String RM_DT_SEQUENCE_NUMBER_KEY = "RMDTSecretManagerRoot/RMDTSequentialNumber";
    private static final String RM_APP_KEY_PREFIX = "RMAppRoot/application";
    private static final String RM_RESERVATION_KEY_PREFIX = "ReservationSystemRoot/";
    private static final Version CURRENT_VERSION_INFO = Version.newInstance((int)1, (int)1);
    private DB db;
    private DBManager dbManager = new DBManager();
    private long compactionIntervalMsec;

    private String getApplicationNodeKey(ApplicationId appId) {
        return "RMAppRoot/" + appId;
    }

    private String getApplicationAttemptNodeKey(ApplicationAttemptId attemptId) {
        return this.getApplicationAttemptNodeKey(this.getApplicationNodeKey(attemptId.getApplicationId()), attemptId);
    }

    private String getApplicationAttemptNodeKey(String appNodeKey, ApplicationAttemptId attemptId) {
        return appNodeKey + SEPARATOR + attemptId;
    }

    private String getRMDTMasterKeyNodeKey(DelegationKey masterKey) {
        return RM_DT_MASTER_KEY_KEY_PREFIX + masterKey.getKeyId();
    }

    private String getRMDTTokenNodeKey(RMDelegationTokenIdentifier tokenId) {
        return RM_DT_TOKEN_KEY_PREFIX + tokenId.getSequenceNumber();
    }

    private String getReservationNodeKey(String planName, String reservationId) {
        return RM_RESERVATION_KEY_PREFIX + planName + SEPARATOR + reservationId;
    }

    @Override
    protected void initInternal(Configuration conf) {
        this.compactionIntervalMsec = conf.getLong("yarn.resourcemanager.leveldb-state-store.compaction-interval-secs", 3600L) * 1000L;
    }

    private Path getStorageDir() throws IOException {
        Configuration conf = this.getConfig();
        String storePath = conf.get("yarn.resourcemanager.leveldb-state-store.path");
        if (storePath == null) {
            throw new IOException("No store location directory configured in yarn.resourcemanager.leveldb-state-store.path");
        }
        return new Path(storePath, DB_NAME);
    }

    private Path createStorageDir() throws IOException {
        Path root = this.getStorageDir();
        LocalFileSystem fs = FileSystem.getLocal((Configuration)this.getConfig());
        fs.mkdirs(root, new FsPermission(448));
        return root;
    }

    @Override
    protected void startInternal() throws Exception {
        Path storeRoot = this.createStorageDir();
        Options options = new Options();
        options.createIfMissing(false);
        LOG.info("Using state database at " + storeRoot + " for recovery");
        File dbfile = new File(storeRoot.toString());
        this.db = this.dbManager.initDatabase(dbfile, options, database -> this.storeVersion(CURRENT_VERSION_INFO));
        this.dbManager.startCompactionTimer(this.compactionIntervalMsec, ((Object)((Object)this)).getClass().getSimpleName());
    }

    @Override
    protected void closeInternal() throws Exception {
        this.dbManager.close();
    }

    @VisibleForTesting
    boolean isClosed() {
        return this.db == null;
    }

    @VisibleForTesting
    DB getDatabase() {
        return this.db;
    }

    @Override
    protected Version loadVersion() throws Exception {
        return this.dbManager.loadVersion("RMVersionNode");
    }

    @Override
    protected void storeVersion() throws Exception {
        try {
            this.storeVersion(CURRENT_VERSION_INFO);
        }
        catch (DBException e) {
            throw new IOException(e);
        }
    }

    protected void storeVersion(Version version) {
        this.dbManager.storeVersion("RMVersionNode", version);
    }

    @Override
    protected Version getCurrentVersion() {
        return CURRENT_VERSION_INFO;
    }

    @Override
    public synchronized long getAndIncrementEpoch() throws Exception {
        long currentEpoch = this.baseEpoch;
        byte[] dbKeyBytes = JniDBFactory.bytes((String)"EpochNode");
        try {
            byte[] data = this.db.get(dbKeyBytes);
            if (data != null) {
                currentEpoch = YarnServerResourceManagerRecoveryProtos.EpochProto.parseFrom(data).getEpoch();
            }
            YarnServerResourceManagerRecoveryProtos.EpochProto proto = Epoch.newInstance(this.nextEpoch(currentEpoch)).getProto();
            this.db.put(dbKeyBytes, proto.toByteArray());
        }
        catch (DBException e) {
            throw new IOException(e);
        }
        return currentEpoch;
    }

    @Override
    public RMStateStore.RMState loadState() throws Exception {
        RMStateStore.RMState rmState = new RMStateStore.RMState();
        this.loadRMDTSecretManagerState(rmState);
        this.loadRMApps(rmState);
        this.loadAMRMTokenSecretManagerState(rmState);
        this.loadReservationState(rmState);
        return rmState;
    }

    private void loadReservationState(RMStateStore.RMState rmState) throws IOException {
        int numReservations = 0;
        try (LeveldbIterator iter = new LeveldbIterator(this.db);){
            iter.seek(JniDBFactory.bytes((String)RM_RESERVATION_KEY_PREFIX));
            while (iter.hasNext()) {
                Map.Entry entry = iter.next();
                String key = JniDBFactory.asString((byte[])((byte[])entry.getKey()));
                if (!key.startsWith(RM_RESERVATION_KEY_PREFIX)) {
                    break;
                }
                String planReservationString = key.substring(RM_RESERVATION_KEY_PREFIX.length());
                String[] parts = planReservationString.split(SEPARATOR);
                if (parts.length != 2) {
                    LOG.warn("Incorrect reservation state key " + key);
                    continue;
                }
                String planName = parts[0];
                String reservationName = parts[1];
                YarnProtos.ReservationAllocationStateProto allocationState = YarnProtos.ReservationAllocationStateProto.parseFrom((byte[])((byte[])entry.getValue()));
                if (!rmState.getReservationState().containsKey(planName)) {
                    rmState.getReservationState().put(planName, new HashMap());
                }
                ReservationId reservationId = ReservationId.parseReservationId((String)reservationName);
                rmState.getReservationState().get(planName).put(reservationId, allocationState);
                ++numReservations;
            }
        }
        catch (DBException e) {
            throw new IOException(e);
        }
        LOG.info("Recovered " + numReservations + " reservations");
    }

    private void loadRMDTSecretManagerState(RMStateStore.RMState state) throws IOException {
        int numKeys = this.loadRMDTSecretManagerKeys(state);
        LOG.info("Recovered " + numKeys + " RM delegation token master keys");
        int numTokens = this.loadRMDTSecretManagerTokens(state);
        LOG.info("Recovered " + numTokens + " RM delegation tokens");
        this.loadRMDTSecretManagerTokenSequenceNumber(state);
    }

    private int loadRMDTSecretManagerKeys(RMStateStore.RMState state) throws IOException {
        int numKeys = 0;
        try (LeveldbIterator iter = new LeveldbIterator(this.db);){
            iter.seek(JniDBFactory.bytes((String)RM_DT_MASTER_KEY_KEY_PREFIX));
            while (iter.hasNext()) {
                Map.Entry entry = iter.next();
                String key = JniDBFactory.asString((byte[])((byte[])entry.getKey()));
                if (!key.startsWith(RM_DT_MASTER_KEY_KEY_PREFIX)) {
                    break;
                }
                DelegationKey masterKey = this.loadDelegationKey((byte[])entry.getValue());
                state.rmSecretManagerState.masterKeyState.add(masterKey);
                ++numKeys;
                if (!LOG.isDebugEnabled()) continue;
                LOG.debug("Loaded RM delegation key from " + key + ": keyId=" + masterKey.getKeyId() + ", expirationDate=" + masterKey.getExpiryDate());
            }
        }
        catch (DBException e) {
            throw new IOException(e);
        }
        return numKeys;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private DelegationKey loadDelegationKey(byte[] data) throws IOException {
        DelegationKey key = new DelegationKey();
        DataInputStream in = new DataInputStream(new ByteArrayInputStream(data));
        try {
            key.readFields((DataInput)in);
        }
        catch (Throwable throwable) {
            IOUtils.cleanupWithLogger((Logger)LOG, (Closeable[])new Closeable[]{in});
            throw throwable;
        }
        IOUtils.cleanupWithLogger((Logger)LOG, (Closeable[])new Closeable[]{in});
        return key;
    }

    private int loadRMDTSecretManagerTokens(RMStateStore.RMState state) throws IOException {
        int numTokens = 0;
        try (LeveldbIterator iter = new LeveldbIterator(this.db);){
            iter.seek(JniDBFactory.bytes((String)RM_DT_TOKEN_KEY_PREFIX));
            while (iter.hasNext()) {
                Map.Entry entry = iter.next();
                String key = JniDBFactory.asString((byte[])((byte[])entry.getKey()));
                if (!key.startsWith(RM_DT_TOKEN_KEY_PREFIX)) {
                    break;
                }
                RMDelegationTokenIdentifierData tokenData = this.loadDelegationToken((byte[])entry.getValue());
                RMDelegationTokenIdentifier tokenId = tokenData.getTokenIdentifier();
                long renewDate = tokenData.getRenewDate();
                state.rmSecretManagerState.delegationTokenState.put(tokenId, renewDate);
                ++numTokens;
                if (!LOG.isDebugEnabled()) continue;
                LOG.debug("Loaded RM delegation token from " + key + ": tokenId=" + tokenId + ", renewDate=" + renewDate);
            }
        }
        catch (DBException e) {
            throw new IOException(e);
        }
        return numTokens;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private RMDelegationTokenIdentifierData loadDelegationToken(byte[] data) throws IOException {
        RMDelegationTokenIdentifierData tokenData;
        DataInputStream in = new DataInputStream(new ByteArrayInputStream(data));
        try {
            tokenData = RMStateStoreUtils.readRMDelegationTokenIdentifierData(in);
        }
        catch (Throwable throwable) {
            IOUtils.cleanupWithLogger((Logger)LOG, (Closeable[])new Closeable[]{in});
            throw throwable;
        }
        IOUtils.cleanupWithLogger((Logger)LOG, (Closeable[])new Closeable[]{in});
        return tokenData;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void loadRMDTSecretManagerTokenSequenceNumber(RMStateStore.RMState state) throws IOException {
        byte[] data;
        try {
            data = this.db.get(JniDBFactory.bytes((String)RM_DT_SEQUENCE_NUMBER_KEY));
        }
        catch (DBException e) {
            throw new IOException(e);
        }
        if (data != null) {
            DataInputStream in = new DataInputStream(new ByteArrayInputStream(data));
            try {
                state.rmSecretManagerState.dtSequenceNumber = in.readInt();
            }
            catch (Throwable throwable) {
                IOUtils.cleanupWithLogger((Logger)LOG, (Closeable[])new Closeable[]{in});
                throw throwable;
            }
            IOUtils.cleanupWithLogger((Logger)LOG, (Closeable[])new Closeable[]{in});
        }
    }

    private void loadRMApps(RMStateStore.RMState state) throws IOException {
        int numApps = 0;
        int numAppAttempts = 0;
        try (LeveldbIterator iter = new LeveldbIterator(this.db);){
            iter.seek(JniDBFactory.bytes((String)RM_APP_KEY_PREFIX));
            while (iter.hasNext()) {
                Map.Entry entry = iter.next();
                String key = JniDBFactory.asString((byte[])((byte[])entry.getKey()));
                if (!key.startsWith(RM_APP_KEY_PREFIX)) {
                    break;
                }
                String appIdStr = key.substring("RMAppRoot".length() + 1);
                if (appIdStr.contains(SEPARATOR)) {
                    LOG.warn("Skipping extraneous data " + key);
                    continue;
                }
                numAppAttempts += this.loadRMApp(state, iter, appIdStr, (byte[])entry.getValue());
                ++numApps;
            }
        }
        catch (DBException e) {
            throw new IOException(e);
        }
        LOG.info("Recovered " + numApps + " applications and " + numAppAttempts + " application attempts");
    }

    private int loadRMApp(RMStateStore.RMState rmState, LeveldbIterator iter, String appIdStr, byte[] appData) throws IOException {
        Map.Entry entry;
        String key;
        ApplicationStateData appState = this.createApplicationState(appIdStr, appData);
        ApplicationId appId = appState.getApplicationSubmissionContext().getApplicationId();
        rmState.appState.put(appId, appState);
        String attemptNodePrefix = this.getApplicationNodeKey(appId) + SEPARATOR;
        while (iter.hasNext() && (key = JniDBFactory.asString((byte[])((byte[])(entry = iter.peekNext()).getKey()))).startsWith(attemptNodePrefix)) {
            String attemptId = key.substring(attemptNodePrefix.length());
            if (attemptId.startsWith("appattempt")) {
                ApplicationAttemptStateData attemptState = this.createAttemptState(attemptId, (byte[])entry.getValue());
                appState.attempts.put(attemptState.getAttemptId(), attemptState);
            } else {
                LOG.warn("Ignoring unknown application key: " + key);
            }
            iter.next();
        }
        int numAttempts = appState.attempts.size();
        if (LOG.isDebugEnabled()) {
            LOG.debug("Loaded application " + appId + " with " + numAttempts + " attempts");
        }
        return numAttempts;
    }

    private ApplicationStateData createApplicationState(String appIdStr, byte[] data) throws IOException {
        ApplicationStateDataPBImpl appState;
        ApplicationId appId = ApplicationId.fromString((String)appIdStr);
        if (!appId.equals((Object)(appState = new ApplicationStateDataPBImpl(YarnServerResourceManagerRecoveryProtos.ApplicationStateDataProto.parseFrom(data))).getApplicationSubmissionContext().getApplicationId())) {
            throw new YarnRuntimeException("The database entry for " + appId + " contains data for " + appState.getApplicationSubmissionContext().getApplicationId());
        }
        return appState;
    }

    @VisibleForTesting
    ApplicationStateData loadRMAppState(ApplicationId appId) throws IOException {
        byte[] data;
        String appKey = this.getApplicationNodeKey(appId);
        try {
            data = this.db.get(JniDBFactory.bytes((String)appKey));
        }
        catch (DBException e) {
            throw new IOException(e);
        }
        if (data == null) {
            return null;
        }
        return this.createApplicationState(appId.toString(), data);
    }

    @VisibleForTesting
    ApplicationAttemptStateData loadRMAppAttemptState(ApplicationAttemptId attemptId) throws IOException {
        byte[] data;
        String attemptKey = this.getApplicationAttemptNodeKey(attemptId);
        try {
            data = this.db.get(JniDBFactory.bytes((String)attemptKey));
        }
        catch (DBException e) {
            throw new IOException(e);
        }
        if (data == null) {
            return null;
        }
        return this.createAttemptState(attemptId.toString(), data);
    }

    private ApplicationAttemptStateData createAttemptState(String itemName, byte[] data) throws IOException {
        ApplicationAttemptStateDataPBImpl attemptState;
        ApplicationAttemptId attemptId = ApplicationAttemptId.fromString((String)itemName);
        if (!attemptId.equals((Object)(attemptState = new ApplicationAttemptStateDataPBImpl(YarnServerResourceManagerRecoveryProtos.ApplicationAttemptStateDataProto.parseFrom(data))).getAttemptId())) {
            throw new YarnRuntimeException("The database entry for " + attemptId + " contains data for " + attemptState.getAttemptId());
        }
        return attemptState;
    }

    private void loadAMRMTokenSecretManagerState(RMStateStore.RMState rmState) throws IOException {
        try {
            byte[] data = this.db.get(JniDBFactory.bytes((String)"AMRMTokenSecretManagerRoot"));
            if (data != null) {
                AMRMTokenSecretManagerStatePBImpl stateData = new AMRMTokenSecretManagerStatePBImpl(YarnServerResourceManagerRecoveryProtos.AMRMTokenSecretManagerStateProto.parseFrom(data));
                rmState.amrmTokenSecretManagerState = AMRMTokenSecretManagerState.newInstance(stateData.getCurrentMasterKey(), stateData.getNextMasterKey());
            }
        }
        catch (DBException e) {
            throw new IOException(e);
        }
    }

    @Override
    protected void storeApplicationStateInternal(ApplicationId appId, ApplicationStateData appStateData) throws IOException {
        String key = this.getApplicationNodeKey(appId);
        if (LOG.isDebugEnabled()) {
            LOG.debug("Storing state for app " + appId + " at " + key);
        }
        try {
            this.db.put(JniDBFactory.bytes((String)key), appStateData.getProto().toByteArray());
        }
        catch (DBException e) {
            throw new IOException(e);
        }
    }

    @Override
    protected void updateApplicationStateInternal(ApplicationId appId, ApplicationStateData appStateData) throws IOException {
        this.storeApplicationStateInternal(appId, appStateData);
    }

    @Override
    protected void storeApplicationAttemptStateInternal(ApplicationAttemptId attemptId, ApplicationAttemptStateData attemptStateData) throws IOException {
        String key = this.getApplicationAttemptNodeKey(attemptId);
        if (LOG.isDebugEnabled()) {
            LOG.debug("Storing state for attempt " + attemptId + " at " + key);
        }
        try {
            this.db.put(JniDBFactory.bytes((String)key), attemptStateData.getProto().toByteArray());
        }
        catch (DBException e) {
            throw new IOException(e);
        }
    }

    @Override
    protected void updateApplicationAttemptStateInternal(ApplicationAttemptId attemptId, ApplicationAttemptStateData attemptStateData) throws IOException {
        this.storeApplicationAttemptStateInternal(attemptId, attemptStateData);
    }

    @Override
    public synchronized void removeApplicationAttemptInternal(ApplicationAttemptId attemptId) throws IOException {
        String attemptKey = this.getApplicationAttemptNodeKey(attemptId);
        if (LOG.isDebugEnabled()) {
            LOG.debug("Removing state for attempt " + attemptId + " at " + attemptKey);
        }
        try {
            this.db.delete(JniDBFactory.bytes((String)attemptKey));
        }
        catch (DBException e) {
            throw new IOException(e);
        }
    }

    @Override
    protected void removeApplicationStateInternal(ApplicationStateData appState) throws IOException {
        ApplicationId appId = appState.getApplicationSubmissionContext().getApplicationId();
        String appKey = this.getApplicationNodeKey(appId);
        try (WriteBatch batch = this.db.createWriteBatch();){
            batch.delete(JniDBFactory.bytes((String)appKey));
            for (ApplicationAttemptId attemptId : appState.attempts.keySet()) {
                String attemptKey = this.getApplicationAttemptNodeKey(appKey, attemptId);
                batch.delete(JniDBFactory.bytes((String)attemptKey));
            }
            if (LOG.isDebugEnabled()) {
                LOG.debug("Removing state for app " + appId + " and " + appState.attempts.size() + " attempts at " + appKey);
            }
            this.db.write(batch);
        }
        catch (DBException e) {
            throw new IOException(e);
        }
    }

    @Override
    protected void storeReservationState(YarnProtos.ReservationAllocationStateProto reservationAllocation, String planName, String reservationIdName) throws Exception {
        try (WriteBatch batch = this.db.createWriteBatch();){
            String key = this.getReservationNodeKey(planName, reservationIdName);
            if (LOG.isDebugEnabled()) {
                LOG.debug("Storing state for reservation " + reservationIdName + " plan " + planName + " at " + key);
            }
            batch.put(JniDBFactory.bytes((String)key), reservationAllocation.toByteArray());
            this.db.write(batch);
        }
        catch (DBException e) {
            throw new IOException(e);
        }
    }

    @Override
    protected void removeReservationState(String planName, String reservationIdName) throws Exception {
        try (WriteBatch batch = this.db.createWriteBatch();){
            String reservationKey = this.getReservationNodeKey(planName, reservationIdName);
            batch.delete(JniDBFactory.bytes((String)reservationKey));
            if (LOG.isDebugEnabled()) {
                LOG.debug("Removing state for reservation " + reservationIdName + " plan " + planName + " at " + reservationKey);
            }
            this.db.write(batch);
        }
        catch (DBException e) {
            throw new IOException(e);
        }
    }

    private void storeOrUpdateRMDT(RMDelegationTokenIdentifier tokenId, Long renewDate, boolean isUpdate) throws IOException {
        String tokenKey = this.getRMDTTokenNodeKey(tokenId);
        RMDelegationTokenIdentifierData tokenData = new RMDelegationTokenIdentifierData((YARNDelegationTokenIdentifier)tokenId, renewDate);
        if (LOG.isDebugEnabled()) {
            LOG.debug("Storing token to " + tokenKey);
        }
        try (WriteBatch batch = this.db.createWriteBatch();){
            batch.put(JniDBFactory.bytes((String)tokenKey), tokenData.toByteArray());
            if (!isUpdate) {
                ByteArrayOutputStream bs = new ByteArrayOutputStream();
                try (DataOutputStream ds = new DataOutputStream(bs);){
                    ds.writeInt(tokenId.getSequenceNumber());
                }
                if (LOG.isDebugEnabled()) {
                    LOG.debug("Storing " + tokenId.getSequenceNumber() + " to " + RM_DT_SEQUENCE_NUMBER_KEY);
                }
                batch.put(JniDBFactory.bytes((String)RM_DT_SEQUENCE_NUMBER_KEY), bs.toByteArray());
            }
            this.db.write(batch);
        }
        catch (DBException e) {
            throw new IOException(e);
        }
    }

    @Override
    protected void storeRMDelegationTokenState(RMDelegationTokenIdentifier tokenId, Long renewDate) throws IOException {
        this.storeOrUpdateRMDT(tokenId, renewDate, false);
    }

    @Override
    protected void updateRMDelegationTokenState(RMDelegationTokenIdentifier tokenId, Long renewDate) throws IOException {
        this.storeOrUpdateRMDT(tokenId, renewDate, true);
    }

    @Override
    protected void removeRMDelegationTokenState(RMDelegationTokenIdentifier tokenId) throws IOException {
        String tokenKey = this.getRMDTTokenNodeKey(tokenId);
        if (LOG.isDebugEnabled()) {
            LOG.debug("Removing token at " + tokenKey);
        }
        try {
            this.db.delete(JniDBFactory.bytes((String)tokenKey));
        }
        catch (DBException e) {
            throw new IOException(e);
        }
    }

    @Override
    protected void storeRMDTMasterKeyState(DelegationKey masterKey) throws IOException {
        String dbKey = this.getRMDTMasterKeyNodeKey(masterKey);
        if (LOG.isDebugEnabled()) {
            LOG.debug("Storing token master key to " + dbKey);
        }
        ByteArrayOutputStream os = new ByteArrayOutputStream();
        try (DataOutputStream out = new DataOutputStream(os);){
            masterKey.write((DataOutput)out);
        }
        try {
            this.db.put(JniDBFactory.bytes((String)dbKey), os.toByteArray());
        }
        catch (DBException e) {
            throw new IOException(e);
        }
    }

    @Override
    protected void removeRMDTMasterKeyState(DelegationKey masterKey) throws IOException {
        String dbKey = this.getRMDTMasterKeyNodeKey(masterKey);
        if (LOG.isDebugEnabled()) {
            LOG.debug("Removing token master key at " + dbKey);
        }
        try {
            this.db.delete(JniDBFactory.bytes((String)dbKey));
        }
        catch (DBException e) {
            throw new IOException(e);
        }
    }

    @Override
    public void storeOrUpdateAMRMTokenSecretManagerState(AMRMTokenSecretManagerState state, boolean isUpdate) {
        AMRMTokenSecretManagerState data = AMRMTokenSecretManagerState.newInstance(state);
        byte[] stateData = data.getProto().toByteArray();
        this.db.put(JniDBFactory.bytes((String)"AMRMTokenSecretManagerRoot"), stateData);
    }

    @Override
    public void deleteStore() throws IOException {
        Path root = this.getStorageDir();
        LOG.info("Deleting state database at " + root);
        this.db.close();
        this.db = null;
        LocalFileSystem fs = FileSystem.getLocal((Configuration)this.getConfig());
        fs.delete(root, true);
    }

    @Override
    public synchronized void removeApplication(ApplicationId removeAppId) throws IOException {
        String appKey = this.getApplicationNodeKey(removeAppId);
        LOG.info("Removing state for app " + removeAppId);
        try {
            this.db.delete(JniDBFactory.bytes((String)appKey));
        }
        catch (DBException e) {
            throw new IOException(e);
        }
    }

    @VisibleForTesting
    int getNumEntriesInDatabase() throws IOException {
        int numEntries = 0;
        try (LeveldbIterator iter = new LeveldbIterator(this.db);){
            iter.seekToFirst();
            while (iter.hasNext()) {
                Map.Entry entry = iter.next();
                LOG.info("entry: " + JniDBFactory.asString((byte[])((byte[])entry.getKey())));
                ++numEntries;
            }
        }
        catch (DBException e) {
            throw new IOException(e);
        }
        return numEntries;
    }

    @VisibleForTesting
    protected void setDbManager(DBManager dbManager) {
        this.dbManager = dbManager;
    }
}

