/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.server.resourcemanager.reservation;

import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.classification.InterfaceStability;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.service.AbstractService;
import org.apache.hadoop.util.ReflectionUtils;
import org.apache.hadoop.yarn.api.records.ReservationId;
import org.apache.hadoop.yarn.api.records.Resource;
import org.apache.hadoop.yarn.exceptions.YarnException;
import org.apache.hadoop.yarn.exceptions.YarnRuntimeException;
import org.apache.hadoop.yarn.proto.YarnProtos;
import org.apache.hadoop.yarn.server.resourcemanager.RMContext;
import org.apache.hadoop.yarn.server.resourcemanager.ResourceManager;
import org.apache.hadoop.yarn.server.resourcemanager.recovery.RMStateStore;
import org.apache.hadoop.yarn.server.resourcemanager.reservation.CapacityReservationSystem;
import org.apache.hadoop.yarn.server.resourcemanager.reservation.CapacitySchedulerPlanFollower;
import org.apache.hadoop.yarn.server.resourcemanager.reservation.FairReservationSystem;
import org.apache.hadoop.yarn.server.resourcemanager.reservation.FairSchedulerPlanFollower;
import org.apache.hadoop.yarn.server.resourcemanager.reservation.InMemoryPlan;
import org.apache.hadoop.yarn.server.resourcemanager.reservation.Plan;
import org.apache.hadoop.yarn.server.resourcemanager.reservation.PlanFollower;
import org.apache.hadoop.yarn.server.resourcemanager.reservation.ReservationSchedulerConfiguration;
import org.apache.hadoop.yarn.server.resourcemanager.reservation.ReservationSystem;
import org.apache.hadoop.yarn.server.resourcemanager.reservation.ReservationSystemUtil;
import org.apache.hadoop.yarn.server.resourcemanager.reservation.SharingPolicy;
import org.apache.hadoop.yarn.server.resourcemanager.reservation.exceptions.PlanningException;
import org.apache.hadoop.yarn.server.resourcemanager.reservation.planning.Planner;
import org.apache.hadoop.yarn.server.resourcemanager.reservation.planning.ReservationAgent;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.QueueMetrics;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.ResourceScheduler;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.capacity.CapacityScheduler;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.fair.FairScheduler;
import org.apache.hadoop.yarn.server.resourcemanager.security.ReservationsACLsManager;
import org.apache.hadoop.yarn.util.Clock;
import org.apache.hadoop.yarn.util.UTCClock;
import org.apache.hadoop.yarn.util.resource.ResourceCalculator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@InterfaceAudience.LimitedPrivate(value={"yarn"})
@InterfaceStability.Unstable
public abstract class AbstractReservationSystem
extends AbstractService
implements ReservationSystem {
    private static final Logger LOG = LoggerFactory.getLogger(AbstractReservationSystem.class);
    private final ReentrantReadWriteLock readWriteLock = new ReentrantReadWriteLock(true);
    private final Lock readLock = this.readWriteLock.readLock();
    private final Lock writeLock = this.readWriteLock.writeLock();
    private boolean initialized = false;
    private final Clock clock = new UTCClock();
    private AtomicLong resCounter = new AtomicLong();
    private Map<String, Plan> plans = new HashMap<String, Plan>();
    private Map<ReservationId, String> resQMap = new HashMap<ReservationId, String>();
    private RMContext rmContext;
    private ResourceScheduler scheduler;
    private ScheduledExecutorService scheduledExecutorService;
    protected Configuration conf;
    protected long planStepSize;
    private PlanFollower planFollower;
    private ReservationsACLsManager reservationsACLsManager;
    private boolean isRecoveryEnabled = false;
    private long maxPeriodicity;

    public AbstractReservationSystem(String name) {
        super(name);
    }

    @Override
    public void setRMContext(RMContext rmContext) {
        this.writeLock.lock();
        try {
            this.rmContext = rmContext;
        }
        finally {
            this.writeLock.unlock();
        }
    }

    @Override
    public void reinitialize(Configuration conf, RMContext rmContext) throws YarnException {
        this.writeLock.lock();
        try {
            if (!this.initialized) {
                this.initialize(conf);
                this.initialized = true;
            } else {
                this.initializeNewPlans(conf);
            }
        }
        finally {
            this.writeLock.unlock();
        }
    }

    private void initialize(Configuration conf) throws YarnException {
        LOG.info("Initializing Reservation system");
        this.conf = conf;
        this.scheduler = this.rmContext.getScheduler();
        this.planStepSize = conf.getTimeDuration("yarn.resourcemanager.reservation-system.planfollower.time-step", 1000L, TimeUnit.MILLISECONDS);
        if (this.planStepSize < 0L) {
            this.planStepSize = 1000L;
        }
        this.maxPeriodicity = conf.getLong("yarn.resourcemanager.reservation-system.max-periodicity", 86400000L);
        if (this.maxPeriodicity <= 0L) {
            this.maxPeriodicity = 86400000L;
        }
        Set<String> planQueueNames = this.scheduler.getPlanQueues();
        for (String planQueueName : planQueueNames) {
            Plan plan = this.initializePlan(planQueueName);
            this.plans.put(planQueueName, plan);
        }
        this.isRecoveryEnabled = conf.getBoolean("yarn.resourcemanager.recovery.enabled", false);
        if (conf.getBoolean("yarn.acl.reservation-enable", false) && conf.getBoolean("yarn.acl.enable", false)) {
            this.reservationsACLsManager = new ReservationsACLsManager(this.scheduler, conf);
        }
    }

    private void loadPlan(String planName, Map<ReservationId, YarnProtos.ReservationAllocationStateProto> reservations) throws PlanningException {
        Plan plan = this.plans.get(planName);
        Resource minAllocation = this.getMinAllocation();
        ResourceCalculator rescCalculator = this.getResourceCalculator();
        for (Map.Entry<ReservationId, YarnProtos.ReservationAllocationStateProto> currentReservation : reservations.entrySet()) {
            plan.addReservation(ReservationSystemUtil.toInMemoryAllocation(planName, currentReservation.getKey(), currentReservation.getValue(), minAllocation, rescCalculator), true);
            this.resQMap.put(currentReservation.getKey(), planName);
        }
        LOG.info("Recovered reservations for Plan: {}", (Object)planName);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void recover(RMStateStore.RMState state) throws Exception {
        LOG.info("Recovering Reservation system");
        this.writeLock.lock();
        try {
            Map<String, Map<ReservationId, YarnProtos.ReservationAllocationStateProto>> reservationSystemState = state.getReservationState();
            if (this.planFollower != null) {
                for (String plan : this.plans.keySet()) {
                    if (reservationSystemState.containsKey(plan)) {
                        this.loadPlan(plan, reservationSystemState.get(plan));
                    }
                    this.synchronizePlan(plan, false);
                }
                this.startPlanFollower(this.conf.getLong("yarn.resourcemanager.work-preserving-recovery.scheduling-wait-ms", 10000L));
            }
        }
        finally {
            this.writeLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void initializeNewPlans(Configuration conf) {
        LOG.info("Refreshing Reservation system");
        this.writeLock.lock();
        try {
            Set<String> planQueueNames = this.scheduler.getPlanQueues();
            for (String planQueueName : planQueueNames) {
                if (!this.plans.containsKey(planQueueName)) {
                    Plan plan = this.initializePlan(planQueueName);
                    this.plans.put(planQueueName, plan);
                    continue;
                }
                LOG.warn("Plan based on reservation queue {} already exists.", (Object)planQueueName);
            }
            if (this.planFollower != null) {
                this.planFollower.setPlans(this.plans.values());
            }
        }
        catch (YarnException e) {
            LOG.warn("Exception while trying to refresh reservable queues", (Throwable)e);
        }
        finally {
            this.writeLock.unlock();
        }
    }

    private PlanFollower createPlanFollower() {
        String planFollowerPolicyClassName = this.conf.get("yarn.resourcemanager.reservation-system.plan.follower", this.getDefaultPlanFollower());
        if (planFollowerPolicyClassName == null) {
            return null;
        }
        LOG.info("Using PlanFollowerPolicy: " + planFollowerPolicyClassName);
        try {
            Class planFollowerPolicyClazz = this.conf.getClassByName(planFollowerPolicyClassName);
            if (PlanFollower.class.isAssignableFrom(planFollowerPolicyClazz)) {
                return (PlanFollower)ReflectionUtils.newInstance((Class)planFollowerPolicyClazz, (Configuration)this.conf);
            }
            throw new YarnRuntimeException("Class: " + planFollowerPolicyClassName + " not instance of " + PlanFollower.class.getCanonicalName());
        }
        catch (ClassNotFoundException e) {
            throw new YarnRuntimeException("Could not instantiate PlanFollowerPolicy: " + planFollowerPolicyClassName, (Throwable)e);
        }
    }

    private String getDefaultPlanFollower() {
        if (this.scheduler instanceof CapacityScheduler) {
            return CapacitySchedulerPlanFollower.class.getName();
        }
        if (this.scheduler instanceof FairScheduler) {
            return FairSchedulerPlanFollower.class.getName();
        }
        return null;
    }

    @Override
    public Plan getPlan(String planName) {
        this.readLock.lock();
        try {
            Plan plan = this.plans.get(planName);
            return plan;
        }
        finally {
            this.readLock.unlock();
        }
    }

    @Override
    public long getPlanFollowerTimeStep() {
        this.readLock.lock();
        try {
            long l = this.planStepSize;
            return l;
        }
        finally {
            this.readLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void synchronizePlan(String planName, boolean shouldReplan) {
        this.writeLock.lock();
        try {
            Plan plan = this.plans.get(planName);
            if (plan != null) {
                this.planFollower.synchronizePlan(plan, shouldReplan);
            }
        }
        finally {
            this.writeLock.unlock();
        }
    }

    private void startPlanFollower(long initialDelay) {
        if (this.planFollower != null) {
            this.scheduledExecutorService = new ScheduledThreadPoolExecutor(1);
            this.scheduledExecutorService.scheduleWithFixedDelay(this.planFollower, initialDelay, this.planStepSize, TimeUnit.MILLISECONDS);
        }
    }

    public void serviceInit(Configuration conf) throws Exception {
        Configuration configuration = new Configuration(conf);
        this.reinitialize(configuration, this.rmContext);
        this.planFollower = this.createPlanFollower();
        if (this.planFollower != null) {
            this.planFollower.init(this.clock, this.scheduler, this.plans.values());
        }
        super.serviceInit(conf);
    }

    public void serviceStart() throws Exception {
        if (!this.isRecoveryEnabled) {
            this.startPlanFollower(this.planStepSize);
        }
        super.serviceStart();
    }

    public void serviceStop() {
        if (this.scheduledExecutorService != null && !this.scheduledExecutorService.isShutdown()) {
            this.scheduledExecutorService.shutdown();
        }
        this.plans.clear();
    }

    @Override
    public String getQueueForReservation(ReservationId reservationId) {
        this.readLock.lock();
        try {
            String string = this.resQMap.get(reservationId);
            return string;
        }
        finally {
            this.readLock.unlock();
        }
    }

    @Override
    public void setQueueForReservation(ReservationId reservationId, String queueName) {
        this.writeLock.lock();
        try {
            this.resQMap.put(reservationId, queueName);
        }
        finally {
            this.writeLock.unlock();
        }
    }

    @Override
    public ReservationId getNewReservationId() {
        this.writeLock.lock();
        try {
            ReservationId resId = ReservationId.newInstance((long)ResourceManager.getClusterTimeStamp(), (long)this.resCounter.incrementAndGet());
            LOG.info("Allocated new reservationId: " + resId);
            ReservationId reservationId = resId;
            return reservationId;
        }
        finally {
            this.writeLock.unlock();
        }
    }

    @Override
    public Map<String, Plan> getAllPlans() {
        return this.plans;
    }

    public static String getDefaultReservationSystem(ResourceScheduler scheduler) {
        if (scheduler instanceof CapacityScheduler) {
            return CapacityReservationSystem.class.getName();
        }
        if (scheduler instanceof FairScheduler) {
            return FairReservationSystem.class.getName();
        }
        return null;
    }

    protected Plan initializePlan(String planQueueName) throws YarnException {
        String planQueuePath = this.getPlanQueuePath(planQueueName);
        SharingPolicy adPolicy = this.getAdmissionPolicy(planQueuePath);
        adPolicy.init(planQueuePath, this.getReservationSchedulerConfiguration());
        Resource minAllocation = this.getMinAllocation();
        Resource maxAllocation = this.getMaxAllocation();
        ResourceCalculator rescCalc = this.getResourceCalculator();
        Resource totCap = this.getPlanQueueCapacity(planQueueName);
        InMemoryPlan plan = new InMemoryPlan(this.getRootQueueMetrics(), adPolicy, this.getAgent(planQueuePath), totCap, this.planStepSize, rescCalc, minAllocation, maxAllocation, planQueueName, this.getReplanner(planQueuePath), this.getReservationSchedulerConfiguration().getMoveOnExpiry(planQueuePath), this.maxPeriodicity, this.rmContext);
        LOG.info("Initialized plan {} based on reservable queue {}", (Object)((Object)plan).toString(), (Object)planQueueName);
        return plan;
    }

    protected Planner getReplanner(String planQueueName) {
        ReservationSchedulerConfiguration reservationConfig = this.getReservationSchedulerConfiguration();
        String plannerClassName = reservationConfig.getReplanner(planQueueName);
        LOG.info("Using Replanner: " + plannerClassName + " for queue: " + planQueueName);
        try {
            Class plannerClazz = this.conf.getClassByName(plannerClassName);
            if (Planner.class.isAssignableFrom(plannerClazz)) {
                Planner planner = (Planner)ReflectionUtils.newInstance((Class)plannerClazz, (Configuration)this.conf);
                planner.init(planQueueName, reservationConfig);
                return planner;
            }
            throw new YarnRuntimeException("Class: " + plannerClazz + " not instance of " + Planner.class.getCanonicalName());
        }
        catch (ClassNotFoundException e) {
            throw new YarnRuntimeException("Could not instantiate Planner: " + plannerClassName + " for queue: " + planQueueName, (Throwable)e);
        }
    }

    protected ReservationAgent getAgent(String queueName) {
        ReservationSchedulerConfiguration reservationConfig = this.getReservationSchedulerConfiguration();
        String agentClassName = reservationConfig.getReservationAgent(queueName);
        LOG.info("Using Agent: " + agentClassName + " for queue: " + queueName);
        try {
            Class agentClazz = this.conf.getClassByName(agentClassName);
            if (ReservationAgent.class.isAssignableFrom(agentClazz)) {
                ReservationAgent resevertionAgent = (ReservationAgent)agentClazz.newInstance();
                resevertionAgent.init(this.conf);
                return resevertionAgent;
            }
            throw new YarnRuntimeException("Class: " + agentClassName + " not instance of " + ReservationAgent.class.getCanonicalName());
        }
        catch (ClassNotFoundException | IllegalAccessException | InstantiationException e) {
            throw new YarnRuntimeException("Could not instantiate Agent: " + agentClassName + " for queue: " + queueName, (Throwable)e);
        }
    }

    protected SharingPolicy getAdmissionPolicy(String queueName) {
        ReservationSchedulerConfiguration reservationConfig = this.getReservationSchedulerConfiguration();
        String admissionPolicyClassName = reservationConfig.getReservationAdmissionPolicy(queueName);
        LOG.info("Using AdmissionPolicy: " + admissionPolicyClassName + " for queue: " + queueName);
        try {
            Class admissionPolicyClazz = this.conf.getClassByName(admissionPolicyClassName);
            if (SharingPolicy.class.isAssignableFrom(admissionPolicyClazz)) {
                return (SharingPolicy)ReflectionUtils.newInstance((Class)admissionPolicyClazz, (Configuration)this.conf);
            }
            throw new YarnRuntimeException("Class: " + admissionPolicyClassName + " not instance of " + SharingPolicy.class.getCanonicalName());
        }
        catch (ClassNotFoundException e) {
            throw new YarnRuntimeException("Could not instantiate AdmissionPolicy: " + admissionPolicyClassName + " for queue: " + queueName, (Throwable)e);
        }
    }

    @Override
    public ReservationsACLsManager getReservationsACLsManager() {
        return this.reservationsACLsManager;
    }

    protected abstract ReservationSchedulerConfiguration getReservationSchedulerConfiguration();

    protected abstract String getPlanQueuePath(String var1);

    protected abstract Resource getPlanQueueCapacity(String var1);

    protected abstract Resource getMinAllocation();

    protected abstract Resource getMaxAllocation();

    protected abstract ResourceCalculator getResourceCalculator();

    protected abstract QueueMetrics getRootQueueMetrics();
}

