/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.server.resourcemanager.webapp.dao;

import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlRootElement;
import org.apache.hadoop.yarn.api.records.ApplicationId;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.activities.AppAllocation;
import org.apache.hadoop.yarn.server.resourcemanager.webapp.dao.AppAllocationInfo;
import org.apache.hadoop.yarn.util.SystemClock;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@XmlRootElement
@XmlAccessorType(value=XmlAccessType.FIELD)
public class AppActivitiesInfo {
    protected String applicationId;
    protected String diagnostic;
    protected String timeStamp;
    protected List<AppAllocationInfo> allocations;
    private static final Logger LOG = LoggerFactory.getLogger(AppActivitiesInfo.class);

    public AppActivitiesInfo() {
    }

    public AppActivitiesInfo(String errorMessage, String applicationId) {
        this.diagnostic = errorMessage;
        this.applicationId = applicationId;
        Date date = new Date();
        date.setTime(SystemClock.getInstance().getTime());
        this.timeStamp = date.toString();
    }

    public AppActivitiesInfo(List<AppAllocation> appAllocations, ApplicationId applicationId) {
        this.applicationId = applicationId.toString();
        this.allocations = new ArrayList<AppAllocationInfo>();
        if (appAllocations == null) {
            this.diagnostic = "waiting for display";
            Date date = new Date();
            date.setTime(SystemClock.getInstance().getTime());
            this.timeStamp = date.toString();
        } else {
            for (int i = appAllocations.size() - 1; i > -1; --i) {
                AppAllocation appAllocation = appAllocations.get(i);
                AppAllocationInfo appAllocationInfo = new AppAllocationInfo(appAllocation);
                this.allocations.add(appAllocationInfo);
            }
        }
    }
}

