/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.fs;

import java.io.Closeable;
import java.io.InputStream;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FSDataInputStream;
import org.apache.hadoop.fs.FSInputStream;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.fs.StreamCapabilities;
import org.apache.hadoop.hdfs.DFSTestUtil;
import org.apache.hadoop.hdfs.DistributedFileSystem;
import org.apache.hadoop.hdfs.MiniDFSCluster;
import org.apache.hadoop.hdfs.PeerCache;
import org.apache.hadoop.hdfs.client.HdfsClientConfigKeys;
import org.apache.hadoop.io.IOUtils;
import org.junit.Assert;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.ExpectedException;
import org.mockito.Mockito;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TestUnbuffer {
    private static final Logger LOG = LoggerFactory.getLogger((String)TestUnbuffer.class.getName());
    @Rule
    public ExpectedException exception = ExpectedException.none();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testUnbufferClosesSockets() throws Exception {
        MiniDFSCluster cluster;
        block5: {
            Configuration conf = new Configuration();
            conf.set("dfs.client.context", "testUnbufferClosesSocketsContext");
            conf.setBoolean(HdfsClientConfigKeys.Read.ShortCircuit.KEY, false);
            conf.setLong("dfs.client.socket-timeout", 100000000L);
            conf.setLong("dfs.client.socketcache.expiryMsec", 100000000L);
            cluster = null;
            FSDataInputStream stream = null;
            try {
                cluster = new MiniDFSCluster.Builder(conf).build();
                DistributedFileSystem dfs = (DistributedFileSystem)FileSystem.newInstance((Configuration)conf);
                Path TEST_PATH = new Path("/test1");
                DFSTestUtil.createFile((FileSystem)dfs, TEST_PATH, 128L, (short)1, 1L);
                stream = dfs.open(TEST_PATH);
                stream.seek(2L);
                int b = stream.read();
                Assert.assertTrue((-1 != b ? 1 : 0) != 0);
                PeerCache cache = dfs.getClient().getClientContext().getPeerCache();
                Assert.assertEquals((long)0L, (long)cache.size());
                stream.unbuffer();
                stream.seek(2L);
                Assert.assertEquals((long)1L, (long)cache.size());
                int b2 = stream.read();
                Assert.assertEquals((long)b, (long)b2);
                if (stream == null) break block5;
            }
            catch (Throwable throwable) {
                if (stream != null) {
                    IOUtils.cleanup(null, (Closeable[])new Closeable[]{stream});
                }
                if (cluster != null) {
                    cluster.shutdown();
                }
                throw throwable;
            }
            IOUtils.cleanup(null, (Closeable[])new Closeable[]{stream});
        }
        if (cluster != null) {
            cluster.shutdown();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testOpenManyFilesViaTcp() throws Exception {
        int NUM_OPENS = 500;
        Configuration conf = new Configuration();
        conf.setBoolean(HdfsClientConfigKeys.Read.ShortCircuit.KEY, false);
        MiniDFSCluster cluster = null;
        FSDataInputStream[] streams = new FSDataInputStream[500];
        try {
            cluster = new MiniDFSCluster.Builder(conf).build();
            DistributedFileSystem dfs = cluster.getFileSystem();
            Path TEST_PATH = new Path("/testFile");
            DFSTestUtil.createFile((FileSystem)dfs, TEST_PATH, 131072L, (short)1, 1L);
            for (int i = 0; i < 500; ++i) {
                streams[i] = dfs.open(TEST_PATH);
                LOG.info("opening file " + i + "...");
                Assert.assertTrue((-1 != streams[i].read() ? 1 : 0) != 0);
                streams[i].unbuffer();
            }
        }
        catch (Throwable throwable) {
            for (FSDataInputStream stream : streams) {
                IOUtils.cleanup(null, (Closeable[])new Closeable[]{stream});
            }
            if (cluster != null) {
                cluster.shutdown();
            }
            throw throwable;
        }
        for (FSDataInputStream stream : streams) {
            IOUtils.cleanup(null, (Closeable[])new Closeable[]{stream});
        }
        if (cluster != null) {
            cluster.shutdown();
        }
    }

    @Test
    public void testUnbufferException() {
        abstract class BuggyStream
        extends FSInputStream
        implements StreamCapabilities {
            BuggyStream() {
            }
        }
        BuggyStream bs = (BuggyStream)((Object)Mockito.mock(BuggyStream.class));
        Mockito.when((Object)bs.hasCapability(Mockito.anyString())).thenReturn((Object)true);
        this.exception.expect(UnsupportedOperationException.class);
        this.exception.expectMessage("claims unbuffer capabilty but does not implement CanUnbuffer");
        FSDataInputStream fs = new FSDataInputStream((InputStream)((Object)bs));
        fs.unbuffer();
    }
}

