/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs;

import java.io.File;
import java.security.PrivilegedExceptionAction;
import java.util.Properties;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.FileUtil;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hdfs.DFSInotifyEventInputStream;
import org.apache.hadoop.hdfs.DistributedFileSystem;
import org.apache.hadoop.hdfs.HdfsConfiguration;
import org.apache.hadoop.hdfs.inotify.EventBatch;
import org.apache.hadoop.hdfs.qjournal.MiniQJMHACluster;
import org.apache.hadoop.hdfs.qjournal.TestSecureNNWithQJM;
import org.apache.hadoop.http.HttpConfig;
import org.apache.hadoop.ipc.Client;
import org.apache.hadoop.minikdc.MiniKdc;
import org.apache.hadoop.security.SecurityUtil;
import org.apache.hadoop.security.UserGroupInformation;
import org.apache.hadoop.security.ssl.KeyStoreTestUtil;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.Timeout;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TestDFSInotifyEventInputStreamKerberized {
    private static final Logger LOG = LoggerFactory.getLogger(TestDFSInotifyEventInputStreamKerberized.class);
    private File baseDir;
    private String keystoresDir;
    private String sslConfDir;
    private MiniKdc kdc;
    private Configuration baseConf;
    private Configuration conf;
    private MiniQJMHACluster cluster;
    private File generalHDFSKeytabFile;
    private File nnKeytabFile;
    @Rule
    public Timeout timeout = new Timeout(180000);

    @Test
    public void testWithKerberizedCluster() throws Exception {
        this.conf = new HdfsConfiguration(this.baseConf);
        this.conf.setInt("hadoop.kerberos.min.seconds.before.relogin", 3);
        this.conf.setInt("ipc.client.connection.idle-scan-interval.ms", 100);
        this.conf.setInt("ipc.client.connection.maxidletime", 2000);
        Client.setConnectTimeout((Configuration)this.conf, (int)2000);
        this.cluster = new MiniQJMHACluster.Builder(this.conf).setForceRemoteEditsOnly(true).build();
        this.cluster.getDfsCluster().waitActive();
        this.cluster.getDfsCluster().transitionToActive(0);
        UserGroupInformation ugi = UserGroupInformation.loginUserFromKeytabAndReturnUGI((String)"hdfs", (String)this.generalHDFSKeytabFile.getAbsolutePath());
        UserGroupInformation.setShouldRenewImmediatelyForTests((boolean)true);
        ugi.doAs((PrivilegedExceptionAction)new PrivilegedExceptionAction<Void>(){

            @Override
            public Void run() throws Exception {
                LOG.info("Current user is: " + UserGroupInformation.getCurrentUser() + " login user is:" + UserGroupInformation.getLoginUser());
                Configuration clientConf = new Configuration(TestDFSInotifyEventInputStreamKerberized.this.cluster.getDfsCluster().getConfiguration(0));
                try (DistributedFileSystem clientFs = (DistributedFileSystem)FileSystem.get((Configuration)clientConf);){
                    EventBatch batch;
                    clientFs.mkdirs(new Path("/test"));
                    LOG.info("mkdir /test success");
                    DFSInotifyEventInputStream eis = clientFs.getInotifyEventStream();
                    while ((batch = eis.poll()) != null) {
                        LOG.info("txid: " + batch.getTxid());
                    }
                    Assert.assertNull((String)"poll should not return anything", (Object)eis.poll());
                    Thread.sleep(6000L);
                    LOG.info("Slept 6 seconds to make sure the TGT has expired.");
                    UserGroupInformation.getCurrentUser().checkTGTAndReloginFromKeytab();
                    clientFs.mkdirs(new Path("/test1"));
                    LOG.info("mkdir /test1 success");
                    batch = eis.poll();
                    Assert.assertNotNull((String)"poll should return something", (Object)batch);
                    Assert.assertEquals((long)1L, (long)batch.getEvents().length);
                    Assert.assertNull((String)"poll should not return anything", (Object)eis.poll());
                    Void void_ = null;
                    return void_;
                }
            }
        });
    }

    @Before
    public void initKerberizedCluster() throws Exception {
        this.baseDir = new File(System.getProperty("test.build.dir", "target/test-dir"), TestDFSInotifyEventInputStreamKerberized.class.getSimpleName());
        FileUtil.fullyDelete((File)this.baseDir);
        Assert.assertTrue((boolean)this.baseDir.mkdirs());
        Properties kdcConf = MiniKdc.createConf();
        kdcConf.setProperty("max.ticket.lifetime", "5");
        kdcConf.setProperty("min.ticket.lifetime", "5");
        this.kdc = new MiniKdc(kdcConf, this.baseDir);
        this.kdc.start();
        this.baseConf = new HdfsConfiguration();
        SecurityUtil.setAuthenticationMethod((UserGroupInformation.AuthenticationMethod)UserGroupInformation.AuthenticationMethod.KERBEROS, (Configuration)this.baseConf);
        UserGroupInformation.setConfiguration((Configuration)this.baseConf);
        Assert.assertTrue((String)"Expected configuration to enable security", (boolean)UserGroupInformation.isSecurityEnabled());
        String userName = "hdfs";
        this.nnKeytabFile = new File(this.baseDir, "hdfs.keytab");
        String keytab = this.nnKeytabFile.getAbsolutePath();
        String krbInstance = Path.WINDOWS ? "127.0.0.1" : "localhost";
        this.kdc.createPrincipal(this.nnKeytabFile, new String[]{"hdfs/" + krbInstance, "HTTP/" + krbInstance});
        this.generalHDFSKeytabFile = new File(this.baseDir, "hdfs_general.keytab");
        this.kdc.createPrincipal(this.generalHDFSKeytabFile, new String[]{"hdfs"});
        Assert.assertTrue((boolean)this.generalHDFSKeytabFile.exists());
        String hdfsPrincipal = "hdfs/" + krbInstance + "@" + this.kdc.getRealm();
        String spnegoPrincipal = "HTTP/" + krbInstance + "@" + this.kdc.getRealm();
        this.baseConf.set("dfs.namenode.kerberos.principal", hdfsPrincipal);
        this.baseConf.set("dfs.namenode.keytab.file", keytab);
        this.baseConf.set("dfs.datanode.kerberos.principal", hdfsPrincipal);
        this.baseConf.set("dfs.datanode.keytab.file", keytab);
        this.baseConf.set("dfs.web.authentication.kerberos.principal", spnegoPrincipal);
        this.baseConf.set("dfs.journalnode.keytab.file", keytab);
        this.baseConf.set("dfs.journalnode.kerberos.principal", hdfsPrincipal);
        this.baseConf.set("dfs.journalnode.kerberos.internal.spnego.principal", spnegoPrincipal);
        this.baseConf.setBoolean("dfs.block.access.token.enable", true);
        this.baseConf.set("dfs.http.policy", HttpConfig.Policy.HTTPS_ONLY.name());
        this.baseConf.set("dfs.namenode.https-address", "localhost:0");
        this.baseConf.set("dfs.datanode.https.address", "localhost:0");
        this.baseConf.set("dfs.journalnode.https-address", "localhost:0");
        this.baseConf.setInt("ipc.client.connect.max.retries.on.sasl", 10);
        this.keystoresDir = this.baseDir.getAbsolutePath();
        this.sslConfDir = KeyStoreTestUtil.getClasspathDir(TestSecureNNWithQJM.class);
        KeyStoreTestUtil.setupSSLConfig((String)this.keystoresDir, (String)this.sslConfDir, (Configuration)this.baseConf, (boolean)false);
        this.baseConf.set("dfs.client.https.keystore.resource", KeyStoreTestUtil.getClientSSLConfigFileName());
        this.baseConf.set("dfs.https.server.keystore.resource", KeyStoreTestUtil.getServerSSLConfigFileName());
    }

    @After
    public void shutdownCluster() throws Exception {
        if (this.cluster != null) {
            this.cluster.shutdown();
        }
        if (this.kdc != null) {
            this.kdc.stop();
        }
        FileUtil.fullyDelete((File)this.baseDir);
        KeyStoreTestUtil.cleanupSSLConfig((String)this.keystoresDir, (String)this.sslConfDir);
    }
}

