/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs.tools;

import java.io.IOException;
import java.util.Iterator;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.LocalFileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hdfs.DistributedFileSystem;
import org.apache.hadoop.hdfs.MiniDFSCluster;
import org.apache.hadoop.hdfs.tools.DelegationTokenFetcher;
import org.apache.hadoop.hdfs.web.WebHdfsFileSystem;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.security.AccessControlException;
import org.apache.hadoop.security.Credentials;
import org.apache.hadoop.security.token.Token;
import org.apache.hadoop.test.GenericTestUtils;
import org.apache.hadoop.tools.FakeRenewer;
import org.junit.Assert;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.TemporaryFolder;
import org.mockito.Matchers;
import org.mockito.Mockito;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TestDelegationTokenFetcher {
    private static final Logger LOG = LoggerFactory.getLogger(TestDelegationTokenFetcher.class);
    private Configuration conf = new Configuration();
    @Rule
    public TemporaryFolder f = new TemporaryFolder();
    private static final String tokenFile = "token";

    @Test(expected=IOException.class)
    public void testTokenFetchFail() throws Exception {
        WebHdfsFileSystem fs = (WebHdfsFileSystem)Mockito.mock(WebHdfsFileSystem.class);
        ((WebHdfsFileSystem)Mockito.doThrow((Throwable)new IOException()).when((Object)fs)).getDelegationToken(Matchers.anyString());
        Path p = new Path(this.f.getRoot().getAbsolutePath(), tokenFile);
        DelegationTokenFetcher.saveDelegationToken((Configuration)this.conf, (FileSystem)fs, null, (Path)p);
    }

    @Test
    public void expectedTokenIsRetrievedFromHttp() throws Exception {
        Token testToken = new Token("id".getBytes(), "pwd".getBytes(), FakeRenewer.KIND, new Text("127.0.0.1:1234"));
        WebHdfsFileSystem fs = (WebHdfsFileSystem)Mockito.mock(WebHdfsFileSystem.class);
        ((WebHdfsFileSystem)Mockito.doReturn((Object)testToken).when((Object)fs)).getDelegationToken(Matchers.anyString());
        Path p = new Path(this.f.getRoot().getAbsolutePath(), tokenFile);
        DelegationTokenFetcher.saveDelegationToken((Configuration)this.conf, (FileSystem)fs, null, (Path)p);
        Credentials creds = Credentials.readTokenStorageFile((Path)p, (Configuration)this.conf);
        Iterator itr = creds.getAllTokens().iterator();
        Assert.assertTrue((String)"token not exist error", (boolean)itr.hasNext());
        Token fetchedToken = (Token)itr.next();
        Assert.assertArrayEquals((String)"token wrong identifier error", (byte[])testToken.getIdentifier(), (byte[])fetchedToken.getIdentifier());
        Assert.assertArrayEquals((String)"token wrong password error", (byte[])testToken.getPassword(), (byte[])fetchedToken.getPassword());
        DelegationTokenFetcher.renewTokens((Configuration)this.conf, (Path)p);
        Assert.assertEquals((Object)testToken, FakeRenewer.getLastRenewed());
        DelegationTokenFetcher.cancelTokens((Configuration)this.conf, (Path)p);
        Assert.assertEquals((Object)testToken, FakeRenewer.getLastCanceled());
    }

    @Test
    public void testReturnedTokenIsNull() throws Exception {
        WebHdfsFileSystem fs = (WebHdfsFileSystem)Mockito.mock(WebHdfsFileSystem.class);
        ((WebHdfsFileSystem)Mockito.doReturn(null).when((Object)fs)).getDelegationToken(Matchers.anyString());
        Path p = new Path(this.f.getRoot().getAbsolutePath(), tokenFile);
        DelegationTokenFetcher.saveDelegationToken((Configuration)this.conf, (FileSystem)fs, null, (Path)p);
        Assert.assertFalse((boolean)p.getFileSystem(this.conf).exists(p));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testDelegationTokenWithoutRenewerViaRPC() throws Exception {
        this.conf.setBoolean("dfs.namenode.delegation.token.always-use", true);
        MiniDFSCluster cluster = new MiniDFSCluster.Builder(this.conf).numDataNodes(0).build();
        try {
            cluster.waitActive();
            DistributedFileSystem fs = cluster.getFileSystem();
            LocalFileSystem localFileSystem = FileSystem.getLocal((Configuration)this.conf);
            Path p = new Path(this.f.getRoot().getAbsolutePath(), tokenFile);
            p = localFileSystem.makeQualified(p);
            DelegationTokenFetcher.saveDelegationToken((Configuration)this.conf, (FileSystem)fs, null, (Path)p);
            Credentials creds = Credentials.readTokenStorageFile((Path)p, (Configuration)this.conf);
            Iterator itr = creds.getAllTokens().iterator();
            Assert.assertTrue((String)"token not exist error", (boolean)itr.hasNext());
            Token token = (Token)itr.next();
            Assert.assertNotNull((String)"Token should be there without renewer", (Object)token);
            String expectedNonVerbose = "Token (HDFS_DELEGATION_TOKEN token 1 for " + System.getProperty("user.name") + " with renewer ) for";
            String resNonVerbose = DelegationTokenFetcher.printTokensToString((Configuration)this.conf, (Path)p, (boolean)false);
            Assert.assertTrue((String)("The non verbose output is expected to start with \"" + expectedNonVerbose + "\""), (boolean)resNonVerbose.startsWith(expectedNonVerbose));
            LOG.info(resNonVerbose);
            LOG.info(DelegationTokenFetcher.printTokensToString((Configuration)this.conf, (Path)p, (boolean)true));
            try {
                DelegationTokenFetcher.renewTokens((Configuration)this.conf, (Path)p);
                Assert.fail((String)"Should have failed to renew");
            }
            catch (AccessControlException e) {
                GenericTestUtils.assertExceptionContains((String)("tried to renew a token (" + token.decodeIdentifier() + ") without a renewer"), (Throwable)e);
            }
        }
        finally {
            cluster.shutdown();
        }
    }
}

