/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.submarine.client.cli;

import com.google.common.annotations.VisibleForTesting;
import java.io.IOException;
import java.util.HashMap;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.GnuParser;
import org.apache.commons.cli.HelpFormatter;
import org.apache.commons.cli.Options;
import org.apache.commons.cli.ParseException;
import org.apache.hadoop.yarn.api.records.ApplicationId;
import org.apache.hadoop.yarn.exceptions.YarnException;
import org.apache.hadoop.yarn.submarine.client.cli.AbstractCli;
import org.apache.hadoop.yarn.submarine.client.cli.CliUtils;
import org.apache.hadoop.yarn.submarine.client.cli.param.RunJobParameters;
import org.apache.hadoop.yarn.submarine.common.ClientContext;
import org.apache.hadoop.yarn.submarine.common.exception.SubmarineException;
import org.apache.hadoop.yarn.submarine.runtimes.common.JobMonitor;
import org.apache.hadoop.yarn.submarine.runtimes.common.JobSubmitter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RunJobCli
extends AbstractCli {
    private static final Logger LOG = LoggerFactory.getLogger(RunJobCli.class);
    private Options options;
    private RunJobParameters parameters = new RunJobParameters();
    private JobSubmitter jobSubmitter;
    private JobMonitor jobMonitor;

    public RunJobCli(ClientContext cliContext) {
        this(cliContext, cliContext.getRuntimeFactory().getJobSubmitterInstance(), cliContext.getRuntimeFactory().getJobMonitorInstance());
    }

    @VisibleForTesting
    public RunJobCli(ClientContext cliContext, JobSubmitter jobSubmitter, JobMonitor jobMonitor) {
        super(cliContext);
        this.options = this.generateOptions();
        this.jobSubmitter = jobSubmitter;
        this.jobMonitor = jobMonitor;
    }

    public void printUsages() {
        new HelpFormatter().printHelp("job run", this.options);
    }

    private Options generateOptions() {
        Options options = new Options();
        options.addOption("name", true, "Name of the job");
        options.addOption("input_path", true, "Input of the job, could be local or other FS directory");
        options.addOption("checkpoint_path", true, "Training output directory of the job, could be local or other FS directory. This typically includes checkpoint files and exported model ");
        options.addOption("saved_model_path", true, "Model exported path (savedmodel) of the job, which is needed when exported model is not placed under ${checkpoint_path}could be local or other FS directory. This will be used to serve.");
        options.addOption("num_workers", true, "Numnber of worker tasks of the job, by default it's 1");
        options.addOption("num_ps", true, "Number of PS tasks of the job, by default it's 0");
        options.addOption("worker_resources", true, "Resource of each worker, for example memory-mb=2048,vcores=2,yarn.io/gpu=2");
        options.addOption("ps_resources", true, "Resource of each PS, for example memory-mb=2048,vcores=2,yarn.io/gpu=2");
        options.addOption("docker_image", true, "Docker image name/tag");
        options.addOption("queue", true, "Name of queue to run the job, by default it uses default queue");
        options.addOption("tensorboard", false, "Should we run TensorBoard for this job? By default it's disabled");
        options.addOption("tensorboard_resources", true, "Specify resources of Tensorboard, by default it is memory=4G,vcores=1");
        options.addOption("tensorboard_docker_image", true, "Specify Tensorboard docker image. when this is not specified, Tensorboard uses --docker_image as default.");
        options.addOption("worker_launch_cmd", true, "Commandline of worker, arguments will be directly used to launch the worker");
        options.addOption("ps_launch_cmd", true, "Commandline of worker, arguments will be directly used to launch the PS");
        options.addOption("env", true, "Common environment variable of worker/ps");
        options.addOption("verbose", false, "Print verbose log for troubleshooting");
        options.addOption("wait_job_finish", false, "Specified when user want to wait the job finish");
        options.addOption("ps_docker_image", true, "Specify docker image for PS, when this is not specified, PS uses --docker_image as default.");
        options.addOption("worker_docker_image", true, "Specify docker image for WORKER, when this is not specified, WORKER uses --docker_image as default.");
        options.addOption("quicklink", true, "Specify quicklink so YARNweb UI shows link to given role instance and port. When --tensorboard is speciied, quicklink to tensorboard instance will be added automatically. The format of quick link is: Quick_link_label=http(or https)://role-name:port. For example, if want to link to first worker's 7070 port, and text of quicklink is Notebook_UI, user need to specify --quicklink Notebook_UI=https://master-0:7070");
        options.addOption("localization", true, "Specify localization to make remote/local file/directory available to all container(Docker). Argument format is \"RemoteUri:LocalFilePath[:rw] \" (ro permission is not supported yet) The RemoteUri can be a file or directory in local or HDFS or s3 or abfs or http .etc. The LocalFilePath can be absolute or relative. If it's a relative path, it'll be under container's implied working directory but sub directory is not supported yet. This option can be set mutiple times. Examples are \n-localization \"hdfs:///user/yarn/mydir2:/opt/data\"\n-localization \"s3a:///a/b/myfile1:./\"\n-localization \"https:///a/b/myfile2:./myfile\"\n-localization \"/user/yarn/mydir3:/opt/mydir3\"\n-localization \"./mydir1:.\"\n");
        options.addOption("keytab", true, "Specify keytab used by the job under security environment");
        options.addOption("principal", true, "Specify principal used by the job under security environment");
        options.addOption("distribute_keytab", false, "Distribute local keytab to cluster machines for service authentication. If not sepcified, pre-destributed keytab of which path specified by parameterkeytab on cluster machines will be used");
        options.addOption("h", "help", false, "Print help");
        return options;
    }

    private void replacePatternsInParameters() throws IOException {
        String afterReplace;
        if (this.parameters.getPSLaunchCmd() != null && !this.parameters.getPSLaunchCmd().isEmpty()) {
            afterReplace = CliUtils.replacePatternsInLaunchCommand(this.parameters.getPSLaunchCmd(), this.parameters, this.clientContext.getRemoteDirectoryManager());
            this.parameters.setPSLaunchCmd(afterReplace);
        }
        if (this.parameters.getWorkerLaunchCmd() != null && !this.parameters.getWorkerLaunchCmd().isEmpty()) {
            afterReplace = CliUtils.replacePatternsInLaunchCommand(this.parameters.getWorkerLaunchCmd(), this.parameters, this.clientContext.getRemoteDirectoryManager());
            this.parameters.setWorkerLaunchCmd(afterReplace);
        }
    }

    private void parseCommandLineAndGetRunJobParameters(String[] args) throws ParseException, IOException, YarnException {
        try {
            GnuParser parser = new GnuParser();
            CommandLine cli = parser.parse(this.options, args);
            this.parameters.updateParametersByParsedCommandline(cli, this.options, this.clientContext);
        }
        catch (ParseException e) {
            LOG.error("Exception in parse:", (Object)e.getMessage());
            this.printUsages();
            throw e;
        }
        this.setDefaultDirs();
        this.replacePatternsInParameters();
    }

    private void setDefaultDirs() throws IOException {
        String savedModelDir;
        String jobDir = this.parameters.getCheckpointPath();
        if (null == jobDir) {
            jobDir = this.parameters.getNumWorkers() > 0 ? this.clientContext.getRemoteDirectoryManager().getJobCheckpointDir(this.parameters.getName(), true).toString() : this.clientContext.getRemoteDirectoryManager().getUserRootFolder().toString();
            this.parameters.setCheckpointPath(jobDir);
        }
        if (this.parameters.getNumWorkers() > 0 && null == (savedModelDir = this.parameters.getSavedModelPath())) {
            savedModelDir = jobDir;
            this.parameters.setSavedModelPath(savedModelDir);
        }
    }

    private void storeJobInformation(String jobName, ApplicationId applicationId, String[] args) throws IOException {
        HashMap<String, String> jobInfo = new HashMap<String, String>();
        jobInfo.put("JOB_NAME", jobName);
        jobInfo.put("APPLICATION_ID", applicationId.toString());
        if (this.parameters.getCheckpointPath() != null) {
            jobInfo.put("CHECKPOINT_PATH", this.parameters.getCheckpointPath());
        }
        if (this.parameters.getInputPath() != null) {
            jobInfo.put("INPUT_PATH", this.parameters.getInputPath());
        }
        if (this.parameters.getSavedModelPath() != null) {
            jobInfo.put("SAVED_MODEL_PATH", this.parameters.getSavedModelPath());
        }
        String joinedArgs = String.join((CharSequence)" ", args);
        jobInfo.put("JOB_RUN_ARGS", joinedArgs);
        this.clientContext.getRuntimeFactory().getSubmarineStorage().addNewJob(jobName, jobInfo);
    }

    @Override
    public int run(String[] args) throws ParseException, IOException, YarnException, InterruptedException, SubmarineException {
        if (CliUtils.argsForHelp(args)) {
            this.printUsages();
            return 0;
        }
        this.parseCommandLineAndGetRunJobParameters(args);
        ApplicationId applicationId = this.jobSubmitter.submitJob(this.parameters);
        this.storeJobInformation(this.parameters.getName(), applicationId, args);
        if (this.parameters.isWaitJobFinish()) {
            this.jobMonitor.waitTrainingFinal(this.parameters.getName());
        }
        return 0;
    }

    @VisibleForTesting
    public JobSubmitter getJobSubmitter() {
        return this.jobSubmitter;
    }

    @VisibleForTesting
    public RunJobParameters getRunJobParameters() {
        return this.parameters;
    }
}

