/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.submarine.common.api;

import java.io.PrintStream;
import java.time.LocalDateTime;
import java.util.List;
import org.apache.hadoop.yarn.submarine.common.api.JobComponentStatus;
import org.apache.hadoop.yarn.submarine.common.api.JobState;

public class JobStatus {
    protected String jobName;
    protected JobState state;
    protected String tensorboardLink = "N/A";
    protected List<JobComponentStatus> componentStatus;

    public void nicePrint(PrintStream out) {
        out.println("Job Name=" + this.jobName + ", status=" + this.state.name() + " time=" + LocalDateTime.now());
        if (JobState.isFinal(this.state)) {
            return;
        }
        if (this.tensorboardLink.startsWith("http")) {
            out.println("  Tensorboard link: " + this.tensorboardLink);
        }
        out.println("  Components:");
        for (JobComponentStatus comp : this.componentStatus) {
            out.println("    [" + comp.getCompName() + "] Ready=" + comp.getNumReadyContainers() + " + Running-But-Non-Ready=" + comp.getNumRunningButUnreadyContainers() + " | Asked=" + comp.getTotalAskedContainers());
        }
        out.println("------------------");
    }

    public JobState getState() {
        return this.state;
    }

    public String getTensorboardLink() {
        return this.tensorboardLink;
    }

    public List<JobComponentStatus> getComponentStatus() {
        return this.componentStatus;
    }

    public String getJobName() {
        return this.jobName;
    }

    public void setJobName(String jobName) {
        this.jobName = jobName;
    }

    public void setState(JobState state) {
        this.state = state;
    }

    public void setTensorboardLink(String tensorboardLink) {
        this.tensorboardLink = tensorboardLink;
    }

    public void setComponentStatus(List<JobComponentStatus> componentStatus) {
        this.componentStatus = componentStatus;
    }
}

