/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.submarine.runtimes;

import com.google.common.annotations.VisibleForTesting;
import java.lang.reflect.InvocationTargetException;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.yarn.submarine.common.ClientContext;
import org.apache.hadoop.yarn.submarine.common.exception.SubmarineRuntimeException;
import org.apache.hadoop.yarn.submarine.runtimes.common.JobMonitor;
import org.apache.hadoop.yarn.submarine.runtimes.common.JobSubmitter;
import org.apache.hadoop.yarn.submarine.runtimes.common.SubmarineStorage;

public abstract class RuntimeFactory {
    protected ClientContext clientContext;
    private JobSubmitter jobSubmitter;
    private JobMonitor jobMonitor;
    private SubmarineStorage submarineStorage;

    public RuntimeFactory(ClientContext clientContext) {
        this.clientContext = clientContext;
    }

    public static RuntimeFactory getRuntimeFactory(ClientContext clientContext) {
        Configuration submarineConfiguration = clientContext.getSubmarineConfig();
        String runtimeClass = submarineConfiguration.get("submarine.runtime.class", "org.apache.hadoop.yarn.submarine.runtimes.yarnservice.YarnServiceRuntimeFactory");
        try {
            Class<?> runtimeClazz = Class.forName(runtimeClass);
            if (RuntimeFactory.class.isAssignableFrom(runtimeClazz)) {
                return (RuntimeFactory)runtimeClazz.getConstructor(ClientContext.class).newInstance(clientContext);
            }
            throw new SubmarineRuntimeException("Class: " + runtimeClass + " not instance of " + RuntimeFactory.class.getCanonicalName());
        }
        catch (ClassNotFoundException | IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException e) {
            throw new SubmarineRuntimeException("Could not instantiate RuntimeFactory: " + runtimeClass, e);
        }
    }

    protected abstract JobSubmitter internalCreateJobSubmitter();

    protected abstract JobMonitor internalCreateJobMonitor();

    protected abstract SubmarineStorage internalCreateSubmarineStorage();

    public synchronized JobSubmitter getJobSubmitterInstance() {
        if (this.jobSubmitter == null) {
            this.jobSubmitter = this.internalCreateJobSubmitter();
        }
        return this.jobSubmitter;
    }

    public synchronized JobMonitor getJobMonitorInstance() {
        if (this.jobMonitor == null) {
            this.jobMonitor = this.internalCreateJobMonitor();
        }
        return this.jobMonitor;
    }

    public synchronized SubmarineStorage getSubmarineStorage() {
        if (this.submarineStorage == null) {
            this.submarineStorage = this.internalCreateSubmarineStorage();
        }
        return this.submarineStorage;
    }

    @VisibleForTesting
    public synchronized void setJobSubmitterInstance(JobSubmitter jobSubmitter) {
        this.jobSubmitter = jobSubmitter;
    }

    @VisibleForTesting
    public synchronized void setJobMonitorInstance(JobMonitor jobMonitor) {
        this.jobMonitor = jobMonitor;
    }

    @VisibleForTesting
    public synchronized void setSubmarineStorage(SubmarineStorage storage) {
        this.submarineStorage = storage;
    }
}

