/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.submarine.runtimes.yarnservice;

import java.io.IOException;
import org.apache.hadoop.yarn.client.api.AppAdminClient;
import org.apache.hadoop.yarn.exceptions.YarnException;
import org.apache.hadoop.yarn.service.api.records.Service;
import org.apache.hadoop.yarn.service.utils.ServiceApiUtil;
import org.apache.hadoop.yarn.submarine.common.ClientContext;
import org.apache.hadoop.yarn.submarine.common.api.JobStatus;
import org.apache.hadoop.yarn.submarine.common.api.builder.JobStatusBuilder;
import org.apache.hadoop.yarn.submarine.runtimes.common.JobMonitor;
import org.apache.hadoop.yarn.submarine.runtimes.yarnservice.YarnServiceUtils;

public class YarnServiceJobMonitor
extends JobMonitor {
    private volatile AppAdminClient serviceClient = null;

    public YarnServiceJobMonitor(ClientContext clientContext) {
        super(clientContext);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public JobStatus getTrainingJobStatus(String jobName) throws IOException, YarnException {
        if (this.serviceClient == null) {
            YarnServiceJobMonitor yarnServiceJobMonitor = this;
            synchronized (yarnServiceJobMonitor) {
                if (this.serviceClient == null) {
                    this.serviceClient = YarnServiceUtils.createServiceClient(this.clientContext.getYarnConfig());
                }
            }
        }
        String appStatus = this.serviceClient.getStatusString(jobName);
        Service serviceSpec = (Service)ServiceApiUtil.jsonSerDeser.fromJson(appStatus);
        JobStatus jobStatus = JobStatusBuilder.fromServiceSpec(serviceSpec);
        return jobStatus;
    }

    @Override
    public void cleanup() throws IOException {
        if (this.serviceClient != null) {
            this.serviceClient.close();
        }
    }
}

