/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.fs.slive;

import java.util.HashMap;
import java.util.Map;
import java.util.Random;
import org.apache.hadoop.fs.slive.AppendOp;
import org.apache.hadoop.fs.slive.ConfigExtractor;
import org.apache.hadoop.fs.slive.Constants;
import org.apache.hadoop.fs.slive.CreateOp;
import org.apache.hadoop.fs.slive.DeleteOp;
import org.apache.hadoop.fs.slive.ListOp;
import org.apache.hadoop.fs.slive.MkdirOp;
import org.apache.hadoop.fs.slive.Operation;
import org.apache.hadoop.fs.slive.ReadOp;
import org.apache.hadoop.fs.slive.RenameOp;
import org.apache.hadoop.fs.slive.TruncateOp;

class OperationFactory {
    private Map<Constants.OperationType, Operation> typedOperations = new HashMap<Constants.OperationType, Operation>();
    private ConfigExtractor config;
    private Random rnd;

    OperationFactory(ConfigExtractor cfg, Random rnd) {
        this.config = cfg;
        this.rnd = rnd;
    }

    Operation getOperation(Constants.OperationType type) {
        Operation op = this.typedOperations.get((Object)type);
        if (op != null) {
            return op;
        }
        switch (type) {
            case READ: {
                op = new ReadOp(this.config, this.rnd);
                break;
            }
            case LS: {
                op = new ListOp(this.config, this.rnd);
                break;
            }
            case MKDIR: {
                op = new MkdirOp(this.config, this.rnd);
                break;
            }
            case APPEND: {
                op = new AppendOp(this.config, this.rnd);
                break;
            }
            case RENAME: {
                op = new RenameOp(this.config, this.rnd);
                break;
            }
            case DELETE: {
                op = new DeleteOp(this.config, this.rnd);
                break;
            }
            case CREATE: {
                op = new CreateOp(this.config, this.rnd);
                break;
            }
            case TRUNCATE: {
                op = new TruncateOp(this.config, this.rnd);
            }
        }
        this.typedOperations.put(type, op);
        return op;
    }
}

