/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.shaded.org.mockito.internal.progress;

import org.apache.hadoop.shaded.org.mockito.MockSettings;
import org.apache.hadoop.shaded.org.mockito.exceptions.Reporter;
import org.apache.hadoop.shaded.org.mockito.internal.configuration.GlobalConfiguration;
import org.apache.hadoop.shaded.org.mockito.internal.debugging.Localized;
import org.apache.hadoop.shaded.org.mockito.internal.debugging.Location;
import org.apache.hadoop.shaded.org.mockito.internal.invocation.Invocation;
import org.apache.hadoop.shaded.org.mockito.internal.listeners.MockingProgressListener;
import org.apache.hadoop.shaded.org.mockito.internal.listeners.MockingStartedListener;
import org.apache.hadoop.shaded.org.mockito.internal.progress.ArgumentMatcherStorage;
import org.apache.hadoop.shaded.org.mockito.internal.progress.ArgumentMatcherStorageImpl;
import org.apache.hadoop.shaded.org.mockito.internal.progress.IOngoingStubbing;
import org.apache.hadoop.shaded.org.mockito.internal.progress.MockingProgress;
import org.apache.hadoop.shaded.org.mockito.verification.VerificationMode;

public class MockingProgressImpl
implements MockingProgress {
    private final Reporter reporter = new Reporter();
    private final ArgumentMatcherStorage argumentMatcherStorage = new ArgumentMatcherStorageImpl();
    IOngoingStubbing iOngoingStubbing;
    private Localized<VerificationMode> verificationMode;
    private Location stubbingInProgress = null;
    private MockingProgressListener listener;

    public void reportOngoingStubbing(IOngoingStubbing iOngoingStubbing) {
        this.iOngoingStubbing = iOngoingStubbing;
    }

    public IOngoingStubbing pullOngoingStubbing() {
        IOngoingStubbing temp = this.iOngoingStubbing;
        this.iOngoingStubbing = null;
        return temp;
    }

    public void verificationStarted(VerificationMode verify) {
        this.validateState();
        this.resetOngoingStubbing();
        this.verificationMode = new Localized<VerificationMode>(verify);
    }

    public void resetOngoingStubbing() {
        this.iOngoingStubbing = null;
    }

    public VerificationMode pullVerificationMode() {
        if (this.verificationMode == null) {
            return null;
        }
        VerificationMode temp = this.verificationMode.getObject();
        this.verificationMode = null;
        return temp;
    }

    public void stubbingStarted() {
        this.validateState();
        this.stubbingInProgress = new Location();
    }

    public void validateState() {
        GlobalConfiguration.validate();
        if (this.verificationMode != null) {
            Location location = this.verificationMode.getLocation();
            this.verificationMode = null;
            this.reporter.unfinishedVerificationException(location);
        }
        if (this.stubbingInProgress != null) {
            Location temp = this.stubbingInProgress;
            this.stubbingInProgress = null;
            this.reporter.unfinishedStubbing(temp);
        }
        this.getArgumentMatcherStorage().validateState();
    }

    public void stubbingCompleted(Invocation invocation) {
        this.stubbingInProgress = null;
    }

    public String toString() {
        return "iOngoingStubbing: " + this.iOngoingStubbing + ", verificationMode: " + this.verificationMode + ", stubbingInProgress: " + this.stubbingInProgress;
    }

    public void reset() {
        this.stubbingInProgress = null;
        this.verificationMode = null;
        this.getArgumentMatcherStorage().reset();
    }

    public ArgumentMatcherStorage getArgumentMatcherStorage() {
        return this.argumentMatcherStorage;
    }

    public void mockingStarted(Object mock, Class classToMock, MockSettings mockSettings) {
        if (this.listener != null && this.listener instanceof MockingStartedListener) {
            ((MockingStartedListener)this.listener).mockingStarted(mock, classToMock, mockSettings);
        }
        this.validateState();
    }

    public void setListener(MockingProgressListener listener) {
        this.listener = listener;
    }
}

