/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.server.nodemanager.containermanager.linux.resources;

import java.io.File;
import java.io.InputStream;
import java.lang.reflect.Constructor;
import java.nio.charset.Charset;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.shaded.com.google.common.annotations.VisibleForTesting;
import org.apache.hadoop.shaded.org.apache.commons.io.IOUtils;
import org.apache.hadoop.util.Shell;
import org.apache.hadoop.yarn.api.ApplicationConstants;
import org.apache.hadoop.yarn.conf.YarnConfiguration;
import org.apache.hadoop.yarn.exceptions.YarnException;
import org.apache.hadoop.yarn.exceptions.YarnRuntimeException;
import org.apache.hadoop.yarn.server.nodemanager.Context;
import org.apache.hadoop.yarn.server.nodemanager.containermanager.linux.resources.CGroupsHandler;
import org.apache.hadoop.yarn.server.nodemanager.containermanager.linux.resources.DefaultOOMHandler;
import org.apache.hadoop.yarn.server.nodemanager.containermanager.linux.resources.ResourceHandlerException;
import org.apache.hadoop.yarn.server.nodemanager.containermanager.linux.resources.ResourceHandlerModule;
import org.apache.hadoop.yarn.util.Clock;
import org.apache.hadoop.yarn.util.MonotonicClock;

public class CGroupElasticMemoryController
extends Thread {
    protected static final Log LOG = LogFactory.getLog(CGroupElasticMemoryController.class);
    private final Clock clock = new MonotonicClock();
    private String yarnCGroupPath;
    private String oomListenerPath;
    private Runnable oomHandler;
    private CGroupsHandler cgroups;
    private boolean controlPhysicalMemory;
    private boolean controlVirtualMemory;
    private long limit;
    private Process process = null;
    private boolean stopped = false;
    private int timeoutMS;

    @VisibleForTesting
    CGroupElasticMemoryController(Configuration conf, Context context, CGroupsHandler cgroups, boolean controlPhysicalMemory, boolean controlVirtualMemory, long limit, Runnable oomHandlerOverride) throws YarnException {
        super("CGroupElasticMemoryController");
        boolean controlVirtual = controlVirtualMemory && !controlPhysicalMemory;
        Runnable oomHandlerTemp = this.getDefaultOOMHandler(conf, context, oomHandlerOverride, controlVirtual);
        if (controlPhysicalMemory && controlVirtualMemory) {
            LOG.warn((Object)"yarn.nodemanager.elastic-memory-control.enabled is on. We cannot control both virtual and physical memory at the same time. Enforcing virtual memory. If swapping is enabled set only yarn.nodemanager.pmem-check-enabled to true otherwise set only yarn.nodemanager.vmem-check-enabled to true.");
        }
        if (!controlPhysicalMemory && !controlVirtualMemory) {
            throw new YarnException("yarn.nodemanager.elastic-memory-control.enabled is on. We need either virtual or physical memory check requested. If swapping is enabled set only yarn.nodemanager.pmem-check-enabled to true otherwise set only yarn.nodemanager.vmem-check-enabled to true.");
        }
        this.timeoutMS = 1000 * conf.getInt("yarn.nodemanager.elastic-memory-control.timeout-sec", YarnConfiguration.DEFAULT_NM_ELASTIC_MEMORY_CONTROL_OOM_TIMEOUT_SEC.intValue());
        this.oomListenerPath = CGroupElasticMemoryController.getOOMListenerExecutablePath(conf);
        this.oomHandler = oomHandlerTemp;
        this.cgroups = cgroups;
        this.controlPhysicalMemory = !controlVirtual;
        this.controlVirtualMemory = controlVirtual;
        this.yarnCGroupPath = this.cgroups.getPathForCGroup(CGroupsHandler.CGroupController.MEMORY, "");
        this.limit = limit;
    }

    private Runnable getDefaultOOMHandler(Configuration conf, Context context, Runnable oomHandlerLocal, boolean controlVirtual) throws YarnException {
        Class oomHandlerClass = conf.getClass("yarn.nodemanager.elastic-memory-control.oom-handler", DefaultOOMHandler.class);
        if (oomHandlerLocal == null) {
            try {
                Constructor constr = oomHandlerClass.getConstructor(Context.class, Boolean.TYPE);
                oomHandlerLocal = (Runnable)constr.newInstance(context, controlVirtual);
            }
            catch (Exception ex) {
                throw new YarnException((Throwable)ex);
            }
        }
        return oomHandlerLocal;
    }

    public CGroupElasticMemoryController(Configuration conf, Context context, CGroupsHandler cgroups, boolean controlPhysicalMemory, boolean controlVirtualMemory, long limit) throws YarnException {
        this(conf, context, cgroups, controlPhysicalMemory, controlVirtualMemory, limit, null);
    }

    public synchronized void stopListening() {
        this.stopped = true;
        if (this.process != null) {
            this.process.destroyForcibly();
        } else {
            LOG.warn((Object)"Trying to stop listening, when listening is not running");
        }
    }

    public static boolean isAvailable() {
        try {
            if (!Shell.LINUX) {
                LOG.info((Object)"CGroupElasticMemoryController currently is supported only on Linux.");
                return false;
            }
            if (ResourceHandlerModule.getCGroupsHandler() == null || ResourceHandlerModule.getMemoryResourceHandler() == null) {
                LOG.info((Object)"CGroupElasticMemoryController requires enabling memory CGroups withyarn.nodemanager.resource.memory.enabled");
                return false;
            }
        }
        catch (SecurityException se) {
            LOG.info((Object)("Failed to get Operating System name. " + se));
            return false;
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public void run() {
        CGroupElasticMemoryController cGroupElasticMemoryController;
        ExecutorService executor = null;
        try {
            int read;
            this.setCGroupParameters();
            ProcessBuilder oomListener = new ProcessBuilder(new String[0]);
            oomListener.command(this.oomListenerPath, this.yarnCGroupPath);
            cGroupElasticMemoryController = this;
            synchronized (cGroupElasticMemoryController) {
                if (this.stopped) {
                    this.resetCGroupParameters();
                    LOG.info((Object)"Listener stopped before starting");
                    return;
                }
                this.process = oomListener.start();
            }
            LOG.info((Object)String.format("Listening on %s with %s", this.yarnCGroupPath, this.oomListenerPath));
            executor = Executors.newFixedThreadPool(2);
            Future<String> errorListener = executor.submit(() -> IOUtils.toString((InputStream)this.process.getErrorStream(), (Charset)Charset.defaultCharset()));
            InputStream events = this.process.getInputStream();
            byte[] event = new byte[8];
            while ((read = events.read(event)) == event.length) {
                this.resolveOOM(executor);
            }
            if (read != -1) {
                LOG.warn((Object)String.format("Characters returned from event hander: %d", read));
            }
            int exitCode = this.process.waitFor();
            String error = errorListener.get();
            this.process = null;
            LOG.info((Object)String.format("OOM listener exited %d %s", exitCode, error));
            return;
        }
        catch (OOMNotResolvedException ex) {
            throw new YarnRuntimeException("Could not resolve OOM", (Throwable)((Object)ex));
        }
        catch (Exception ex) {
            cGroupElasticMemoryController = this;
            synchronized (cGroupElasticMemoryController) {
                if (this.stopped) return;
                LOG.warn((Object)"OOM Listener exiting.", (Throwable)ex);
                return;
            }
        }
        finally {
            if (this.process != null && this.process.isAlive()) {
                this.process.destroyForcibly();
            }
            if (executor != null) {
                try {
                    executor.awaitTermination(6L, TimeUnit.SECONDS);
                }
                catch (InterruptedException e) {
                    LOG.warn((Object)"Exiting without processing all OOM events.");
                }
                executor.shutdown();
            }
            this.resetCGroupParameters();
        }
    }

    private void resolveOOM(ExecutorService executor) throws InterruptedException, ExecutionException {
        long start = this.clock.getTime();
        Future<Boolean> watchdog = executor.submit(() -> this.watchAndLogOOMState(start));
        try {
            this.oomHandler.run();
        }
        catch (RuntimeException ex) {
            watchdog.cancel(true);
            throw new OOMNotResolvedException("OOM handler failed", ex);
        }
        if (!watchdog.get().booleanValue()) {
            throw new OOMNotResolvedException("OOM handler timed out", null);
        }
    }

    private boolean watchAndLogOOMState(long start) {
        long lastLog = start;
        try {
            long end = start;
            while (end - start < (long)this.timeoutMS) {
                end = this.clock.getTime();
                String underOOM = this.cgroups.getCGroupParam(CGroupsHandler.CGroupController.MEMORY, "", "oom_control");
                if (underOOM.contains("under_oom 1")) {
                    if (end - lastLog > 1000L) {
                        LOG.warn((Object)String.format("OOM not resolved in %d ms", end - start));
                        lastLog = end;
                    }
                } else {
                    LOG.info((Object)String.format("Resolved OOM in %d ms", end - start));
                    return true;
                }
                Thread.sleep(10L);
            }
        }
        catch (InterruptedException ex) {
            LOG.debug((Object)"Watchdog interrupted");
        }
        catch (Exception e) {
            LOG.warn((Object)"Exception running logging thread", (Throwable)e);
        }
        LOG.warn((Object)String.format("OOM was not resolved in %d ms", this.clock.getTime() - start));
        this.stopListening();
        return false;
    }

    private void setCGroupParameters() throws ResourceHandlerException {
        this.cgroups.updateCGroupParam(CGroupsHandler.CGroupController.MEMORY, "", "oom_control", "1");
        if (this.controlPhysicalMemory && !this.controlVirtualMemory) {
            try {
                this.cgroups.updateCGroupParam(CGroupsHandler.CGroupController.MEMORY, "", "memsw.limit_in_bytes", "-1");
            }
            catch (ResourceHandlerException ex) {
                LOG.debug((Object)"Swap monitoring is turned off in the kernel");
            }
            this.cgroups.updateCGroupParam(CGroupsHandler.CGroupController.MEMORY, "", "limit_in_bytes", Long.toString(this.limit));
        } else if (this.controlVirtualMemory && !this.controlPhysicalMemory) {
            this.cgroups.updateCGroupParam(CGroupsHandler.CGroupController.MEMORY, "", "memsw.limit_in_bytes", "-1");
            this.cgroups.updateCGroupParam(CGroupsHandler.CGroupController.MEMORY, "", "limit_in_bytes", Long.toString(this.limit));
            this.cgroups.updateCGroupParam(CGroupsHandler.CGroupController.MEMORY, "", "memsw.limit_in_bytes", Long.toString(this.limit));
        } else {
            throw new ResourceHandlerException(String.format("Unsupported scenario physical:%b virtual:%b", this.controlPhysicalMemory, this.controlVirtualMemory));
        }
    }

    private void resetCGroupParameters() {
        try {
            try {
                this.cgroups.updateCGroupParam(CGroupsHandler.CGroupController.MEMORY, "", "memsw.limit_in_bytes", "-1");
            }
            catch (ResourceHandlerException ex) {
                LOG.debug((Object)"Swap monitoring is turned off in the kernel");
            }
            this.cgroups.updateCGroupParam(CGroupsHandler.CGroupController.MEMORY, "", "limit_in_bytes", "-1");
            this.cgroups.updateCGroupParam(CGroupsHandler.CGroupController.MEMORY, "", "oom_control", "0");
        }
        catch (ResourceHandlerException ex) {
            LOG.warn((Object)"Error in cleanup", (Throwable)((Object)ex));
        }
    }

    private static String getOOMListenerExecutablePath(Configuration conf) {
        String yarnHomeEnvVar = System.getenv(ApplicationConstants.Environment.HADOOP_YARN_HOME.key());
        if (yarnHomeEnvVar == null) {
            yarnHomeEnvVar = ".";
        }
        File hadoopBin = new File(yarnHomeEnvVar, "bin");
        String defaultPath = new File(hadoopBin, "oom-listener").getAbsolutePath();
        String path = conf.get("yarn.nodemanager.elastic-memory-control.oom-listener.path", defaultPath);
        LOG.debug((Object)String.format("oom-listener path: %s %s", path, defaultPath));
        return path;
    }

    private static class OOMNotResolvedException
    extends YarnRuntimeException {
        OOMNotResolvedException(String message, Exception parent) {
            super(message, (Throwable)parent);
        }
    }
}

