/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.server.resourcemanager.reservation.planning;

import java.util.HashSet;
import java.util.ListIterator;
import java.util.Map;
import org.apache.hadoop.yarn.api.records.ReservationDefinition;
import org.apache.hadoop.yarn.api.records.ReservationId;
import org.apache.hadoop.yarn.api.records.ReservationRequest;
import org.apache.hadoop.yarn.api.records.ReservationRequestInterpreter;
import org.apache.hadoop.yarn.api.records.Resource;
import org.apache.hadoop.yarn.server.resourcemanager.reservation.Plan;
import org.apache.hadoop.yarn.server.resourcemanager.reservation.RLESparseResourceAllocation;
import org.apache.hadoop.yarn.server.resourcemanager.reservation.ReservationAllocation;
import org.apache.hadoop.yarn.server.resourcemanager.reservation.ReservationInterval;
import org.apache.hadoop.yarn.server.resourcemanager.reservation.exceptions.ContractValidationException;
import org.apache.hadoop.yarn.server.resourcemanager.reservation.exceptions.PlanningException;
import org.apache.hadoop.yarn.server.resourcemanager.reservation.planning.PlanningAlgorithm;
import org.apache.hadoop.yarn.server.resourcemanager.reservation.planning.StageAllocator;
import org.apache.hadoop.yarn.server.resourcemanager.reservation.planning.StageExecutionInterval;
import org.apache.hadoop.yarn.util.resource.ResourceCalculator;
import org.apache.hadoop.yarn.util.resource.Resources;

public class IterativePlanner
extends PlanningAlgorithm {
    private RLESparseResourceAllocation planModifications;
    private RLESparseResourceAllocation planLoads;
    private Resource capacity;
    private long step;
    private ReservationRequestInterpreter jobType;
    private long jobArrival;
    private long jobDeadline;
    private StageExecutionInterval algStageExecutionInterval = null;
    private StageAllocator algStageAllocator = null;
    private final boolean allocateLeft;

    public IterativePlanner(StageExecutionInterval algStageExecutionInterval, StageAllocator algStageAllocator, boolean allocateLeft) {
        this.allocateLeft = allocateLeft;
        this.setAlgStageExecutionInterval(algStageExecutionInterval);
        this.setAlgStageAllocator(algStageAllocator);
    }

    @Override
    public RLESparseResourceAllocation computeJobAllocation(Plan plan, ReservationId reservationId, ReservationDefinition reservation, String user) throws PlanningException {
        this.initialize(plan, reservationId, reservation);
        RLESparseResourceAllocation allocations = new RLESparseResourceAllocation(plan.getResourceCalculator());
        StageProvider stageProvider = new StageProvider(this.allocateLeft, reservation);
        long period = 0L;
        if (reservation.getRecurrenceExpression() != null) {
            period = Long.parseLong(reservation.getRecurrenceExpression());
        }
        while (stageProvider.hasNext()) {
            ReservationRequest currentReservationStage = stageProvider.next();
            this.validateInputStage(plan, currentReservationStage);
            ReservationInterval stageInterval = this.setStageExecutionInterval(plan, reservation, currentReservationStage, allocations);
            Long stageArrival = stageInterval.getStartTime();
            Long stageDeadline = stageInterval.getEndTime();
            Map<ReservationInterval, Resource> curAlloc = this.computeStageAllocation(plan, currentReservationStage, stageArrival, stageDeadline, period, user, reservationId);
            if (curAlloc == null) {
                if (this.jobType == ReservationRequestInterpreter.R_ANY) continue;
                throw new PlanningException("The request cannot be satisfied");
            }
            if (this.jobType == ReservationRequestInterpreter.R_ORDER_NO_GAP && !IterativePlanner.validateOrderNoGap(allocations, curAlloc, this.allocateLeft)) {
                throw new PlanningException("The allocation found does not respect ORDER_NO_GAP");
            }
            for (Map.Entry<ReservationInterval, Resource> entry : curAlloc.entrySet()) {
                allocations.addInterval(entry.getKey(), entry.getValue());
            }
            if (this.jobType != ReservationRequestInterpreter.R_ANY) continue;
            break;
        }
        if (allocations.isEmpty()) {
            throw new PlanningException("The request cannot be satisfied");
        }
        return allocations;
    }

    protected static boolean validateOrderNoGap(RLESparseResourceAllocation allocations, Map<ReservationInterval, Resource> curAlloc, boolean allocateLeft) {
        if (allocateLeft) {
            Long stageStartTime = IterativePlanner.findEarliestTime(curAlloc);
            Long allocationEndTime = allocations.getLatestNonNullTime();
            if (allocationEndTime != -1L && allocationEndTime < stageStartTime) {
                return false;
            }
        } else {
            Long stageEndTime = IterativePlanner.findLatestTime(curAlloc);
            Long allocationStartTime = allocations.getEarliestStartTime();
            if (allocationStartTime != -1L && stageEndTime < allocationStartTime) {
                return false;
            }
        }
        return IterativePlanner.isNonPreemptiveAllocation(curAlloc);
    }

    protected void initialize(Plan plan, ReservationId reservationId, ReservationDefinition reservation) throws PlanningException {
        this.capacity = plan.getTotalCapacity();
        this.step = plan.getStep();
        this.jobType = reservation.getReservationRequests().getInterpreter();
        this.jobArrival = IterativePlanner.stepRoundUp(reservation.getArrival(), this.step);
        this.jobDeadline = IterativePlanner.stepRoundDown(reservation.getDeadline(), this.step);
        this.planModifications = new RLESparseResourceAllocation(plan.getResourceCalculator());
        this.planLoads = plan.getCumulativeLoadOverTime(this.jobArrival, this.jobDeadline);
        ReservationAllocation oldRes = plan.getReservationById(reservationId);
        if (oldRes != null) {
            this.planLoads = RLESparseResourceAllocation.merge(plan.getResourceCalculator(), plan.getTotalCapacity(), this.planLoads, oldRes.getResourcesOverTime(this.jobArrival, this.jobDeadline), RLESparseResourceAllocation.RLEOperator.subtract, this.jobArrival, this.jobDeadline);
        }
    }

    private void validateInputStage(Plan plan, ReservationRequest rr) throws ContractValidationException {
        if (rr.getConcurrency() < 1) {
            throw new ContractValidationException("Gang Size should be >= 1");
        }
        if (rr.getNumContainers() <= 0) {
            throw new ContractValidationException("Num containers should be > 0");
        }
        if (rr.getNumContainers() % rr.getConcurrency() != 0) {
            throw new ContractValidationException("Parallelism must be an exact multiple of gang size");
        }
        if (Resources.greaterThan((ResourceCalculator)plan.getResourceCalculator(), (Resource)this.capacity, (Resource)rr.getCapability(), (Resource)plan.getMaximumAllocation())) {
            throw new ContractValidationException("Individual capability requests should not exceed cluster's maxAlloc");
        }
    }

    private static boolean isNonPreemptiveAllocation(Map<ReservationInterval, Resource> curAlloc) {
        HashSet<Long> endPoints = new HashSet<Long>(2 * curAlloc.size());
        for (Map.Entry<ReservationInterval, Resource> entry : curAlloc.entrySet()) {
            ReservationInterval interval = entry.getKey();
            Resource resource = entry.getValue();
            if (Resources.equals((Resource)resource, (Resource)Resource.newInstance((int)0, (int)0))) continue;
            Long left = interval.getStartTime();
            Long right = interval.getEndTime();
            if (!endPoints.contains(left)) {
                endPoints.add(left);
            } else {
                endPoints.remove(left);
            }
            if (!endPoints.contains(right)) {
                endPoints.add(right);
                continue;
            }
            endPoints.remove(right);
        }
        return endPoints.size() == 2;
    }

    protected ReservationInterval setStageExecutionInterval(Plan plan, ReservationDefinition reservation, ReservationRequest currentReservationStage, RLESparseResourceAllocation allocations) {
        return this.algStageExecutionInterval.computeExecutionInterval(plan, reservation, currentReservationStage, this.allocateLeft, allocations);
    }

    protected Map<ReservationInterval, Resource> computeStageAllocation(Plan plan, ReservationRequest rr, long stageArrivalTime, long stageDeadline, long period, String user, ReservationId oldId) throws PlanningException {
        return this.algStageAllocator.computeStageAllocation(plan, this.planLoads, this.planModifications, rr, stageArrivalTime, stageDeadline, period, user, oldId);
    }

    public IterativePlanner setAlgStageExecutionInterval(StageExecutionInterval alg) {
        this.algStageExecutionInterval = alg;
        return this;
    }

    public IterativePlanner setAlgStageAllocator(StageAllocator alg) {
        this.algStageAllocator = alg;
        return this;
    }

    public static class StageProvider {
        private final boolean allocateLeft;
        private final ListIterator<ReservationRequest> li;

        public StageProvider(boolean allocateLeft, ReservationDefinition reservation) {
            this.allocateLeft = allocateLeft;
            int startingIndex = allocateLeft ? 0 : reservation.getReservationRequests().getReservationResources().size();
            this.li = reservation.getReservationRequests().getReservationResources().listIterator(startingIndex);
        }

        public boolean hasNext() {
            if (this.allocateLeft) {
                return this.li.hasNext();
            }
            return this.li.hasPrevious();
        }

        public ReservationRequest next() {
            if (this.allocateLeft) {
                return this.li.next();
            }
            return this.li.previous();
        }

        public int getCurrentIndex() {
            if (this.allocateLeft) {
                return this.li.nextIndex() - 1;
            }
            return this.li.previousIndex() + 1;
        }
    }
}

