/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.server.resourcemanager.webapp.dao;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlTransient;
import org.apache.hadoop.shaded.com.google.common.annotations.VisibleForTesting;
import org.apache.hadoop.shaded.com.google.common.base.Joiner;
import org.apache.hadoop.yarn.api.records.ApplicationId;
import org.apache.hadoop.yarn.api.records.ApplicationResourceUsageReport;
import org.apache.hadoop.yarn.api.records.ApplicationSubmissionContext;
import org.apache.hadoop.yarn.api.records.ApplicationTimeoutType;
import org.apache.hadoop.yarn.api.records.Container;
import org.apache.hadoop.yarn.api.records.FinalApplicationStatus;
import org.apache.hadoop.yarn.api.records.LogAggregationStatus;
import org.apache.hadoop.yarn.api.records.Resource;
import org.apache.hadoop.yarn.api.records.ResourceRequest;
import org.apache.hadoop.yarn.api.records.SchedulingRequest;
import org.apache.hadoop.yarn.api.records.YarnApplicationState;
import org.apache.hadoop.yarn.server.resourcemanager.ResourceManager;
import org.apache.hadoop.yarn.server.resourcemanager.rmapp.RMApp;
import org.apache.hadoop.yarn.server.resourcemanager.rmapp.RMAppMetrics;
import org.apache.hadoop.yarn.server.resourcemanager.rmapp.attempt.RMAppAttempt;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.ResourceScheduler;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.capacity.CapacityScheduler;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.common.fica.FiCaSchedulerApp;
import org.apache.hadoop.yarn.server.resourcemanager.webapp.DeSelectFields;
import org.apache.hadoop.yarn.server.resourcemanager.webapp.dao.AppTimeoutInfo;
import org.apache.hadoop.yarn.server.resourcemanager.webapp.dao.AppTimeoutsInfo;
import org.apache.hadoop.yarn.server.resourcemanager.webapp.dao.ResourceRequestInfo;
import org.apache.hadoop.yarn.server.resourcemanager.webapp.dao.ResourcesInfo;
import org.apache.hadoop.yarn.util.Times;
import org.apache.hadoop.yarn.webapp.util.WebAppUtils;

@XmlRootElement(name="app")
@XmlAccessorType(value=XmlAccessType.FIELD)
public class AppInfo {
    @XmlTransient
    protected String appIdNum;
    @XmlTransient
    protected boolean trackingUrlIsNotReady;
    @XmlTransient
    protected String trackingUrlPretty;
    @XmlTransient
    protected boolean amContainerLogsExist = false;
    @XmlTransient
    protected ApplicationId applicationId;
    @XmlTransient
    private String schemePrefix;
    protected String id;
    protected String user;
    private String name;
    protected String queue;
    private YarnApplicationState state;
    protected FinalApplicationStatus finalStatus;
    protected float progress;
    protected String trackingUI;
    protected String trackingUrl;
    protected String diagnostics;
    protected long clusterId;
    protected String applicationType;
    protected String applicationTags = "";
    protected int priority;
    protected long startedTime;
    private long launchTime;
    protected long finishedTime;
    protected long elapsedTime;
    protected String amContainerLogs;
    protected String amHostHttpAddress;
    private String amRPCAddress;
    private String masterNodeId;
    private long allocatedMB;
    private long allocatedVCores;
    private long reservedMB;
    private long reservedVCores;
    private int runningContainers;
    private long memorySeconds;
    private long vcoreSeconds;
    protected float queueUsagePercentage;
    protected float clusterUsagePercentage;
    protected Map<String, Long> resourceSecondsMap;
    private long preemptedResourceMB;
    private long preemptedResourceVCores;
    private int numNonAMContainerPreempted;
    private int numAMContainerPreempted;
    private long preemptedMemorySeconds;
    private long preemptedVcoreSeconds;
    protected Map<String, Long> preemptedResourceSecondsMap;
    @XmlElement(name="resourceRequests")
    private List<ResourceRequestInfo> resourceRequests = new ArrayList<ResourceRequestInfo>();
    protected LogAggregationStatus logAggregationStatus;
    protected boolean unmanagedApplication;
    protected String appNodeLabelExpression;
    protected String amNodeLabelExpression;
    protected ResourcesInfo resourceInfo = null;
    private AppTimeoutsInfo timeouts;

    public AppInfo() {
    }

    public AppInfo(ResourceManager rm, RMApp app, Boolean hasAccess, String schemePrefix) {
        this(rm, app, hasAccess, schemePrefix, new DeSelectFields());
    }

    public AppInfo(ResourceManager rm, RMApp app, Boolean hasAccess, String schemePrefix, DeSelectFields deSelects) {
        this.schemePrefix = schemePrefix;
        if (app != null) {
            RMAppAttempt attempt;
            ResourceScheduler scheduler;
            String trackingUrl = app.getTrackingUrl();
            this.state = app.createApplicationState();
            boolean bl = this.trackingUrlIsNotReady = trackingUrl == null || trackingUrl.isEmpty() || YarnApplicationState.NEW == this.state || YarnApplicationState.NEW_SAVING == this.state || YarnApplicationState.SUBMITTED == this.state || YarnApplicationState.ACCEPTED == this.state;
            this.trackingUI = this.trackingUrlIsNotReady ? "UNASSIGNED" : (app.getFinishTime() == 0L ? "ApplicationMaster" : "History");
            this.trackingUrlPretty = !this.trackingUrlIsNotReady ? (this.trackingUrl = WebAppUtils.getURLWithScheme((String)schemePrefix, (String)trackingUrl)) : "UNASSIGNED";
            this.applicationId = app.getApplicationId();
            this.applicationType = app.getApplicationType();
            this.appIdNum = String.valueOf(app.getApplicationId().getId());
            this.id = app.getApplicationId().toString();
            this.user = app.getUser().toString();
            this.name = app.getName().toString();
            this.queue = app.getQueue().toString();
            this.priority = 0;
            this.masterNodeId = "";
            if (app.getApplicationPriority() != null) {
                this.priority = app.getApplicationPriority().getPriority();
            }
            this.progress = app.getProgress() * 100.0f;
            this.diagnostics = app.getDiagnostics().toString();
            if (this.diagnostics == null || this.diagnostics.isEmpty()) {
                this.diagnostics = "";
            }
            if (app.getApplicationTags() != null && !app.getApplicationTags().isEmpty()) {
                this.applicationTags = Joiner.on((char)',').join(app.getApplicationTags());
            }
            this.finalStatus = app.getFinalApplicationStatus();
            this.clusterId = ResourceManager.getClusterTimeStamp();
            if (hasAccess.booleanValue()) {
                this.startedTime = app.getStartTime();
                this.launchTime = app.getLaunchTime();
                this.finishedTime = app.getFinishTime();
                this.elapsedTime = Times.elapsed((long)app.getStartTime(), (long)app.getFinishTime());
                this.logAggregationStatus = app.getLogAggregationStatusForAppReport();
                RMAppAttempt attempt2 = app.getCurrentAppAttempt();
                if (attempt2 != null) {
                    Container masterContainer = attempt2.getMasterContainer();
                    if (masterContainer != null) {
                        this.amContainerLogsExist = true;
                        this.amContainerLogs = WebAppUtils.getRunningLogURL((String)(schemePrefix + masterContainer.getNodeHttpAddress()), (String)masterContainer.getId().toString(), (String)app.getUser());
                        this.amHostHttpAddress = masterContainer.getNodeHttpAddress();
                        this.masterNodeId = masterContainer.getNodeId().toString();
                    }
                    this.amRPCAddress = AppInfo.getAmRPCAddressFromRMAppAttempt(attempt2);
                    ApplicationResourceUsageReport resourceReport = attempt2.getApplicationResourceUsageReport();
                    if (resourceReport != null) {
                        Resource usedResources = resourceReport.getUsedResources();
                        Resource reservedResources = resourceReport.getReservedResources();
                        this.allocatedMB = usedResources.getMemorySize();
                        this.allocatedVCores = usedResources.getVirtualCores();
                        this.reservedMB = reservedResources.getMemorySize();
                        this.reservedVCores = reservedResources.getVirtualCores();
                        this.runningContainers = resourceReport.getNumUsedContainers();
                        this.queueUsagePercentage = resourceReport.getQueueUsagePercentage();
                        this.clusterUsagePercentage = resourceReport.getClusterUsagePercentage();
                    }
                    if (!deSelects.contains(DeSelectFields.DeSelectType.RESOURCE_REQUESTS)) {
                        List<SchedulingRequest> schedulingRequestsRaw;
                        List<ResourceRequest> resourceRequestsRaw = rm.getRMContext().getScheduler().getPendingResourceRequestsForAttempt(attempt2.getAppAttemptId());
                        if (resourceRequestsRaw != null) {
                            for (ResourceRequest resourceRequest : resourceRequestsRaw) {
                                this.resourceRequests.add(new ResourceRequestInfo(resourceRequest));
                            }
                        }
                        if ((schedulingRequestsRaw = rm.getRMContext().getScheduler().getPendingSchedulingRequestsForAttempt(attempt2.getAppAttemptId())) != null) {
                            for (SchedulingRequest req : schedulingRequestsRaw) {
                                this.resourceRequests.add(new ResourceRequestInfo(req));
                            }
                        }
                    }
                }
            }
            RMAppMetrics appMetrics = app.getRMAppMetrics();
            this.numAMContainerPreempted = appMetrics.getNumAMContainersPreempted();
            this.preemptedResourceMB = appMetrics.getResourcePreempted().getMemorySize();
            this.numNonAMContainerPreempted = appMetrics.getNumNonAMContainersPreempted();
            this.preemptedResourceVCores = appMetrics.getResourcePreempted().getVirtualCores();
            this.memorySeconds = appMetrics.getMemorySeconds();
            this.vcoreSeconds = appMetrics.getVcoreSeconds();
            this.resourceSecondsMap = appMetrics.getResourceSecondsMap();
            this.preemptedMemorySeconds = appMetrics.getPreemptedMemorySeconds();
            this.preemptedVcoreSeconds = appMetrics.getPreemptedVcoreSeconds();
            this.preemptedResourceSecondsMap = appMetrics.getPreemptedResourceSecondsMap();
            ApplicationSubmissionContext appSubmissionContext = app.getApplicationSubmissionContext();
            this.unmanagedApplication = appSubmissionContext.getUnmanagedAM();
            this.appNodeLabelExpression = app.getApplicationSubmissionContext().getNodeLabelExpression();
            if (!deSelects.contains(DeSelectFields.DeSelectType.AM_NODE_LABEL_EXPRESSION)) {
                String string = this.amNodeLabelExpression = this.unmanagedApplication ? null : app.getAMResourceRequests().get(0).getNodeLabelExpression();
            }
            if (!deSelects.contains(DeSelectFields.DeSelectType.APP_NODE_LABEL_EXPRESSION)) {
                this.appNodeLabelExpression = app.getApplicationSubmissionContext().getNodeLabelExpression();
            }
            if (!deSelects.contains(DeSelectFields.DeSelectType.AM_NODE_LABEL_EXPRESSION)) {
                String string = this.amNodeLabelExpression = this.unmanagedApplication ? null : app.getAMResourceRequests().get(0).getNodeLabelExpression();
            }
            if (!deSelects.contains(DeSelectFields.DeSelectType.RESOURCE_INFO) && (scheduler = rm.getRMContext().getScheduler()) instanceof CapacityScheduler && null != (attempt = app.getCurrentAppAttempt())) {
                FiCaSchedulerApp ficaAppAttempt = ((CapacityScheduler)scheduler).getApplicationAttempt(attempt.getAppAttemptId());
                ResourcesInfo resourcesInfo = this.resourceInfo = null != ficaAppAttempt ? new ResourcesInfo(ficaAppAttempt.getSchedulingResourceUsage()) : null;
            }
            if (!deSelects.contains(DeSelectFields.DeSelectType.TIMEOUTS)) {
                Map<ApplicationTimeoutType, Long> applicationTimeouts = app.getApplicationTimeouts();
                this.timeouts = new AppTimeoutsInfo();
                if (applicationTimeouts.isEmpty()) {
                    AppTimeoutInfo timeoutInfo = new AppTimeoutInfo();
                    timeoutInfo.setTimeoutType(ApplicationTimeoutType.LIFETIME);
                    this.timeouts.add(timeoutInfo);
                } else {
                    for (Map.Entry<ApplicationTimeoutType, Long> entry : app.getApplicationTimeouts().entrySet()) {
                        AppTimeoutInfo appTimeoutInfo = new AppTimeoutInfo();
                        appTimeoutInfo.setTimeoutType(entry.getKey());
                        long timeoutInMillis = entry.getValue();
                        appTimeoutInfo.setExpiryTime(Times.formatISO8601((long)timeoutInMillis));
                        if (app.isAppInCompletedStates()) {
                            appTimeoutInfo.setRemainingTime(0L);
                        } else {
                            appTimeoutInfo.setRemainingTime(Math.max((timeoutInMillis - System.currentTimeMillis()) / 1000L, 0L));
                        }
                        this.timeouts.add(appTimeoutInfo);
                    }
                }
            }
        }
    }

    public boolean isTrackingUrlReady() {
        return !this.trackingUrlIsNotReady;
    }

    public ApplicationId getApplicationId() {
        return this.applicationId;
    }

    public String getAppId() {
        return this.id;
    }

    public String getAppIdNum() {
        return this.appIdNum;
    }

    public String getUser() {
        return this.user;
    }

    public String getQueue() {
        return this.queue;
    }

    public String getName() {
        return this.name;
    }

    public YarnApplicationState getState() {
        return this.state;
    }

    public float getProgress() {
        return this.progress;
    }

    public String getTrackingUI() {
        return this.trackingUI;
    }

    public String getNote() {
        return this.diagnostics;
    }

    public FinalApplicationStatus getFinalStatus() {
        return this.finalStatus;
    }

    public String getTrackingUrl() {
        return this.trackingUrl;
    }

    public String getTrackingUrlPretty() {
        return this.trackingUrlPretty;
    }

    public long getStartTime() {
        return this.startedTime;
    }

    public long getLaunchTime() {
        return this.launchTime;
    }

    public long getFinishTime() {
        return this.finishedTime;
    }

    public long getElapsedTime() {
        return this.elapsedTime;
    }

    public String getAMContainerLogs() {
        return this.amContainerLogs;
    }

    public String getAMHostHttpAddress() {
        return this.amHostHttpAddress;
    }

    public String getAmRPCAddress() {
        return this.amRPCAddress;
    }

    public static String getAmRPCAddressFromRMAppAttempt(RMAppAttempt attempt) {
        String amRPCAddress = null;
        if (attempt != null) {
            String amHost = attempt.getHost();
            int amRpcPort = attempt.getRpcPort();
            if (!"N/A".equals(amHost) && amRpcPort != -1) {
                amRPCAddress = amHost + ":" + amRpcPort;
            }
        }
        return amRPCAddress;
    }

    public boolean amContainerLogsExist() {
        return this.amContainerLogsExist;
    }

    public long getClusterId() {
        return this.clusterId;
    }

    public String getApplicationType() {
        return this.applicationType;
    }

    public String getApplicationTags() {
        return this.applicationTags;
    }

    public int getRunningContainers() {
        return this.runningContainers;
    }

    public long getAllocatedMB() {
        return this.allocatedMB;
    }

    public long getAllocatedVCores() {
        return this.allocatedVCores;
    }

    public long getReservedMB() {
        return this.reservedMB;
    }

    public long getReservedVCores() {
        return this.reservedVCores;
    }

    public long getPreemptedMB() {
        return this.preemptedResourceMB;
    }

    public long getPreemptedVCores() {
        return this.preemptedResourceVCores;
    }

    public int getNumNonAMContainersPreempted() {
        return this.numNonAMContainerPreempted;
    }

    public int getNumAMContainersPreempted() {
        return this.numAMContainerPreempted;
    }

    public long getMemorySeconds() {
        return this.memorySeconds;
    }

    public long getVcoreSeconds() {
        return this.vcoreSeconds;
    }

    public Map<String, Long> getResourceSecondsMap() {
        return this.resourceSecondsMap;
    }

    public long getPreemptedMemorySeconds() {
        return this.preemptedMemorySeconds;
    }

    public long getPreemptedVcoreSeconds() {
        return this.preemptedVcoreSeconds;
    }

    public Map<String, Long> getPreemptedResourceSecondsMap() {
        return this.preemptedResourceSecondsMap;
    }

    public List<ResourceRequestInfo> getResourceRequests() {
        return this.resourceRequests;
    }

    public void setResourceRequests(List<ResourceRequestInfo> resourceRequests) {
        this.resourceRequests = resourceRequests;
    }

    public LogAggregationStatus getLogAggregationStatus() {
        return this.logAggregationStatus;
    }

    public boolean isUnmanagedApp() {
        return this.unmanagedApplication;
    }

    public int getPriority() {
        return this.priority;
    }

    public String getAppNodeLabelExpression() {
        return this.appNodeLabelExpression;
    }

    public String getAmNodeLabelExpression() {
        return this.amNodeLabelExpression;
    }

    public ResourcesInfo getResourceInfo() {
        return this.resourceInfo;
    }

    public long getPreemptedResourceMB() {
        return this.preemptedResourceMB;
    }

    public void setPreemptedResourceMB(long preemptedResourceMB) {
        this.preemptedResourceMB = preemptedResourceMB;
    }

    public long getPreemptedResourceVCores() {
        return this.preemptedResourceVCores;
    }

    public void setPreemptedResourceVCores(long preemptedResourceVCores) {
        this.preemptedResourceVCores = preemptedResourceVCores;
    }

    public int getNumNonAMContainerPreempted() {
        return this.numNonAMContainerPreempted;
    }

    public void setNumNonAMContainerPreempted(int numNonAMContainerPreempted) {
        this.numNonAMContainerPreempted = numNonAMContainerPreempted;
    }

    public int getNumAMContainerPreempted() {
        return this.numAMContainerPreempted;
    }

    public void setNumAMContainerPreempted(int numAMContainerPreempted) {
        this.numAMContainerPreempted = numAMContainerPreempted;
    }

    public void setPreemptedMemorySeconds(long preemptedMemorySeconds) {
        this.preemptedMemorySeconds = preemptedMemorySeconds;
    }

    public void setPreemptedVcoreSeconds(long preemptedVcoreSeconds) {
        this.preemptedVcoreSeconds = preemptedVcoreSeconds;
    }

    public void setAllocatedMB(long allocatedMB) {
        this.allocatedMB = allocatedMB;
    }

    public void setAllocatedVCores(long allocatedVCores) {
        this.allocatedVCores = allocatedVCores;
    }

    public void setReservedMB(long reservedMB) {
        this.reservedMB = reservedMB;
    }

    public void setReservedVCores(long reservedVCores) {
        this.reservedVCores = reservedVCores;
    }

    public void setRunningContainers(int runningContainers) {
        this.runningContainers = runningContainers;
    }

    public void setMemorySeconds(long memorySeconds) {
        this.memorySeconds = memorySeconds;
    }

    public void setVcoreSeconds(long vcoreSeconds) {
        this.vcoreSeconds = vcoreSeconds;
    }

    public void setAppId(String appId) {
        this.id = appId;
    }

    @VisibleForTesting
    public void setAMHostHttpAddress(String amHost) {
        this.amHostHttpAddress = amHost;
    }

    public void setState(YarnApplicationState state) {
        this.state = state;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getMasterNodeId() {
        return this.masterNodeId;
    }

    public void setMasterNodeId(String masterNodeId) {
        this.masterNodeId = masterNodeId;
    }
}

