/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs.server.federation.router;

import java.io.IOException;
import java.util.Arrays;
import java.util.List;
import org.apache.hadoop.fs.permission.FsAction;
import org.apache.hadoop.fs.permission.FsPermission;
import org.apache.hadoop.hdfs.server.federation.store.records.MountTable;
import org.apache.hadoop.hdfs.server.namenode.FSPermissionChecker;
import org.apache.hadoop.hdfs.server.namenode.NameNode;
import org.apache.hadoop.security.AccessControlException;
import org.apache.hadoop.security.UserGroupInformation;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RouterPermissionChecker
extends FSPermissionChecker {
    static final Logger LOG = LoggerFactory.getLogger(RouterPermissionChecker.class);
    public static final short MOUNT_TABLE_PERMISSION_DEFAULT = 493;
    private final String superUser;
    private final String superGroup;

    public RouterPermissionChecker(String user, String group, UserGroupInformation callerUgi) {
        super(user, group, callerUgi, null);
        this.superUser = user;
        this.superGroup = group;
    }

    public RouterPermissionChecker(String user, String group) throws IOException {
        super(user, group, UserGroupInformation.getCurrentUser(), null);
        this.superUser = user;
        this.superGroup = group;
    }

    public void checkPermission(MountTable mountTable, FsAction access) throws AccessControlException {
        if (this.isSuperUser()) {
            return;
        }
        FsPermission mode = mountTable.getMode();
        if (this.getUser().equals(mountTable.getOwnerName()) && mode.getUserAction().implies(access)) {
            return;
        }
        if (this.isMemberOfGroup(mountTable.getGroupName()) && mode.getGroupAction().implies(access)) {
            return;
        }
        if (!this.getUser().equals(mountTable.getOwnerName()) && !this.isMemberOfGroup(mountTable.getGroupName()) && mode.getOtherAction().implies(access)) {
            return;
        }
        throw new AccessControlException("Permission denied while accessing mount table " + mountTable.getSourcePath() + ": user " + this.getUser() + " does not have " + access.toString() + " permissions.");
    }

    public void checkSuperuserPrivilege() throws AccessControlException {
        UserGroupInformation ugi = null;
        try {
            ugi = NameNode.getRemoteUser();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        if (ugi == null) {
            LOG.error("Cannot get the remote user name");
            throw new AccessControlException("Cannot get the remote user name");
        }
        if (ugi.getUserName().equals(this.superUser)) {
            return;
        }
        List<String> groups = Arrays.asList(ugi.getGroupNames());
        if (groups.contains(this.superGroup)) {
            return;
        }
        throw new AccessControlException(ugi.getUserName() + " is not a super user");
    }
}

